Object subclass:  #GtkObject
	instanceVariableNames: 'gtk properties signals'
	classVariableNames: 'gtkRunning gtkInitialized gtkInitSequence'
	poolDictionaries: ''
	category: 'Graphics-Windows'!

GtkObject subclass: #Widget
	instanceVariableNames: 'name parent'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Graphics-Windows'!

!"----- GtkObject -----"
"void gst_gtk_set_property(void *aWidget, char *aProperty, OOP aValue)"
GtkObject class
        defineCFunc: 'gst_gtk_set_property'
        withSelectorArgs: 'widget: aWidget property: aProperty value: aValue'
        returning: #void
        args: #(#cObject #string #smalltalk)
!

"OOP gst_gtk_get_property(void *aWidget, char *aProperty)"
GtkObject class
        defineCFunc: 'gst_gtk_get_property'
        withSelectorArgs: 'widget: aWidget property: aProperty'
        returning: #smalltalk
        args: #(#cObject #string)

!

"void gst_gtk_initialize(void);"
GtkObject class
        defineCFunc: 'gst_gtk_initialize'
        withSelectorArgs: 'cInitializeGtk'
        returning: #void
        args: #(#void)
!

"void gst_gtk_finalize(void);"
GtkObject class
        defineCFunc: 'gst_gtk_finalize'
        withSelectorArgs: 'cFinalizeGtk'
        returning: #void
        args: #(#void)
!

"void gst_gtk_dispatch_events(void);"
GtkObject class
        defineCFunc: 'gst_gtk_dispatch_events'
        withSelectorArgs: 'dispatchEvents'
        returning: #void
        args: #(#void)

        "Or define as async?
        Blox class
        defineAsyncCFunc: 'gst_gtk_dispatch_events'
        withSelectorArgs: 'dispatchEvents'
        args: #(#void)"
!

"void gst_gtk_test(void);"
GtkObject class
        defineCFunc: 'gst_gtk_test'
        withSelectorArgs: 'cTest'
        returning: #void
        args: #(#void)
!

"int gst_gtk_enum_get_value(char *enum_name, char *enum_nick);"
GtkObject class
        defineCFunc: 'gst_gtk_enum_get_value'
        withSelectorArgs: 'enum: aEnum value: aNick'
        returning: #int
        args: #(#string #string)
!

!GtkObject class methodsFor: 'initializing Gtk'!

initializeGtk
  self cInitializeGtk.
  ObjectMemory addDependent: self.
  gtkInitialized := true.
  "self allInstancesDo: [ :each | each invalidateGtk ]."
  Transcript print: 'Gtk initialized'. "DEBUG"
!

finalizeGtk
  self cFinalizeGtk.
  ObjectMemory removeDependent: self.
  gtkInitialized := nil.
  "self allInstancesDo: [ :each | each invalidateGtk ]."
  Transcript print: 'Gtk finalized'. "DEBUG"
!

!GtkObject class methodsFor: 'saving and loading'!

update: aParameter
  super update: aParameter.

  aParameter == #returnFromSnapshot ifFalse: [ ^self ].

  Transcript print: 'Gtk received returnFromSnapshot'. "DEBUG"
  self runGtkInitSequence.
!

runGtkInitSequence
  gtkInitialized := nil.
  gtkRunning := nil.  

  gtkInitSequence := OrderedCollection new.
  self withAllSubclassesDo: [ :each | each registerInitEvents ].
  self changed: #registerInitEvents.

  gtkInitSequence := gtkInitSequence asSortedCollection: [ :a :b | a key < b key ].

  [ gtkInitSequence notEmpty ] whileTrue: [ | first | 
    first := gtkInitSequence removeFirst.

    Transcript cr; print: 'GtkInit: ', first value printString.
    first value send.
  ].
  Transcript cr; print: 'GtkInit: done.'; cr. "DEBUG"
!

registerInitEvent: aDirectedMessage priority: aPriority
  gtkInitSequence add: ( aPriority -> aDirectedMessage ).
!

registerInitEvents
  self == GtkObject ifFalse: [ ^self ].
  self registerInitEvent: 
         (DirectedMessage selector: #cInitializeGtk arguments: #() receiver: self)
       priority: 1.
  self registerInitEvent: 
         (DirectedMessage selector: #sendToAllInstances: arguments: #(#recreateGtk) receiver: self)
       priority: 2.
  self registerInitEvent: 
         (DirectedMessage selector: #sendToAllInstances: arguments: #(#restoreProperties) receiver: self)
       priority: 5.
!

sendToAllInstances: aSelector
  "private"
  "GtkObject is abstract, should not have any instances itself"
  self allSubclassesDo: [ :cls | 
    cls allInstancesDo: [ :inst |
      inst perform: aSelector 
    ]
  ].
!

!

!GtkObject class methodsFor: 'event loop'!

forkEventLoop
  gtkRunning isNil
    ifTrue: [ gtkRunning := 1 ]
    ifFalse: [ gtkRunning := gtkRunning + 1 ].
  (gtkRunning = 1) ifTrue:
    [[[gtkRunning > 0] whileTrue:
      [self dispatchEvents. Processor yield]] fork].
!

waitForEventLoop
  [gtkRunning > 0] whileTrue: [Processor yield].
!

enterEventLoop
  "Is threadsafety important?"
  self forkEventLoop; waitForEventLoop.
!

stopEventLoop
  "Is threadsafety important?"
  gtkRunning > 0 ifTrue: [
    gtkRunning := gtkRunning - 1
  ]

!

!GtkObject methodsFor: 'properties'!

gtk
  ^gtk
!

property: aName value: aValue
  (properties isNil) ifTrue: [properties := Dictionary new].
  properties at: aName put: aValue.
  self class widget: gtk property: aName value: aValue
!

property: aName
  ^self class widget: gtk property: aName
!

properties
  ^properties.
!

!

!GtkObject methodsFor: 'saving and loading' !

recreateGtk
    self restoreSignals.
!

restoreProperties
  | toRestore |
  "Set any properties that are not the defaults"
  properties isNil ifFalse: [
    toRestore := properties.
    properties := Dictionary new.
    toRestore keysAndValuesDo: [ :key :value |
      self property: key value: value
    ].
  ].
!

restoreSignals
  "Reconnect any signals"
  signals isNil ifFalse: [
    signals do: [ :each | each connect ].
  ]
!
!

!GtkObject methodsFor: 'signals'!

signals
  signals isNil ifTrue: [signals := Dictionary new].
  ^signals.
!  

addSignal: aSignal
  "For add signal subclasses created by subclasses of self"
  self signals at: aSignal signal asSymbol put: aSignal.
!

connectSignal: aSignal to: aReceiver send: aSelector
  "aSelector is a one-argument message that receives this widget as its
 argument"
  self addSignal: 
    (Signal new on: aSignal from: self send: aSelector asSymbol to: aReceiver).
!

connectSTSignal: aEvent to: aReceiver send: aSelector
  "For signals that do not originate in Gtk."
  self addSignal: 
    (Signal new onST: aEvent from: self send: (aSelector asSymbol) to: aReceiver).
!

disconnectSignal: aSignal
  signals isNil ifTrue: [ ^self ].
  signals at: aSignal asSymbol ifPresent: [ :sig |
    sig disconnect.
    signals remove: sig.
  ].
!

abortSignal: aSignal
  signals isNil ifTrue: [ ^self ].
  self signals at: aSignal asSymbol ifPresent: [ :sig | sig abort ].
!

emitSignal: aSignal
  signals isNil ifTrue: [ ^self ].
  signals at: aSignal asSymbol ifPresent: [ :sig | sig emit ].
!
!

!"----- Widget -----"
"----- Widget CFuncs -----"

"void *gst_gtk_create_widget(OOP st_obj, char *aName, char *aType, void *aParent);"
Widget class
        defineCFunc: 'gst_gtk_create_widget'
        withSelectorArgs: 'cCreateWidget: cb name: name type: aType parent: aWindow'
        returning: #cObject
        args: #(#smalltalk #string #string #cObject)
!

"void gst_gtk_destroy_widget(void *aWidget);"
Widget class
        defineCFunc: 'gst_gtk_destroy_widget'
        withSelectorArgs: 'cDestroyWidget: aWidget'
        returning: #void
        args: #(#cObject)
!

"void gst_gtk_size_request(void *aWidget);"
Widget class
        defineCFunc: 'gst_gtk_size_request'
        withSelectorArgs: 'cSizeRequest: aWidget'
        returning: #void
        args: #(#cObject)
!

"----- Widget Non C -----"

!Widget class methodsFor: 'instance creation' !

new
  self shouldNotImplement.
!

new: aName
  | wgt |
  wgt := self basicNew name: aName; createGtk; yourself.
  "GtkObject addDependent: wgt."
  ^wgt.
!

widgetType
  self subclassResponsibility.
!

!Widget methodsFor: 'printing'!

printOn: aStream
    "Print a representation of the receiver on aStream"
    aStream 
	nextPutAll: self class article; space;
	nextPutAll: self classNameString;
	nextPutAll: ' called ';
	nextPutAll: self name.
!

!Widget methodsFor: 'containers'!

parent
  ^parent
!

parentsDo: aBlock
  | pt |
  pt := parent.
  [pt notNil] whileTrue: [aBlock value: pt. pt := pt parent].
!

parentWindow
  | pt |
  pt := parent.
  [ pt notNil ] whileTrue: [ pt parent isNil ifTrue: [ ^pt ]. pt := pt parent].
!

packInto: aContainer
  parent notNil ifTrue: [parent remove: self].
  aContainer notNil ifTrue: [aContainer add: self].
  parent := aContainer.
!

withParents
  | coll |
  coll := OrderedCollection with: self.
  self parentsDo: [ :pt | coll add: pt ].
  ^coll.
!

!Widget class methodsFor: 'instance creation' !

new: aName in: aContainer
  ^(self new: aName) packInto: aContainer; yourself.
!

!Widget methodsFor: 'initialization' !

createGtk
  gtk := self class cCreateWidget: self name: name type: self class widgetType parent: nil.
!

!

!Widget methodsFor: 'saving and loading' !

recreateGtk
  "Recreates the Gtk widget and reconnects. Called when the image is reloaded."
  | toRestore |
  super recreateGtk.
  Transcript print: ' Recreating Gtk widget for ',
    self class name, ' ', self name, '.'. "DEBUG"
  self createGtk.
!

restoreGtkLinks
  "Does nothing in Widget"
!

restoreAllGtkLinks
  self restoreGtkLinks.
!
!

!Widget methodsFor: 'destruction'!

destroyWidget
  gtk isNil ifFalse: [ self class cDestroyWidget: gtk ].
!

destroy
  self destroyWidget.
!

widgetDestroyed
  "Callback from gtk when widget destroyed."
  gtk := nil.
!

!Widget methodsFor: 'accessing' !

name: aName
  name isNil
    ifTrue: [ name := aName ]
    ifFalse: [ self error: 'A widget''s name can only be set once.' ].
!

name
  ^name.
!
!

!Widget methodsFor: 'common properties'!

visible: aBoolean
  self property: 'visible' value: aBoolean
!

height: aHeight width: aWidth
  self
    property: 'height-request' value: aHeight;
    property: 'width-request' value: aWidth.
!

width: aWidth height: aHeight
  self
    property: 'height-request' value: aHeight;
    property: 'width-request' value: aWidth.
!

!Widget methodsFor: 'testing'!

isContainer
  ^false.
!

!
