/* -*- c++ -*- */
/*
 * Copyright 2003,2004 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


%typemap(in) vector_float & {
  int i;
  if (!PySequence_Check($input)) {
    PyErr_SetString(PyExc_ValueError,"Expected a sequence");
    return NULL;
  }

  int	len = PySequence_Length ($input);

  $1 = new vector_float;
  $1->resize (len);

  for (i = 0; i < len; i++) {
    PyObject *o = PySequence_GetItem($input,i);
    if (PyNumber_Check(o)) {
      (*$1)[i] = (float) PyFloat_AsDouble(o);
    } else {
      PyErr_SetString(PyExc_ValueError,"Sequence elements must be numbers");
      return NULL;
    }
  }
}

%typemap(freearg) vector_float & {
  if ($1) delete $1;
}

%typemap(out) vector_float {
  unsigned int	i;

  $result = PyList_New ($1.size ());
  for (i = 0; i < $1.size (); i++){
    PyList_SetItem ($result, i, PyFloat_FromDouble ((double) $1[i]));
  }
}

// ----------------------------------------------------------------

%typemap(in) vector_double & {
  int i;
  if (!PySequence_Check($input)) {
    PyErr_SetString(PyExc_ValueError,"Expected a sequence");
    return NULL;
  }

  int	len = PySequence_Length ($input);

  $1 = new vector_double;
  $1->resize (len);

  for (i = 0; i < len; i++) {
    PyObject *o = PySequence_GetItem($input,i);
    if (PyNumber_Check(o)) {
      (*$1)[i] = (double) PyFloat_AsDouble(o);
    } else {
      PyErr_SetString(PyExc_ValueError,"Sequence elements must be numbers");
      return NULL;
    }
  }
}

%typemap(freearg) vector_double & {
  if ($1) delete $1;
}

%typemap(out) vector_double {
  unsigned int	i;

  $result = PyList_New ($1.size ());
  for (i = 0; i < $1.size (); i++){
    PyList_SetItem ($result, i, PyFloat_FromDouble ((double) $1[i]));
  }
}

// ----------------------------------------------------------------

%{

static short
saturate_double_to_short (double v)
{
  if (v > 32767)
    return 32767;
  else if (v < -32768)
    return -32768;

  return (short) rint (v);
}

%}

%typemap(in) vector_short & {
  int i;
  if (!PySequence_Check($input)) {
    PyErr_SetString(PyExc_ValueError,"Expected a sequence");
    return NULL;
  }

  int	len = PySequence_Length ($input);

  $1 = new vector_short;
  $1->resize (len);

  for (i = 0; i < len; i++) {
    PyObject *o = PySequence_GetItem($input,i);
    if (PyNumber_Check(o)) {
      (*$1)[i] = saturate_double_to_short (PyFloat_AsDouble(o));
    } else {
      PyErr_SetString(PyExc_ValueError,"Sequence elements must be numbers");
      return NULL;
    }
  }
}

%typemap(freearg) vector_short & {
  if ($1) delete $1;
}

%typemap(out) vector_short {
  unsigned int	i;

  $result = PyList_New ($1.size ());
  for (i = 0; i < $1.size (); i++){
    PyList_SetItem ($result, i, PyFloat_FromDouble ((double) $1[i]));
  }
}

// ----------------------------------------------------------------

%typemap(in) vector_VrComplex & {
  int i;
  if (!PySequence_Check($input)) {
    PyErr_SetString(PyExc_ValueError,"Expected a sequence");
    return NULL;
  }

  int	len = PySequence_Length ($input);

  $1 = new vector_VrComplex;
  $1->resize (len);

  for (i = 0; i < len; i++) {
    PyObject *o = PySequence_GetItem($input,i);
    if (PyNumber_Check(o)) {
      if (PyComplex_Check (o)){
	(*$1)[i] = gr_complex ((float) PyComplex_RealAsDouble(o),
			      (float) PyComplex_ImagAsDouble(o));
      }
      else {
	(*$1)[i] = (float) PyFloat_AsDouble (o);
      }
    } else {
      PyErr_SetString(PyExc_ValueError,"Sequence elements must be numbers");
      return NULL;
    }
  }
}

%typemap(freearg) vector_VrComplex & {
  if ($1) delete $1;
}

%typemap(out) vector_VrComplex {
  unsigned int	i;

  $result = PyList_New ($1.size ());
  for (i = 0; i < $1.size (); i++){
    PyList_SetItem ($result, i,
		    PyComplex_FromDoubles ((double) $1[i].real (),
					   (double) $1[i].imag ()));
  }
}

