/* GNU Mailutils -- a suite of utilities for electronic mail
   Copyright (C) 1999, 2000, 2001 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA  */

#ifndef _MAILUTILS_SYS_STREAM_H
#define _MAILUTILS_SYS_STREAM_H

#ifdef DMALLOC
# include <dmalloc.h>
#endif

#include <mailutils/stream.h>

#ifdef __cplusplus
extern "C" {
#endif

struct _stream_vtable
{
  int  (*ref)       __P ((stream_t));
  void (*destroy)   __P ((stream_t *));

  int  (*open)      __P ((stream_t, const char *, int, int));
  int  (*close)     __P ((stream_t));

  int  (*read)      __P ((stream_t, void *, size_t, off_t, size_t *));
  int  (*readline)  __P ((stream_t, char *, size_t, off_t, size_t *));
  int  (*write)     __P ((stream_t, const void *, size_t, off_t, size_t *));

  int  (*tell)      __P ((stream_t, off_t *));

  int  (*get_size)  __P ((stream_t, off_t *));
  int  (*truncate)  __P ((stream_t, off_t));
  int  (*flush)     __P ((stream_t));

  int  (*get_fd)    __P ((stream_t , int *));
  int  (*get_flags) __P ((stream_t, int *));
  int  (*get_state) __P ((stream_t, enum stream_state *));

  int  (*is_seekable) __P ((stream_t));
  int  (*is_readready) __P ((stream_t, int));
  int  (*is_writeready) __P ((stream_t, int));
  int  (*is_exceptionpending) __P ((stream_t, int));

  int  (*is_open) __P ((stream_t));
};

struct _stream
{
  struct _stream_vtable *vtable;
};

#ifdef __cplusplus
}
#endif

#endif /* _MAILUTILS_SYS_STREAM_H */
