/* GNU Mailutils -- a suite of utilities for electronic mail
   Copyright (C) 1999, 2000, 2001 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA  */

#ifndef _MAILUTILS_SYS_DATTRIBUTE_H
# define _MAILUTILS_SYS_DATTRIBUTE_H

#ifdef DMALLOC
#  include <dmalloc.h>
#endif

#include <mailutils/sys/attribute.h>
#include <mailutils/refcount.h>

#ifdef __cplusplus
extern "C" {
#endif

/* A simple default attribute implementation.  */
struct _attribute_default
{
  struct _attribute base;
  mu_refcount_t refcount;
  int flags;
  int userflags;
};

extern int  _attribute_default_ctor        __P ((struct _attribute_default *));
extern void _attribute_default_dtor        __P ((attribute_t));
extern int  _attribute_default_ref         __P ((attribute_t));
extern void _attribute_default_destroy     __P ((attribute_t *));

extern int  _attribute_default_get_flags   __P ((attribute_t, int *));
extern int  _attribute_default_set_flags   __P ((attribute_t, int));
extern int  _attribute_default_unset_flags __P ((attribute_t, int));
extern int  _attribute_default_clear_flags __P ((attribute_t));

extern int  _attribute_default_get_userflags   __P ((attribute_t, int *));
extern int  _attribute_default_set_userflags   __P ((attribute_t, int));
extern int  _attribute_default_unset_userflags __P ((attribute_t, int));
extern int  _attribute_default_clear_userflags __P ((attribute_t));

#ifdef __cplusplus
}
#endif

#endif /* _MAILUTILS_SYS_ATTRIBUTE_H */
