/* GNU Mailutils -- a suite of utilities for electronic mail
   Copyright (C) 1999, 2000, 2001 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA  */

#ifndef _MAILUTILS_BODY_H
#define _MAILUTILS_BODY_H

#include <sys/types.h>
#include <mailutils/mu_features.h>
#include <mailutils/types.h>
#include <mailutils/property.h>
#include <mailutils/stream.h>

#ifdef __cplusplus
extern "C" {
#endif

/* forward declaration */

extern int  body_ref            __P ((body_t));
extern void body_release        __P ((body_t *));
extern int  body_destroy        __P ((body_t));

extern int  body_is_modified    __P ((body_t));
extern int  body_clear_modified __P ((body_t));

extern int  body_get_stream     __P ((body_t, stream_t *));

extern int  body_get_property   __P ((body_t, property_t *));

extern int  body_get_size       __P ((body_t, size_t*));
extern int  body_get_lines      __P ((body_t, size_t *));

#ifdef __cplusplus
}
#endif

#endif /* _MAILUTILS_BODY_H */
