

from wxPython.wx import *
import gmPG

class PnlAddress(wxPanel):
	def __init__(self, parent, id,
		pos = wxPyDefaultPosition, size = wxPyDefaultSize,
		style = wxTAB_TRAVERSAL):
		
		wxPanel.__init__(self, parent, id, pos, size, style)

		self.parent = parent
		self.labelfont = wxFont(9, wxSWISS, wxNORMAL, wxNORMAL, 0, "")
		self.label_title = wxStaticText(self, -1, "Title")
		self.combo_box_title = wxComboBox(self, -1, choices=['choice 1'], style=wxCB_DROPDOWN)
		self.label_firstnames = wxStaticText(self, -1, "First Name(s)")
		self.text_ctrl_firstnames = wxTextCtrl(self, -1, "")
		self.label_lastnames = wxStaticText(self, -1, "Last Name(s)")
		self.text_ctrl_lastnames = wxTextCtrl(self, -1, "")
		self.button_previous_names = wxButton(self, -1, "previous")
		self.button_add_name = wxButton(self, -1, "+")
		self.button_delete_name = wxButton(self, -1, "-")
		self.label_gender = wxStaticText(self, -1, "Gender")
		self.combo_box_gender = wxComboBox(self, -1, choices=['choice 1'], style=wxCB_DROPDOWN)
		self.label_dob = wxStaticText(self, -1, "Date of Birth")
		self.text_ctrl_dob = wxTextCtrl(self, -1, "")
		self.label_pob = wxStaticText(self, -1, "Place of Birth")
		self.text_ctrl_pob = wxTextCtrl(self, -1, "")
		self.label_cob = wxStaticText(self, -1, "Country of Birth")
		self.combo_box_cob = wxComboBox(self, -1, choices=['choice 1'], style=wxCB_DROPDOWN)
		self.static_line_person_address = wxStaticLine(self, -1)
		self.label_address_at = wxStaticText(self, -1, "Address at")
		self.combo_box_addressat = wxComboBox(self, -1, choices=['choice 1'], style=wxCB_DROPDOWN)
		self.button_addressat_previous = wxButton(self, -1, "<")
		self.button_addressat_add = wxButton(self, -1, "+")
		self.button_addressat_delete = wxButton(self, -1, "-")
		self.button_addressat_next = wxButton(self, -1, ">")
		self.text_ctrl_address = wxTextCtrl(self, -1, "", style=wxTE_MULTILINE)
		self.label_streetnumber = wxStaticText(self, -1, "Number")
		self.text_ctrl_streetnumber = wxTextCtrl(self, -1, "")
		self.label_street = wxStaticText(self, -1, "Street")
		self.combo_box_street = wxComboBox(self, -1, choices=['choice 1'], style=wxCB_DROPDOWN)
		self.label_city = wxStaticText(self, -1, "City / Town")
		self.text_ctrl_city = wxTextCtrl(self, -1, "")
		self.label_postcode = wxStaticText(self, -1, "Postcode")
		self.text_ctrl_postcode = wxTextCtrl(self, -1, "")
		self.label_state = wxStaticText(self, -1, "State")
		self.combo_box_state = wxComboBox(self, -1, choices=['choice 1'], style=wxCB_DROPDOWN)
		self.label_country = wxStaticText(self, -1, "Country")
		self.combo_box_country = wxComboBox(self, -1, choices=['choice 1'], style=wxCB_DROPDOWN)
		self.label_device = wxStaticText(self, -1, "Device")
		self.combo_box_phone = wxComboBox(self, -1, choices=['Phone', 'Fax', 'Pager'], style=wxCB_DROPDOWN)
		self.label_devicelocation = wxStaticText(self, -1, "Location")
		self.combo_box_devicelocation = wxComboBox(self, -1, choices=['choice 1'], style=wxCB_DROPDOWN)
		self.label_phone_country = wxStaticText(self, -1, "Country")
		self.combo_box_phone_country = wxComboBox(self, -1, choices=['choice 1'], style=wxCB_DROPDOWN)
		self.label_areacode = wxStaticText(self, -1, "Area")
		self.text_ctrl_areacode = wxTextCtrl(self, -1, "")
		self.label_phone_number = wxStaticText(self, -1, "Number")
		self.text_ctrl_phone_number = wxTextCtrl(self, -1, "")
		self.label_phone_extension = wxStaticText(self, -1, "Ext.")
		self.text_ctrl_phone_extension = wxTextCtrl(self, -1, "")
		self.label_phone_comment = wxStaticText(self, -1, "Comment")
		self.text_ctrl_phone_comment = wxTextCtrl(self, -1, "")
		self.button_add_phone = wxButton(self, -1, "+")
		self.button_delete_phone = wxButton(self, -1, "-")
		self.label_internet_type = wxStaticText(self, -1, "Type")
		self.combo_box_internet_type = wxComboBox(self, -1, choices=['choice 1'], style=wxCB_DROPDOWN)
		self.label_URL = wxStaticText(self, -1, "URL")
		self.text_ctrl_URL = wxTextCtrl(self, -1, "")
		self.label_URL_comment = wxStaticText(self, -1, "Comment")
		self.text_ctrl_URL_comment = wxTextCtrl(self, -1, "")
		self.button_URL_add = wxButton(self, -1, "+")
		self.button_URL_delete = wxButton(self, -1, "-")
		
		self.__set_properties()
		self.__do_layout()


	def __set_properties(self):
		# begin wxGlade: __set_properties
		#self.SetTitle("Addressbook")
		self.label_title.SetFont(self.labelfont)
		self.combo_box_title.SetSize((80, 22))
		self.combo_box_title.SetSelection(0)
		self.label_firstnames.SetFont(self.labelfont)
		self.text_ctrl_firstnames.SetSize((231, 22))
		self.label_lastnames.SetSize((73, 16))
		self.label_lastnames.SetFont(self.labelfont)
		self.button_previous_names.SetSize((60, 22))
		self.button_add_name.SetSize((22, 22))
		self.button_delete_name.SetSize((22, 22))
		self.label_gender.SetFont(wxFont(8, wxSWISS, wxNORMAL, wxNORMAL, 0, "5"))
		self.combo_box_gender.SetSize((80, 22))
		self.combo_box_gender.SetSelection(0)
		self.label_dob.SetFont(wxFont(8, wxSWISS, wxNORMAL, wxNORMAL, 0, "5"))
		self.label_pob.SetFont(wxFont(8, wxSWISS, wxNORMAL, wxNORMAL, 0, "5"))
		self.label_cob.SetFont(wxFont(8, wxSWISS, wxNORMAL, wxNORMAL, 0, "5"))
		self.combo_box_cob.SetSize((104, 22))
		self.combo_box_cob.SetSelection(0)
		self.combo_box_addressat.SetSelection(0)
		self.button_addressat_previous.SetSize((22, 22))
		self.button_addressat_add.SetSize((22, 22))
		self.button_addressat_delete.SetSize((22, 22))
		self.button_addressat_next.SetSize((22, 22))
		self.text_ctrl_address.SetSize((650, 34))
		self.label_streetnumber.SetFont(wxFont(8, wxSWISS, wxNORMAL, wxNORMAL, 0, "5"))
		self.label_street.SetFont(wxFont(8, wxSWISS, wxNORMAL, wxNORMAL, 0, "5"))
		self.combo_box_street.SetSelection(0)
		self.label_city.SetFont(wxFont(8, wxSWISS, wxNORMAL, wxNORMAL, 0, "5"))
		self.label_state.SetFont(wxFont(8, wxSWISS, wxNORMAL, wxNORMAL, 0, "5"))
		self.combo_box_state.SetSelection(0)
		self.label_country.SetFont(wxFont(8, wxSWISS, wxNORMAL, wxNORMAL, 0, ""))
		self.combo_box_country.SetSelection(0)
		self.label_device.SetFont(wxFont(8, wxSWISS, wxNORMAL, wxNORMAL, 0, ""))
		self.combo_box_phone.SetSize((80, 22))
		self.combo_box_phone.SetSelection(0)
		self.label_devicelocation.SetFont(wxFont(8, wxSWISS, wxNORMAL, wxNORMAL, 0, ""))
		self.combo_box_devicelocation.SetSize((80, 22))
		self.combo_box_devicelocation.SetSelection(0)
		self.label_phone_country.SetFont(wxFont(8, wxSWISS, wxNORMAL, wxNORMAL, 0, ""))
		self.combo_box_phone_country.SetSize((50, 22))
		self.combo_box_phone_country.SetSelection(0)
		self.label_areacode.SetFont(wxFont(8, wxSWISS, wxNORMAL, wxNORMAL, 0, ""))
		self.text_ctrl_areacode.SetSize((40, 22))
		self.label_phone_number.SetFont(wxFont(8, wxSWISS, wxNORMAL, wxNORMAL, 0, ""))
		self.label_phone_extension.SetFont(wxFont(8, wxSWISS, wxNORMAL, wxNORMAL, 0, ""))
		self.text_ctrl_phone_extension.SetSize((40, 22))
		self.label_phone_comment.SetFont(wxFont(8, wxSWISS, wxNORMAL, wxNORMAL, 0, ""))
		self.button_add_phone.SetSize((22, 22))
		self.button_delete_phone.SetSize((22, 22))
		self.label_internet_type.SetFont(wxFont(10, wxSWISS, wxNORMAL, wxNORMAL, 0, ""))
		self.combo_box_internet_type.SetSize((80, 22))
		self.combo_box_internet_type.SetSelection(0)
		self.label_URL.SetFont(wxFont(10, wxSWISS, wxNORMAL, wxNORMAL, 0, ""))
		self.label_URL_comment.SetFont(wxFont(8, wxSWISS, wxNORMAL, wxNORMAL, 0, ""))
		self.button_URL_add.SetSize((22, 22))
		self.button_URL_delete.SetSize((22, 22))
	        self.SetFont(wxFont(8, wxSWISS, wxNORMAL, wxNORMAL, 0, ""))
        	

	def __do_layout(self):
        # begin wxGlade: __do_layout
		szr_top = wxBoxSizer(wxVERTICAL)
		sizer_V_tops_person = wxBoxSizer(wxVERTICAL)
		sizer_V_communication = wxBoxSizer(wxVERTICAL)
		sizer_H_Internet = wxStaticBoxSizer(wxStaticBox(self, -1, "Internet"), wxHORIZONTAL)
		sizer_URL_comment = wxBoxSizer(wxVERTICAL)
		sizer_V_URL = wxBoxSizer(wxVERTICAL)
		sizer_V_internet_type = wxBoxSizer(wxVERTICAL)
		sizer_HS_phone = wxStaticBoxSizer(wxStaticBox(self, -1, "Phone / Fax / Pager"), wxHORIZONTAL)
		sizer_V_phone_comment = wxBoxSizer(wxVERTICAL)
		sizer_V_phone_extension = wxBoxSizer(wxVERTICAL)
		sizer_V_phone_number = wxBoxSizer(wxVERTICAL)
		sizer_V_areacode = wxBoxSizer(wxVERTICAL)
		sizer_V_phone_country = wxBoxSizer(wxVERTICAL)
		sizer_V_device_location = wxBoxSizer(wxVERTICAL)
		sizer_V_device = wxBoxSizer(wxVERTICAL)
		sizer_H_location = wxBoxSizer(wxHORIZONTAL)
		sizer_country = wxBoxSizer(wxVERTICAL)
		sizer_V_state = wxBoxSizer(wxVERTICAL)
		sizer_V_postcode = wxBoxSizer(wxVERTICAL)
		sizer_V_city = wxBoxSizer(wxVERTICAL)
		sizer_H_street_details = wxBoxSizer(wxHORIZONTAL)
		sizer_V_street = wxBoxSizer(wxVERTICAL)
		sizer_V_streetnumber = wxBoxSizer(wxVERTICAL)
		sizer_address_at = wxBoxSizer(wxHORIZONTAL)
		sizer_H_birthdetails = wxBoxSizer(wxHORIZONTAL)
		sizer_V_cob = wxBoxSizer(wxVERTICAL)
		sizer_V_pob = wxBoxSizer(wxVERTICAL)
		sizer_V_dob = wxBoxSizer(wxVERTICAL)
		sizer_V_gender = wxBoxSizer(wxVERTICAL)
		sizer_H_names = wxBoxSizer(wxHORIZONTAL)
		sizer_V_lastnames = wxBoxSizer(wxVERTICAL)
		sizer_V_firstnames = wxBoxSizer(wxVERTICAL)
		sizer_V_title = wxBoxSizer(wxVERTICAL)
		sizer_V_title.Add(self.label_title, 0, 0, 0)
		sizer_V_title.Add(self.combo_box_title, 0, 0, 0)
		sizer_H_names.Add(sizer_V_title, 0, 0, 0)
		sizer_V_firstnames.Add(self.label_firstnames, 0, 0, 0)
		sizer_V_firstnames.Add(self.text_ctrl_firstnames, 0, wxEXPAND, 0)
		sizer_H_names.Add(sizer_V_firstnames, 1, wxEXPAND, 0)
		sizer_V_lastnames.Add(self.label_lastnames, 0, 0, 0)
		sizer_V_lastnames.Add(self.text_ctrl_lastnames, 0, wxEXPAND, 0)
		sizer_H_names.Add(sizer_V_lastnames, 1, wxEXPAND, 0)
		sizer_H_names.Add(self.button_previous_names, 0, wxALIGN_BOTTOM, 0)
		sizer_H_names.Add(self.button_add_name, 0, wxALIGN_BOTTOM, 0)
		sizer_H_names.Add(self.button_delete_name, 0, wxALIGN_BOTTOM, 0)
		sizer_V_tops_person.Add(sizer_H_names, 0, wxEXPAND, 0)
		sizer_V_gender.Add(self.label_gender, 0, 0, 0)
		sizer_V_gender.Add(self.combo_box_gender, 0, 0, 0)
		sizer_H_birthdetails.Add(sizer_V_gender, 0, wxEXPAND, 0)
		sizer_V_dob.Add(self.label_dob, 0, 0, 0)
		sizer_V_dob.Add(self.text_ctrl_dob, 0, wxEXPAND, 0)
		sizer_H_birthdetails.Add(sizer_V_dob, 1, wxEXPAND, 0)
		sizer_V_pob.Add(self.label_pob, 0, 0, 0)
		sizer_V_pob.Add(self.text_ctrl_pob, 0, wxEXPAND, 0)
		sizer_H_birthdetails.Add(sizer_V_pob, 1, wxEXPAND, 0)
		sizer_V_cob.Add(self.label_cob, 0, 0, 0)
		sizer_V_cob.Add(self.combo_box_cob, 0, 0, 0)
		sizer_H_birthdetails.Add(sizer_V_cob, 0, wxEXPAND, 0)
		sizer_V_tops_person.Add(sizer_H_birthdetails, 0, wxEXPAND, 0)
		sizer_V_tops_person.Add(self.static_line_person_address, 0, wxTOP|wxBOTTOM|wxEXPAND, 5)
		sizer_address_at.Add(self.label_address_at, 0, wxLEFT|wxRIGHT, 10)
		sizer_address_at.Add(self.combo_box_addressat, 1, 0, 0)
		sizer_address_at.Add(self.button_addressat_previous, 0, 0, 0)
		sizer_address_at.Add(self.button_addressat_add, 0, 0, 0)
		sizer_address_at.Add(self.button_addressat_delete, 0, 0, 0)
		sizer_address_at.Add(self.button_addressat_next, 0, 0, 0)
		sizer_V_tops_person.Add(sizer_address_at, 0, wxEXPAND, 0)
		sizer_V_tops_person.Add(self.text_ctrl_address, 0, wxEXPAND, 0)
		sizer_V_streetnumber.Add(self.label_streetnumber, 0, 0, 0)
		sizer_V_streetnumber.Add(self.text_ctrl_streetnumber, 0, 0, 0)
		sizer_H_street_details.Add(sizer_V_streetnumber, 0, wxEXPAND, 0)
		sizer_V_street.Add(self.label_street, 0, 0, 0)
		sizer_V_street.Add(self.combo_box_street, 0, wxEXPAND, 0)
		sizer_H_street_details.Add(sizer_V_street, 1, wxEXPAND, 0)
		sizer_V_tops_person.Add(sizer_H_street_details, 0, wxEXPAND, 0)
		sizer_V_city.Add(self.label_city, 0, 0, 0)
		sizer_V_city.Add(self.text_ctrl_city, 0, wxEXPAND, 0)
		sizer_H_location.Add(sizer_V_city, 1, wxEXPAND, 0)
		sizer_V_postcode.Add(self.label_postcode, 0, 0, 0)
		sizer_V_postcode.Add(self.text_ctrl_postcode, 0, 0, 0)
		sizer_H_location.Add(sizer_V_postcode, 0, 0, 0)
		sizer_V_state.Add(self.label_state, 0, 0, 0)
		sizer_V_state.Add(self.combo_box_state, 0, 0, 0)
		sizer_H_location.Add(sizer_V_state, 0, 0, 0)
		sizer_country.Add(self.label_country, 0, 0, 0)
		sizer_country.Add(self.combo_box_country, 0, 0, 0)
		sizer_H_location.Add(sizer_country, 0, 0, 0)
		sizer_V_tops_person.Add(sizer_H_location, 0, wxEXPAND, 0)
		sizer_V_device.Add(self.label_device, 0, 0, 0)
		sizer_V_device.Add(self.combo_box_phone, 0, 0, 0)
		sizer_HS_phone.Add(sizer_V_device, 0, wxEXPAND, 0)
		sizer_V_device_location.Add(self.label_devicelocation, 0, 0, 0)
		sizer_V_device_location.Add(self.combo_box_devicelocation, 0, 0, 0)
		sizer_HS_phone.Add(sizer_V_device_location, 0, wxEXPAND, 0)
		sizer_V_phone_country.Add(self.label_phone_country, 0, 0, 0)
		sizer_V_phone_country.Add(self.combo_box_phone_country, 0, 0, 0)
		sizer_HS_phone.Add(sizer_V_phone_country, 0, wxEXPAND, 0)
		sizer_V_areacode.Add(self.label_areacode, 0, 0, 0)
		sizer_V_areacode.Add(self.text_ctrl_areacode, 0, 0, 0)
		sizer_HS_phone.Add(sizer_V_areacode, 0, 0, 0)
		sizer_V_phone_number.Add(self.label_phone_number, 0, 0, 0)
		sizer_V_phone_number.Add(self.text_ctrl_phone_number, 0, wxEXPAND, 0)
		sizer_HS_phone.Add(sizer_V_phone_number, 1, wxEXPAND, 0)
		sizer_V_phone_extension.Add(self.label_phone_extension, 0, 0, 0)
		sizer_V_phone_extension.Add(self.text_ctrl_phone_extension, 0, 0, 0)
		sizer_HS_phone.Add(sizer_V_phone_extension, 0, wxEXPAND, 0)
		sizer_V_phone_comment.Add(self.label_phone_comment, 0, 0, 0)
		sizer_V_phone_comment.Add(self.text_ctrl_phone_comment, 0, wxEXPAND, 0)
		sizer_HS_phone.Add(sizer_V_phone_comment, 1, wxEXPAND, 0)
		sizer_HS_phone.Add(self.button_add_phone, 0, wxALIGN_BOTTOM, 0)
		sizer_HS_phone.Add(self.button_delete_phone, 0, wxALIGN_BOTTOM, 0)
		sizer_V_communication.Add(sizer_HS_phone, 0, wxEXPAND, 0)
		sizer_V_internet_type.Add(self.label_internet_type, 0, 0, 0)
		sizer_V_internet_type.Add(self.combo_box_internet_type, 0, 0, 0)
		sizer_H_Internet.Add(sizer_V_internet_type, 0, wxEXPAND, 0)
		sizer_V_URL.Add(self.label_URL, 0, 0, 0)
		sizer_V_URL.Add(self.text_ctrl_URL, 0, wxEXPAND, 0)
		sizer_H_Internet.Add(sizer_V_URL, 1, wxEXPAND, 0)
		sizer_URL_comment.Add(self.label_URL_comment, 0, 0, 0)
		sizer_URL_comment.Add(self.text_ctrl_URL_comment, 0, wxEXPAND, 0)
		sizer_H_Internet.Add(sizer_URL_comment, 1, wxEXPAND, 0)
		sizer_H_Internet.Add(self.button_URL_add, 0, wxALIGN_BOTTOM, 0)
		sizer_H_Internet.Add(self.button_URL_delete, 0, wxALIGN_RIGHT|wxALIGN_BOTTOM, 0)
		sizer_V_communication.Add(sizer_H_Internet, 0, wxEXPAND, 0)
		sizer_V_tops_person.Add(sizer_V_communication, 1, wxTOP|wxBOTTOM|wxEXPAND, 5)
		szr_top.Add(sizer_V_tops_person, 1, wxEXPAND, 0)
		self.SetAutoLayout(1)
		self.SetSizer(szr_top)
		szr_top.Fit(self)
		self.Layout()
		self.set_defaults()
		
	def set_defaults(self):
		con = gmPG.ConnectionPool.GetConnection()
		cursor = con.cursor()
		cursor.execute("select short, id from titles")
		titles = cursor.fetchall()
		self.combo_box_title.Clear()
		for title in titles:
			self.combo_box_title.Append(title[0], title[1])
        
		
# end of class AddressDialog
if __name__ == "__main__":
	app = wxPyWidgetTester(size = (600, 400))
	app.SetWidget(PnlAddress, -1)
	app.MainLoop()


