--
-- Selected TOC Entries:
--
--
-- TOC Entry ID 117 (OID 35306)
--
-- Name: "plpgsql_call_handler" () Type: FUNCTION Owner: syan
--

CREATE FUNCTION "plpgsql_call_handler" () RETURNS opaque AS '/usr/lib/pgsql/plpgsql.so', 'plpgsql_call_handler' LANGUAGE 'C';

--
-- TOC Entry ID 118 (OID 35307)
--
-- Name: plpgsql Type: PROCEDURAL LANGUAGE Owner: 
--

CREATE TRUSTED PROCEDURAL LANGUAGE 'plpgsql' HANDLER "plpgsql_call_handler" LANCOMPILER 'PL/pgSQL';

--
-- TOC Entry ID 2 (OID 35308)
--
-- Name: db_id_seq Type: SEQUENCE Owner: syan
--

CREATE SEQUENCE "db_id_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 38 (OID 35310)
--
-- Name: db Type: TABLE Owner: syan
--

CREATE TABLE "db" (
	"id" integer DEFAULT nextval('"db_id_seq"'::text) NOT NULL,
	"name" character(35),
	"port" integer DEFAULT 5432,
	"host" character varying(255) DEFAULT 'localhost',
	"opt" character varying(255) DEFAULT '',
	"tty" character varying(255) DEFAULT '',
	Constraint "db_pkey" Primary Key ("id")
);

--
-- TOC Entry ID 4 (OID 35313)
--
-- Name: distributed_db_id_seq Type: SEQUENCE Owner: syan
--

CREATE SEQUENCE "distributed_db_id_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 43 (OID 35315)
--
-- Name: distributed_db Type: TABLE Owner: syan
--

CREATE TABLE "distributed_db" (
	"id" integer DEFAULT nextval('"distributed_db_id_seq"'::text) NOT NULL,
	"name" character(35),
	Constraint "distributed_db_pkey" Primary Key ("id")
);

--
-- TOC Entry ID 6 (OID 35330)
--
-- Name: config_id_seq Type: SEQUENCE Owner: syan
--

CREATE SEQUENCE "config_id_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 45 (OID 35332)
--
-- Name: config Type: TABLE Owner: syan
--

CREATE TABLE "config" (
	"id" integer DEFAULT nextval('"config_id_seq"'::text) NOT NULL,
	"profile" character(25) DEFAULT 'default',
	"username" character(25) DEFAULT "current_user"(),
	"ddb" integer,
	"db" integer,
	"crypt_pwd" character varying(255),
	"crypt_algo" character varying(255),
	"pwd_hash" character varying(255),
	"hash_algo" character varying(255),
	Constraint "config_pkey" Primary Key ("id")
);

--
-- TOC Entry ID 8 (OID 35347)
--
-- Name: queries_id_seq Type: SEQUENCE Owner: syan
--

CREATE SEQUENCE "queries_id_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 55 (OID 35349)
--
-- Name: queries Type: TABLE Owner: syan
--

CREATE TABLE "queries" (
	"id" integer DEFAULT nextval('"queries_id_seq"'::text) NOT NULL,
	"name" character(40),
	"db" integer,
	"query" text,
	Constraint "queries_pkey" Primary Key ("id")
);

--
-- TOC Entry ID 10 (OID 35361)
--
-- Name: audit_identity_audit_id_seq Type: SEQUENCE Owner: syan
--

CREATE SEQUENCE "audit_identity_audit_id_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 56 (OID 35363)
--
-- Name: audit_identity Type: TABLE Owner: syan
--

CREATE TABLE "audit_identity" (
	"audit_id" integer DEFAULT nextval('"audit_identity_audit_id_seq"'::text) NOT NULL,
	Constraint "audit_identity_pkey" Primary Key ("audit_id")
);

--
-- TOC Entry ID 12 (OID 35366)
--
-- Name: identity_id_seq Type: SEQUENCE Owner: syan
--

CREATE SEQUENCE "identity_id_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 58 (OID 35368)
--
-- Name: identity Type: TABLE Owner: syan
--

CREATE TABLE "identity" (
	"id" integer DEFAULT nextval('"identity_id_seq"'::text) NOT NULL,
	"pupic" character(24),
	"gender" character(2) DEFAULT '?',
	"karyotype" character(10),
	"dob" character(10),
	"cob" character(2),
	"deceased" date,
	CONSTRAINT "identity_gender" CHECK (((((((gender = 'm'::bpchar) OR (gender = 'f'::bpchar)) OR (gender = 'h'::bpchar)) OR (gender = 'tm'::bpchar)) OR (gender = 'tf'::bpchar)) OR (gender = '?'::bpchar))),
	Constraint "identity_pkey" Primary Key ("id")
)
INHERITS ("audit_identity");

--
-- TOC Entry ID 14 (OID 35371)
--
-- Name: names_id_seq Type: SEQUENCE Owner: syan
--

CREATE SEQUENCE "names_id_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 65 (OID 35373)
--
-- Name: names Type: TABLE Owner: syan
--

CREATE TABLE "names" (
	"id" integer DEFAULT nextval('"names_id_seq"'::text) NOT NULL,
	"id_identity" integer,
	"active" boolean DEFAULT 't',
	"lastnames" character varying(80),
	"firstnames" character varying(255),
	"preferred" character varying(80),
	"title" character varying(80),
	Constraint "names_pkey" Primary Key ("id")
)
INHERITS ("audit_identity");

--
-- TOC Entry ID 119 (OID 35382)
--
-- Name: "check_active_name" () Type: FUNCTION Owner: syan
--

CREATE FUNCTION "check_active_name" () RETURNS opaque AS '
DECLARE
BEGIN
	IF NEW.active THEN
	   UPDATE names SET active=''f'' WHERE id_identity = NEW.id_identity
	   AND active;
	END IF;
	RETURN NEW;
END;' LANGUAGE 'plpgsql';

--
-- TOC Entry ID 16 (OID 35384)
--
-- Name: relation_types_id_seq Type: SEQUENCE Owner: syan
--

CREATE SEQUENCE "relation_types_id_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 71 (OID 35386)
--
-- Name: relation_types Type: TABLE Owner: syan
--

CREATE TABLE "relation_types" (
	"id" integer DEFAULT nextval('"relation_types_id_seq"'::text) NOT NULL,
	"biological" boolean,
	"biol_verified" boolean DEFAULT 'f'::bool,
	"description" character varying(40),
	Constraint "relation_types_pkey" Primary Key ("id")
)
INHERITS ("audit_identity");

--
-- TOC Entry ID 18 (OID 35398)
--
-- Name: relation_id_seq Type: SEQUENCE Owner: syan
--

CREATE SEQUENCE "relation_id_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 76 (OID 35400)
--
-- Name: relation Type: TABLE Owner: syan
--

CREATE TABLE "relation" (
	"id" integer DEFAULT nextval('"relation_id_seq"'::text) NOT NULL,
	"id_identity" integer,
	"id_relative" integer,
	"id_relation_type" integer,
	"started" date,
	"ended" date,
	Constraint "relation_pkey" Primary Key ("id")
)
INHERITS ("audit_identity");

--
-- TOC Entry ID 82 (OID 35423)
--
-- Name: v_basic_person Type: VIEW Owner: syan
--

CREATE VIEW "v_basic_person" as SELECT i.id, n.title, n.firstnames, n.lastnames, i.dob, i.cob, i.gender FROM identity i, "names" n WHERE (((i.deceased IS NULL) AND (n.id_identity = i.id)) AND (n.active = 't'::bool));

--
-- TOC Entry ID 120 (OID 35424)
--
-- Name: "new_pupic" () Type: FUNCTION Owner: syan
--

CREATE FUNCTION "new_pupic" () RETURNS character AS '
DECLARE
BEGIN
   -- how does this work? How do we get new ''unique'' numbers?
   RETURN ''0000000000'';
END;' LANGUAGE 'plpgsql';

--
-- TOC Entry ID 121 (OID 35429)
--
-- Name: "delete_names" () Type: FUNCTION Owner: syan
--

CREATE FUNCTION "delete_names" () RETURNS opaque AS '
DECLARE
BEGIN
	DELETE FROM names WHERE id_identity=OLD.id;
	RETURN OLD;
END;' LANGUAGE 'plpgsql';

--
-- TOC Entry ID 20 (OID 35431)
--
-- Name: audit_gis_audit_id_seq Type: SEQUENCE Owner: syan
--

CREATE SEQUENCE "audit_gis_audit_id_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 83 (OID 35433)
--
-- Name: audit_gis Type: TABLE Owner: syan
--

CREATE TABLE "audit_gis" (
	"audit_id" integer DEFAULT nextval('"audit_gis_audit_id_seq"'::text) NOT NULL,
	Constraint "audit_gis_pkey" Primary Key ("audit_id")
);

--
-- TOC Entry ID 85 (OID 35436)
--
-- Name: country Type: TABLE Owner: syan
--

CREATE TABLE "country" (
	"code" character(2) NOT NULL,
	"name" character varying(80),
	"deprecated" date,
	Constraint "country_pkey" Primary Key ("code")
);

--
-- TOC Entry ID 22 (OID 35439)
--
-- Name: state_id_seq Type: SEQUENCE Owner: syan
--

CREATE SEQUENCE "state_id_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 89 (OID 35441)
--
-- Name: state Type: TABLE Owner: syan
--

CREATE TABLE "state" (
	"id" integer DEFAULT nextval('"state_id_seq"'::text) NOT NULL,
	"code" character(10),
	"country" character(2),
	"name" character varying(60),
	"deprecated" date,
	Constraint "state_pkey" Primary Key ("id")
)
INHERITS ("audit_gis");

--
-- TOC Entry ID 24 (OID 35451)
--
-- Name: urb_id_seq Type: SEQUENCE Owner: syan
--

CREATE SEQUENCE "urb_id_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 93 (OID 35453)
--
-- Name: urb Type: TABLE Owner: syan
--

CREATE TABLE "urb" (
	"id" integer DEFAULT nextval('"urb_id_seq"'::text) NOT NULL,
	"statecode" integer,
	"postcode" character(8),
	"name" character varying(60),
	Constraint "urb_pkey" Primary Key ("id")
)
INHERITS ("audit_gis");

--
-- TOC Entry ID 26 (OID 35462)
--
-- Name: street_id_seq Type: SEQUENCE Owner: syan
--

CREATE SEQUENCE "street_id_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 98 (OID 35464)
--
-- Name: street Type: TABLE Owner: syan
--

CREATE TABLE "street" (
	"id" integer DEFAULT nextval('"street_id_seq"'::text) NOT NULL,
	"id_urb" integer NOT NULL,
	"name" character varying(60),
	Constraint "street_pkey" Primary Key ("id")
)
INHERITS ("audit_gis");

--
-- TOC Entry ID 28 (OID 35473)
--
-- Name: address_type_id_seq Type: SEQUENCE Owner: syan
--

CREATE SEQUENCE "address_type_id_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 102 (OID 35475)
--
-- Name: address_type Type: TABLE Owner: syan
--

CREATE TABLE "address_type" (
	"id" integer DEFAULT nextval('"address_type_id_seq"'::text) NOT NULL,
	"name" character(10) NOT NULL,
	Constraint "address_type_pkey" Primary Key ("id")
)
INHERITS ("audit_gis");

--
-- TOC Entry ID 30 (OID 35483)
--
-- Name: address_id_seq Type: SEQUENCE Owner: syan
--

CREATE SEQUENCE "address_id_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 103 (OID 35485)
--
-- Name: address Type: TABLE Owner: syan
--

CREATE TABLE "address" (
	"id" integer DEFAULT nextval('"address_id_seq"'::text) NOT NULL,
	"street" integer,
	"number" character(10),
	"addendum" text,
	Constraint "address_pkey" Primary Key ("id")
)
INHERITS ("audit_gis");

--
-- TOC Entry ID 104 (OID 35497)
--
-- Name: address_external_ref Type: TABLE Owner: syan
--

CREATE TABLE "address_external_ref" (
	"id" integer NOT NULL,
	"refcounter" integer DEFAULT 0,
	Constraint "address_external_ref_pkey" Primary Key ("id")
);

--
-- TOC Entry ID 122 (OID 35506)
--
-- Name: "find_state" (text,text) Type: FUNCTION Owner: syan
--

CREATE FUNCTION "find_state" (text,text) RETURNS text AS '
DECLARE
        pcode ALIAS FOR $1;
	ccode ALIAS FOR $2;
        s RECORD;
	retval text := NULL;
BEGIN
        SELECT INTO s * FROM state WHERE id =
	(SELECT statecode from urb where postcode like pcode||''%'' limit 1)
	AND country=ccode;
        IF FOUND THEN
           retval := s.code;
        END IF;
	RETURN retval;
END;' LANGUAGE 'plpgsql';

--
-- TOC Entry ID 32 (OID 35507)
--
-- Name: identities_addresses_id_seq Type: SEQUENCE Owner: syan
--

CREATE SEQUENCE "identities_addresses_id_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 105 (OID 35509)
--
-- Name: identities_addresses Type: TABLE Owner: syan
--

CREATE TABLE "identities_addresses" (
	"id" integer DEFAULT nextval('"identities_addresses_id_seq"'::text) NOT NULL,
	"id_identity" integer,
	"id_address" integer,
	"id_type" integer DEFAULT 1,
	"address_source" character varying(30),
	Constraint "identities_addresses_pkey" Primary Key ("id")
)
INHERITS ("audit_identity");

--
-- TOC Entry ID 110 (OID 35532)
--
-- Name: v_basic_address Type: VIEW Owner: syan
--

CREATE VIEW "v_basic_address" as SELECT ia.id, a.id AS addr_id, s.country, s.code AS state, u.postcode, u.name AS city, a.number, str.name AS street, a.addendum AS street2, t.name AS address_at FROM identities_addresses ia, address a, state s, urb u, street str, address_type t WHERE (((((ia.id_address = a.id) AND (a.street = str.id)) AND (t.id = ia.id_type)) AND (str.id_urb = u.id)) AND (u.statecode = s.id));

--
-- TOC Entry ID 123 (OID 35533)
--
-- Name: "find_street" (text,integer) Type: FUNCTION Owner: syan
--

CREATE FUNCTION "find_street" (text,integer) RETURNS integer AS '
DECLARE
        s_name ALIAS FOR $1;
        s_id_urb ALIAS FOR $2;
        s RECORD;
BEGIN
        SELECT INTO s * FROM street WHERE name = s_name AND
               id_urb = s_id_urb;
        IF FOUND THEN
           RETURN s.id;
        ELSE
           INSERT INTO street (id_urb, name) VALUES (s_id_urb, s_name);
           RETURN currval (''street_id_seq'');
        END IF;
END;' LANGUAGE 'plpgsql';

--
-- TOC Entry ID 34 (OID 35536)
--
-- Name: mapbook_id_seq Type: SEQUENCE Owner: syan
--

CREATE SEQUENCE "mapbook_id_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 111 (OID 35538)
--
-- Name: mapbook Type: TABLE Owner: syan
--

CREATE TABLE "mapbook" (
	"id" integer DEFAULT nextval('"mapbook_id_seq"'::text) NOT NULL,
	"name" character(30)
);

--
-- TOC Entry ID 36 (OID 35541)
--
-- Name: coordinate_id_seq Type: SEQUENCE Owner: syan
--

CREATE SEQUENCE "coordinate_id_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 112 (OID 35543)
--
-- Name: coordinate Type: TABLE Owner: syan
--

CREATE TABLE "coordinate" (
	"id" integer DEFAULT nextval('"coordinate_id_seq"'::text) NOT NULL,
	"name" character varying(30),
	"scale" double precision
);

--
-- TOC Entry ID 113 (OID 35546)
--
-- Name: address_info Type: TABLE Owner: syan
--

CREATE TABLE "address_info" (
	"address_id" integer,
	"location" point,
	"id_coord" integer,
	"mapref" character(30),
	"id_map" integer,
	"howto_get_there" text,
	"comments" text
)
INHERITS ("audit_gis");

--
-- Data for TOC Entry ID 124 (OID 35310)
--
-- Name: db Type: TABLE DATA Owner: syan
--


--
-- Data for TOC Entry ID 125 (OID 35315)
--
-- Name: distributed_db Type: TABLE DATA Owner: syan
--


INSERT INTO "distributed_db" ("id","name") VALUES (1,'default                            ');
INSERT INTO "distributed_db" ("id","name") VALUES (2,'transactions                       ');
INSERT INTO "distributed_db" ("id","name") VALUES (3,'personalia                         ');
INSERT INTO "distributed_db" ("id","name") VALUES (4,'historica                          ');
INSERT INTO "distributed_db" ("id","name") VALUES (5,'extresults                         ');
INSERT INTO "distributed_db" ("id","name") VALUES (6,'correspondence                     ');
INSERT INTO "distributed_db" ("id","name") VALUES (7,'pharmaceutica                      ');
INSERT INTO "distributed_db" ("id","name") VALUES (8,'reference                          ');
INSERT INTO "distributed_db" ("id","name") VALUES (9,'blobs                              ');
INSERT INTO "distributed_db" ("id","name") VALUES (10,'accounting                         ');
INSERT INTO "distributed_db" ("id","name") VALUES (11,'office                             ');
INSERT INTO "distributed_db" ("id","name") VALUES (12,'modules                            ');
--
-- Data for TOC Entry ID 126 (OID 35332)
--
-- Name: config Type: TABLE DATA Owner: syan
--


--
-- Data for TOC Entry ID 127 (OID 35349)
--
-- Name: queries Type: TABLE DATA Owner: syan
--


--
-- Data for TOC Entry ID 128 (OID 35363)
--
-- Name: audit_identity Type: TABLE DATA Owner: syan
--


--
-- Data for TOC Entry ID 129 (OID 35368)
--
-- Name: identity Type: TABLE DATA Owner: syan
--


INSERT INTO "identity" ("audit_id","id","pupic","gender","karyotype","dob","cob","deceased") VALUES (10,1,'0000000000              ','f ',NULL,'1-12-1930 ','  ',NULL);
INSERT INTO "identity" ("audit_id","id","pupic","gender","karyotype","dob","cob","deceased") VALUES (13,2,'0000000000              ','m ',NULL,'4/12/1940 ','  ',NULL);
INSERT INTO "identity" ("audit_id","id","pupic","gender","karyotype","dob","cob","deceased") VALUES (30,10,'0000000000              ','f ',NULL,'12-12-1960','  ',NULL);
--
-- Data for TOC Entry ID 130 (OID 35373)
--
-- Name: names Type: TABLE DATA Owner: syan
--


INSERT INTO "names" ("audit_id","id","id_identity","active","lastnames","firstnames","preferred","title") VALUES (11,1,1,'t','Head','Sally',NULL,'Ms.');
INSERT INTO "names" ("audit_id","id","id_identity","active","lastnames","firstnames","preferred","title") VALUES (14,2,2,'t','Head','Victor',NULL,'Mr.');
INSERT INTO "names" ("audit_id","id","id_identity","active","lastnames","firstnames","preferred","title") VALUES (31,10,10,'t','Headde','Annie',NULL,'Miss');
--
-- Data for TOC Entry ID 131 (OID 35386)
--
-- Name: relation_types Type: TABLE DATA Owner: syan
--


INSERT INTO "relation_types" ("audit_id","id","biological","biol_verified","description") VALUES (1,1,'t','f','parent');
INSERT INTO "relation_types" ("audit_id","id","biological","biol_verified","description") VALUES (2,2,'t','f','sibling');
INSERT INTO "relation_types" ("audit_id","id","biological","biol_verified","description") VALUES (3,3,'t','f','halfsibling');
INSERT INTO "relation_types" ("audit_id","id","biological","biol_verified","description") VALUES (4,4,'f','f','stepparent');
INSERT INTO "relation_types" ("audit_id","id","biological","biol_verified","description") VALUES (5,5,'f','f','married');
INSERT INTO "relation_types" ("audit_id","id","biological","biol_verified","description") VALUES (6,6,'f','f','defacto');
INSERT INTO "relation_types" ("audit_id","id","biological","biol_verified","description") VALUES (7,7,'f','f','divorced');
INSERT INTO "relation_types" ("audit_id","id","biological","biol_verified","description") VALUES (8,8,'f','f','separated');
INSERT INTO "relation_types" ("audit_id","id","biological","biol_verified","description") VALUES (9,9,'f','f','legal_guardian');
--
-- Data for TOC Entry ID 132 (OID 35400)
--
-- Name: relation Type: TABLE DATA Owner: syan
--


--
-- Data for TOC Entry ID 133 (OID 35433)
--
-- Name: audit_gis Type: TABLE DATA Owner: syan
--


--
-- Data for TOC Entry ID 134 (OID 35436)
--
-- Name: country Type: TABLE DATA Owner: syan
--


INSERT INTO "country" ("code","name","deprecated") VALUES ('AF','AFGHANISTAN',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('AL','ALBANIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('DZ','ALGERIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('AS','AMERICAN SAMOA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('AD','ANDORRA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('AO','ANGOLA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('AI','ANGUILLA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('AQ','ANTARCTICA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('AG','ANTIGUA AND BARBUDA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('AR','ARGENTINA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('AM','ARMENIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('AW','ARUBA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('AU','AUSTRALIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('AT','AUSTRIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('AZ','AZERBAIJAN',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('BS','BAHAMAS',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('BH','BAHRAIN',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('BD','BANGLADESH',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('BB','BARBADOS',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('BY','BELARUS',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('BE','BELGIUM',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('BZ','BELIZE',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('BJ','BENIN',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('BM','BERMUDA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('BT','BHUTAN',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('BO','BOLIVIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('BA','BOSNIA AND HERZEGOVINA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('BW','BOTSWANA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('BV','BOUVET ISLAND',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('BR','BRAZIL',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('IO','BRITISH INDIAN OCEAN TERRITORY',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('BN','BRUNEI DARUSSALAM',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('BG','BULGARIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('BF','BURKINA FASO',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('BI','BURUNDI',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('KH','CAMBODIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('CM','CAMEROON',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('CA','CANADA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('CV','CAPE VERDE',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('KY','CAYMAN ISLANDS',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('CF','CENTRAL AFRICAN REPUBLIC',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('TD','CHAD',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('CL','CHILE',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('CN','CHINA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('CX','CHRISTMAS ISLAND',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('CC','COCOS (KEELING) ISLANDS',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('CO','COLOMBIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('KM','COMOROS',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('CG','CONGO',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('CD','CONGO, THE DEMOCRATIC REPUBLIC',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('CK','COOK ISLANDS',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('CR','COSTA RICA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('CI','COTE D''IVOIRE',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('HR','CROATIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('CU','CUBA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('CY','CYPRUS',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('CZ','CZECH REPUBLIC',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('DK','DENMARK',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('DJ','DJIBOUTI',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('DM','DOMINICA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('DO','DOMINICAN REPUBLIC',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('TP','EAST TIMOR',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('EC','ECUADOR',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('EG','EGYPT',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('SV','EL SALVADOR',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('GQ','EQUATORIAL GUINEA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('ER','ERITREA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('EE','ESTONIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('ET','ETHIOPIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('FK','FALKLAND ISLANDS (MALVINAS)',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('FO','FAROE ISLANDS',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('FJ','FIJI',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('FI','FINLAND',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('FR','FRANCE',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('GF','FRENCH GUIANA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('PF','FRENCH POLYNESIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('TF','FRENCH SOUTHERN TERRITORIES',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('GA','GABON',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('GM','GAMBIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('GE','GEORGIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('DE','GERMANY',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('GH','GHANA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('GI','GIBRALTAR',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('GR','GREECE',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('GL','GREENLAND',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('GD','GRENADA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('GP','GUADELOUPE',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('GU','GUAM',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('GT','GUATEMALA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('GN','GUINEA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('GW','GUINEA-BISSAU',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('GY','GUYANA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('HT','HAITI',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('HM','HEARD ISLAND AND MCDONALD ISLA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('VA','HOLY SEE (VATICAN CITY STATE)',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('HN','HONDURAS',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('HK','HONG KONG',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('HU','HUNGARY',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('IS','ICELAND',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('IN','INDIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('ID','INDONESIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('IR','IRAN, ISLAMIC REPUBLIC OF',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('IQ','IRAQ',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('IE','IRELAND',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('IL','ISRAEL',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('IT','ITALY',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('JM','JAMAICA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('JP','JAPAN',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('JO','JORDAN',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('KZ','KAZAKSTAN',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('KE','KENYA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('KI','KIRIBATI',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('KP','KOREA, DEMOCRATIC PEOPLE''S REP',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('KR','KOREA, REPUBLIC OF',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('KW','KUWAIT',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('KG','KYRGYZSTAN',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('LA','LAO PEOPLE''S DEMOCRATIC REPUBL',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('LV','LATVIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('LB','LEBANON',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('LS','LESOTHO',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('LR','LIBERIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('LY','LIBYAN ARAB JAMAHIRIYA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('LI','LIECHTENSTEIN',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('LT','LITHUANIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('LU','LUXEMBOURG',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('MO','MACAU',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('MK','MACEDONIA, THE FORMER YUGOSLAV',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('MG','MADAGASCAR',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('MW','MALAWI',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('MY','MALAYSIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('MV','MALDIVES',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('ML','MALI',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('MT','MALTA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('MH','MARSHALL ISLANDS',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('MQ','MARTINIQUE',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('MR','MAURITANIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('MU','MAURITIUS',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('YT','MAYOTTE',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('MX','MEXICO',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('FM','MICRONESIA, FEDERATED STATES O',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('MD','MOLDOVA, REPUBLIC OF',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('MC','MONACO',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('MN','MONGOLIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('MS','MONTSERRAT',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('MA','MOROCCO',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('MZ','MOZAMBIQUE',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('MM','MYANMAR',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('NA','NAMIBIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('NR','NAURU',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('NP','NEPAL',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('NL','NETHERLANDS',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('AN','NETHERLANDS ANTILLES',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('NC','NEW CALEDONIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('NZ','NEW ZEALAND',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('NI','NICARAGUA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('NE','NIGER',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('NG','NIGERIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('NU','NIUE',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('NF','NORFOLK ISLAND',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('MP','NORTHERN MARIANA ISLANDS',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('NO','NORWAY',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('OM','OMAN',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('PK','PAKISTAN',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('PW','PALAU',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('PS','PALESTINIAN TERRITORY, OCCUPIE',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('PA','PANAMA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('PG','PAPUA NEW GUINEA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('PY','PARAGUAY',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('PE','PERU',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('PH','PHILIPPINES',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('PN','PITCAIRN',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('PL','POLAND',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('PT','PORTUGAL',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('PR','PUERTO RICO',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('QA','QATAR',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('RE','REUNION',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('RO','ROMANIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('RU','RUSSIAN FEDERATION',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('RW','RWANDA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('SH','SAINT HELENA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('KN','SAINT KITTS AND NEVIS',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('LC','SAINT LUCIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('PM','SAINT PIERRE AND MIQUELON',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('VC','SAINT VINCENT AND THE GRENADIN',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('WS','SAMOA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('SM','SAN MARINO',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('ST','SAO TOME AND PRINCIPE',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('SA','SAUDI ARABIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('SN','SENEGAL',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('SC','SEYCHELLES',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('SL','SIERRA LEONE',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('SG','SINGAPORE',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('SK','SLOVAKIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('SI','SLOVENIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('SB','SOLOMON ISLANDS',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('SO','SOMALIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('ZA','SOUTH AFRICA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('GS','SOUTH GEORGIA AND THE SOUTH SA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('ES','SPAIN',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('LK','SRI LANKA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('SD','SUDAN',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('SR','SURINAME',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('SJ','SVALBARD AND JAN MAYEN',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('SZ','SWAZILAND',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('SE','SWEDEN',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('CH','SWITZERLAND',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('SY','SYRIAN ARAB REPUBLIC',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('TW','TAIWAN, PROVINCE OF CHINA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('TJ','TAJIKISTAN',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('TZ','TANZANIA, UNITED REPUBLIC OF',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('TH','THAILAND',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('TG','TOGO',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('TK','TOKELAU',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('TO','TONGA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('TT','TRINIDAD AND TOBAGO',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('TN','TUNISIA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('TR','TURKEY',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('TM','TURKMENISTAN',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('TC','TURKS AND CAICOS ISLANDS',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('TV','TUVALU',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('UG','UGANDA',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('UA','UKRAINE',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('AE','UNITED ARAB EMIRATES',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('GB','UNITED KINGDOM',NULL);
INSERT INTO "country" ("code","name","deprecated") VALUES ('US','UNITED STATES',NULL);
--
-- Data for TOC Entry ID 135 (OID 35441)
--
-- Name: state Type: TABLE DATA Owner: syan
--


INSERT INTO "state" ("audit_id","id","code","country","name","deprecated") VALUES (6,1,'ACT       ','AU','Australian Capital Territory',NULL);
INSERT INTO "state" ("audit_id","id","code","country","name","deprecated") VALUES (7,2,'NSW       ','AU','New South Wales',NULL);
INSERT INTO "state" ("audit_id","id","code","country","name","deprecated") VALUES (8,3,'NT        ','AU','Northern Territory',NULL);
INSERT INTO "state" ("audit_id","id","code","country","name","deprecated") VALUES (9,4,'SA        ','AU','South Australia',NULL);
INSERT INTO "state" ("audit_id","id","code","country","name","deprecated") VALUES (10,5,'TAS       ','AU','Tasmania',NULL);
INSERT INTO "state" ("audit_id","id","code","country","name","deprecated") VALUES (11,6,'QLD       ','AU','Queensland',NULL);
INSERT INTO "state" ("audit_id","id","code","country","name","deprecated") VALUES (12,7,'VIC       ','AU','Victoria',NULL);
INSERT INTO "state" ("audit_id","id","code","country","name","deprecated") VALUES (13,8,'WA        ','AU','West Australia',NULL);
--
-- Data for TOC Entry ID 136 (OID 35453)
--
-- Name: urb Type: TABLE DATA Owner: syan
--


INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (14,1,1,'200     ','AUSTRALIAN NATIONAL UNIVERSITY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (15,2,3,'800     ','DARWIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (16,3,3,'801     ','DARWIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (17,4,3,'804     ','PARAP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (18,5,3,'810     ','ALAWA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (19,6,3,'810     ','BRINKIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (20,7,3,'810     ','CASUARINA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (21,8,3,'810     ','COCONUT GROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (22,9,3,'810     ','JINGILI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (23,10,3,'810     ','LEE POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (24,11,3,'810     ','MILLNER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (25,12,3,'810     ','MOIL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (26,13,3,'810     ','NAKARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (27,14,3,'810     ','NIGHTCLIFF');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (28,15,3,'810     ','RAPID CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (29,16,3,'810     ','TIWI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (30,17,3,'810     ','WAGAMAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (31,18,3,'810     ','WANGURI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (32,19,3,'811     ','CASUARINA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (33,20,3,'812     ','ANULA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (34,21,3,'812     ','KARAMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (35,22,3,'812     ','LEANYER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (36,23,3,'812     ','MALAK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (37,24,3,'812     ','MARRARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (38,25,3,'812     ','SANDERSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (39,26,3,'812     ','WOODLEIGH GARDENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (40,27,3,'812     ','WULAGI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (41,28,3,'813     ','SANDERSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (42,29,3,'814     ','NIGHTCLIFF');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (43,30,3,'815     ','NORTHERN TERRITORY UNIVERSITY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (44,31,3,'820     ','BAGOT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (45,32,3,'820     ','EAST POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (46,33,3,'820     ','FANNIE BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (47,34,3,'820     ','HMAS COONAWARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (48,35,3,'820     ','LARRAKEYAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (49,36,3,'820     ','LUDMILLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (50,37,3,'820     ','PARAP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (51,38,3,'820     ','STUART PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (52,39,3,'820     ','THE GARDENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (53,40,3,'820     ','THE NARROWS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (54,41,3,'820     ','WINNELLIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (55,42,3,'820     ','WOOLNER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (56,43,3,'821     ','WINNELLIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (57,44,3,'822     ','ANGURUGU');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (58,45,3,'822     ','CROKER ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (59,46,3,'822     ','DALY RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (60,47,3,'822     ','DARWIN MC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (61,48,3,'822     ','DELISSAVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (62,49,3,'822     ','GALIWINKU');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (63,50,3,'822     ','GOULBOURN ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (64,51,3,'822     ','MANINGRIDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (65,52,3,'822     ','MILINGIMBI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (66,53,3,'822     ','MINJILANG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (67,54,3,'822     ','NGUIU');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (68,55,3,'822     ','OENPELLI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (69,56,3,'822     ','PULARUMPI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (70,57,3,'822     ','RAMINGINING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (71,58,3,'822     ','UMBAKUMBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (72,59,3,'822     ','WADEYE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (73,60,3,'822     ','WINNELLIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (74,61,3,'828     ','BERRIMAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (75,62,3,'830     ','ARCHER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (76,63,3,'830     ','DRIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (77,64,3,'830     ','GRAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (78,65,3,'830     ','MARLOW LAGOON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (79,66,3,'830     ','MOULDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (80,67,3,'830     ','PALMERSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (81,68,3,'830     ','WOODROFFE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (82,69,3,'830     ','YARRAWONGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (83,70,3,'831     ','PALMERSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (84,71,3,'832     ','BAKEWELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (85,72,3,'832     ','BELLAMACK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (86,73,3,'832     ','GUNN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (87,74,3,'832     ','MITCHELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (88,75,3,'832     ','ROSEBERY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (89,76,3,'835     ','HOWARD SPRINGS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (90,77,3,'836     ','HUMPTY DOO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (91,78,3,'837     ','BERRY SPRINGS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (92,79,3,'837     ','NOONAMAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (93,80,3,'840     ','DUNDEE BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (94,81,3,'845     ','BATCHELOR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (95,82,3,'846     ','ADELAIDE RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (96,83,3,'847     ','PINE CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (97,84,3,'850     ','KATHERINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (98,85,3,'851     ','KATHERINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (99,86,3,'852     ','DALY WATERS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (100,87,3,'852     ','KATHERINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (101,88,3,'852     ','LAJAMANU');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (102,89,3,'852     ','LARRIMAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (103,90,3,'852     ','MARANBOY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (104,91,3,'852     ','MATARANKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (105,92,3,'852     ','NGUKURR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (106,93,3,'852     ','NUMBULWAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (107,94,3,'852     ','VICTORIA RIVER DOWNS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (108,95,3,'853     ','TINDAL RAAF');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (109,96,3,'854     ','BORROLOOLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (110,97,3,'860     ','TENNANT CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (111,98,3,'861     ','TENNANT CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (112,99,3,'862     ','ELLIOTT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (113,100,3,'862     ','NEWCASTLE WATERS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (114,101,3,'862     ','TENNANT CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (115,102,3,'862     ','WARREGO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (116,103,3,'870     ','ALICE SPRINGS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (117,104,3,'871     ','ALICE SPRINGS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (118,105,3,'872     ','ALI CURUNG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (119,106,3,'872     ','ALICE SPRINGS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (120,107,3,'872     ','AREYONGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (121,108,3,'872     ','BARROW CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (122,109,4,'872     ','ERNABELLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (123,110,3,'872     ','FINKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (124,111,4,'872     ','FREGON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (125,112,3,'872     ','HAASTS BLUFF');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (126,113,3,'872     ','HERMANNSBURG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (127,114,3,'872     ','KALTUKATJARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (128,115,3,'872     ','KINTORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (129,116,3,'872     ','PAPUNYA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (130,117,3,'872     ','SANTA TERESA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (131,118,3,'872     ','TI TREE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (132,119,3,'872     ','YUENDUMU');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (133,120,3,'872     ','YULARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (134,121,3,'880     ','NHULUNBUY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (135,122,3,'880     ','YIRRKALA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (136,123,3,'881     ','NHULUNBUY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (137,124,3,'885     ','ALYANGULA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (138,125,3,'886     ','JABIRU');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (139,126,2,'1215    ','AUSTRALIA SQUARE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (140,127,2,'1220    ','GROSVENOR PLACE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (141,128,2,'1225    ','ROYAL EXCHANGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (142,129,2,'1230    ','QUEEN VICTORIA BUILDING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (143,130,2,'1235    ','SYDNEY SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (144,131,2,'1240    ','HAYMARKET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (145,132,2,'1300    ','DARLINGHURST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (146,133,2,'1335    ','POTTS POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (147,134,2,'1340    ','KINGS CROSS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (148,135,2,'1350    ','WOOLLAHRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (149,136,2,'1355    ','BONDI JUNCTION');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (150,137,2,'1360    ','DOUBLE BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (151,138,2,'1363    ','MOORE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (152,139,2,'1420    ','STRAWBERRY HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (153,140,2,'1424    ','STRAWBERRY HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (154,141,2,'1427    ','STRAWBERRY HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (155,142,2,'1435    ','ALEXANDRIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (156,143,2,'1445    ','ROSEBERY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (157,144,2,'1450    ','CAMPERDOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (158,145,2,'1455    ','BOTANY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (159,146,2,'1460    ','MASCOT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (160,147,2,'1465    ','KENSINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (161,148,2,'1470    ','DRUMMOYNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (162,149,2,'1475    ','MARRICKVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (163,150,2,'1480    ','KINGSGROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (164,151,2,'1481    ','HURSTVILLE BC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (165,152,2,'1485    ','KOGARAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (166,153,2,'1490    ','MIRANDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (167,154,2,'1495    ','CARINGBAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (168,155,2,'1499    ','SUTHERLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (169,156,2,'1515    ','WEST CHATSWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (170,157,2,'1560    ','NORTHBRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (171,158,2,'1565    ','MILSONS POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (172,159,2,'1570    ','ARTARMON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (173,160,2,'1585    ','CROWS NEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (174,161,2,'1590    ','ST LEONARDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (175,162,2,'1595    ','LANE COVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (176,163,2,'1630    ','HORNSBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (177,164,2,'1635    ','HORNSBY NORTHGATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (178,165,2,'1639    ','FRENCHS FOREST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (179,166,2,'1640    ','FRENCHS FOREST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (180,167,2,'1655    ','MANLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (181,168,2,'1660    ','MONA VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (182,169,2,'1670    ','NORTH RYDE BC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (183,170,2,'1675    ','GLADESVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (184,171,2,'1680    ','RYDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (185,172,2,'1685    ','WEST RYDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (186,173,2,'1700    ','ERMINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (187,174,2,'1701    ','RYDALMERE BC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (188,175,2,'1710    ','EPPING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (189,176,2,'1715    ','PENNANT HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (190,177,2,'1730    ','SEVEN HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (191,178,2,'1750    ','NORTH PARRAMATTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (192,179,2,'1755    ','BAULKHAM HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (193,180,2,'1765    ','CASTLE HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (194,181,2,'1790    ','ST MARYS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (195,182,2,'1800    ','ASHFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (196,183,2,'1805    ','BURWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (197,184,2,'1811    ','SILVERWATER DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (198,185,2,'1825    ','LIDCOMBE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (199,186,2,'1835    ','AUBURN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (200,187,2,'1851    ','WETHERILL PARK DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (201,188,2,'1860    ','FAIRFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (202,189,2,'1871    ','LIVERPOOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (203,190,2,'1875    ','MOOREBANK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (204,191,2,'1885    ','BANKSTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (205,192,2,'1890    ','INGLEBURN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (206,193,2,'1891    ','MILPERRA DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (207,194,2,'2000    ','DAWES POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (208,195,2,'2000    ','HAYMARKET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (209,196,2,'2000    ','MILLERS POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (210,197,2,'2000    ','ST JAMES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (211,198,2,'2000    ','SYDNEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (212,199,2,'2000    ','SYDNEY SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (213,200,2,'2000    ','THE ROCKS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (214,201,2,'2001    ','SYDNEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (215,202,2,'2004    ','EASTERN SUBURBS MC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (216,203,2,'2006    ','THE UNIVERSITY OF SYDNEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (217,204,2,'2007    ','BROADWAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (218,205,2,'2007    ','ULTIMO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (219,206,2,'2008    ','CHIPPENDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (220,207,2,'2008    ','DARLINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (221,208,2,'2009    ','PYRMONT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (222,209,2,'2010    ','DARLINGHURST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (223,210,2,'2010    ','SURRY HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (224,211,2,'2011    ','ELIZABETH BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (225,212,2,'2011    ','GARDEN ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (226,213,2,'2011    ','KINGS CROSS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (227,214,2,'2011    ','POTTS POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (228,215,2,'2011    ','RUSHCUTTERS BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (229,216,2,'2011    ','WOOLLOOMOOLOO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (230,217,2,'2012    ','STRAWBERRY HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (231,218,2,'2014    ','BEACONSFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (232,219,2,'2015    ','ALEXANDRIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (233,220,2,'2015    ','BEACONSFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (234,221,2,'2015    ','EVELEIGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (235,222,2,'2016    ','REDFERN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (236,223,2,'2017    ','WATERLOO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (237,224,2,'2017    ','WATERLOO DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (238,225,2,'2017    ','ZETLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (239,226,2,'2018    ','EASTLAKES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (240,227,2,'2018    ','ROSEBERY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (241,228,2,'2019    ','BANKSMEADOW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (242,229,2,'2019    ','BOTANY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (243,230,2,'2020    ','MASCOT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (244,231,2,'2020    ','SYDNEY AIRPORT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (245,232,2,'2020    ','SYDNEY INTERNATIONAL AIRPORT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (246,233,2,'2021    ','CENTENNIAL PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (247,234,2,'2021    ','PADDINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (248,235,2,'2022    ','BONDI JUNCTION');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (249,236,2,'2022    ','BONDI JUNCTION DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (250,237,2,'2022    ','QUEENS PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (251,238,2,'2023    ','BELLEVUE HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (252,239,2,'2024    ','BRONTE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (253,240,2,'2024    ','WAVERLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (254,241,2,'2025    ','WOOLLAHRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (255,242,2,'2026    ','BEN BUCKLER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (256,243,2,'2026    ','BONDI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (257,244,2,'2026    ','BONDI BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (258,245,2,'2026    ','TAMARAMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (259,246,2,'2027    ','DARLING POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (260,247,2,'2027    ','EDGECLIFF');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (261,248,2,'2027    ','POINT PIPER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (262,249,2,'2028    ','DOUBLE BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (263,250,2,'2029    ','ROSE BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (264,251,2,'2030    ','DOVER HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (265,252,2,'2030    ','ROSE BAY NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (266,253,2,'2030    ','VAUCLUSE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (267,254,2,'2030    ','WATSONS BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (268,255,2,'2031    ','CLOVELLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (269,256,2,'2031    ','CLOVELLY WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (270,257,2,'2031    ','RANDWICK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (271,258,2,'2031    ','ST PAULS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (272,259,2,'2032    ','DACEYVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (273,260,2,'2032    ','KINGSFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (274,261,2,'2033    ','KENSINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (275,262,2,'2034    ','COOGEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (276,263,2,'2035    ','MAROUBRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (277,264,2,'2035    ','PAGEWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (278,265,2,'2036    ','CHIFLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (279,266,2,'2036    ','EASTGARDENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (280,267,2,'2036    ','HILLSDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (281,268,2,'2036    ','LA PEROUSE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (282,269,2,'2036    ','LITTLE BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (283,270,2,'2036    ','MALABAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (284,271,2,'2036    ','MATRAVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (285,272,2,'2036    ','PHILLIP BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (286,273,2,'2036    ','PORT BOTANY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (287,274,2,'2037    ','GLEBE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (288,275,2,'2038    ','ANNANDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (289,276,2,'2039    ','ROZELLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (290,277,2,'2040    ','LEICHHARDT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (291,278,2,'2040    ','LILYFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (292,279,2,'2041    ','BALMAIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (293,280,2,'2041    ','BIRCHGROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (294,281,2,'2042    ','ENMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (295,282,2,'2042    ','NEWTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (296,283,2,'2043    ','ERSKINEVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (297,284,2,'2044    ','ST PETERS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (298,285,2,'2044    ','ST PETERS DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (299,286,2,'2044    ','SYDENHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (300,287,2,'2044    ','TEMPE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (301,288,2,'2045    ','DOBROYD POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (302,289,2,'2045    ','HABERFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (303,290,2,'2046    ','ABBOTSFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (304,291,2,'2046    ','CANADA BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (305,292,2,'2046    ','CHISWICK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (306,293,2,'2046    ','FIVE DOCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (307,294,2,'2046    ','RODD POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (308,295,2,'2046    ','RUSSELL LEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (309,296,2,'2046    ','WAREEMBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (310,297,2,'2047    ','DRUMMOYNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (311,298,2,'2048    ','STANMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (312,299,2,'2048    ','WESTGATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (313,300,2,'2049    ','LEWISHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (314,301,2,'2049    ','PETERSHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (315,302,2,'2050    ','CAMPERDOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (316,303,2,'2050    ','MISSENDEN ROAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (317,304,2,'2052    ','UNSW SYDNEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (318,305,2,'2055    ','NORTH SYDNEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (319,306,2,'2057    ','CHATSWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (320,307,2,'2059    ','NORTH SYDNEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (321,308,2,'2060    ','LAVENDER BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (322,309,2,'2060    ','MCMAHONS POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (323,310,2,'2060    ','NORTH SYDNEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (324,311,2,'2060    ','NORTH SYDNEY SHOPPINGWORLD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (325,312,2,'2060    ','WAVERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (326,313,2,'2061    ','KIRRIBILLI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (327,314,2,'2061    ','MILSONS POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (328,315,2,'2062    ','CAMMERAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (329,316,2,'2063    ','NORTHBRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (330,317,2,'2064    ','ARTARMON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (331,318,2,'2065    ','CROWS NEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (332,319,2,'2065    ','GORE HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (333,320,2,'2065    ','GREENWICH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (334,321,2,'2065    ','NAREMBURN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (335,322,2,'2065    ','ROYAL NORTH SHORE HOSPITAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (336,323,2,'2065    ','ST LEONARDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (337,324,2,'2065    ','WOLLSTONECRAFT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (338,325,2,'2066    ','LANE COVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (339,326,2,'2066    ','LINLEY POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (340,327,2,'2066    ','LONGUEVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (341,328,2,'2066    ','NORTHWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (342,329,2,'2066    ','RIVERVIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (343,330,2,'2067    ','CHATSWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (344,331,2,'2067    ','CHATSWOOD DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (345,332,2,'2067    ','CHATSWOOD WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (346,333,2,'2068    ','CASTLECRAG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (347,334,2,'2068    ','MIDDLE COVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (348,335,2,'2068    ','WILLOUGHBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (349,336,2,'2069    ','CASTLE COVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (350,337,2,'2069    ','ROSEVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (351,338,2,'2070    ','EAST LINDFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (352,339,2,'2070    ','LINDFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (353,340,2,'2070    ','LINDFIELD WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (354,341,2,'2071    ','KILLARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (355,342,2,'2072    ','GORDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (356,343,2,'2073    ','PYMBLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (357,344,2,'2073    ','WEST PYMBLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (358,345,2,'2074    ','NORTH TURRAMURRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (359,346,2,'2074    ','SOUTH TURRAMURRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (360,347,2,'2074    ','TURRAMURRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (361,348,2,'2074    ','WARRAWEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (362,349,2,'2075    ','ST IVES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (363,350,2,'2076    ','NORMANHURST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (364,351,2,'2076    ','WAHROONGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (365,352,2,'2077    ','ASQUITH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (366,353,2,'2077    ','HORNSBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (367,354,2,'2077    ','WAITARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (368,355,2,'2079    ','MOUNT COLAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (369,356,2,'2080    ','MOUNT KURING-GAI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (370,357,2,'2081    ','BEROWRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (371,358,2,'2081    ','COWAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (372,359,2,'2082    ','BEROWRA HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (373,360,2,'2082    ','BEROWRA WATERS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (374,361,2,'2083    ','BROOKLYN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (375,362,2,'2083    ','DANGAR ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (376,363,2,'2083    ','MILSONS PASSAGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (377,364,2,'2083    ','MOONEY MOONEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (378,365,2,'2084    ','DUFFYS FOREST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (379,366,2,'2084    ','TERREY HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (380,367,2,'2085    ','BELROSE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (381,368,2,'2085    ','BELROSE WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (382,369,2,'2085    ','DAVIDSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (383,370,2,'2086    ','FRENCHS FOREST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (384,371,2,'2086    ','FRENCHS FOREST DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (385,372,2,'2087    ','FORESTVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (386,373,2,'2087    ','KILLARNEY HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (387,374,2,'2088    ','BALMORAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (388,375,2,'2088    ','BEAUTY POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (389,376,2,'2088    ','CLIFTON GARDENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (390,377,2,'2088    ','GEORGES HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (391,378,2,'2088    ','MOSMAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (392,379,2,'2088    ','SPIT JUNCTION');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (393,380,2,'2088    ','THE SPIT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (394,381,2,'2089    ','NEUTRAL BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (395,382,2,'2089    ','NEUTRAL BAY JUNCTION');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (396,383,2,'2090    ','CREMORNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (397,384,2,'2090    ','CREMORNE JUNCTION');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (398,385,2,'2092    ','SEAFORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (399,386,2,'2093    ','BALGOWLAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (400,387,2,'2093    ','BALGOWLAH DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (401,388,2,'2093    ','CLONTARF');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (402,389,2,'2093    ','MANLY VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (403,390,2,'2094    ','FAIRLIGHT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (404,391,2,'2095    ','MANLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (405,392,2,'2096    ','CURL CURL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (406,393,2,'2096    ','HARBORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (407,394,2,'2096    ','HARBORD WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (408,395,2,'2096    ','QUEENSCLIFF');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (409,396,2,'2097    ','COLLAROY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (410,397,2,'2097    ','COLLAROY BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (411,398,2,'2097    ','COLLAROY PLATEAU');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (412,399,2,'2097    ','WHEELER HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (413,400,2,'2099    ','CROMER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (414,401,2,'2099    ','DEE WHY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (415,402,2,'2099    ','NARRAWEENA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (416,403,2,'2099    ','NORTH CURL CURL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (417,404,2,'2099    ','WINGALA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (418,405,2,'2100    ','ALLAMBIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (419,406,2,'2100    ','ALLAMBIE HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (420,407,2,'2100    ','BEACON HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (421,408,2,'2100    ','BROOKVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (422,409,2,'2100    ','BROOKVALE DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (423,410,2,'2100    ','NORTH MANLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (424,411,2,'2100    ','OXFORD FALLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (425,412,2,'2100    ','WARRINGAH MALL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (426,413,2,'2101    ','ELANORA HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (427,414,2,'2101    ','INGLESIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (428,415,2,'2101    ','NARRABEEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (429,416,2,'2102    ','WARRIEWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (430,417,2,'2102    ','WARRIEWOOD DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (431,418,2,'2102    ','WARRIEWOOD SHOPPING SQUARE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (432,419,2,'2103    ','MONA VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (433,420,2,'2104    ','BAYVIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (434,421,2,'2105    ','CHURCH POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (435,422,2,'2105    ','ELVINA BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (436,423,2,'2105    ','LOVETT BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (437,424,2,'2105    ','SCOTLAND ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (438,425,2,'2106    ','NEWPORT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (439,426,2,'2106    ','NEWPORT BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (440,427,2,'2107    ','AVALON BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (441,428,2,'2107    ','BILGOLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (442,429,2,'2107    ','CAREEL BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (443,430,2,'2107    ','WHALE BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (444,431,2,'2108    ','PALM BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (445,432,2,'2108    ','THE BASIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (446,433,2,'2109    ','MACQUARIE UNIVERSITY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (447,434,2,'2110    ','HUNTERS HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (448,435,2,'2110    ','WOOLWICH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (449,436,2,'2111    ','GLADESVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (450,437,2,'2111    ','HENLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (451,438,2,'2111    ','HUNTLEYS POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (452,439,2,'2111    ','MONASH PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (453,440,2,'2111    ','TARBAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (454,441,2,'2111    ','TENNYSON POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (455,442,2,'2112    ','DENISTONE EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (456,443,2,'2112    ','PUTNEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (457,444,2,'2112    ','RYDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (458,445,2,'2113    ','BLENHEIM ROAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (459,446,2,'2113    ','EAST RYDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (460,447,2,'2113    ','MACQUARIE CENTRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (461,448,2,'2113    ','MACQUARIE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (462,449,2,'2113    ','NORTH RYDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (463,450,2,'2114    ','DENISTONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (464,451,2,'2114    ','DENISTONE WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (465,452,2,'2114    ','MEADOWBANK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (466,453,2,'2114    ','MELROSE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (467,454,2,'2114    ','WEST RYDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (468,455,2,'2115    ','ERMINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (469,456,2,'2116    ','RYDALMERE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (470,457,2,'2117    ','DUNDAS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (471,458,2,'2117    ','OATLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (472,459,2,'2117    ','TELOPEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (473,460,2,'2118    ','CARLINGFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (474,461,2,'2118    ','CARLINGFORD COURT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (475,462,2,'2118    ','KINGSDENE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (476,463,2,'2119    ','BEECROFT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (477,464,2,'2119    ','CHELTENHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (478,465,2,'2120    ','PENNANT HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (479,466,2,'2120    ','THORNLEIGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (480,467,2,'2120    ','WESTLEIGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (481,468,2,'2121    ','EPPING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (482,469,2,'2122    ','EASTWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (483,470,2,'2122    ','MARSFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (484,471,2,'2123    ','PARRAMATTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (485,472,2,'2124    ','PARRAMATTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (486,473,2,'2125    ','WEST PENNANT HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (487,474,2,'2126    ','CHERRYBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (488,475,2,'2127    ','HOMEBUSH BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (489,476,2,'2127    ','NEWINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (490,477,2,'2128    ','SILVERWATER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (491,478,2,'2129    ','SYDNEY MARKETS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (492,479,2,'2130    ','SUMMER HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (493,480,2,'2131    ','ASHFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (494,481,2,'2132    ','CROYDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (495,482,2,'2133    ','CROYDON PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (496,483,2,'2133    ','ENFIELD SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (497,484,2,'2134    ','BURWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (498,485,2,'2135    ','STRATHFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (499,486,2,'2136    ','BURWOOD HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (500,487,2,'2136    ','ENFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (501,488,2,'2136    ','STRATHFIELD SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (502,489,2,'2137    ','CABARITA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (503,490,2,'2137    ','CONCORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (504,491,2,'2137    ','MORTLAKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (505,492,2,'2137    ','NORTH STRATHFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (506,493,2,'2138    ','CONCORD WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (507,494,2,'2138    ','RHODES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (508,495,2,'2139    ','CONCORD REPATRIATION HOSPITAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (509,496,2,'2140    ','HOMEBUSH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (510,497,2,'2140    ','STRATHFIELD WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (511,498,2,'2141    ','BERALA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (512,499,2,'2141    ','LIDCOMBE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (513,500,2,'2142    ','BLAXCELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (514,501,2,'2142    ','CAMELLIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (515,502,2,'2142    ','CLYDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (516,503,2,'2142    ','GRANVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (517,504,2,'2142    ','HOLROYD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (518,505,2,'2142    ','ROSEHILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (519,506,2,'2143    ','BIRRONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (520,507,2,'2143    ','POTTS HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (521,508,2,'2143    ','REGENTS PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (522,509,2,'2144    ','AUBURN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (523,510,2,'2145    ','GIRRAWEEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (524,511,2,'2145    ','GREYSTANES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (525,512,2,'2145    ','MAYS HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (526,513,2,'2145    ','PENDLE HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (527,514,2,'2145    ','WENTWORTHVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (528,515,2,'2145    ','WESTMEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (529,516,2,'2146    ','OLD TOONGABBIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (530,517,2,'2146    ','TOONGABBIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (531,518,2,'2146    ','TOONGABBIE EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (532,519,2,'2147    ','KINGS LANGLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (533,520,2,'2147    ','LALOR PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (534,521,2,'2147    ','SEVEN HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (535,522,2,'2147    ','SEVEN HILLS WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (536,523,2,'2148    ','BLACKTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (537,524,2,'2148    ','BLACKTOWN DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (538,525,2,'2148    ','BLACKTOWN WESTPOINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (539,526,2,'2148    ','KINGS PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (540,527,2,'2148    ','MARAYONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (541,528,2,'2148    ','PROSPECT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (542,529,2,'2150    ','HARRIS PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (543,530,2,'2150    ','PARRAMATTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (544,531,2,'2150    ','PARRAMATTA DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (545,532,2,'2151    ','NORTH PARRAMATTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (546,533,2,'2151    ','NORTH ROCKS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (547,534,2,'2152    ','NORTHMEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (548,535,2,'2153    ','BAULKHAM HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (549,536,2,'2153    ','BAULKHAM HILLS DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (550,537,2,'2153    ','BELLA VISTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (551,538,2,'2153    ','CHISHOLM CENTRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (552,539,2,'2153    ','MODEL FARMS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (553,540,2,'2153    ','WINSTON HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (554,541,2,'2154    ','CASTLE HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (555,542,2,'2155    ','KELLYVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (556,543,2,'2155    ','ROUSE HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (557,544,2,'2156    ','ANNANGROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (558,545,2,'2156    ','GLENHAVEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (559,546,2,'2156    ','KENTHURST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (560,547,2,'2157    ','GLENORIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (561,548,2,'2158    ','DURAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (562,549,2,'2158    ','ROUND CORNER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (563,550,2,'2159    ','ARCADIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (564,551,2,'2159    ','BERRILEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (565,552,2,'2159    ','FIDDLETOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (566,553,2,'2159    ','GALSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (567,554,2,'2160    ','MERRYLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (568,555,2,'2160    ','MERRYLANDS WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (569,556,2,'2161    ','GUILDFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (570,557,2,'2161    ','GUILDFORD WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (571,558,2,'2161    ','OLD GUILDFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (572,559,2,'2161    ','YENNORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (573,560,2,'2162    ','CHESTER HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (574,561,2,'2162    ','SEFTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (575,562,2,'2163    ','CARRAMAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (576,563,2,'2163    ','VILLAWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (577,564,2,'2164    ','HORSLEY PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (578,565,2,'2164    ','SMITHFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (579,566,2,'2164    ','SMITHFIELD WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (580,567,2,'2164    ','WETHERILL PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (581,568,2,'2165    ','FAIRFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (582,569,2,'2165    ','FAIRFIELD EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (583,570,2,'2165    ','FAIRFIELD HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (584,571,2,'2165    ','FAIRFIELD WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (585,572,2,'2166    ','CABRAMATTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (586,573,2,'2166    ','CANLEY HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (587,574,2,'2166    ','CANLEY VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (588,575,2,'2166    ','LANSVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (589,576,2,'2167    ','GLENFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (590,577,2,'2168    ','ASHCROFT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (591,578,2,'2168    ','BUSBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (592,579,2,'2168    ','CARTWRIGHT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (593,580,2,'2168    ','GREEN VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (594,581,2,'2168    ','HECKENBERG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (595,582,2,'2168    ','HINCHINBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (596,583,2,'2168    ','MILLER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (597,584,2,'2168    ','SADLEIR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (598,585,2,'2170    ','CASULA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (599,586,2,'2170    ','CASULA MALL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (600,587,2,'2170    ','CHIPPING NORTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (601,588,2,'2170    ','HAMMONDVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (602,589,2,'2170    ','LIVERPOOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (603,590,2,'2170    ','LIVERPOOL BC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (604,591,2,'2170    ','LIVERPOOL SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (605,592,2,'2170    ','LURNEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (606,593,2,'2170    ','MOOREBANK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (607,594,2,'2170    ','MOUNT PRITCHARD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (608,595,2,'2170    ','PRESTONS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (609,596,2,'2170    ','PRESTONS DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (610,597,2,'2170    ','WARWICK FARM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (611,598,2,'2171    ','AUSTRAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (612,599,2,'2171    ','BADGERYS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (613,600,2,'2171    ','BRINGELLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (614,601,2,'2171    ','CATHERINE FIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (615,602,2,'2171    ','CECIL HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (616,603,2,'2171    ','CECIL PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (617,604,2,'2171    ','EDMONDSON PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (618,605,2,'2171    ','HORNINGSEA PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (619,606,2,'2171    ','HOXTON PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (620,607,2,'2171    ','KEMPS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (621,608,2,'2171    ','LEPPINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (622,609,2,'2171    ','PLEASURE POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (623,610,2,'2171    ','ROSSMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (624,611,2,'2171    ','SANDY POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (625,612,2,'2171    ','VOYAGER POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (626,613,2,'2171    ','WEST HOXTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (627,614,2,'2173    ','HOLSWORTHY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (628,615,2,'2173    ','WATTLE GROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (629,616,2,'2176    ','ABBOTSBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (630,617,2,'2176    ','BOSSLEY PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (631,618,2,'2176    ','EDENSOR PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (632,619,2,'2176    ','GREENFIELD PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (633,620,2,'2176    ','PRAIRIEWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (634,621,2,'2176    ','ST JOHNS PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (635,622,2,'2176    ','WAKELEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (636,623,2,'2177    ','BONNYRIGG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (637,624,2,'2177    ','BONNYRIGG HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (638,625,2,'2190    ','CHULLORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (639,626,2,'2190    ','GREENACRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (640,627,2,'2190    ','MOUNT LEWIS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (641,628,2,'2191    ','BELFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (642,629,2,'2192    ','BELMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (643,630,2,'2193    ','ASHBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (644,631,2,'2193    ','CANTERBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (645,632,2,'2193    ','HURLSTONE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (646,633,2,'2194    ','CAMPSIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (647,634,2,'2195    ','LAKEMBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (648,635,2,'2195    ','LAKEMBA DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (649,636,2,'2195    ','WILEY PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (650,637,2,'2196    ','PUNCHBOWL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (651,638,2,'2196    ','ROSELANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (652,639,2,'2197    ','BASS HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (653,640,2,'2198    ','GEORGES HALL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (654,641,2,'2199    ','YAGOONA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (655,642,2,'2199    ','YAGOONA WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (656,643,2,'2200    ','BANKSTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (657,644,2,'2200    ','BANKSTOWN NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (658,645,2,'2200    ','BANKSTOWN SQUARE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (659,646,2,'2200    ','CONDELL PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (660,647,2,'2200    ','MANAHAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (661,648,2,'2200    ','MOUNT LEWIS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (662,649,2,'2203    ','DULWICH HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (663,650,2,'2204    ','MARRICKVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (664,651,2,'2204    ','MARRICKVILLE METRO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (665,652,2,'2204    ','MARRICKVILLE SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (666,653,2,'2205    ','ARNCLIFFE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (667,654,2,'2205    ','TURRELLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (668,655,2,'2206    ','CLEMTON PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (669,656,2,'2206    ','EARLWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (670,657,2,'2206    ','UNDERCLIFFE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (671,658,2,'2207    ','BARDWELL PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (672,659,2,'2207    ','BARDWELL VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (673,660,2,'2207    ','BEXLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (674,661,2,'2207    ','BEXLEY NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (675,662,2,'2207    ','BEXLEY SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (676,663,2,'2208    ','KINGSGROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (677,664,2,'2208    ','KINGSWAY WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (678,665,2,'2209    ','BEVERLY HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (679,666,2,'2209    ','NARWEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (680,667,2,'2210    ','LUGARNO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (681,668,2,'2210    ','PEAKHURST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (682,669,2,'2210    ','PEAKHURST DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (683,670,2,'2210    ','PEAKHURST HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (684,671,2,'2210    ','RIVERWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (685,672,2,'2211    ','PADSTOW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (686,673,2,'2212    ','REVESBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (687,674,2,'2212    ','REVESBY NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (688,675,2,'2213    ','EAST HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (689,676,2,'2213    ','PANANIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (690,677,2,'2213    ','PICNIC POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (691,678,2,'2214    ','MILPERRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (692,679,2,'2215    ','SOUTHERN SUBURBS MC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (693,680,2,'2216    ','BANKSIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (694,681,2,'2216    ','BRIGHTON-LE-SANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (695,682,2,'2216    ','KYEEMAGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (696,683,2,'2216    ','ROCKDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (697,684,2,'2216    ','ROCKDALE DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (698,685,2,'2217    ','BEVERLEY PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (699,686,2,'2217    ','KOGARAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (700,687,2,'2217    ','KOGARAH BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (701,688,2,'2217    ','MONTEREY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (702,689,2,'2217    ','RAMSGATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (703,690,2,'2217    ','RAMSGATE BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (704,691,2,'2218    ','ALLAWAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (705,692,2,'2218    ','CARLTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (706,693,2,'2219    ','SANDRINGHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (707,694,2,'2219    ','SANS SOUCI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (708,695,2,'2220    ','HURSTVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (709,696,2,'2220    ','HURSTVILLE WESTFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (710,697,2,'2221    ','BLAKEHURST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (711,698,2,'2221    ','CARSS PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (712,699,2,'2221    ','CONNELLS POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (713,700,2,'2221    ','KYLE BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (714,701,2,'2221    ','SOUTH HURSTVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (715,702,2,'2222    ','PENSHURST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (716,703,2,'2223    ','MORTDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (717,704,2,'2223    ','OATLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (718,705,2,'2224    ','KANGAROO POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (719,706,2,'2224    ','SYLVANIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (720,707,2,'2224    ','SYLVANIA SOUTHGATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (721,708,2,'2224    ','SYLVANIA WATERS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (722,709,2,'2225    ','OYSTER BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (723,710,2,'2226    ','BONNET BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (724,711,2,'2226    ','COMO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (725,712,2,'2226    ','JANNALI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (726,713,2,'2227    ','GYMEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (727,714,2,'2228    ','MIRANDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (728,715,2,'2228    ','YOWIE BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (729,716,2,'2229    ','CARINGBAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (730,717,2,'2229    ','DOLANS BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (731,718,2,'2229    ','LILLI PILLI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (732,719,2,'2229    ','PORT HACKING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (733,720,2,'2229    ','TAREN POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (734,721,2,'2229    ','TAREN POINT DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (735,722,2,'2230    ','BUNDEENA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (736,723,2,'2230    ','CRONULLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (737,724,2,'2230    ','MAIANBAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (738,725,2,'2230    ','WOOLOOWARE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (739,726,2,'2231    ','KURNELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (740,727,2,'2232    ','AUDLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (741,728,2,'2232    ','GRAYS POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (742,729,2,'2232    ','KAREELA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (743,730,2,'2232    ','KIRRAWEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (744,731,2,'2232    ','KIRRAWEE DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (745,732,2,'2232    ','LOFTUS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (746,733,2,'2232    ','SUTHERLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (747,734,2,'2232    ','WORONORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (748,735,2,'2233    ','ENGADINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (749,736,2,'2233    ','HEATHCOTE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (750,737,2,'2233    ','WATERFALL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (751,738,2,'2233    ','WORONORA HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (752,739,2,'2233    ','YARRAWARRAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (753,740,2,'2234    ','ALFORDS POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (754,741,2,'2234    ','BANGOR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (755,742,2,'2234    ','BARDEN RIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (756,743,2,'2234    ','ILLAWONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (757,744,2,'2234    ','LUCAS HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (758,745,2,'2234    ','MENAI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (759,746,2,'2234    ','MENAI CENTRAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (760,747,2,'2250    ','CALGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (761,748,2,'2250    ','EAST GOSFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (762,749,2,'2250    ','ERINA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (763,750,2,'2250    ','ERINA FAIR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (764,751,2,'2250    ','GOSFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (765,752,2,'2250    ','GOSFORD WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (766,753,2,'2250    ','KARIONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (767,754,2,'2250    ','KULNURA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (768,755,2,'2250    ','LISAROW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (769,756,2,'2250    ','LOWER MANGROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (770,757,2,'2250    ','MANGROVE MOUNTAIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (771,758,2,'2250    ','MATCHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (772,759,2,'2250    ','MOUNT WHITE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (773,760,2,'2250    ','NARARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (774,761,2,'2250    ','NIAGARA PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (775,762,2,'2250    ','PEATS RIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (776,763,2,'2250    ','POINT CLARE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (777,764,2,'2250    ','SOMERSBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (778,765,2,'2250    ','SPRINGFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (779,766,2,'2250    ','TASCOTT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (780,767,2,'2250    ','WENDOREE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (781,768,2,'2250    ','WYOMING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (782,769,2,'2251    ','AVOCA BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (783,770,2,'2251    ','BENSVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (784,771,2,'2251    ','COPACABANA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (785,772,2,'2251    ','DAVISTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (786,773,2,'2251    ','GREEN POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (787,774,2,'2251    ','KINCUMBER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (788,775,2,'2251    ','MACMASTERS BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (789,776,2,'2251    ','SARATOGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (790,777,2,'2251    ','YATTALUNGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (791,778,2,'2256    ','BLACKWALL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (792,779,2,'2256    ','KOOLEWONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (793,780,2,'2256    ','PATONGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (794,781,2,'2256    ','PATONGA BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (795,782,2,'2256    ','PEARL BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (796,783,2,'2256    ','PHEGANS BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (797,784,2,'2256    ','WOY WOY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (798,785,2,'2257    ','BOOKER BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (799,786,2,'2257    ','DALEYS POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (800,787,2,'2257    ','EMPIRE BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (801,788,2,'2257    ','ETTALONG BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (802,789,2,'2257    ','HARDYS BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (803,790,2,'2257    ','KILLCARE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (804,791,2,'2257    ','PRETTY BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (805,792,2,'2257    ','ST HUBERTS ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (806,793,2,'2257    ','UMINA BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (807,794,2,'2258    ','KANGY ANGY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (808,795,2,'2258    ','OURIMBAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (809,796,2,'2259    ','CHAIN VALLEY BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (810,797,2,'2259    ','DOORALONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (811,798,2,'2259    ','DURREN DURREN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (812,799,2,'2259    ','GWANDALAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (813,800,2,'2259    ','JILLIBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (814,801,2,'2259    ','KANWAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (815,802,2,'2259    ','LAKE MUNMORAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (816,803,2,'2259    ','LEMON TREE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (817,804,2,'2259    ','MANNERING PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (818,805,2,'2259    ','RAVENSDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (819,806,2,'2259    ','SUMMERLAND POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (820,807,2,'2259    ','TACOMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (821,808,2,'2259    ','TUGGERAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (822,809,2,'2259    ','TUGGERAWONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (823,810,2,'2259    ','WARNERVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (824,811,2,'2259    ','WATANOBBI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (825,812,2,'2259    ','WYEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (826,813,2,'2259    ','WYONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (827,814,2,'2259    ','WYONGAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (828,815,2,'2259    ','YARRAMALONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (829,816,2,'2260    ','ERINA HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (830,817,2,'2260    ','FORRESTERS BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (831,818,2,'2260    ','NORTH AVOCA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (832,819,2,'2260    ','TERRIGAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (833,820,2,'2260    ','WAMBERAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (834,821,2,'2261    ','BATEAU BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (835,822,2,'2261    ','BAY VILLAGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (836,823,2,'2261    ','BERKELEY VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (837,824,2,'2261    ','BLUE BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (838,825,2,'2261    ','CHITTAWAY BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (839,826,2,'2261    ','CHITTAWAY POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (840,827,2,'2261    ','GLENNING VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (841,828,2,'2261    ','KILLARNEY VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (842,829,2,'2261    ','LONG JETTY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (843,830,2,'2261    ','LONG JETTY DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (844,831,2,'2261    ','SHELLY BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (845,832,2,'2261    ','THE ENTRANCE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (846,833,2,'2261    ','TOOWOON BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (847,834,2,'2261    ','TUMBI UMBI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (848,835,2,'2262    ','BLUE HAVEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (849,836,2,'2262    ','BUDGEWOI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (850,837,2,'2262    ','BUFF POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (851,838,2,'2262    ','DOYALSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (852,839,2,'2262    ','HALEKULANI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (853,840,2,'2262    ','SAN REMO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (854,841,2,'2263    ','CHARMHAVEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (855,842,2,'2263    ','GOROKAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (856,843,2,'2263    ','LAKE HAVEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (857,844,2,'2263    ','NORAH HEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (858,845,2,'2263    ','NORAVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (859,846,2,'2263    ','TOUKLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (860,847,2,'2264    ','BONNELLS BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (861,848,2,'2264    ','BRIGHTWATERS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (862,849,2,'2264    ','DORA CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (863,850,2,'2264    ','ERARING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (864,851,2,'2264    ','MANDALONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (865,852,2,'2264    ','MIRRABOOKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (866,853,2,'2264    ','MORISSET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (867,854,2,'2264    ','SILVERWATER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (868,855,2,'2264    ','SUNSHINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (869,856,2,'2265    ','COORANBONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (870,857,2,'2265    ','MARTINSVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (871,858,2,'2267    ','WANGI WANGI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (872,859,2,'2278    ','BARNSLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (873,860,2,'2278    ','KILLINGWORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (874,861,2,'2278    ','WAKEFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (875,862,2,'2280    ','BELMONT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (876,863,2,'2280    ','CROUDACE BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (877,864,2,'2280    ','FLORAVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (878,865,2,'2280    ','JEWELLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (879,866,2,'2280    ','MARKS POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (880,867,2,'2280    ','VALENTINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (881,868,2,'2281    ','BLACKSMITHS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (882,869,2,'2281    ','CAMS WHARF');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (883,870,2,'2281    ','CATHERINE HILL BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (884,871,2,'2281    ','CAVES BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (885,872,2,'2281    ','MIDDLE CAMP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (886,873,2,'2281    ','NORDS WHARF');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (887,874,2,'2281    ','SWANSEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (888,875,2,'2282    ','ELEEBANA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (889,876,2,'2282    ','LAKELANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (890,877,2,'2282    ','WARNERS BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (891,878,2,'2283    ','ARCADIA VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (892,879,2,'2283    ','AWABA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (893,880,2,'2283    ','BALMORAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (894,881,2,'2283    ','BLACKALLS PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (895,882,2,'2283    ','BOLTON POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (896,883,2,'2283    ','BUTTABA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (897,884,2,'2283    ','CAREY BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (898,885,2,'2283    ','COAL POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (899,886,2,'2283    ','FASSIFERN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (900,887,2,'2283    ','FENNELL BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (901,888,2,'2283    ','FISHING POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (902,889,2,'2283    ','KILABEN BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (903,890,2,'2283    ','RATHMINES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (904,891,2,'2283    ','TORONTO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (905,892,2,'2284    ','ARGENTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (906,893,2,'2284    ','BOOLAROO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (907,894,2,'2284    ','BOORAGUL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (908,895,2,'2284    ','MARMONG POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (909,896,2,'2284    ','SPEERS POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (910,897,2,'2284    ','TERALBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (911,898,2,'2284    ','WOODRISING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (912,899,2,'2285    ','CARDIFF');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (913,900,2,'2285    ','EDGEWORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (914,901,2,'2285    ','EDGEWORTH DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (915,902,2,'2285    ','GLENDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (916,903,2,'2286    ','HOLMESVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (917,904,2,'2286    ','WEST WALLSEND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (918,905,2,'2287    ','BIRMINGHAM GARDENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (919,906,2,'2287    ','ELERMORE VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (920,907,2,'2287    ','FLETCHER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (921,908,2,'2287    ','MARYLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (922,909,2,'2287    ','MINMI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (923,910,2,'2287    ','RANKIN PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (924,911,2,'2287    ','SUMMER HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (925,912,2,'2287    ','WALLSEND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (926,913,2,'2287    ','WALLSEND DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (927,914,2,'2287    ','WALLSEND SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (928,915,2,'2289    ','ADAMSTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (929,916,2,'2289    ','ADAMSTOWN HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (930,917,2,'2289    ','GARDEN SUBURB');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (931,918,2,'2289    ','HIGHFIELDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (932,919,2,'2289    ','KOTARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (933,920,2,'2289    ','KOTARA FAIR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (934,921,2,'2290    ','BENNETTS GREEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (935,922,2,'2290    ','CHARLESTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (936,923,2,'2290    ','DUDLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (937,924,2,'2290    ','GATESHEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (938,925,2,'2290    ','HILLSBOROUGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (939,926,2,'2290    ','KAHIBAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (940,927,2,'2290    ','MOUNT HUTTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (941,928,2,'2290    ','REDHEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (942,929,2,'2290    ','TINGIRA HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (943,930,2,'2290    ','WHITEBRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (944,931,2,'2291    ','MEREWETHER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (945,932,2,'2291    ','MEREWETHER HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (946,933,2,'2291    ','THE JUNCTION');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (947,934,2,'2292    ','BROADMEADOW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (948,935,2,'2293    ','MARYVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (949,936,2,'2293    ','WICKHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (950,937,2,'2294    ','CARRINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (951,938,2,'2295    ','FERN BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (952,939,2,'2295    ','STOCKTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (953,940,2,'2295    ','STOCKTON DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (954,941,2,'2296    ','ISLINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (955,942,2,'2297    ','TIGHES HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (956,943,2,'2298    ','GEORGETOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (957,944,2,'2298    ','WARATAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (958,945,2,'2298    ','WARATAH WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (959,946,2,'2299    ','JESMOND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (960,947,2,'2299    ','LAMBTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (961,948,2,'2299    ','NORTH LAMBTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (962,949,2,'2300    ','BAR BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (963,950,2,'2300    ','COOKS HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (964,951,2,'2300    ','NEWCASTLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (965,952,2,'2300    ','NEWCASTLE EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (966,953,2,'2300    ','THE HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (967,954,2,'2302    ','NEWCASTLE WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (968,955,2,'2303    ','HAMILTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (969,956,2,'2303    ','HAMILTON EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (970,957,2,'2303    ','HAMILTON SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (971,958,2,'2304    ','KOORAGANG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (972,959,2,'2304    ','MAYFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (973,960,2,'2304    ','MAYFIELD EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (974,961,2,'2304    ','MAYFIELD NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (975,962,2,'2304    ','MAYFIELD WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (976,963,2,'2304    ','SANDGATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (977,964,2,'2304    ','WARABROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (978,965,2,'2305    ','KOTARA EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (979,966,2,'2305    ','NEW LAMBTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (980,967,2,'2305    ','NEW LAMBTON HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (981,968,2,'2306    ','WINDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (982,969,2,'2307    ','SHORTLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (983,970,2,'2308    ','CALLAGHAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (984,971,2,'2308    ','NEWCASTLE UNIVERSITY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (985,972,2,'2309    ','DANGAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (986,973,2,'2310    ','HUNTER REGION MC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (987,974,2,'2311    ','ALLYNBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (988,975,2,'2311    ','EAST GRESFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (989,976,2,'2311    ','GRESFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (990,977,2,'2311    ','HALTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (991,978,2,'2311    ','LOSTOCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (992,979,2,'2312    ','NABIAC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (993,980,2,'2314    ','WILLIAMTOWN RAAF');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (994,981,2,'2315    ','CORLETTE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (995,982,2,'2315    ','FINGAL BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (996,983,2,'2315    ','NELSON BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (997,984,2,'2315    ','SHOAL BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (998,985,2,'2316    ','ANNA BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (999,986,2,'2316    ','BOAT HARBOUR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1000,987,2,'2316    ','BOBS FARM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1001,988,2,'2317    ','SALAMANDER BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1002,989,2,'2317    ','SOLDIERS POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1003,990,2,'2318    ','CAMPVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1004,991,2,'2318    ','FULLERTON COVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1005,992,2,'2318    ','MEDOWIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1006,993,2,'2318    ','OYSTER COVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1007,994,2,'2318    ','SALT ASH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1008,995,2,'2318    ','WILLIAMTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1009,996,2,'2319    ','LEMON TREE PASSAGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1010,997,2,'2319    ','MALLABULA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1011,998,2,'2319    ','TANILBA BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1012,999,2,'2320    ','BOLWARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1013,1000,2,'2320    ','FARLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1014,1001,2,'2320    ','HILLSBOROUGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1015,1002,2,'2320    ','LARGS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1016,1003,2,'2320    ','LORN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1017,1004,2,'2320    ','MAITLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1018,1005,2,'2320    ','MAITLAND DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1019,1006,2,'2320    ','MAITLAND NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1020,1007,2,'2320    ','POKOLBIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1021,1008,2,'2320    ','ROTHBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1022,1009,2,'2320    ','RUTHERFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1023,1010,2,'2320    ','TELARAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1024,1011,2,'2321    ','CLARENCE TOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1025,1012,2,'2321    ','GILLIESTON HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1026,1013,2,'2321    ','GLEN WILLIAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1027,1014,2,'2321    ','HEDDON GRETA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1028,1015,2,'2321    ','HINTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1029,1016,2,'2321    ','LOCHINVAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1030,1017,2,'2321    ','MORPETH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1031,1018,2,'2321    ','RAWORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1032,1019,2,'2321    ','WOODVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1033,1020,2,'2322    ','BERESFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1034,1021,2,'2322    ','BLACK HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1035,1022,2,'2322    ','HEXHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1036,1023,2,'2322    ','LENAGHAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1037,1024,2,'2322    ','TARRO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1038,1025,2,'2322    ','THORNTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1039,1026,2,'2322    ','TOMAGO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1040,1027,2,'2322    ','WOODBERRY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1041,1028,2,'2323    ','ASHTONFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1042,1029,2,'2323    ','BRUNKERVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1043,1030,2,'2323    ','EAST MAITLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1044,1031,2,'2323    ','FREEMANS WATERHOLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1045,1032,2,'2323    ','GREENHILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1046,1033,2,'2323    ','METFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1047,1034,2,'2323    ','METFORD DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1048,1035,2,'2323    ','MOUNT VINCENT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1049,1036,2,'2323    ','MULBRING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1050,1037,2,'2323    ','TENAMBIT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1051,1038,2,'2324    ','CARRINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1052,1039,2,'2324    ','HAWKS NEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1053,1040,2,'2324    ','HEATHERBRAE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1054,1041,2,'2324    ','KARUAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1055,1042,2,'2324    ','LIMEBURNERS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1056,1043,2,'2324    ','MILLERS FOREST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1057,1044,2,'2324    ','NORTH ARM COVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1058,1045,2,'2324    ','OSTERLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1059,1046,2,'2324    ','RAYMOND TERRACE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1060,1047,2,'2324    ','RAYMOND TERRACE EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1061,1048,2,'2324    ','SEAHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1062,1049,2,'2324    ','SWAN BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1063,1050,2,'2324    ','TEA GARDENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1064,1051,2,'2325    ','ABERDARE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1065,1052,2,'2325    ','ABERNETHY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1066,1053,2,'2325    ','BELLBIRD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1067,1054,2,'2325    ','CESSNOCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1068,1055,2,'2325    ','CESSNOCK DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1069,1056,2,'2325    ','CESSNOCK WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1070,1057,2,'2325    ','CONGEWAI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1071,1058,2,'2325    ','ELLALONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1072,1059,2,'2325    ','ELRINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1073,1060,2,'2325    ','KEARSLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1074,1061,2,'2325    ','KITCHENER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1075,1062,2,'2325    ','LAGUNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1076,1063,2,'2325    ','MILLFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1077,1064,2,'2325    ','MOUNT VIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1078,1065,2,'2325    ','NULKABA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1079,1066,2,'2325    ','PAXTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1080,1067,2,'2325    ','PAYNES CROSSING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1081,1068,2,'2325    ','PELTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1082,1069,2,'2325    ','QUORROBOLONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1083,1070,2,'2325    ','WOLLOMBI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1084,1071,2,'2326    ','ABERMAIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1085,1072,2,'2326    ','BISHOPS BRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1086,1073,2,'2326    ','LOXFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1087,1074,2,'2326    ','WESTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1088,1075,2,'2327    ','KURRI KURRI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1089,1076,2,'2327    ','PELAW MAIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1090,1077,2,'2327    ','STANFORD MERTHYR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1091,1078,2,'2328    ','DENMAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1092,1079,2,'2328    ','KERRABEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1093,1080,2,'2329    ','BORAMBIL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1094,1081,2,'2329    ','BOW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1095,1082,2,'2329    ','CASSILIS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1096,1083,2,'2329    ','MERRIWA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1097,1084,2,'2329    ','UARBRY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1098,1085,2,'2330    ','BROKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1099,1086,2,'2330    ','BULGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1100,1087,2,'2330    ','CAMBERWELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1101,1088,2,'2330    ','CARROWBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1102,1089,2,'2330    ','DURAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1103,1090,2,'2330    ','GLENNIES CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1104,1091,2,'2330    ','GREENLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1105,1092,2,'2330    ','HEBDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1106,1093,2,'2330    ','HOWES VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1107,1094,2,'2330    ','JERRYS PLAINS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1108,1095,2,'2330    ','MIRANNIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1109,1096,2,'2330    ','MITCHELLS FLAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1110,1097,2,'2330    ','MOUNT OLIVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1111,1098,2,'2330    ','PUTTY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1112,1099,2,'2330    ','RAVENSWORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1113,1100,2,'2330    ','REEDY CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1114,1101,2,'2330    ','SINGLETON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1115,1102,2,'2330    ','SINGLETON DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1116,1103,2,'2330    ','ST CLAIR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1117,1104,2,'2330    ','WARKWORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1118,1105,2,'2331    ','SINGLETON MILPO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1119,1106,2,'2333    ','BAERAMI CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1120,1107,2,'2333    ','EDDERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1121,1108,2,'2333    ','GUNGAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1122,1109,2,'2333    ','HOLLYDEEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1123,1110,2,'2333    ','LIDDELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1124,1111,2,'2333    ','MCCULLYS GAP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1125,1112,2,'2333    ','MUSCLE CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1126,1113,2,'2333    ','MUSWELLBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1127,1114,2,'2333    ','SANDY HOLLOW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1128,1115,2,'2333    ','WYBONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1129,1116,2,'2334    ','GRETA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1130,1117,2,'2335    ','BELFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1131,1118,2,'2335    ','BRANXTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1132,1119,2,'2335    ','DALWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1133,1120,2,'2335    ','ELDERSLIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1134,1121,2,'2335    ','NORTH ROTHBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1135,1122,2,'2335    ','STANHOPE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1136,1123,2,'2336    ','ABERDEEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1137,1124,2,'2336    ','DANGARFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1138,1125,2,'2336    ','DARTBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1139,1126,2,'2336    ','DAVIS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1140,1127,2,'2336    ','ROUCHEL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1141,1128,2,'2336    ','UPPER ROUCHEL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1142,1129,2,'2337    ','BUNNAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1143,1130,2,'2337    ','ELLERSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1144,1131,2,'2337    ','GUNDY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1145,1132,2,'2337    ','KARS SPRINGS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1146,1133,2,'2337    ','MOONAN BROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1147,1134,2,'2337    ','MOONAN FLAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1148,1135,2,'2337    ','OWENS GAP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1149,1136,2,'2337    ','PARKVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1150,1137,2,'2337    ','SATUR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1151,1138,2,'2337    ','SCONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1152,1139,2,'2337    ','STEWARTS BROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1153,1140,2,'2337    ','WINGEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1154,1141,2,'2337    ','WOOLOOMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1155,1142,2,'2338    ','ARDGLEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1156,1143,2,'2338    ','BLANDFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1157,1144,2,'2338    ','MURRURUNDI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1158,1145,2,'2339    ','WARRAH CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1159,1146,2,'2339    ','WILLOW TREE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1160,1147,2,'2340    ','BOWLING ALLEY POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1161,1148,2,'2340    ','CARROLL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1162,1149,2,'2340    ','DUNGOWAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1163,1150,2,'2340    ','GOWRIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1164,1151,2,'2340    ','NEMINGHA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1165,1152,2,'2340    ','NUNDLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1166,1153,2,'2340    ','OXLEY VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1167,1154,2,'2340    ','SOMERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1168,1155,2,'2340    ','TAMWORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1169,1156,2,'2340    ','TAMWORTH DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1170,1157,2,'2340    ','TAMWORTH SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1171,1158,2,'2340    ','WEST TAMWORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1172,1159,2,'2340    ','WESTDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1173,1160,2,'2340    ','WOOLOMIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1174,1161,2,'2341    ','WERRIS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1175,1162,2,'2342    ','CURRABUBULA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1176,1163,2,'2343    ','BLACKVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1177,1164,2,'2343    ','CAROONA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1178,1165,2,'2343    ','COLLY BLUE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1179,1166,2,'2343    ','PINE RIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1180,1167,2,'2343    ','QUIRINDI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1181,1168,2,'2343    ','SPRING RIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1182,1169,2,'2343    ','WALLABADAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1183,1170,2,'2344    ','DURI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1184,1171,2,'2345    ','ATTUNGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1185,1172,2,'2345    ','GARTHOWEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1186,1173,2,'2346    ','MANILLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1187,1174,2,'2347    ','BARRABA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1188,1175,2,'2347    ','COBBADAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1189,1176,2,'2347    ','UPPER HORTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1190,1177,2,'2348    ','NEW ENGLAND MC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1191,1178,2,'2350    ','ACACIA PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1192,1179,2,'2350    ','ARMIDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1193,1180,2,'2350    ','EAST ARMIDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1194,1181,2,'2350    ','ENMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1195,1182,2,'2350    ','EXMOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1196,1183,2,'2350    ','HILLGROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1197,1184,2,'2350    ','INVERGOWRIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1198,1185,2,'2350    ','JEOGLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1199,1186,2,'2350    ','METZ');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1200,1187,2,'2350    ','NORTH HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1201,1188,2,'2350    ','SOUTH HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1202,1189,2,'2350    ','ST PATRICKS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1203,1190,2,'2350    ','WEST ARMIDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1204,1191,2,'2350    ','WOLLOMOMBI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1205,1192,2,'2351    ','UNIVERSITY OF NEW ENGLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1206,1193,2,'2352    ','KOOTINGAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1207,1194,2,'2352    ','LIMBRI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1208,1195,2,'2353    ','MOONBI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1209,1196,2,'2354    ','KENTUCKY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1210,1197,2,'2354    ','NIANGALA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1211,1198,2,'2354    ','NOWENDOC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1212,1199,2,'2354    ','WALCHA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1213,1200,2,'2354    ','WOLLUN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1214,1201,2,'2354    ','WOOLBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1215,1202,2,'2355    ','BENDEMEER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1216,1203,2,'2355    ','WATSONS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1217,1204,2,'2356    ','GWABEGAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1218,1205,2,'2357    ','BUGALDIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1219,1206,2,'2357    ','COONABARABRAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1220,1207,2,'2357    ','PURLEWAUGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1221,1208,2,'2357    ','ROCKY GLEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1222,1209,2,'2357    ','ULAMAMBRI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1223,1210,2,'2358    ','ENMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1224,1211,2,'2358    ','KINGSTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1225,1212,2,'2358    ','URALLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1226,1213,2,'2359    ','BUNDARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1227,1214,2,'2360    ','BUKKULLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1228,1215,2,'2360    ','ELSMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1229,1216,2,'2360    ','GILGAI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1230,1217,2,'2360    ','GRAMAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1231,1218,2,'2360    ','GUM FLAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1232,1219,2,'2360    ','INVERELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1233,1220,2,'2360    ','LITTLE PLAIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1234,1221,2,'2360    ','MOUNT RUSSELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1235,1222,2,'2360    ','NULLAMANNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1236,1223,2,'2360    ','WALLANGRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1237,1224,2,'2361    ','ASHFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1238,1225,2,'2361    ','BONSHAW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1239,1226,2,'2365    ','BEN LOMOND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1240,1227,2,'2365    ','BLACK MOUNTAIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1241,1228,2,'2365    ','GLENCOE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1242,1229,2,'2365    ','GUYRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1243,1230,2,'2365    ','LLANGOTHLIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1244,1231,2,'2365    ','WANDSWORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1245,1232,2,'2369    ','STANNIFER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1246,1233,2,'2369    ','TINGHA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1247,1234,2,'2370    ','DUNDEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1248,1235,2,'2370    ','FURRACABAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1249,1236,2,'2370    ','GLEN INNES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1250,1237,2,'2370    ','MATHESON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1251,1238,2,'2370    ','NEWTON BOYD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1252,1239,2,'2370    ','RED RANGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1253,1240,2,'2370    ','SWAN VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1254,1241,2,'2371    ','DEEPWATER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1255,1242,2,'2371    ','EMMAVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1256,1243,2,'2371    ','STANNUM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1257,1244,2,'2371    ','TORRINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1258,1245,2,'2372    ','BLACK SWAMP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1259,1246,2,'2372    ','BOLIVIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1260,1247,2,'2372    ','BOONOO BOONOO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1261,1248,2,'2372    ','BUNGULLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1262,1249,2,'2372    ','LISTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1263,1250,2,'2372    ','SANDY FLAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1264,1251,2,'2372    ','TENTERFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1265,1252,2,'2372    ','WYLIE CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1266,1253,2,'2379    ','MULLALEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1267,1254,2,'2380    ','BURBURGATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1268,1255,2,'2380    ','COOCOOBOONAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1269,1256,2,'2380    ','GUNNEDAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1270,1257,2,'2380    ','KELVIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1271,1258,2,'2380    ','ORANGE GROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1272,1259,2,'2381    ','BREEZA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1273,1260,2,'2381    ','CURLEWIS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1274,1261,2,'2381    ','PREMER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1275,1262,2,'2381    ','PULLAMING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1276,1263,2,'2381    ','TAMBAR SPRINGS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1277,1264,2,'2382    ','BOGGABRI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1278,1265,2,'2386    ','BURREN JUNCTION');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1279,1266,2,'2387    ','ROWENA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1280,1267,2,'2388    ','CUTTABRI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1281,1268,2,'2388    ','PILLIGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1282,1269,2,'2388    ','WEE WAA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1283,1270,2,'2390    ','BAAN BAA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1284,1271,2,'2390    ','EDGEROI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1285,1272,2,'2390    ','NARRABRI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1286,1273,2,'2390    ','TURRAWAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1287,1274,2,'2395    ','BINNAWAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1288,1275,2,'2395    ','WEETALIBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1289,1276,2,'2396    ','BARADINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1290,1277,2,'2396    ','KENEBRI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1291,1278,2,'2397    ','BELLATA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1292,1279,2,'2398    ','GURLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1293,1280,2,'2399    ','PALLAMALLAWA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1294,1281,2,'2400    ','ASHLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1295,1282,2,'2400    ','CROOBLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1296,1283,2,'2400    ','MOREE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1297,1284,2,'2400    ','TERRY HIE HIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1298,1285,2,'2401    ','GRAVESEND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1299,1286,2,'2402    ','COOLATAI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1300,1287,2,'2402    ','WARIALDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1301,1288,2,'2403    ','DELUNGRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1302,1289,2,'2403    ','KOLOONA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1303,1290,2,'2404    ','BINGARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1304,1291,2,'2404    ','DINOGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1305,1292,2,'2405    ','BOOMI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1306,1293,2,'2405    ','GARAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1307,1294,2,'2406    ','MUNGINDI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1308,1295,2,'2408    ','NORTH STAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1309,1296,2,'2409    ','BOGGABILLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1310,1297,2,'2410    ','YETMAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1311,1298,2,'2411    ','CROPPA CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1312,1299,2,'2415    ','MONKERAI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1313,1300,2,'2415    ','STROUD ROAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1314,1301,2,'2420    ','BANDON GROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1315,1302,2,'2420    ','DUNGOG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1316,1303,2,'2420    ','HILLDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1317,1304,2,'2420    ','MARSHDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1318,1305,2,'2420    ','SALISBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1319,1306,2,'2420    ','WALLAROBBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1320,1307,2,'2421    ','PATERSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1321,1308,2,'2421    ','TREVALLYN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1322,1309,2,'2421    ','VACY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1323,1310,2,'2422    ','BARRINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1324,1311,2,'2422    ','BELBORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1325,1312,2,'2422    ','BRETTI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1326,1313,2,'2422    ','BUNDOOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1327,1314,2,'2422    ','COPELAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1328,1315,2,'2422    ','CRAVEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1329,1316,2,'2422    ','GLOUCESTER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1330,1317,2,'2422    ','RAWDON VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1331,1318,2,'2422    ','STRATFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1332,1319,2,'2422    ','UPPER BOWMAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1333,1320,2,'2422    ','WARDS RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1334,1321,2,'2423    ','BOOLAMBAYTE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1335,1322,2,'2423    ','BULAHDELAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1336,1323,2,'2423    ','BUNGWAHL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1337,1324,2,'2423    ','COOLONGOLOOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1338,1325,2,'2423    ','MARKWELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1339,1326,2,'2423    ','NERONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1340,1327,2,'2423    ','SEAL ROCKS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1341,1328,2,'2423    ','UPPER MYALL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1342,1329,2,'2423    ','WANG WAUK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1343,1330,2,'2423    ','WILLINA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1344,1331,2,'2423    ','WOOTTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1345,1332,2,'2424    ','CUNDLE FLAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1346,1333,2,'2424    ','KNORRIT FLAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1347,1334,2,'2424    ','MOUNT GEORGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1348,1335,2,'2424    ','NUMBER ONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1349,1336,2,'2425    ','ALLWORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1350,1337,2,'2425    ','BOORAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1351,1338,2,'2425    ','GIRVAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1352,1339,2,'2425    ','STROUD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1353,1340,2,'2425    ','WASHPOOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1354,1341,2,'2426    ','COOPERNOOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1355,1342,2,'2426    ','LANGLEY VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1356,1343,2,'2427    ','CROWDY HEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1357,1344,2,'2427    ','HARRINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1358,1345,2,'2428    ','FORSTER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1359,1346,2,'2428    ','FORSTER DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1360,1347,2,'2428    ','FORSTER SHOPPING VILLAGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1361,1348,2,'2428    ','GREEN POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1362,1349,2,'2428    ','SMITHS LAKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1363,1350,2,'2428    ','TARBUCK BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1364,1351,2,'2428    ','TUNCURRY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1365,1352,2,'2429    ','BOBIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1366,1353,2,'2429    ','BUNYAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1367,1354,2,'2429    ','BURRELL CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1368,1355,2,'2429    ','CAPARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1369,1356,2,'2429    ','COMBOYNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1370,1357,2,'2429    ','DYERS CROSSING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1371,1358,2,'2429    ','ELANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1372,1359,2,'2429    ','FIREFLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1373,1360,2,'2429    ','KILLABAKH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1374,1361,2,'2429    ','KIMBRIKI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1375,1362,2,'2429    ','KRAMBACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1376,1363,2,'2429    ','MARLEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1377,1364,2,'2429    ','MOORAL CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1378,1365,2,'2429    ','WARRIWILLAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1379,1366,2,'2429    ','WHERROL FLAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1380,1367,2,'2429    ','WINGHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1381,1368,2,'2430    ','BOHNOCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1382,1369,2,'2430    ','CHATHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1383,1370,2,'2430    ','CUNDLETOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1384,1371,2,'2430    ','DIAMOND BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1385,1372,2,'2430    ','FAILFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1386,1373,2,'2430    ','GHINNI GHINNI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1387,1374,2,'2430    ','HALLIDAYS POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1388,1375,2,'2430    ','KOLODONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1389,1376,2,'2430    ','KOORAINGHAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1390,1377,2,'2430    ','OLD BAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1391,1378,2,'2430    ','PURFLEET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1392,1379,2,'2430    ','TAREE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1393,1380,2,'2430    ','TAREE DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1394,1381,2,'2430    ','TINONEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1395,1382,2,'2430    ','UPPER LANSDOWNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1396,1383,2,'2431    ','JERSEYVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1397,1384,2,'2431    ','SOUTH WEST ROCKS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1398,1385,2,'2439    ','KENDALL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1399,1386,2,'2439    ','KEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1400,1387,2,'2439    ','LORNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1401,1388,2,'2440    ','BELLBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1402,1389,2,'2440    ','BELLIMBOPINNI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1403,1390,2,'2440    ','CARRAI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1404,1391,2,'2440    ','CLYBUCCA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1405,1392,2,'2440    ','COLLOMBATTI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1406,1393,2,'2440    ','COMARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1407,1394,2,'2440    ','CRESCENT HEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1408,1395,2,'2440    ','FREDERICKTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1409,1396,2,'2440    ','GLADSTONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1410,1397,2,'2440    ','GREENHILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1411,1398,2,'2440    ','HAT HEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1412,1399,2,'2440    ','HICKEYS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1413,1400,2,'2440    ','KEMPSEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1414,1401,2,'2440    ','LOWER CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1415,1402,2,'2440    ','MILLBANK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1416,1403,2,'2440    ','SMITHTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1417,1404,2,'2440    ','SOUTH KEMPSEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1418,1405,2,'2440    ','TOOROOKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1419,1406,2,'2440    ','VERGES CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1420,1407,2,'2440    ','WILLAWARRIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1421,1408,2,'2441    ','BALLENGARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1422,1409,2,'2441    ','CROSSMAGLEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1423,1410,2,'2441    ','EUNGAI CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1424,1411,2,'2441    ','EUNGAI RAIL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1425,1412,2,'2441    ','GRASSY HEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1426,1413,2,'2441    ','GUM SCRUB');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1427,1414,2,'2441    ','KUNDABUNG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1428,1415,2,'2441    ','ROLLANDS PLAINS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1429,1416,2,'2441    ','STUARTS POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1430,1417,2,'2441    ','TELEGRAPH POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1431,1418,2,'2442    ','MID NORTH COAST MSC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1432,1419,2,'2443    ','CAMDEN HEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1433,1420,2,'2443    ','DUNBOGAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1434,1421,2,'2443    ','HANNAM VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1435,1422,2,'2443    ','HERONS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1436,1423,2,'2443    ','JOHNS RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1437,1424,2,'2443    ','LAURIETON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1438,1425,2,'2443    ','MOORLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1439,1426,2,'2443    ','NORTH HAVEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1440,1427,2,'2443    ','WEST HAVEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1441,1428,2,'2444    ','BLACKMANS POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1442,1429,2,'2444    ','FLYNNS BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1443,1430,2,'2444    ','PORT MACQUARIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1444,1431,2,'2444    ','PORT MACQUARIE BC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1445,1432,2,'2444    ','PORT MACQUARIE DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1446,1433,2,'2445    ','BONNY HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1447,1434,2,'2445    ','LAKE CATHIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1448,1435,2,'2446    ','BAGNOO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1449,1436,2,'2446    ','BEECHWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1450,1437,2,'2446    ','BELLANGRY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1451,1438,2,'2446    ','BYABARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1452,1439,2,'2446    ','ELLENBOROUGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1453,1440,2,'2446    ','HOLLISDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1454,1441,2,'2446    ','HUNTINGDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1455,1442,2,'2446    ','LONG FLAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1456,1443,2,'2446    ','PAPPINBARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1457,1444,2,'2446    ','PEMBROOKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1458,1445,2,'2446    ','TOMS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1459,1446,2,'2446    ','WAUCHOPE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1460,1447,2,'2447    ','MACKSVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1461,1448,2,'2447    ','SCOTTS HEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1462,1449,2,'2447    ','TAYLORS ARM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1463,1450,2,'2447    ','THUMB CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1464,1451,2,'2447    ','WARRELL CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1465,1452,2,'2448    ','NAMBUCCA HEADS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1466,1453,2,'2448    ','VALLA BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1467,1454,2,'2449    ','ARGENTS HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1468,1455,2,'2449    ','BOWRAVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1469,1456,2,'2449    ','MISSABOTTI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1470,1457,2,'2450    ','BOAMBEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1471,1458,2,'2450    ','COFFS HARBOUR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1472,1459,2,'2450    ','COFFS HARBOUR DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1473,1460,2,'2450    ','CORAMBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1474,1461,2,'2450    ','GLENREAGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1475,1462,2,'2450    ','KARANGI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1476,1463,2,'2450    ','KORORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1477,1464,2,'2450    ','LOWANNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1478,1465,2,'2450    ','LOWER BUCCA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1479,1466,2,'2450    ','MOONEE BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1480,1467,2,'2450    ','NANA GLEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1481,1468,2,'2450    ','TIMMSVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1482,1469,2,'2450    ','ULONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1483,1470,2,'2450    ','UPPER ORARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1484,1471,2,'2452    ','SAWTELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1485,1472,2,'2452    ','TOORMINA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1486,1473,2,'2453    ','BOSTOBRICK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1487,1474,2,'2453    ','BRIGGSVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1488,1475,2,'2453    ','CASCADE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1489,1476,2,'2453    ','DORRIGO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1490,1477,2,'2453    ','DUNDURRABIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1491,1478,2,'2453    ','EBOR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1492,1479,2,'2453    ','HERNANI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1493,1480,2,'2453    ','MEGAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1494,1481,2,'2453    ','TYRINGHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1495,1482,2,'2454    ','BELLINGEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1496,1483,2,'2454    ','FERNMOUNT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1497,1484,2,'2454    ','KALANG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1498,1485,2,'2454    ','MYLESTOM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1499,1486,2,'2454    ','RALEIGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1500,1487,2,'2454    ','REPTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1501,1488,2,'2454    ','SUNNY CORNER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1502,1489,2,'2454    ','THORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1503,1490,2,'2455    ','URUNGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1504,1491,2,'2456    ','ARRAWARRA HEADLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1505,1492,2,'2456    ','CORINDI BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1506,1493,2,'2456    ','EMERALD BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1507,1494,2,'2456    ','RED ROCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1508,1495,2,'2456    ','SAFETY BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1509,1496,2,'2456    ','SANDY BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1510,1497,2,'2456    ','WOOLGOOLGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1511,1498,2,'2456    ','WOOLGOOLGA DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1512,1499,2,'2460    ','BARYULGIL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1513,1500,2,'2460    ','BRUSHGROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1514,1501,2,'2460    ','CANGAI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1515,1502,2,'2460    ','COALDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1516,1503,2,'2460    ','COPMANHURST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1517,1504,2,'2460    ','COUTTS CROSSING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1518,1505,2,'2460    ','COWPER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1519,1506,2,'2460    ','GRAFTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1520,1507,2,'2460    ','GRAFTON WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1521,1508,2,'2460    ','HALFWAY CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1522,1509,2,'2460    ','JACKADGERY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1523,1510,2,'2460    ','JUNCTION HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1524,1511,2,'2460    ','KANGAROO CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1525,1512,2,'2460    ','LAWRENCE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1526,1513,2,'2460    ','NYMBOIDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1527,1514,2,'2460    ','SEELANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1528,1515,2,'2460    ','SOUTH ARM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1529,1516,2,'2460    ','SOUTH GRAFTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1530,1517,2,'2460    ','WATERVIEW HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1531,1518,2,'2460    ','WINEGROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1532,1519,2,'2462    ','PILLAR VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1533,1520,2,'2462    ','TUCABIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1534,1521,2,'2462    ','ULMARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1535,1522,2,'2462    ','WOOLI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1536,1523,2,'2463    ','BROOMS HEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1537,1524,2,'2463    ','MACLEAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1538,1525,2,'2463    ','TULLYMORGAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1539,1526,2,'2463    ','WOODFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1540,1527,2,'2464    ','YAMBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1541,1528,2,'2468    ','NORTHERN RIVERS MSC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1542,1529,2,'2469    ','MUMMULGUM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1543,1530,2,'2470    ','BACKMEDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1544,1531,2,'2470    ','BARAIMAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1545,1532,2,'2470    ','CASINO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1546,1533,2,'2470    ','CASINO WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1547,1534,2,'2470    ','COOMBELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1548,1535,2,'2470    ','DOBIES BIGHT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1549,1536,2,'2470    ','DOUBTFUL CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1550,1537,2,'2470    ','DYRAABA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1551,1538,2,'2470    ','DYRAABA CENTRAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1552,1539,2,'2470    ','DYRAABA CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1553,1540,2,'2470    ','ELLANGOWAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1554,1541,2,'2470    ','FAIRY HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1555,1542,2,'2470    ','IRVINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1556,1543,2,'2470    ','LEEVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1557,1544,2,'2470    ','MONGOGARIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1558,1545,2,'2470    ','NAUGHTONS GAP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1559,1546,2,'2470    ','PIORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1560,1547,2,'2470    ','SEXTONVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1561,1548,2,'2470    ','SHANNON BROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1562,1549,2,'2470    ','SPRING GROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1563,1550,2,'2470    ','STRATHEDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1564,1551,2,'2470    ','TOMKI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1565,1552,2,'2470    ','WOODVIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1566,1553,2,'2471    ','CORAKI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1567,1554,2,'2471    ','SWAN BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1568,1555,2,'2471    ','TATHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1569,1556,2,'2472    ','BROADWATER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1570,1557,2,'2472    ','RILEYS HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1571,1558,2,'2472    ','WOODBURN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1572,1559,2,'2473    ','EVANS HEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1573,1560,2,'2474    ','CAWONGLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1574,1561,2,'2474    ','ETTRICK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1575,1562,2,'2474    ','GENEVA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1576,1563,2,'2474    ','GREVILLIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1577,1564,2,'2474    ','KYOGLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1578,1565,2,'2474    ','LINDESAY VIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1579,1566,2,'2474    ','LYNCHS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1580,1567,2,'2474    ','RUKENVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1581,1568,2,'2474    ','THE RISK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1582,1569,2,'2474    ','TOONUMBAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1583,1570,2,'2474    ','WIANGAREE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1584,1571,2,'2475    ','URBENVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1585,1572,2,'2476    ','ACACIA PLATEAU');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1586,1573,2,'2476    ','LEGUME');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1587,1574,2,'2476    ','OLD KOREELAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1588,1575,2,'2476    ','WOODENBONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1589,1576,2,'2477    ','ALSTONVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1590,1577,2,'2477    ','ALSTONVILLE DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1591,1578,2,'2477    ','CABBAGE TREE ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1592,1579,2,'2477    ','DALWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1593,1580,2,'2477    ','MEERSCHAUM VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1594,1581,2,'2477    ','ROUS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1595,1582,2,'2477    ','ROUS MILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1596,1583,2,'2477    ','URALBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1597,1584,2,'2477    ','WARDELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1598,1585,2,'2477    ','WOLLONGBAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1599,1586,2,'2478    ','BALLINA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1600,1587,2,'2478    ','BALLINA DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1601,1588,2,'2478    ','EMPIRE VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1602,1589,2,'2478    ','KEITH HALL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1603,1590,2,'2478    ','LENNOX HEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1604,1591,2,'2478    ','PIMLICO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1605,1592,2,'2478    ','TEVEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1606,1593,2,'2478    ','TINTENBAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1607,1594,2,'2479    ','BANGALOW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1608,1595,2,'2479    ','BINNA BURRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1609,1596,2,'2479    ','BROOKLET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1610,1597,2,'2479    ','FERNLEIGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1611,1598,2,'2479    ','NASHUA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1612,1599,2,'2480    ','BENTLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1613,1600,2,'2480    ','BEXHILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1614,1601,2,'2480    ','CLUNES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1615,1602,2,'2480    ','CORNDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1616,1603,2,'2480    ','DORROUGHBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1617,1604,2,'2480    ','DUNOON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1618,1605,2,'2480    ','ELTHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1619,1606,2,'2480    ','EUREKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1620,1607,2,'2480    ','FEDERAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1621,1608,2,'2480    ','GEORGICA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1622,1609,2,'2480    ','GOOLMANGAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1623,1610,2,'2480    ','GOONELLABAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1624,1611,2,'2480    ','LISMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1625,1612,2,'2480    ','LISMORE DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1626,1613,2,'2480    ','MAROM CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1627,1614,2,'2480    ','MCKEES HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1628,1615,2,'2480    ','NIMBIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1629,1616,2,'2480    ','NORTH LISMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1630,1617,2,'2480    ','NUMULGI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1631,1618,2,'2480    ','RICHMOND HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1632,1619,2,'2480    ','ROCK VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1633,1620,2,'2480    ','ROSEBANK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1634,1621,2,'2480    ','RUTHVEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1635,1622,2,'2480    ','THE CHANNON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1636,1623,2,'2480    ','TREGEAGLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1637,1624,2,'2480    ','TUCKURIMBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1638,1625,2,'2480    ','TUNCESTER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1639,1626,2,'2480    ','WHIAN WHIAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1640,1627,2,'2480    ','WYRALLAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1641,1628,2,'2481    ','BROKEN HEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1642,1629,2,'2481    ','BYRON BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1643,1630,2,'2481    ','BYRON BAY DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1644,1631,2,'2481    ','SUFFOLK PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1645,1632,2,'2481    ','TYAGARAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1646,1633,2,'2482    ','GOONENGERRY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1647,1634,2,'2482    ','MULLUMBIMBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1648,1635,2,'2483    ','BILLINUDGEL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1649,1636,2,'2483    ','BRUNSWICK HEADS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1650,1637,2,'2483    ','BURRINGBAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1651,1638,2,'2483    ','CRABBES CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1652,1639,2,'2483    ','MOOBALL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1653,1640,2,'2483    ','NEW BRIGHTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1654,1641,2,'2483    ','OCEAN SHORES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1655,1642,2,'2483    ','SOUTH GOLDEN BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1656,1643,2,'2483    ','YELGUN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1657,1644,2,'2484    ','BOAT HARBOUR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1658,1645,2,'2484    ','BRAY PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1659,1646,2,'2484    ','CHILLINGHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1660,1647,2,'2484    ','CONDONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1661,1648,2,'2484    ','CRYSTAL CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1662,1649,2,'2484    ','CUDGERA CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1663,1650,2,'2484    ','DOON DOON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1664,1651,2,'2484    ','DUNBIBLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1665,1652,2,'2484    ','DUNGAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1666,1653,2,'2484    ','EUNGELLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1667,1654,2,'2484    ','KUNGHUR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1668,1655,2,'2484    ','MURWILLUMBAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1669,1656,2,'2484    ','MURWILLUMBAH DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1670,1657,2,'2484    ','NUMINBAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1671,1658,2,'2484    ','PALMVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1672,1659,2,'2484    ','STOKERS SIDING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1673,1660,2,'2484    ','TYALGUM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1674,1661,2,'2484    ','UKI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1675,1662,2,'2485    ','TWEED HEADS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1676,1663,2,'2485    ','TWEED HEADS WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1677,1664,2,'2486    ','BANORA POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1678,1665,2,'2486    ','BILAMBIL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1679,1666,2,'2486    ','CAROOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1680,1667,2,'2486    ','TERRANORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1681,1668,2,'2486    ','TWEED HEADS SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1682,1669,2,'2486    ','TWEED HEADS SOUTH DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1683,1670,2,'2487    ','CHINDERAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1684,1671,2,'2487    ','CUDGEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1685,1672,2,'2487    ','DURANBAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1686,1673,2,'2487    ','FINGAL HEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1687,1674,2,'2487    ','KINGSCLIFF');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1688,1675,2,'2487    ','STOTTS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1689,1676,2,'2488    ','BOGANGAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1690,1677,2,'2488    ','CABARITA BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1691,1678,2,'2489    ','HASTINGS POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1692,1679,2,'2489    ','POTTSVILLE BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1693,1680,2,'2490    ','TUMBULGUM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1694,1681,2,'2500    ','CONISTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1695,1682,2,'2500    ','GWYNNEVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1696,1683,2,'2500    ','KEIRAVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1697,1684,2,'2500    ','MANGERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1698,1685,2,'2500    ','MOUNT KEIRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1699,1686,2,'2500    ','MOUNT SAINT THOMAS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1700,1687,2,'2500    ','WOLLONGONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1701,1688,2,'2502    ','CRINGILA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1702,1689,2,'2502    ','LAKE HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1703,1690,2,'2502    ','PRIMBEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1704,1691,2,'2502    ','WARRAWONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1705,1692,2,'2505    ','KEMBLAWARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1706,1693,2,'2505    ','PORT KEMBLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1707,1694,2,'2506    ','BERKELEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1708,1695,2,'2508    ','COALCLIFF');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1709,1696,2,'2508    ','DARKES FOREST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1710,1697,2,'2508    ','HELENSBURGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1711,1698,2,'2508    ','OTFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1712,1699,2,'2508    ','STANWELL PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1713,1700,2,'2508    ','STANWELL TOPS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1714,1701,2,'2515    ','AUSTINMER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1715,1702,2,'2515    ','CLIFTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1716,1703,2,'2515    ','COLEDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1717,1704,2,'2515    ','SCARBOROUGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1718,1705,2,'2515    ','THIRROUL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1719,1706,2,'2515    ','WOMBARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1720,1707,2,'2516    ','BULLI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1721,1708,2,'2517    ','RUSSELL VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1722,1709,2,'2517    ','WOONONA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1723,1710,2,'2518    ','BELLAMBI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1724,1711,2,'2518    ','BELLAMBI DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1725,1712,2,'2518    ','CORRIMAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1726,1713,2,'2518    ','TARRAWANNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1727,1714,2,'2518    ','TOWRADGI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1728,1715,2,'2519    ','BALGOWNIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1729,1716,2,'2519    ','FAIRY MEADOW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1730,1717,2,'2519    ','MOUNT OUSLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1731,1718,2,'2519    ','MOUNT PLEASANT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1732,1719,2,'2520    ','WOLLONGONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1733,1720,2,'2521    ','SOUTH COAST MC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1734,1721,2,'2522    ','UNIVERSITY OF WOLLONGONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1735,1722,2,'2525    ','FIGTREE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1736,1723,2,'2526    ','CORDEAUX HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1737,1724,2,'2526    ','FARMBOROUGH HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1738,1725,2,'2526    ','KEMBLA GRANGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1739,1726,2,'2526    ','MOUNT KEMBLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1740,1727,2,'2526    ','UNANDERRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1741,1728,2,'2527    ','ALBION PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1742,1729,2,'2527    ','ALBION PARK RAIL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1743,1730,2,'2528    ','BARRACK HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1744,1731,2,'2528    ','BARRACK POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1745,1732,2,'2528    ','LAKE ILLAWARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1746,1733,2,'2528    ','MOUNT WARRIGAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1747,1734,2,'2528    ','WARILLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1748,1735,2,'2528    ','WINDANG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1749,1736,2,'2529    ','BALARANG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1750,1737,2,'2529    ','BLACKBUTT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1751,1738,2,'2529    ','DUNMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1752,1739,2,'2529    ','FLINDERS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1753,1740,2,'2529    ','OAK FLATS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1754,1741,2,'2529    ','OAK FLATS DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1755,1742,2,'2529    ','SHELL COVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1756,1743,2,'2529    ','SHELLHARBOUR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1757,1744,2,'2529    ','SHELLHARBOUR SQUARE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1758,1745,2,'2530    ','BROWNSVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1759,1746,2,'2530    ','DAPTO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1760,1747,2,'2530    ','HORSLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1761,1748,2,'2530    ','KANAHOOKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1762,1749,2,'2530    ','KOONAWARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1763,1750,2,'2530    ','WONGAWILLI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1764,1751,2,'2530    ','YALLAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1765,1752,2,'2533    ','BOMBO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1766,1753,2,'2533    ','JAMBEROO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1767,1754,2,'2533    ','KIAMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1768,1755,2,'2533    ','MINNAMURRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1769,1756,2,'2534    ','FOXGROUND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1770,1757,2,'2534    ','GERRINGONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1771,1758,2,'2534    ','GERROA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1772,1759,2,'2534    ','TOOLIJOOA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1773,1760,2,'2534    ','WERRI BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1774,1761,2,'2535    ','BELLAWONGARAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1775,1762,2,'2535    ','BERRY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1776,1763,2,'2535    ','BUDDEROO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1777,1764,2,'2535    ','COOLANGATTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1778,1765,2,'2535    ','JASPERS BRUSH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1779,1766,2,'2535    ','SHOALHAVEN HEADS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1780,1767,2,'2535    ','WATTAMOLLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1781,1768,2,'2535    ','WOODHILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1782,1769,2,'2536    ','BATEHAVEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1783,1770,2,'2536    ','BATEMANS BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1784,1771,2,'2536    ','BENANDARAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1785,1772,2,'2536    ','BIMBIMBIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1786,1773,2,'2536    ','BUCKENBOWRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1787,1774,2,'2536    ','CATALINA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1788,1775,2,'2536    ','CURROWAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1789,1776,2,'2536    ','DENHAMS BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1790,1777,2,'2536    ','DURRAS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1791,1778,2,'2536    ','DURRAS NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1792,1779,2,'2536    ','EAST LYNNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1793,1780,2,'2536    ','GUERILLA BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1794,1781,2,'2536    ','JEREMADRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1795,1782,2,'2536    ','LILLI PILLI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1796,1783,2,'2536    ','LONG BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1797,1784,2,'2536    ','MALONEYS BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1798,1785,2,'2536    ','MALUA BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1799,1786,2,'2536    ','MERRICUMBENE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1800,1787,2,'2536    ','MOGO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1801,1788,2,'2536    ','MURRENGENBURG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1802,1789,2,'2536    ','NELLIGEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1803,1790,2,'2536    ','NORTH BATEMANS BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1804,1791,2,'2536    ','ROSEDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1805,1792,2,'2536    ','RUNNYFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1806,1793,2,'2536    ','SOUTH DURRAS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1807,1794,2,'2536    ','SUNSHINE BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1808,1795,2,'2536    ','SURF BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1809,1796,2,'2536    ','SURFSIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1810,1797,2,'2536    ','WOODLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1811,1798,2,'2537    ','BERGALIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1812,1799,2,'2537    ','BINGIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1813,1800,2,'2537    ','BROULEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1814,1801,2,'2537    ','COILA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1815,1802,2,'2537    ','CONGO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1816,1803,2,'2537    ','DEUA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1817,1804,2,'2537    ','DEUA RIVER VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1818,1805,2,'2537    ','KIORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1819,1806,2,'2537    ','MERINGO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1820,1807,2,'2537    ','MOGENDOURA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1821,1808,2,'2537    ','MORUYA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1822,1809,2,'2537    ','MORUYA HEADS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1823,1810,2,'2537    ','MOSSY POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1824,1811,2,'2537    ','TOMAKIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1825,1812,2,'2537    ','TURLINJAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1826,1813,2,'2537    ','TUROSS HEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1827,1814,2,'2538    ','MILTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1828,1815,2,'2539    ','BAWLEY POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1829,1816,2,'2539    ','BENDALONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1830,1817,2,'2539    ','BERRINGER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1831,1818,2,'2539    ','BURRILL LAKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1832,1819,2,'2539    ','CONJOLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1833,1820,2,'2539    ','CUNJURONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1834,1821,2,'2539    ','KIOLOA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1835,1822,2,'2539    ','LAKE CONJOLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1836,1823,2,'2539    ','MANYANA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1837,1824,2,'2539    ','MOLLYMOOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1838,1825,2,'2539    ','TABOURIE LAKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1839,1826,2,'2539    ','TERMEIL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1840,1827,2,'2539    ','ULLADULLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1841,1828,2,'2539    ','YATTEYATTAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1842,1829,2,'2540    ','BAMARANG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1843,1830,2,'2540    ','BASIN VIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1844,1831,2,'2540    ','BERRARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1845,1832,2,'2540    ','BOLONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1846,1833,2,'2540    ','BRUNDEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1847,1834,2,'2540    ','BURRIER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1848,1835,2,'2540    ','CABBAGE TREE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1849,1836,2,'2540    ','CALLALA BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1850,1837,2,'2540    ','CALLALA BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1851,1838,2,'2540    ','CAMBEWARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1852,1839,2,'2540    ','CROOKHAVEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1853,1840,2,'2540    ','CUDMIRRAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1854,1841,2,'2540    ','CULBURRA BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1855,1842,2,'2540    ','CURRARONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1856,1843,2,'2540    ','EROWAL BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1857,1844,2,'2540    ','FALLS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1858,1845,2,'2540    ','GREENWELL POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1859,1846,2,'2540    ','HMAS ALBATROSS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1860,1847,2,'2540    ','HMAS CRESWELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1861,1848,2,'2540    ','HUSKISSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1862,1849,2,'2540    ','HYAMS BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1863,1850,1,'2540    ','JERVIS BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1864,1851,2,'2540    ','MEROO MEADOW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1865,1852,2,'2540    ','MYOLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1866,1853,2,'2540    ','NOWRA NAVAL PO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1867,1854,2,'2540    ','NUMBAA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1868,1855,2,'2540    ','OLD EROWAL BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1869,1856,2,'2540    ','ORIENT POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1870,1857,2,'2540    ','PYREE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1871,1858,2,'2540    ','SANCTUARY POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1872,1859,2,'2540    ','ST GEORGES BASIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1873,1860,2,'2540    ','SUSSEX INLET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1874,1861,2,'2540    ','SWANHAVEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1875,1862,2,'2540    ','TAPITALLEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1876,1863,2,'2540    ','TERARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1877,1864,2,'2540    ','TOMERONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1878,1865,2,'2540    ','VINCENTIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1879,1866,2,'2540    ','WANDANDIAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1880,1867,2,'2540    ','WOOLLAMIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1881,1868,2,'2540    ','WORRIGEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1882,1869,2,'2540    ','WRIGHTS BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1883,1870,2,'2540    ','YALWAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1884,1871,2,'2541    ','BOMADERRY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1885,1872,2,'2541    ','NOWRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1886,1873,2,'2541    ','NOWRA DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1887,1874,2,'2545    ','BODALLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1888,1875,2,'2545    ','NERRIGUNDAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1889,1876,2,'2546    ','BARRAGGA BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1890,1877,2,'2546    ','BEAUTY POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1891,1878,2,'2546    ','BERMAGUI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1892,1879,2,'2546    ','CENTRAL TILBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1893,1880,2,'2546    ','CUTTAGEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1894,1881,2,'2546    ','DALMENY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1895,1882,2,'2546    ','DIGNAMS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1896,1883,2,'2546    ','GREENDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1897,1884,2,'2546    ','NAROOMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1898,1885,2,'2546    ','NORTH NAROOMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1899,1886,2,'2546    ','TILBA TILBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1900,1887,2,'2546    ','TINPOT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1901,1888,2,'2546    ','WADBILLIGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1902,1889,2,'2546    ','WALLAGA LAKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1903,1890,2,'2546    ','WALLAGA LAKE HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1904,1891,2,'2548    ','BERRAMBOOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1905,1892,2,'2548    ','MERIMBULA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1906,1893,2,'2548    ','TURA BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1907,1894,2,'2549    ','BROADWATER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1908,1895,2,'2549    ','GREIGS FLAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1909,1896,2,'2549    ','NETHERCOTE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1910,1897,2,'2549    ','PAMBULA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1911,1898,2,'2549    ','SOUTH PAMBULA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1912,1899,2,'2550    ','BEGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1913,1900,2,'2550    ','BEMBOKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1914,1901,2,'2550    ','BOURNDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1915,1902,2,'2550    ','BROGO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1916,1903,2,'2550    ','BURRAGATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1917,1904,2,'2550    ','CANDELO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1918,1905,2,'2550    ','COBARGO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1919,1906,2,'2550    ','DOCTOR GEORGE MOUNTAIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1920,1907,2,'2550    ','KINGSWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1921,1908,2,'2550    ','MOGAREEKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1922,1909,2,'2550    ','MORANS CROSSING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1923,1910,2,'2550    ','MUMBULLA MOUNTAIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1924,1911,2,'2550    ','NELSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1925,1912,2,'2550    ','QUAAMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1926,1913,2,'2550    ','ROCKY HALL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1927,1914,2,'2550    ','TATHRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1928,1915,2,'2550    ','TOWAMBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1929,1916,2,'2550    ','WANDELLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1930,1917,2,'2550    ','WAPENGO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1931,1918,2,'2550    ','WOLUMLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1932,1919,2,'2550    ','WYNDHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1933,1920,2,'2550    ','YOWRIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1934,1921,2,'2551    ','EDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1935,1922,2,'2551    ','KIAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1936,1923,2,'2551    ','WONBOYN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1937,1924,2,'2551    ','WONBOYN LAKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1938,1925,2,'2558    ','EAGLE VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1939,1926,2,'2558    ','ESCHOL PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1940,1927,2,'2558    ','KEARNS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1941,1928,2,'2559    ','BLAIRMOUNT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1942,1929,2,'2559    ','CLAYMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1943,1930,2,'2560    ','AIRDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1944,1931,2,'2560    ','AMBARVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1945,1932,2,'2560    ','APPIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1946,1933,2,'2560    ','BLAIR ATHOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1947,1934,2,'2560    ','BRADBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1948,1935,2,'2560    ','CAMPBELLTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1949,1936,2,'2560    ','CAMPBELLTOWN DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1950,1937,2,'2560    ','ENGLORIE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1951,1938,2,'2560    ','GILEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1952,1939,2,'2560    ','GLEN ALPINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1953,1940,2,'2560    ','KENTLYN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1954,1941,2,'2560    ','LEUMEAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1955,1942,2,'2560    ','ROSEMEADOW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1956,1943,2,'2560    ','RUSE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1957,1944,2,'2560    ','ST HELENS PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1958,1945,2,'2560    ','WEDDERBURN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1959,1946,2,'2560    ','WOODBINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1960,1947,2,'2563    ','MENANGLE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1961,1948,2,'2564    ','LONG POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1962,1949,2,'2564    ','MACQUARIE FIELDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1963,1950,2,'2565    ','DENHAM COURT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1964,1951,2,'2565    ','INGLEBURN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1965,1952,2,'2565    ','MACQUARIE LINKS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1966,1953,2,'2566    ','BOW BOWING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1967,1954,2,'2566    ','MINTO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1968,1955,2,'2566    ','RABY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1969,1956,2,'2566    ','ST ANDREWS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1970,1957,2,'2566    ','VARROVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1971,1958,2,'2567    ','CURRANS HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1972,1959,2,'2567    ','HARRINGTON PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1973,1960,2,'2567    ','MOUNT ANNAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1974,1961,2,'2567    ','NARELLAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1975,1962,2,'2567    ','NARELLAN DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1976,1963,2,'2567    ','NARELLAN VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1977,1964,2,'2568    ','CAMDEN PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1978,1965,2,'2568    ','MENANGLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1979,1966,2,'2569    ','DOUGLAS PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1980,1967,2,'2570    ','CAMDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1981,1968,2,'2570    ','CAWDOR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1982,1969,2,'2570    ','COBBITTY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1983,1970,2,'2570    ','ELDERSLIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1984,1971,2,'2570    ','ELLIS LANE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1985,1972,2,'2570    ','GRASMERE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1986,1973,2,'2570    ','MOUNT HUNTER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1987,1974,2,'2570    ','NATTAI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1988,1975,2,'2570    ','OAKDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1989,1976,2,'2570    ','ORANGEVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1990,1977,2,'2570    ','THE OAKS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1991,1978,2,'2570    ','WEROMBI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1992,1979,2,'2571    ','BALMORAL VILLAGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1993,1980,2,'2571    ','BUXTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1994,1981,2,'2571    ','COURIDJAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1995,1982,2,'2571    ','PICTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1996,1983,2,'2571    ','RAZORBACK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1997,1984,2,'2571    ','WILTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1998,1985,2,'2572    ','LAKESLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (1999,1986,2,'2572    ','THIRLMERE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2000,1987,2,'2573    ','TAHMOOR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2001,1988,2,'2574    ','BARGO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2002,1989,2,'2574    ','PHEASANTS NEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2003,1990,2,'2574    ','YANDERRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2004,1991,2,'2575    ','AYLMERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2005,1992,2,'2575    ','COLO VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2006,1993,2,'2575    ','HILL TOP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2007,1994,2,'2575    ','MITTAGONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2008,1995,2,'2575    ','WELBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2009,1996,2,'2575    ','YERRINBOOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2010,1997,2,'2576    ','BOWRAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2011,1998,2,'2576    ','BURRADOO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2012,1999,2,'2576    ','KANGALOON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2013,2000,2,'2577    ','AVOCA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2014,2001,2,'2577    ','BARRENGARRY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2015,2002,2,'2577    ','BEAUMONT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2016,2003,2,'2577    ','BERRIMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2017,2004,2,'2577    ','BURRAWANG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2018,2005,2,'2577    ','FITZROY FALLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2019,2006,2,'2577    ','KANGAROO VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2020,2007,2,'2577    ','MOSS VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2021,2008,2,'2577    ','NEW BERRIMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2022,2009,2,'2577    ','ROBERTSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2023,2010,2,'2577    ','SUTTON FOREST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2024,2011,2,'2577    ','WILDES MEADOW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2025,2012,2,'2578    ','BUNDANOON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2026,2013,2,'2579    ','EXETER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2027,2014,2,'2579    ','MARULAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2028,2015,2,'2579    ','PENROSE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2029,2016,2,'2579    ','TALLONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2030,2017,2,'2579    ','WINGELLO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2031,2018,2,'2580    ','BANNISTER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2032,2019,2,'2580    ','BRADFORDVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2033,2020,2,'2580    ','BUNGONIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2034,2021,2,'2580    ','GOLSPIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2035,2022,2,'2580    ','GOULBURN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2036,2023,2,'2580    ','KENMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2037,2024,2,'2580    ','KINGSDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2038,2025,2,'2580    ','LAKE BATHURST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2039,2026,2,'2580    ','ROSLYN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2040,2027,2,'2580    ','TARAGO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2041,2028,2,'2580    ','TARALGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2042,2029,2,'2580    ','TOWRANG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2043,2030,2,'2580    ','WOMBEYAN CAVES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2044,2031,2,'2580    ','WOODHOUSELEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2045,2032,2,'2580    ','YALBRAITH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2046,2033,2,'2580    ','YARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2047,2034,2,'2581    ','BREADALBANE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2048,2035,2,'2581    ','COLLECTOR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2049,2036,2,'2581    ','DALTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2050,2037,2,'2581    ','GUNNING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2051,2038,2,'2582    ','BOOKHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2052,2039,2,'2582    ','BOWNING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2053,2040,2,'2582    ','BURRINJUCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2054,2041,2,'2582    ','MURRUMBATEMAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2055,2042,2,'2582    ','WEE JASPER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2056,2043,2,'2582    ','YASS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2057,2044,2,'2583    ','BIGGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2058,2045,2,'2583    ','BINDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2059,2046,2,'2583    ','BLANKET FLAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2060,2047,2,'2583    ','CROOKED CORNER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2061,2048,2,'2583    ','CROOKWELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2062,2049,2,'2583    ','FULLERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2063,2050,2,'2583    ','GRABBEN GULLEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2064,2051,2,'2583    ','KIALLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2065,2052,2,'2583    ','LAGGAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2066,2053,2,'2583    ','LIMERICK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2067,2054,2,'2583    ','PEELWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2068,2055,2,'2583    ','RUGBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2069,2056,2,'2583    ','TUENA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2070,2057,2,'2584    ','BINALONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2071,2058,2,'2585    ','GALONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2072,2059,2,'2586    ','BOOROWA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2073,2060,2,'2586    ','MURRINGO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2074,2061,2,'2586    ','REIDS FLAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2075,2062,2,'2586    ','RYE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2076,2063,2,'2587    ','HARDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2077,2064,2,'2587    ','KINGSVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2078,2065,2,'2587    ','MURRUMBURRAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2079,2066,2,'2587    ','WOMBAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2080,2067,2,'2588    ','WALLENDBEEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2081,2068,2,'2589    ','SOUTHERN TABLELANDS MC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2082,2069,2,'2590    ','BETHUNGRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2083,2070,2,'2590    ','COOTAMUNDRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2084,2071,2,'2590    ','ILLABO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2085,2072,2,'2594    ','BRIBBAREE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2086,2073,2,'2594    ','MILVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2087,2074,2,'2594    ','MONTEAGLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2088,2075,2,'2594    ','YOUNG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2089,2076,1,'2600    ','BARTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2090,2077,1,'2600    ','CANBERRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2091,2078,1,'2600    ','DEAKIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2092,2079,1,'2600    ','DUNTROON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2093,2080,1,'2600    ','HARMAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2094,2081,1,'2600    ','PARKES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2095,2082,1,'2600    ','PARLIAMENT HOUSE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2096,2083,1,'2600    ','RUSSELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2097,2084,1,'2600    ','YARRALUMLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2098,2085,1,'2601    ','ACTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2099,2086,1,'2601    ','BLACK MOUNTAIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2100,2087,1,'2601    ','CANBERRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2101,2088,1,'2602    ','AINSLIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2102,2089,1,'2602    ','DICKSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2103,2090,1,'2602    ','DOWNER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2104,2091,1,'2602    ','HACKETT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2105,2092,1,'2602    ','LYNEHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2106,2093,1,'2602    ','O''CONNOR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2107,2094,1,'2602    ','WATSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2108,2095,1,'2603    ','FORREST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2109,2096,1,'2603    ','GRIFFITH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2110,2097,1,'2603    ','MANUKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2111,2098,1,'2603    ','RED HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2112,2099,1,'2604    ','CAUSEWAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2113,2100,1,'2604    ','KINGSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2114,2101,1,'2604    ','NARRABUNDAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2115,2102,1,'2605    ','CURTIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2116,2103,1,'2605    ','GARRAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2117,2104,1,'2605    ','HUGHES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2118,2105,1,'2606    ','CHIFLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2119,2106,1,'2606    ','LYONS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2120,2107,1,'2606    ','O''MALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2121,2108,1,'2606    ','PHILLIP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2122,2109,1,'2606    ','SWINGER HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2123,2110,1,'2606    ','WODEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2124,2111,1,'2607    ','FARRER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2125,2112,1,'2607    ','ISAACS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2126,2113,1,'2607    ','MAWSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2127,2114,1,'2607    ','PEARCE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2128,2115,1,'2607    ','TORRENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2129,2116,1,'2608    ','CIVIC SQUARE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2130,2117,1,'2609    ','FYSHWICK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2131,2118,1,'2609    ','PIALLIGO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2132,2119,1,'2609    ','SYMONSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2133,2120,1,'2610    ','CANBERRA BC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2134,2121,2,'2611    ','BRINDABELLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2135,2122,1,'2611    ','CHAPMAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2136,2123,1,'2611    ','DUFFY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2137,2124,1,'2611    ','FISHER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2138,2125,1,'2611    ','HOLDER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2139,2126,1,'2611    ','MOUNT STROMLO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2140,2127,1,'2611    ','RIVETT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2141,2128,1,'2611    ','STIRLING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2142,2129,1,'2611    ','URIARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2143,2130,1,'2611    ','WARAMANGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2144,2131,1,'2611    ','WESTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2145,2132,1,'2611    ','WESTON CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2146,2133,1,'2612    ','BRADDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2147,2134,1,'2612    ','CAMPBELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2148,2135,1,'2612    ','REID');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2149,2136,1,'2612    ','TURNER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2150,2137,1,'2614    ','ARANDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2151,2138,1,'2614    ','COOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2152,2139,1,'2614    ','HAWKER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2153,2140,1,'2614    ','JAMISON CENTRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2154,2141,1,'2614    ','MACQUARIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2155,2142,1,'2614    ','PAGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2156,2143,1,'2614    ','SCULLIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2157,2144,1,'2614    ','WEETANGERA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2158,2145,1,'2615    ','CHARNWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2159,2146,1,'2615    ','DUNLOP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2160,2147,1,'2615    ','FLOREY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2161,2148,1,'2615    ','FLYNN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2162,2149,1,'2615    ','FRASER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2163,2150,1,'2615    ','HIGGINS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2164,2151,1,'2615    ','HOLT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2165,2152,1,'2615    ','KIPPAX');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2166,2153,1,'2615    ','KIPPAX CENTRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2167,2154,1,'2615    ','LATHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2168,2155,1,'2615    ','MACGREGOR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2169,2156,1,'2615    ','MELBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2170,2157,1,'2615    ','SPENCE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2171,2158,1,'2616    ','BELCONNEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2172,2159,1,'2617    ','BELCONNEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2173,2160,1,'2617    ','BRUCE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2174,2161,1,'2617    ','EVATT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2175,2162,1,'2617    ','GIRALANG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2176,2163,1,'2617    ','KALEEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2177,2164,1,'2617    ','LAWSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2178,2165,1,'2617    ','MCKELLAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2179,2166,1,'2617    ','UNIVERSITY OF CANBERRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2180,2167,1,'2618    ','HALL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2181,2168,2,'2619    ','JERRABOMBERRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2182,2169,2,'2620    ','BURRA CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2183,2170,2,'2620    ','GUNDAROO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2184,2171,1,'2620    ','HUME');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2185,2172,2,'2620    ','KARABAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2186,2173,2,'2620    ','MICHELAGO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2187,2174,2,'2620    ','QUEANBEYAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2188,2175,2,'2620    ','QUEANBEYAN EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2189,2176,2,'2620    ','ROYALLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2190,2177,2,'2620    ','SUTTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2191,2178,1,'2620    ','THARWA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2192,2179,2,'2620    ','WAMBOIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2193,2180,2,'2620    ','WILLIAMSDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2194,2181,2,'2621    ','BUNGENDORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2195,2182,2,'2622    ','ARALUEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2196,2183,2,'2622    ','BALLALABA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2197,2184,2,'2622    ','BORO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2198,2185,2,'2622    ','BRAIDWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2199,2186,2,'2622    ','GUNDILLION');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2200,2187,2,'2622    ','JEMBAICUMBENE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2201,2188,2,'2622    ','MAJORS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2202,2189,2,'2622    ','MAYFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2203,2190,2,'2622    ','MONGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2204,2191,2,'2622    ','MONGARLOWE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2205,2192,2,'2622    ','NERRIGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2206,2193,2,'2622    ','ORANMEIR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2207,2194,2,'2622    ','REIDSDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2208,2195,2,'2623    ','CAPTAINS FLAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2209,2196,2,'2624    ','CHARLOTTES PASS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2210,2197,2,'2624    ','PERISHER VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2211,2198,2,'2624    ','SMIGGIN HOLES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2212,2199,2,'2625    ','THREDBO VILLAGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2213,2200,2,'2626    ','BREDBO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2214,2201,2,'2627    ','JINDABYNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2215,2202,2,'2628    ','BERRIDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2216,2203,2,'2628    ','DALGETY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2217,2204,2,'2628    ','EUCUMBENE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2218,2205,2,'2628    ','NUMBLA VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2219,2206,2,'2630    ','ADAMINABY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2220,2207,2,'2630    ','BUNGARBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2221,2208,2,'2630    ','BUNYAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2222,2209,2,'2630    ','CABRAMURRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2223,2210,2,'2630    ','CHAKOLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2224,2211,2,'2630    ','COOMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2225,2212,2,'2630    ','JERANGLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2226,2213,2,'2630    ','KIANDRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2227,2214,2,'2630    ','NUMERALLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2228,2215,2,'2630    ','PEAK VIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2229,2216,2,'2630    ','ROCK FLAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2230,2217,2,'2630    ','ROSE VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2231,2218,2,'2630    ','YAOUK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2232,2219,2,'2631    ','ANDO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2233,2220,2,'2631    ','NIMMITABEL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2234,2221,2,'2632    ','BIBBENLUKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2235,2222,2,'2632    ','BOMBALA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2236,2223,2,'2632    ','CATHCART');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2237,2224,2,'2632    ','CRAIGIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2238,2225,2,'2632    ','MILA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2239,2226,2,'2633    ','DELEGATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2240,2227,2,'2640    ','ALBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2241,2228,2,'2640    ','EAST ALBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2242,2229,2,'2640    ','LAVINGTON DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2243,2230,2,'2640    ','NORTH ALBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2244,2231,2,'2640    ','SOUTH ALBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2245,2232,2,'2640    ','TABLE TOP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2246,2233,2,'2640    ','TALMALMO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2247,2234,2,'2640    ','THURGOONA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2248,2235,2,'2641    ','LAVINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2249,2236,2,'2642    ','BROCKLESBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2250,2237,2,'2642    ','BURRUMBUTTOCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2251,2238,2,'2642    ','GEROGERY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2252,2239,2,'2642    ','JINDERA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2253,2240,2,'2642    ','JINGELLIC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2254,2241,2,'2642    ','KHANCOBAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2255,2242,2,'2642    ','RAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2256,2243,2,'2642    ','TOOMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2257,2244,2,'2642    ','WALBUNDRIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2258,2245,2,'2642    ','YERONG CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2259,2246,2,'2643    ','HOWLONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2260,2247,2,'2644    ','BOWNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2261,2248,2,'2644    ','HOLBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2262,2249,2,'2644    ','MULLENGANDRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2263,2250,2,'2644    ','WOOMARGAMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2264,2251,2,'2645    ','URANA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2265,2252,2,'2646    ','BALLDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2266,2253,2,'2646    ','COROWA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2267,2254,2,'2646    ','DAYSDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2268,2255,2,'2646    ','LOWESDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2269,2256,2,'2646    ','OAKLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2270,2257,2,'2646    ','RENNIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2271,2258,2,'2646    ','SAVERNAKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2272,2259,2,'2647    ','MULWALA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2273,2260,2,'2648    ','CAL LAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2274,2261,2,'2648    ','CURLWAA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2275,2262,2,'2648    ','MOURQUONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2276,2263,2,'2648    ','PALINYEWAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2277,2264,2,'2648    ','POMONA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2278,2265,2,'2648    ','POONCARIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2279,2266,2,'2648    ','RUFUS RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2280,2267,2,'2648    ','WENTWORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2281,2268,2,'2649    ','LAUREL HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2282,2269,2,'2650    ','ASHMONT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2283,2270,2,'2650    ','CARABOST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2284,2271,2,'2650    ','COLLINGULLIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2285,2272,2,'2650    ','COOKARDINIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2286,2273,2,'2650    ','DOWNSIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2287,2274,2,'2650    ','GLENFIELD PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2288,2275,2,'2650    ','HAREFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2289,2276,2,'2650    ','KOORINGAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2290,2277,2,'2650    ','LAKE ALBERT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2291,2278,2,'2650    ','MOUNT AUSTIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2292,2279,2,'2650    ','TOLLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2293,2280,2,'2650    ','TURVEY PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2294,2281,2,'2650    ','WAGGA WAGGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2295,2282,2,'2650    ','WAGGA WAGGA SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2296,2283,2,'2651    ','FOREST HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2297,2284,2,'2651    ','WAGGA WAGGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2298,2285,2,'2652    ','BOREE CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2299,2286,2,'2652    ','GALORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2300,2287,2,'2652    ','GOOLGOWI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2301,2288,2,'2652    ','GRONG GRONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2302,2289,2,'2652    ','GUMLY GUMLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2303,2290,2,'2652    ','HUMULA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2304,2291,2,'2652    ','LADYSMITH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2305,2292,2,'2652    ','MANGOPLAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2306,2293,2,'2652    ','MARRAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2307,2294,2,'2652    ','MATONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2308,2295,2,'2652    ','MERRIWAGGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2309,2296,2,'2652    ','OLD JUNEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2310,2297,2,'2652    ','ROSEWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2311,2298,2,'2652    ','TABBITA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2312,2299,2,'2652    ','TARCUTTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2313,2300,2,'2652    ','URANQUINTY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2314,2301,2,'2653    ','MANNUS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2315,2302,2,'2653    ','TUMBARUMBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2316,2303,2,'2655    ','FRENCH PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2317,2304,2,'2655    ','THE ROCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2318,2305,2,'2656    ','LOCKHART');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2319,2306,2,'2656    ','MILBRULONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2320,2307,2,'2656    ','URANGELINE EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2321,2308,2,'2658    ','HENTY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2322,2309,2,'2658    ','PLEASANT HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2323,2310,2,'2658    ','RYAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2324,2311,2,'2659    ','WALLA WALLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2325,2312,2,'2660    ','CULCAIRN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2326,2313,2,'2660    ','MORVEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2327,2314,2,'2661    ','KAPOOKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2328,2315,2,'2663    ','JUNEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2329,2316,2,'2665    ','ARDLETHAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2330,2317,2,'2665    ','ARIAH PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2331,2318,2,'2665    ','BARELLAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2332,2319,2,'2665    ','BECKOM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2333,2320,2,'2665    ','BINYA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2334,2321,2,'2665    ','KAMARAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2335,2322,2,'2665    ','MIRROOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2336,2323,2,'2665    ','MOOMBOOLDOOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2337,2324,2,'2666    ','GROGAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2338,2325,2,'2666    ','REEFTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2339,2326,2,'2666    ','SEBASTOPOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2340,2327,2,'2666    ','SPRINGDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2341,2328,2,'2666    ','TEMORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2342,2329,2,'2666    ','TRUNGLEY HALL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2343,2330,2,'2668    ','BARMEDMAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2344,2331,2,'2669    ','BYGALORIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2345,2332,2,'2669    ','ERIGOLIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2346,2333,2,'2669    ','GIRRAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2347,2334,2,'2669    ','GUBBATA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2348,2335,2,'2669    ','NARADHAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2349,2336,2,'2669    ','RANKINS SPRINGS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2350,2337,2,'2669    ','TALLIMBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2351,2338,2,'2669    ','TULLIBIGEAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2352,2339,2,'2669    ','UNGARIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2353,2340,2,'2669    ','WEETHALLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2354,2341,2,'2671    ','BURCHER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2355,2342,2,'2671    ','WEST WYALONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2356,2343,2,'2671    ','WYALONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2357,2344,2,'2672    ','BURGOONEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2358,2345,2,'2672    ','LAKE CARGELLIGO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2359,2346,2,'2675    ','HILLSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2360,2347,2,'2675    ','ROTO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2361,2348,2,'2678    ','CHARLES STURT UNIVERSITY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2362,2349,2,'2680    ','BEELBANGERA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2363,2350,2,'2680    ','BENEREMBAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2364,2351,2,'2680    ','BILBUL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2365,2352,2,'2680    ','GRIFFITH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2366,2353,2,'2680    ','HANWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2367,2354,2,'2680    ','LAKE WYANGAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2368,2355,2,'2680    ','THARBOGANG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2369,2356,2,'2680    ','WIDGELLI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2370,2357,2,'2680    ','WILLBRIGGIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2371,2358,2,'2680    ','YOOGALI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2372,2359,2,'2681    ','YENDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2373,2360,2,'2700    ','COROBIMILLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2374,2361,2,'2700    ','GILLENBAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2375,2362,2,'2700    ','MORUNDAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2376,2363,2,'2700    ','NARRANDERA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2377,2364,2,'2701    ','COOLAMON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2378,2365,2,'2702    ','GANMAIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2379,2366,2,'2703    ','YANCO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2380,2367,2,'2705    ','CORBIE HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2381,2368,2,'2705    ','LEETON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2382,2369,2,'2705    ','MURRAMI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2383,2370,2,'2705    ','WAMOON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2384,2371,2,'2705    ','WHITTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2385,2372,2,'2706    ','DARLINGTON POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2386,2373,2,'2707    ','ARGOON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2387,2374,2,'2707    ','COLEAMBALLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2388,2375,2,'2708    ','MURRAY REGION MC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2389,2376,2,'2710    ','CALDWELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2390,2377,2,'2710    ','CONARGO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2391,2378,2,'2710    ','DENILIQUIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2392,2379,2,'2710    ','GULPA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2393,2380,2,'2710    ','MATHOURA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2394,2381,2,'2710    ','MAYRUNG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2395,2382,2,'2710    ','MOIRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2396,2383,2,'2710    ','WAKOOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2397,2384,2,'2710    ','WANGANELLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2398,2385,2,'2711    ','BOOLIGAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2399,2386,2,'2711    ','CARRATHOOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2400,2387,2,'2711    ','GUNBAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2401,2388,2,'2711    ','HAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2402,2389,2,'2711    ','MAUDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2403,2390,2,'2711    ','OXLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2404,2391,2,'2712    ','BERRIGAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2405,2392,2,'2713    ','BLIGHTY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2406,2393,2,'2713    ','FINLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2407,2394,2,'2714    ','TOCUMWAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2408,2395,2,'2715    ','BALRANALD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2409,2396,2,'2715    ','HATFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2410,2397,2,'2716    ','JERILDERIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2411,2398,2,'2716    ','MABINS WELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2412,2399,2,'2717    ','DARETON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2413,2400,2,'2720    ','GILMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2414,2401,2,'2720    ','TALBINGO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2415,2402,2,'2720    ','TUMUT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2416,2403,2,'2721    ','QUANDIALLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2417,2404,2,'2722    ','BRUNGLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2418,2405,2,'2722    ','GUNDAGAI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2419,2406,2,'2722    ','MUTTAMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2420,2407,2,'2722    ','NANGUS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2421,2408,2,'2725    ','STOCKINBINGAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2422,2409,2,'2726    ','JUGIONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2423,2410,2,'2727    ','ADJUNGBILLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2424,2411,2,'2727    ','COOLAC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2425,2412,2,'2729    ','ADELONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2426,2413,2,'2729    ','BACK CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2427,2414,2,'2729    ','COOLEYS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2428,2415,2,'2729    ','GRAHAMSTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2429,2416,2,'2729    ','MOUNT HOREB');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2430,2417,2,'2729    ','TUMBLONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2431,2418,2,'2729    ','WONDALGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2432,2419,2,'2730    ','BATLOW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2433,2420,2,'2730    ','GREEN HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2434,2421,2,'2731    ','BUNNALOO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2435,2422,2,'2731    ','MOAMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2436,2423,2,'2731    ','WOMBOOTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2437,2424,2,'2732    ','BARHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2438,2425,2,'2733    ','MOULAMEIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2439,2426,2,'2734    ','KYALITE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2440,2427,2,'2735    ','KORALEIGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2441,2428,2,'2736    ','GOODNIGHT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2442,2429,2,'2736    ','TOOLEYBUC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2443,2430,2,'2737    ','EUSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2444,2431,2,'2738    ','GOL GOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2445,2432,2,'2738    ','MONAK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2446,2433,2,'2739    ','BURONGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2447,2434,2,'2745    ','GLENMORE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2448,2435,2,'2745    ','GREENDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2449,2436,2,'2745    ','LUDDENHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2450,2437,2,'2745    ','MULGOA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2451,2438,2,'2745    ','REGENTVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2452,2439,2,'2745    ','WALLACIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2453,2440,2,'2747    ','CAMBRIDGE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2454,2441,2,'2747    ','KINGSWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2455,2442,2,'2747    ','LLANDILO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2456,2443,2,'2747    ','SHANES PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2457,2444,2,'2747    ','WERRINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2458,2445,2,'2747    ','WERRINGTON COUNTY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2459,2446,2,'2747    ','WERRINGTON DOWNS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2460,2447,2,'2748    ','ORCHARD HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2461,2448,2,'2749    ','CASTLEREAGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2462,2449,2,'2749    ','CRANEBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2463,2450,2,'2749    ','MOUNT PLEASANT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2464,2451,2,'2750    ','EMU PLAINS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2465,2452,2,'2750    ','LEONAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2466,2453,2,'2750    ','PENRITH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2467,2454,2,'2750    ','PENRITH BC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2468,2455,2,'2750    ','PENRITH SOUTH DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2469,2456,2,'2751    ','PENRITH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2470,2457,2,'2752    ','SILVERDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2471,2458,2,'2752    ','WARRAGAMBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2472,2459,2,'2753    ','BOWEN MOUNTAIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2473,2460,2,'2753    ','GROSE VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2474,2461,2,'2753    ','GROSE WOLD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2475,2462,2,'2753    ','HOBARTVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2476,2463,2,'2753    ','LONDONDERRY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2477,2464,2,'2753    ','RICHMOND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2478,2465,2,'2753    ','YARRAMUNDI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2479,2466,2,'2754    ','NORTH RICHMOND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2480,2467,2,'2754    ','TENNYSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2481,2468,2,'2755    ','RICHMOND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2482,2469,2,'2756    ','BLIGH PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2483,2470,2,'2756    ','CATTAI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2484,2471,2,'2756    ','CLARENDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2485,2472,2,'2756    ','COLO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2486,2473,2,'2756    ','CORNWALLIS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2487,2474,2,'2756    ','EBENEZER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2488,2475,2,'2756    ','FREEMANS REACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2489,2476,2,'2756    ','GLOSSODIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2490,2477,2,'2756    ','LOWER PORTLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2491,2478,2,'2756    ','MAROOTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2492,2479,2,'2756    ','MCGRATHS HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2493,2480,2,'2756    ','MULGRAVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2494,2481,2,'2756    ','PITT TOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2495,2482,2,'2756    ','SCHEYVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2496,2483,2,'2756    ','WILBERFORCE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2497,2484,2,'2756    ','WINDSOR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2498,2485,2,'2757    ','KURMOND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2499,2486,2,'2758    ','BILPIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2500,2487,2,'2758    ','BLAXLANDS RIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2501,2488,2,'2758    ','KURRAJONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2502,2489,2,'2759    ','ERSKINE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2503,2490,2,'2759    ','MOUNT VERNON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2504,2491,2,'2759    ','ST CLAIR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2505,2492,2,'2760    ','COLYTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2506,2493,2,'2760    ','OXLEY PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2507,2494,2,'2760    ','ST MARYS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2508,2495,2,'2761    ','DEAN PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2509,2496,2,'2761    ','GLENDENNING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2510,2497,2,'2761    ','HASSALL GROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2511,2498,2,'2761    ','OAKHURST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2512,2499,2,'2761    ','PLUMPTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2513,2500,2,'2762    ','SCHOFIELDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2514,2501,2,'2763    ','ACACIA GARDENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2515,2502,2,'2763    ','QUAKERS HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2516,2503,2,'2764    ','QUAKERS HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2517,2504,2,'2765    ','BERKSHIRE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2518,2505,2,'2765    ','BOX HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2519,2506,2,'2765    ','MARAYLYA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2520,2507,2,'2765    ','MARSDEN PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2521,2508,2,'2765    ','NELSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2522,2509,2,'2765    ','OAKVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2523,2510,2,'2765    ','RIVERSTONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2524,2511,2,'2765    ','VINEYARD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2525,2512,2,'2766    ','EASTERN CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2526,2513,2,'2766    ','ROOTY HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2527,2514,2,'2767    ','DOONSIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2528,2515,2,'2767    ','WOODCROFT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2529,2516,2,'2768    ','GLENWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2530,2517,2,'2768    ','PARKLEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2531,2518,2,'2768    ','STANHOPE GARDENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2532,2519,2,'2770    ','BIDWILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2533,2520,2,'2770    ','BLACKETT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2534,2521,2,'2770    ','DHARRUK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2535,2522,2,'2770    ','EMERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2536,2523,2,'2770    ','HEBERSHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2537,2524,2,'2770    ','LETHBRIDGE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2538,2525,2,'2770    ','MINCHINBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2539,2526,2,'2770    ','MOUNT DRUITT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2540,2527,2,'2770    ','SHALVEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2541,2528,2,'2770    ','TREGEAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2542,2529,2,'2770    ','WHALAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2543,2530,2,'2770    ','WILLMOT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2544,2531,2,'2773    ','GLENBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2545,2532,2,'2773    ','LAPSTONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2546,2533,2,'2774    ','BLAXLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2547,2534,2,'2774    ','MOUNT RIVERVIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2548,2535,2,'2774    ','WARRIMOO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2549,2536,2,'2775    ','CENTRAL MACDONALD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2550,2537,2,'2775    ','LAUGHTONDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2551,2538,2,'2775    ','LOWER HAWKESBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2552,2539,2,'2775    ','SPENCER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2553,2540,2,'2775    ','ST ALBANS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2554,2541,2,'2775    ','WISEMANS FERRY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2555,2542,2,'2776    ','FAULCONBRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2556,2543,2,'2777    ','HAWKESBURY HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2557,2544,2,'2777    ','SPRINGWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2558,2545,2,'2777    ','VALLEY HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2559,2546,2,'2777    ','WINMALEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2560,2547,2,'2777    ','YELLOW ROCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2561,2548,2,'2778    ','LINDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2562,2549,2,'2778    ','WOODFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2563,2550,2,'2779    ','HAZELBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2564,2551,2,'2780    ','KATOOMBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2565,2552,2,'2780    ','LEURA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2566,2553,2,'2780    ','MEDLOW BATH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2567,2554,2,'2782    ','WENTWORTH FALLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2568,2555,2,'2783    ','LAWSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2569,2556,2,'2784    ','BULLABURRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2570,2557,2,'2785    ','BLACKHEATH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2571,2558,2,'2785    ','MEGALONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2572,2559,2,'2786    ','BELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2573,2560,2,'2786    ','DARGAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2574,2561,2,'2786    ','MOUNT IRVINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2575,2562,2,'2786    ','MOUNT VICTORIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2576,2563,2,'2786    ','MOUNT WILSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2577,2564,2,'2787    ','BLACK SPRINGS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2578,2565,2,'2787    ','DUCKMALOI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2579,2566,2,'2787    ','EDITH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2580,2567,2,'2787    ','GINGKIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2581,2568,2,'2787    ','HAZELGROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2582,2569,2,'2787    ','OBERON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2583,2570,2,'2787    ','PORTERS RETREAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2584,2571,2,'2787    ','SHOOTERS HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2585,2572,2,'2787    ','TARANA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2586,2573,2,'2790    ','BOWENFELS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2587,2574,2,'2790    ','CLARENCE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2588,2575,2,'2790    ','COBAR PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2589,2576,2,'2790    ','CULLEN BULLEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2590,2577,2,'2790    ','HAMPTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2591,2578,2,'2790    ','HARTLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2592,2579,2,'2790    ','JENOLAN CAVES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2593,2580,2,'2790    ','LIDSDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2594,2581,2,'2790    ','LITHGOW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2595,2582,2,'2790    ','LITTLE HARTLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2596,2583,2,'2790    ','LOWTHER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2597,2584,2,'2790    ','MARRANGAROO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2598,2585,2,'2790    ','RYDAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2599,2586,2,'2790    ','SODWALLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2600,2587,2,'2791    ','CARCOAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2601,2588,2,'2792    ','MANDURAMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2602,2589,2,'2793    ','DARBYS FALLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2603,2590,2,'2793    ','WOODSTOCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2604,2591,2,'2794    ','BUMBALDRY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2605,2592,2,'2794    ','COWRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2606,2593,2,'2794    ','NOONBINNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2607,2594,2,'2794    ','WATTAMONDARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2608,2595,2,'2794    ','WESTVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2609,2596,2,'2795    ','BALD RIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2610,2597,2,'2795    ','BALLYROE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2611,2598,2,'2795    ','BATHURST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2612,2599,2,'2795    ','BREWONGLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2613,2600,2,'2795    ','BURRAGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2614,2601,2,'2795    ','DARK CORNER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2615,2602,2,'2795    ','DUNKELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2616,2603,2,'2795    ','DURAMANA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2617,2604,2,'2795    ','EGLINTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2618,2605,2,'2795    ','FREEMANTLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2619,2606,2,'2795    ','GEMALLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2620,2607,2,'2795    ','GEORGES PLAINS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2621,2608,2,'2795    ','HOBBYS YARDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2622,2609,2,'2795    ','ISABELLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2623,2610,2,'2795    ','JUDDS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2624,2611,2,'2795    ','KELSO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2625,2612,2,'2795    ','LOCKSLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2626,2613,2,'2795    ','MEADOW FLAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2627,2614,2,'2795    ','MOUNT DAVID');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2628,2615,2,'2795    ','NEWBRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2629,2616,2,'2795    ','PEEL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2630,2617,2,'2795    ','PERTHVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2631,2618,2,'2795    ','RAGLAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2632,2619,2,'2795    ','ROCKLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2633,2620,2,'2795    ','SOFALA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2634,2621,2,'2795    ','SUNNY CORNER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2635,2622,2,'2795    ','THE ROCKS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2636,2623,2,'2795    ','TRUNKEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2637,2624,2,'2795    ','TURONDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2638,2625,2,'2795    ','WAMBOOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2639,2626,2,'2795    ','WATTLE FLAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2640,2627,2,'2795    ','WEST BATHURST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2641,2628,2,'2795    ','WIMBLEDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2642,2629,2,'2795    ','WISEMANS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2643,2630,2,'2795    ','YETHOLME');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2644,2631,2,'2797    ','GARLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2645,2632,2,'2797    ','LYNDHURST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2646,2633,2,'2798    ','FOREST REEFS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2647,2634,2,'2798    ','MILLTHORPE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2648,2635,2,'2798    ','TALLWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2649,2636,2,'2799    ','BARRY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2650,2637,2,'2799    ','BLAYNEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2651,2638,2,'2799    ','BROWNS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2652,2639,2,'2799    ','NEVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2653,2640,2,'2799    ','VITTORIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2654,2641,2,'2800    ','BORENORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2655,2642,2,'2800    ','BOWEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2656,2643,2,'2800    ','CARGO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2657,2644,2,'2800    ','LUCKNOW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2658,2645,2,'2800    ','MARCH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2659,2646,2,'2800    ','MULLION CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2660,2647,2,'2800    ','NARRAMBLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2661,2648,2,'2800    ','NASHDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2662,2649,2,'2800    ','ORANGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2663,2650,2,'2800    ','SPRING HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2664,2651,2,'2803    ','BENDICK MURRELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2665,2652,2,'2803    ','CROWTHER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2666,2653,2,'2803    ','WIRRIMAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2667,2654,2,'2804    ','CANOWINDRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2668,2655,2,'2805    ','GOOLOOGONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2669,2656,2,'2806    ','EUGOWRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2670,2657,2,'2807    ','KOORAWATHA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2671,2658,2,'2808    ','WYANGALA DAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2672,2659,2,'2809    ','GREENETHORPE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2673,2660,2,'2810    ','BIMBI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2674,2661,2,'2810    ','CARAGABAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2675,2662,2,'2810    ','GRENFELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2676,2663,2,'2810    ','PULLABOOKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2677,2664,2,'2820    ','ARTHURVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2678,2665,2,'2820    ','BAKERS SWAMP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2679,2666,2,'2820    ','BODANGORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2680,2667,2,'2820    ','DRIPSTONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2681,2668,2,'2820    ','FARNHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2682,2669,2,'2820    ','MARYVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2683,2670,2,'2820    ','MUMBIL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2684,2671,2,'2820    ','NEUREA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2685,2672,2,'2820    ','SPICERS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2686,2673,2,'2820    ','STUART TOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2687,2674,2,'2820    ','WALMER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2688,2675,2,'2820    ','WELLINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2689,2676,2,'2821    ','NARROMINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2690,2677,2,'2823    ','TRANGIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2691,2678,2,'2824    ','WARREN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2692,2679,2,'2825    ','BOGAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2693,2680,2,'2825    ','CANONBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2694,2681,2,'2825    ','MIANDETTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2695,2682,2,'2825    ','MULLENGUDGERY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2696,2683,2,'2825    ','NYNGAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2697,2684,2,'2826    ','WESTERN PLAINS MSC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2698,2685,2,'2827    ','COLLIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2699,2686,2,'2827    ','CURBAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2700,2687,2,'2827    ','GILGANDRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2701,2688,2,'2828    ','GULARGAMBONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2702,2689,2,'2828    ','WARRUMBUNGLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2703,2690,2,'2829    ','COMBARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2704,2691,2,'2829    ','COONAMBLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2705,2692,2,'2830    ','BALLIMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2706,2693,2,'2830    ','BROCKLEHURST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2707,2694,2,'2830    ','DUBBO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2708,2695,2,'2830    ','MOGRIGUY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2709,2696,2,'2830    ','MURONBUNG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2710,2697,2,'2831    ','ARMATREE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2711,2698,2,'2831    ','BALLADORAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2712,2699,2,'2831    ','BYROCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2713,2700,2,'2831    ','CARINDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2714,2701,2,'2831    ','COOLABAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2715,2702,2,'2831    ','ELONG ELONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2716,2703,2,'2831    ','EUMUNGERIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2717,2704,2,'2831    ','GEURIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2718,2705,2,'2831    ','GIRILAMBONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2719,2706,2,'2831    ','GOODOOGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2720,2707,2,'2831    ','HERMIDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2721,2708,2,'2831    ','MERRYGOEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2722,2709,2,'2831    ','NEILREX');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2723,2710,2,'2831    ','NEVERTIRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2724,2711,2,'2831    ','NYMAGEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2725,2712,2,'2831    ','QUAMBONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2726,2713,2,'2831    ','TOORAWEENAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2727,2714,2,'2831    ','WONGARBON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2728,2715,2,'2832    ','COME BY CHANCE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2729,2716,2,'2832    ','CRYON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2730,2717,2,'2832    ','CUMBORAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2731,2718,2,'2832    ','WALGETT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2732,2719,2,'2833    ','COLLARENEBRI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2733,2720,2,'2833    ','POKATAROO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2734,2721,2,'2834    ','LIGHTNING RIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2735,2722,2,'2835    ','COBAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2736,2723,2,'2836    ','WHITE CLIFFS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2737,2724,2,'2836    ','WILCANNIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2738,2725,2,'2839    ','BREWARRINA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2739,2726,2,'2839    ','WEILMORINGLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2740,2727,2,'2840    ','BARRINGUN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2741,2728,2,'2840    ','BOURKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2742,2729,2,'2840    ','ENNGONIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2743,2730,2,'2840    ','FORDS BRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2744,2731,2,'2840    ','LOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2745,2732,2,'2840    ','TILPA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2746,2733,2,'2840    ','URISINO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2747,2734,2,'2840    ','WANAARING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2748,2735,2,'2840    ','YANTABULLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2749,2736,2,'2842    ','MENDOORAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2750,2737,2,'2842    ','NEW MOLLYAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2751,2738,2,'2843    ','COOLAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2752,2739,2,'2844    ','BIRRIWA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2753,2740,2,'2844    ','COBBORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2754,2741,2,'2844    ','CRABOON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2755,2742,2,'2844    ','DUNEDOO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2756,2743,2,'2844    ','LEADVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2757,2744,2,'2844    ','TUCKLAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2758,2745,2,'2845    ','WALLERAWANG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2759,2746,2,'2846    ','CAPERTEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2760,2747,2,'2846    ','GLEN DAVIS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2761,2748,2,'2847    ','PIPERS FLAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2762,2749,2,'2847    ','PORTLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2763,2750,2,'2848    ','CHARBON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2764,2751,2,'2848    ','CLANDULLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2765,2752,2,'2848    ','KANDOS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2766,2753,2,'2849    ','BYLONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2767,2754,2,'2849    ','RYLSTONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2768,2755,2,'2850    ','HARGRAVES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2769,2756,2,'2850    ','HAVILAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2770,2757,2,'2850    ','HILL END');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2771,2758,2,'2850    ','ILFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2772,2759,2,'2850    ','LUE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2773,2760,2,'2850    ','MUDGEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2774,2761,2,'2850    ','RUNNING STREAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2775,2762,2,'2850    ','TURILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2776,2763,2,'2850    ','TWELVE MILE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2777,2764,2,'2850    ','ULAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2778,2765,2,'2850    ','WINDEYER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2779,2766,2,'2850    ','WOLLAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2780,2767,2,'2850    ','YARRAWONGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2781,2768,2,'2852    ','GOOLMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2782,2769,2,'2852    ','GULGONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2783,2770,2,'2852    ','LAHEYS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2784,2771,2,'2852    ','TWO MILE FLAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2785,2772,2,'2864    ','CUDAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2786,2773,2,'2864    ','MURGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2787,2774,2,'2864    ','TOOGONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2788,2775,2,'2865    ','MANILDRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2789,2776,2,'2866    ','EUCHAREENA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2790,2777,2,'2866    ','GARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2791,2778,2,'2866    ','LARRAS LEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2792,2779,2,'2866    ','MOLONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2793,2780,2,'2867    ','BALDRY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2794,2781,2,'2867    ','CUMNOCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2795,2782,2,'2868    ','YEOVAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2796,2783,2,'2869    ','PEAK HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2797,2784,2,'2869    ','TOMINGLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2798,2785,2,'2869    ','TREWILGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2799,2786,2,'2870    ','ALECTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2800,2787,2,'2870    ','COOKAMIDGERA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2801,2788,2,'2870    ','DAROOBALGIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2802,2789,2,'2870    ','GOONUMBLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2803,2790,2,'2870    ','MANDAGERY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2804,2791,2,'2870    ','NELUNGALOO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2805,2792,2,'2870    ','PARKES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2806,2793,2,'2870    ','TICHBORNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2807,2794,2,'2871    ','BEDGEREBONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2808,2795,2,'2871    ','FORBES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2809,2796,2,'2871    ','GAREMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2810,2797,2,'2871    ','WIRRINYA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2811,2798,2,'2873    ','ALBERT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2812,2799,2,'2873    ','TOTTENHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2813,2800,2,'2874    ','TULLAMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2814,2801,2,'2875    ','FIFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2815,2802,2,'2875    ','OOTHA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2816,2803,2,'2875    ','TRUNDLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2817,2804,2,'2875    ','YARRABANDI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2818,2805,2,'2876    ','BOGAN GATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2819,2806,2,'2876    ','GUNNINGBLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2820,2807,2,'2877    ','CONDOBOLIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2821,2808,2,'2877    ','DERRIWONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2822,2809,2,'2877    ','EUABALONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2823,2810,2,'2877    ','MOUNT HOPE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2824,2811,2,'2878    ','CONOBLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2825,2812,2,'2878    ','DARNICK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2826,2813,2,'2878    ','IVANHOE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2827,2814,2,'2878    ','MOSSGIEL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2828,2815,2,'2878    ','TRIDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2829,2816,2,'2879    ','MENINDEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2830,2817,2,'2880    ','BROKEN HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2831,2818,2,'2880    ','MILPARINKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2832,2819,2,'2880    ','SILVERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2833,2820,2,'2880    ','TIBOOBURRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2834,2821,2,'2890    ','AUSTRALIAN DEFENCE FORCES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2835,2822,2,'2898    ','LORD HOWE ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2836,2823,2,'2899    ','NORFOLK ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2837,2824,1,'2900    ','GREENWAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2838,2825,1,'2900    ','TUGGERANONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2839,2826,1,'2901    ','TUGGERANONG DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2840,2827,1,'2902    ','KAMBAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2841,2828,1,'2903    ','ERINDALE CENTRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2842,2829,1,'2903    ','OXLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2843,2830,1,'2903    ','WANNIASSA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2844,2831,1,'2904    ','FADDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2845,2832,1,'2904    ','GOWRIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2846,2833,1,'2904    ','MACARTHUR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2847,2834,1,'2904    ','MONASH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2848,2835,1,'2905    ','BONYTHON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2849,2836,1,'2905    ','CALWELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2850,2837,1,'2905    ','CHISHOLM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2851,2838,1,'2905    ','GILMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2852,2839,1,'2905    ','ISABELLA PLAINS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2853,2840,1,'2905    ','RICHARDSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2854,2841,1,'2905    ','THEODORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2855,2842,1,'2906    ','BANKS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2856,2843,1,'2906    ','CONDER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2857,2844,1,'2906    ','GORDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2858,2845,1,'2911    ','CRACE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2859,2846,1,'2911    ','KENNY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2860,2847,1,'2911    ','MITCHELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2861,2848,1,'2911    ','MITCHELL DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2862,2849,1,'2912    ','GUNGAHLIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2863,2850,1,'2913    ','CASEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2864,2851,1,'2913    ','FRANKLIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2865,2852,1,'2913    ','GINNINDERRA VILLAGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2866,2853,1,'2913    ','KINLYSIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2867,2854,1,'2913    ','NGUNNAWAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2868,2855,1,'2913    ','NICHOLLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2869,2856,1,'2913    ','PALMERSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2870,2857,1,'2913    ','TAYLOR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2871,2858,1,'2914    ','AMAROO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2872,2859,1,'2914    ','FORDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2873,2860,1,'2914    ','HARRISON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2874,2861,1,'2914    ','MONCRIEFF');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2875,2862,1,'2914    ','MULANGGARRI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2876,2863,1,'2914    ','THROSBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2877,2864,7,'3000    ','MELBOURNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2878,2865,7,'3001    ','MELBOURNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2879,2866,7,'3002    ','EAST MELBOURNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2880,2867,7,'3002    ','PARLIAMENT HOUSE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2881,2868,7,'3003    ','WEST MELBOURNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2882,2869,7,'3004    ','QUEENS ROAD MELBOURNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2883,2870,7,'3004    ','ST KILDA ROAD MELBOURNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2884,2871,7,'3005    ','WORLD TRADE CENTRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2885,2872,7,'3006    ','SOUTHBANK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2886,2873,7,'3008    ','DOCKLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2887,2874,7,'3010    ','UNIVERSITY OF MELBOURNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2888,2875,7,'3011    ','FOOTSCRAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2889,2876,7,'3011    ','SEDDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2890,2877,7,'3011    ','SEDDON WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2891,2878,7,'3012    ','BROOKLYN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2892,2879,7,'3012    ','KINGSVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2893,2880,7,'3012    ','MAIDSTONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2894,2881,7,'3012    ','TOTTENHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2895,2882,7,'3012    ','WEST FOOTSCRAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2896,2883,7,'3013    ','YARRAVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2897,2884,7,'3013    ','YARRAVILLE WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2898,2885,7,'3015    ','NEWPORT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2899,2886,7,'3015    ','SOUTH KINGSVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2900,2887,7,'3015    ','SPOTSWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2901,2888,7,'3016    ','WILLIAMSTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2902,2889,7,'3018    ','ALTONA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2903,2890,7,'3018    ','SEAHOLME');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2904,2891,7,'3019    ','BRAYBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2905,2892,7,'3019    ','ROBINSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2906,2893,7,'3020    ','ALBION');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2907,2894,7,'3020    ','SUNSHINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2908,2895,7,'3021    ','ALBANVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2909,2896,7,'3021    ','KEALBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2910,2897,7,'3021    ','KINGS PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2911,2898,7,'3021    ','ST ALBANS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2912,2899,7,'3022    ','ARDEER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2913,2900,7,'3022    ','DEER PARK EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2914,2901,7,'3023    ','BURNSIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2915,2902,7,'3023    ','CAROLINE SPRINGS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2916,2903,7,'3023    ','DEER PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2917,2904,7,'3024    ','MOUNT COTTRELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2918,2905,7,'3024    ','WYNDHAM VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2919,2906,7,'3025    ','ALTONA NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2920,2907,7,'3026    ','LAVERTON NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2921,2908,7,'3028    ','ALTONA MEADOWS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2922,2909,7,'3028    ','LAVERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2923,2910,7,'3029    ','HOPPERS CROSSING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2924,2911,7,'3029    ','TARNEIT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2925,2912,7,'3029    ','TRUGANINA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2926,2913,7,'3030    ','DERRIMUT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2927,2914,7,'3030    ','POINT COOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2928,2915,7,'3030    ','WERRIBEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2929,2916,7,'3031    ','FLEMINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2930,2917,7,'3031    ','KENSINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2931,2918,7,'3032    ','ASCOT VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2932,2919,7,'3032    ','HIGHPOINT CITY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2933,2920,7,'3032    ','MARIBYRNONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2934,2921,7,'3032    ','TRAVANCORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2935,2922,7,'3033    ','KEILOR EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2936,2923,7,'3034    ','AVONDALE HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2937,2924,7,'3036    ','KEILOR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2938,2925,7,'3037    ','DELAHEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2939,2926,7,'3037    ','HILLSIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2940,2927,7,'3037    ','SYDENHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2941,2928,7,'3038    ','KEILOR DOWNS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2942,2929,7,'3038    ','TAYLORS LAKES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2943,2930,7,'3039    ','MOONEE PONDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2944,2931,7,'3040    ','ABERFELDIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2945,2932,7,'3040    ','ESSENDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2946,2933,7,'3040    ','ESSENDON WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2947,2934,7,'3041    ','ESSENDON NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2948,2935,7,'3041    ','STRATHMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2949,2936,7,'3041    ','STRATHMORE HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2950,2937,7,'3042    ','AIRPORT WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2951,2938,7,'3042    ','KEILOR PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2952,2939,7,'3042    ','NIDDRIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2953,2940,7,'3043    ','GLADSTONE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2954,2941,7,'3043    ','GOWANBRAE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2955,2942,7,'3043    ','TULLAMARINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2956,2943,7,'3044    ','PASCOE VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2957,2944,7,'3044    ','PASCOE VALE SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2958,2945,7,'3044    ','WESTBREEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2959,2946,7,'3045    ','MELBOURNE AIRPORT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2960,2947,7,'3046    ','GLENROY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2961,2948,7,'3046    ','HADFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2962,2949,7,'3046    ','OAK PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2963,2950,7,'3047    ','BROADMEADOWS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2964,2951,7,'3047    ','DALLAS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2965,2952,7,'3047    ','JACANA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2966,2953,7,'3048    ','COOLAROO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2967,2954,7,'3048    ','MEADOW HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2968,2955,7,'3049    ','ATTWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2969,2956,7,'3049    ','WESTMEADOWS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2970,2957,7,'3050    ','ROYAL MELBOURNE HOSPITAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2971,2958,7,'3051    ','HOTHAM HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2972,2959,7,'3051    ','NORTH MELBOURNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2973,2960,7,'3052    ','MELBOURNE UNIVERSITY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2974,2961,7,'3052    ','PARKVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2975,2962,7,'3053    ','CARLTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2976,2963,7,'3053    ','CARLTON SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2977,2964,7,'3054    ','CARLTON NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2978,2965,7,'3055    ','BRUNSWICK WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2979,2966,7,'3056    ','BRUNSWICK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2980,2967,7,'3057    ','BRUNSWICK EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2981,2968,7,'3058    ','COBURG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2982,2969,7,'3058    ','COBURG NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2983,2970,7,'3058    ','MERLYNSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2984,2971,7,'3058    ','MORELAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2985,2972,7,'3059    ','GREENVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2986,2973,7,'3060    ','FAWKNER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2987,2974,7,'3061    ','CAMPBELLFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2988,2975,7,'3062    ','SOMERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2989,2976,7,'3063    ','OAKLANDS JUNCTION');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2990,2977,7,'3063    ','YUROKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2991,2978,7,'3064    ','CRAIGIEBURN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2992,2979,7,'3064    ','DONNYBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2993,2980,7,'3064    ','KALKALLO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2994,2981,7,'3064    ','MICKLEHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2995,2982,7,'3064    ','ROXBURGH PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2996,2983,7,'3065    ','FITZROY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2997,2984,7,'3066    ','COLLINGWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2998,2985,7,'3067    ','ABBOTSFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (2999,2986,7,'3068    ','CLIFTON HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3000,2987,7,'3068    ','FITZROY NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3001,2988,7,'3070    ','NORTHCOTE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3002,2989,7,'3071    ','THORNBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3003,2990,7,'3072    ','NORTHLAND CENTRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3004,2991,7,'3072    ','PRESTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3005,2992,7,'3072    ','PRESTON SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3006,2993,7,'3072    ','REGENT WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3007,2994,7,'3073    ','KEON PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3008,2995,7,'3073    ','RESERVOIR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3009,2996,7,'3074    ','THOMASTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3010,2997,7,'3075    ','LALOR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3011,2998,7,'3076    ','EPPING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3012,2999,7,'3076    ','EPPING DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3013,3000,7,'3078    ','ALPHINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3014,3001,7,'3078    ','FAIRFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3015,3002,7,'3079    ','IVANHOE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3016,3003,7,'3079    ','IVANHOE EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3017,3004,7,'3081    ','HEIDELBERG HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3018,3005,7,'3081    ','HEIDELBERG RGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3019,3006,7,'3081    ','HEIDELBERG WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3020,3007,7,'3082    ','MILL PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3021,3008,7,'3083    ','BUNDOORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3022,3009,7,'3083    ','KINGSBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3023,3010,7,'3084    ','BANYULE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3024,3011,7,'3084    ','EAGLEMONT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3025,3012,7,'3084    ','HEIDELBERG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3026,3013,7,'3084    ','ROSANNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3027,3014,7,'3084    ','VIEWBANK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3028,3015,7,'3085    ','MACLEOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3029,3016,7,'3085    ','YALLAMBIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3030,3017,7,'3087    ','WATSONIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3031,3018,7,'3088    ','BRIAR HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3032,3019,7,'3088    ','GREENSBOROUGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3033,3020,7,'3088    ','SAINT HELENA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3034,3021,7,'3089    ','DIAMOND CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3035,3022,7,'3090    ','PLENTY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3036,3023,7,'3091    ','YARRAMBAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3037,3024,7,'3093    ','LOWER PLENTY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3038,3025,7,'3094    ','MONTMORENCY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3039,3026,7,'3095    ','ELTHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3040,3027,7,'3095    ','ELTHAM NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3041,3028,7,'3095    ','RESEARCH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3042,3029,7,'3096    ','WATTLE GLEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3043,3030,7,'3097    ','BEND OF ISLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3044,3031,7,'3097    ','KANGAROO GROUND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3045,3032,7,'3099    ','ARTHURS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3046,3033,7,'3099    ','COTTLES BRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3047,3034,7,'3099    ','HURSTBRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3048,3035,7,'3099    ','NUTFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3049,3036,7,'3099    ','STRATHEWEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3050,3037,7,'3101    ','KEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3051,3038,7,'3102    ','KEW EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3052,3039,7,'3103    ','BALWYN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3053,3040,7,'3104    ','BALWYN NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3054,3041,7,'3105    ','BULLEEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3055,3042,7,'3106    ','TEMPLESTOWE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3056,3043,7,'3107    ','TEMPLESTOWE HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3057,3044,7,'3107    ','TEMPLESTOWE LOWER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3058,3045,7,'3108    ','DONCASTER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3059,3046,7,'3109    ','DONCASTER EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3060,3047,7,'3109    ','DONCASTER HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3061,3048,7,'3109    ','TUNSTALL SQUARE PO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3062,3049,7,'3110    ','NUNAWADING BC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3063,3050,7,'3111    ','DONVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3064,3051,7,'3113    ','WARRANDYTE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3065,3052,7,'3114    ','PARK ORCHARDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3066,3053,7,'3115    ','WONGA PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3067,3054,7,'3116    ','CHIRNSIDE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3068,3055,7,'3121    ','BURNLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3069,3056,7,'3121    ','RICHMOND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3070,3057,7,'3122    ','HAWTHORN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3071,3058,7,'3123    ','HAWTHORN EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3072,3059,7,'3124    ','CAMBERWELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3073,3060,7,'3124    ','CAMBERWELL NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3074,3061,7,'3124    ','CAMBERWELL SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3075,3062,7,'3124    ','CAMBERWELL WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3076,3063,7,'3124    ','MIDDLE CAMBERWELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3077,3064,7,'3125    ','BENNETTSWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3078,3065,7,'3125    ','BURWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3079,3066,7,'3126    ','CAMBERWELL EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3080,3067,7,'3126    ','CANTERBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3081,3068,7,'3127    ','MONT ALBERT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3082,3069,7,'3127    ','SURREY HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3083,3070,7,'3128    ','BOX HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3084,3071,7,'3128    ','BOX HILL SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3085,3072,7,'3128    ','HOUSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3086,3073,7,'3128    ','WATTLE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3087,3074,7,'3129    ','BOX HILL NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3088,3075,7,'3129    ','KERRIMUIR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3089,3076,7,'3129    ','MONT ALBERT NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3090,3077,7,'3130    ','BLACKBURN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3091,3078,7,'3130    ','BLACKBURN NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3092,3079,7,'3130    ','BLACKBURN SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3093,3080,7,'3130    ','LABURNUM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3094,3081,7,'3131    ','BRENTFORD SQUARE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3095,3082,7,'3131    ','FOREST HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3096,3083,7,'3131    ','NUNAWADING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3097,3084,7,'3132    ','HEATHERDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3098,3085,7,'3132    ','MITCHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3099,3086,7,'3132    ','RANGEVIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3100,3087,7,'3133    ','VERMONT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3101,3088,7,'3133    ','VERMONT SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3102,3089,7,'3134    ','RINGWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3103,3090,7,'3134    ','RINGWOOD NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3104,3091,7,'3134    ','WARRANDYTE SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3105,3092,7,'3134    ','WARRANWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3106,3093,7,'3135    ','BEDFORD ROAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3107,3094,7,'3135    ','HEATHMONT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3108,3095,7,'3135    ','RINGWOOD EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3109,3096,7,'3136    ','CROYDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3110,3097,7,'3136    ','CROYDON HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3111,3098,7,'3136    ','CROYDON NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3112,3099,7,'3136    ','CROYDON SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3113,3100,7,'3137    ','KILSYTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3114,3101,7,'3137    ','KILSYTH SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3115,3102,7,'3138    ','MOOROOLBARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3116,3103,7,'3139    ','HODDLES CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3117,3104,7,'3139    ','LAUNCHING PLACE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3118,3105,7,'3139    ','SEVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3119,3106,7,'3139    ','WANDIN NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3120,3107,7,'3139    ','WOORI YALLOCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3121,3108,7,'3139    ','YELLINGBO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3122,3109,7,'3140    ','LILYDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3123,3110,7,'3141    ','SOUTH YARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3124,3111,7,'3142    ','HAWKSBURN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3125,3112,7,'3142    ','TOORAK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3126,3113,7,'3143    ','ARMADALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3127,3114,7,'3143    ','ARMADALE NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3128,3115,7,'3144    ','KOOYONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3129,3116,7,'3144    ','MALVERN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3130,3117,7,'3145    ','CAULFIELD EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3131,3118,7,'3145    ','CENTRAL PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3132,3119,7,'3145    ','DARLING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3133,3120,7,'3145    ','MALVERN EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3134,3121,7,'3146    ','GLEN IRIS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3135,3122,7,'3147    ','ASHBURTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3136,3123,7,'3147    ','ASHWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3137,3124,7,'3148    ','CHADSTONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3138,3125,7,'3148    ','HOLMESGLEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3139,3126,7,'3149    ','MOUNT WAVERLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3140,3127,7,'3149    ','SYNDAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3141,3128,7,'3150    ','GLEN WAVERLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3142,3129,7,'3150    ','WHEELERS HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3143,3130,7,'3151    ','BURWOOD EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3144,3131,7,'3151    ','BURWOOD HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3145,3132,7,'3152    ','KNOX CITY CENTRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3146,3133,7,'3152    ','STUDFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3147,3134,7,'3152    ','WANTIRNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3148,3135,7,'3152    ','WANTIRNA SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3149,3136,7,'3153    ','BAYSWATER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3150,3137,7,'3153    ','BAYSWATER NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3151,3138,7,'3154    ','THE BASIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3152,3139,7,'3155    ','BORONIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3153,3140,7,'3156    ','FERNTREE GULLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3154,3141,7,'3156    ','LYSTERFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3155,3142,7,'3156    ','MOUNTAIN GATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3156,3143,7,'3156    ','UPPER FERNTREE GULLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3157,3144,7,'3158    ','UPWEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3158,3145,7,'3159    ','MENZIES CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3159,3146,7,'3159    ','SELBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3160,3147,7,'3160    ','BELGRAVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3161,3148,7,'3160    ','TECOMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3162,3149,7,'3161    ','CAULFIELD JUNCTION');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3163,3150,7,'3161    ','CAULFIELD NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3164,3151,7,'3162    ','CAULFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3165,3152,7,'3162    ','CAULFIELD SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3166,3153,7,'3163    ','CARNEGIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3167,3154,7,'3163    ','GLEN HUNTLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3168,3155,7,'3163    ','MURRUMBEENA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3169,3156,7,'3164    ','DANDENONG SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3170,3157,7,'3165    ','BENTLEIGH EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3171,3158,7,'3165    ','COATESVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3172,3159,7,'3166    ','HUGHESDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3173,3160,7,'3166    ','HUNTINGDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3174,3161,7,'3166    ','OAKLEIGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3175,3162,7,'3166    ','OAKLEIGH EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3176,3163,7,'3167    ','OAKLEIGH SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3177,3164,7,'3168    ','CLAYTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3178,3165,7,'3168    ','NOTTING HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3179,3166,7,'3169    ','CLARINDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3180,3167,7,'3169    ','CLAYTON SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3181,3168,7,'3170    ','MULGRAVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3182,3169,7,'3171    ','SANDOWN VILLAGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3183,3170,7,'3171    ','SPRINGVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3184,3171,7,'3172    ','DINGLEY VILLAGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3185,3172,7,'3172    ','SPRINGVALE SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3186,3173,7,'3173    ','KEYSBOROUGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3187,3174,7,'3174    ','NOBLE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3188,3175,7,'3174    ','NOBLE PARK NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3189,3176,7,'3175    ','BANGHOLME');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3190,3177,7,'3175    ','DANDENONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3191,3178,7,'3175    ','DANDENONG SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3192,3179,7,'3176    ','SCORESBY BC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3193,3180,7,'3177    ','DOVETON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3194,3181,7,'3178    ','ROWVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3195,3182,7,'3179    ','SCORESBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3196,3183,7,'3180    ','KNOXFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3197,3184,7,'3181    ','PRAHRAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3198,3185,7,'3181    ','WINDSOR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3199,3186,7,'3182    ','ST KILDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3200,3187,7,'3182    ','ST KILDA SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3201,3188,7,'3182    ','ST KILDA WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3202,3189,7,'3183    ','BALACLAVA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3203,3190,7,'3183    ','ST KILDA EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3204,3191,7,'3184    ','BRIGHTON ROAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3205,3192,7,'3184    ','ELWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3206,3193,7,'3185    ','ELSTERNWICK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3207,3194,7,'3185    ','GARDENVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3208,3195,7,'3185    ','RIPPONLEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3209,3196,7,'3186    ','BRIGHTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3210,3197,7,'3186    ','DENDY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3211,3198,7,'3187    ','BRIGHTON EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3212,3199,7,'3187    ','NORTH ROAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3213,3200,7,'3188    ','HAMPTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3214,3201,7,'3188    ','HAMPTON EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3215,3202,7,'3188    ','HAMPTON NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3216,3203,7,'3189    ','MOORABBIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3217,3204,7,'3189    ','MOORABBIN EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3218,3205,7,'3189    ','WISHART');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3219,3206,7,'3190    ','HIGHETT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3220,3207,7,'3191    ','SANDRINGHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3221,3208,7,'3192    ','CHELTENHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3222,3209,7,'3192    ','CHELTENHAM EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3223,3210,7,'3192    ','SOUTHLAND CENTRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3224,3211,7,'3193    ','BEAUMARIS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3225,3212,7,'3193    ','BLACK ROCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3226,3213,7,'3193    ','CROMER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3227,3214,7,'3194    ','MENTONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3228,3215,7,'3194    ','MOORABBIN AIRPORT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3229,3216,7,'3195    ','ASPENDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3230,3217,7,'3195    ','ASPENDALE GARDENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3231,3218,7,'3195    ','BRAESIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3232,3219,7,'3195    ','MORDIALLOC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3233,3220,7,'3195    ','PARKDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3234,3221,7,'3196    ','BONBEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3235,3222,7,'3196    ','CHELSEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3236,3223,7,'3196    ','CHELSEA HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3237,3224,7,'3196    ','EDITHVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3238,3225,7,'3197    ','CARRUM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3239,3226,7,'3197    ','PATTERSON LAKES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3240,3227,7,'3198    ','BELVEDERE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3241,3228,7,'3198    ','SEAFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3242,3229,7,'3199    ','FRANKSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3243,3230,7,'3199    ','KARINGAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3244,3231,7,'3200    ','FRANKSTON NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3245,3232,7,'3200    ','PINES FOREST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3246,3233,7,'3201    ','CARRUM DOWNS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3247,3234,7,'3202    ','HEATHERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3248,3235,7,'3204    ','BENTLEIGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3249,3236,7,'3204    ','MCKINNON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3250,3237,7,'3204    ','ORMOND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3251,3238,7,'3205    ','SOUTH MELBOURNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3252,3239,7,'3205    ','SOUTH MELBOURNE DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3253,3240,7,'3206    ','ALBERT PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3254,3241,7,'3206    ','MIDDLE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3255,3242,7,'3207    ','GARDEN CITY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3256,3243,7,'3207    ','PORT MELBOURNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3257,3244,7,'3211    ','LITTLE RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3258,3245,7,'3212    ','LARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3259,3246,7,'3214    ','CORIO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3260,3247,7,'3214    ','NORLANE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3261,3248,7,'3214    ','NORTH SHORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3262,3249,7,'3215    ','BELL PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3263,3250,7,'3215    ','BELL POST HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3264,3251,7,'3215    ','HAMLYN HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3265,3252,7,'3215    ','NORTH GEELONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3266,3253,7,'3216    ','BELMONT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3267,3254,7,'3216    ','FRESHWATER CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3268,3255,7,'3216    ','GROVEDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3269,3256,7,'3216    ','HIGHTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3270,3257,7,'3216    ','MARSHALL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3271,3258,7,'3216    ','MOUNT DUNEED');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3272,3259,7,'3216    ','WANDANA HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3273,3260,7,'3216    ','WAURN PONDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3274,3261,7,'3217    ','DEAKIN UNIVERSITY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3275,3262,7,'3218    ','GEELONG WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3276,3263,7,'3218    ','HERNE HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3277,3264,7,'3218    ','MANIFOLD HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3278,3265,7,'3219    ','BREAKWATER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3279,3266,7,'3219    ','EAST GEELONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3280,3267,7,'3219    ','NEWCOMB');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3281,3268,7,'3219    ','ST ALBANS PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3282,3269,7,'3219    ','WHITTINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3283,3270,7,'3220    ','GEELONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3284,3271,7,'3220    ','NEWTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3285,3272,7,'3221    ','ANAKIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3286,3273,7,'3221    ','BARRABOOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3287,3274,7,'3221    ','BATESFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3288,3275,7,'3221    ','BELLARINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3289,3276,7,'3221    ','CERES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3290,3277,7,'3221    ','FYANSFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3291,3278,7,'3221    ','GNARWARRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3292,3279,7,'3221    ','KENNETT RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3293,3280,7,'3221    ','LOVELY BANKS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3294,3281,7,'3221    ','MOOLAP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3295,3282,7,'3221    ','MOORABOOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3296,3283,7,'3221    ','MURGHEBOLUC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3297,3284,7,'3221    ','STAUGHTON VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3298,3285,7,'3221    ','STONEHAVEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3299,3286,7,'3221    ','WALLINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3300,3287,7,'3221    ','WONGARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3301,3288,7,'3221    ','WYE RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3302,3289,7,'3222    ','CLIFTON SPRINGS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3303,3290,7,'3222    ','CURLEWIS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3304,3291,7,'3222    ','DRYSDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3305,3292,7,'3222    ','MANNERIM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3306,3293,7,'3222    ','MARCUS HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3307,3294,7,'3223    ','INDENTED HEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3308,3295,7,'3223    ','PORTARLINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3309,3296,7,'3223    ','ST LEONARDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3310,3297,7,'3224    ','LEOPOLD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3311,3298,7,'3225    ','POINT LONSDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3312,3299,7,'3225    ','QUEENSCLIFF');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3313,3300,7,'3226    ','OCEAN GROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3314,3301,7,'3227    ','BARWON HEADS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3315,3302,7,'3227    ','BREAMLEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3316,3303,7,'3227    ','CONNEWARRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3317,3304,7,'3228    ','BELLBRAE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3318,3305,7,'3228    ','JAN JUC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3319,3306,7,'3228    ','TORQUAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3320,3307,7,'3230    ','ANGLESEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3321,3308,7,'3231    ','AIREYS INLET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3322,3309,7,'3231    ','EASTERN VIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3323,3310,7,'3231    ','FAIRHAVEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3324,3311,7,'3231    ','MOGGS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3325,3312,7,'3232    ','LORNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3326,3313,7,'3233    ','APOLLO BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3327,3314,7,'3233    ','SKENES CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3328,3315,7,'3235    ','DEANS MARSH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3329,3316,7,'3236    ','FORREST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3330,3317,7,'3237    ','BEECH FOREST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3331,3318,7,'3237    ','GELLIBRAND LOWER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3332,3319,7,'3238    ','HORDERN VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3333,3320,7,'3238    ','JOHANNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3334,3321,7,'3238    ','LAVERS HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3335,3322,7,'3239    ','CARLISLE RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3336,3323,7,'3239    ','CHAPPLE VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3337,3324,7,'3239    ','GELLIBRAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3338,3325,7,'3239    ','KENNEDYS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3339,3326,7,'3240    ','BUCKLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3340,3327,7,'3240    ','MODEWARRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3341,3328,7,'3240    ','MORIAC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3342,3329,7,'3240    ','MOUNT MORIAC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3343,3330,7,'3241    ','BAMBRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3344,3331,7,'3241    ','WINCHELSEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3345,3332,7,'3241    ','WURDIBOLUC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3346,3333,7,'3242    ','BIRREGURRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3347,3334,7,'3243    ','BARWON DOWNS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3348,3335,7,'3243    ','GERANGAMETE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3349,3336,7,'3243    ','WARNCOORT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3350,3337,7,'3249    ','ALVIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3351,3338,7,'3249    ','BARONGAROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3352,3339,7,'3249    ','BARRAMUNGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3353,3340,7,'3249    ','CORAGULAC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3354,3341,7,'3249    ','CORUNNUN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3355,3342,7,'3249    ','DREEITE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3356,3343,7,'3249    ','IRREWARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3357,3344,7,'3249    ','KAWARREN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3358,3345,7,'3249    ','LARPENT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3359,3346,7,'3249    ','NALANGIL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3360,3347,7,'3249    ','ONDIT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3361,3348,7,'3249    ','PIRRON YALLOCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3362,3349,7,'3249    ','SWAN MARSH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3363,3350,7,'3249    ','WARRION');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3364,3351,7,'3249    ','WOOL WOOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3365,3352,7,'3249    ','YEODENE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3366,3353,7,'3250    ','COLAC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3367,3354,7,'3250    ','ELLIMINYT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3368,3355,7,'3251    ','BEEAC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3369,3356,7,'3251    ','CUNDARE NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3370,3357,7,'3251    ','WEERING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3371,3358,7,'3254    ','COROROOKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3372,3359,7,'3260    ','BUNGADOR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3373,3360,7,'3260    ','CAMPERDOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3374,3361,7,'3260    ','GNOTUK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3375,3362,7,'3260    ','POMBORNEIT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3376,3363,7,'3260    ','STONYFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3377,3364,7,'3264    ','TERANG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3378,3365,7,'3265    ','BOORCAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3379,3366,7,'3265    ','CUDGEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3380,3367,7,'3265    ','ELLERSLIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3381,3368,7,'3265    ','FRAMLINGHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3382,3369,7,'3265    ','GARVOC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3383,3370,7,'3265    ','KOLORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3384,3371,7,'3265    ','NOORAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3385,3372,7,'3265    ','PANMURE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3386,3373,7,'3265    ','THE SISTERS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3387,3374,7,'3266    ','COBDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3388,3375,7,'3266    ','GLENFYNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3389,3376,7,'3266    ','JANCOURT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3390,3377,7,'3266    ','JANCOURT EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3391,3378,7,'3266    ','SIMPSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3392,3379,7,'3267    ','SCOTTS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3393,3380,7,'3268    ','CURDIE VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3394,3381,7,'3268    ','CURDIES RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3395,3382,7,'3268    ','NIRRANDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3396,3383,7,'3268    ','NULLAWARRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3397,3384,7,'3268    ','TIMBOON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3398,3385,7,'3269    ','PORT CAMPBELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3399,3386,7,'3269    ','PRINCETOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3400,3387,7,'3270    ','PETERBOROUGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3401,3388,7,'3271    ','DARLINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3402,3389,7,'3271    ','DUNDONNELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3403,3390,7,'3271    ','PURA PURA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3404,3391,7,'3272    ','MORTLAKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3405,3392,7,'3272    ','WOORNDOO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3406,3393,7,'3273    ','HEXHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3407,3394,7,'3274    ','CARAMUT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3408,3395,7,'3275    ','MAILER FLAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3409,3396,7,'3276    ','WOOLSTHORPE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3410,3397,7,'3277    ','ALLANSFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3411,3398,7,'3277    ','MEPUNGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3412,3399,7,'3277    ','NARINGAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3413,3400,7,'3278    ','PURNIM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3414,3401,7,'3279    ','WANGOOM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3415,3402,7,'3280    ','DENNINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3416,3403,7,'3280    ','WARRNAMBOOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3417,3404,7,'3281    ','BUSHFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3418,3405,7,'3281    ','GRASSMERE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3419,3406,7,'3281    ','WINSLOW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3420,3407,7,'3281    ','WOODFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3421,3408,7,'3282    ','ILLOWA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3422,3409,7,'3282    ','KOROIT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3423,3410,7,'3282    ','MALONES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3424,3411,7,'3283    ','KILLARNEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3425,3412,7,'3283    ','KIRKSTALL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3426,3413,7,'3283    ','SOUTHERN CROSS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3427,3414,7,'3283    ','TOWER HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3428,3415,7,'3284    ','PORT FAIRY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3429,3416,7,'3285    ','NARRAWONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3430,3417,7,'3285    ','ROSEBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3431,3418,7,'3285    ','ST HELENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3432,3419,7,'3285    ','TOOLONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3433,3420,7,'3285    ','TYRENDARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3434,3421,7,'3285    ','YAMBUK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3435,3422,7,'3286    ','MACARTHUR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3436,3423,7,'3287    ','HAWKESDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3437,3424,7,'3287    ','MINHAMITE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3438,3425,7,'3289    ','PENSHURST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3439,3426,7,'3292    ','NELSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3440,3427,7,'3293    ','GLENTHOMPSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3441,3428,7,'3294    ','DUNKELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3442,3429,7,'3294    ','MOUTAJUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3443,3430,7,'3294    ','VICTORIA VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3444,3431,7,'3300    ','HAMILTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3445,3432,7,'3301    ','BROADWATER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3446,3433,7,'3301    ','BYADUK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3447,3434,7,'3301    ','STRATHKELLAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3448,3435,7,'3301    ','TARRINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3449,3436,7,'3302    ','BRANXHOLME');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3450,3437,7,'3303    ','CONDAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3451,3438,7,'3304    ','DARTMOOR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3452,3439,7,'3304    ','HEYWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3453,3440,7,'3304    ','WINNAP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3454,3441,7,'3305    ','ALLESTREE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3455,3442,7,'3305    ','BOLWARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3456,3443,7,'3305    ','GORAE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3457,3444,7,'3305    ','PORTLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3458,3445,7,'3309    ','DIGBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3459,3446,7,'3310    ','MERINO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3460,3447,7,'3311    ','CASTERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3461,3448,7,'3312    ','CARAPOOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3462,3449,7,'3312    ','CHETWYND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3463,3450,7,'3312    ','DERGHOLM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3464,3451,7,'3312    ','HENTY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3465,3452,7,'3312    ','LAKE MUNDI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3466,3453,7,'3312    ','POOLAIJELO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3467,3454,7,'3312    ','SANDFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3468,3455,7,'3312    ','STRATHDOWNIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3469,3456,7,'3312    ','WANDO VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3470,3457,7,'3314    ','CAVENDISH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3471,3458,7,'3315    ','COLERAINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3472,3459,7,'3315    ','MELVILLE FOREST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3473,3460,7,'3315    ','NAREEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3474,3461,7,'3317    ','HARROW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3475,3462,7,'3318    ','EDENHOPE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3476,3463,7,'3318    ','LANGKOOP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3477,3464,7,'3319    ','APSLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3478,3465,7,'3319    ','BENAYEO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3479,3466,7,'3321    ','INVERLEIGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3480,3467,7,'3322    ','CRESSY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3481,3468,7,'3323    ','BERRYBANK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3482,3469,7,'3323    ','DUVERNEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3483,3470,7,'3324    ','LISMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3484,3471,7,'3325    ','DERRINALLUM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3485,3472,7,'3328    ','TEESDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3486,3473,7,'3329    ','BARUNAH PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3487,3474,7,'3329    ','SHELFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3488,3475,7,'3330    ','ROKEWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3489,3476,7,'3331    ','BANNOCKBURN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3490,3477,7,'3331    ','GHERINGHAP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3491,3478,7,'3331    ','MAUDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3492,3479,7,'3331    ','RUSSELLS BRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3493,3480,7,'3331    ','SHE OAKS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3494,3481,7,'3331    ','STEIGLITZ');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3495,3482,7,'3331    ','SUTHERLANDS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3496,3483,7,'3332    ','LETHBRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3497,3484,7,'3333    ','MEREDITH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3498,3485,7,'3334    ','ELAINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3499,3486,7,'3334    ','MORRISONS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3500,3487,7,'3335    ','ROCKBANK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3501,3488,7,'3337    ','KURUNJANG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3502,3489,7,'3337    ','MELTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3503,3490,7,'3337    ','TOOLERN VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3504,3491,7,'3338    ','BROOKFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3505,3492,7,'3338    ','EXFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3506,3493,7,'3338    ','MELTON SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3507,3494,7,'3340    ','BACCHUS MARSH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3508,3495,7,'3340    ','BALLIANG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3509,3496,7,'3340    ','COIMADAI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3510,3497,7,'3340    ','GLENMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3511,3498,7,'3340    ','PARWAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3512,3499,7,'3340    ','ROWSLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3513,3500,7,'3341    ','GREENDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3514,3501,7,'3341    ','MYRNIONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3515,3502,7,'3342    ','BALLAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3516,3503,7,'3342    ','BEREMBOKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3517,3504,7,'3342    ','BLAKEVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3518,3505,7,'3342    ','MOUNT WALLACE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3519,3506,7,'3345    ','GORDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3520,3507,7,'3350    ','ALFREDTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3521,3508,7,'3350    ','BALLARAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3522,3509,7,'3350    ','BALLARAT NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3523,3510,7,'3350    ','BALLARAT WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3524,3511,7,'3350    ','BLACK HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3525,3512,7,'3350    ','BROWN HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3526,3513,7,'3350    ','CANADIAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3527,3514,7,'3350    ','EUREKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3528,3515,7,'3350    ','LAKE WENDOUREE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3529,3516,7,'3350    ','MOUNT CLEAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3530,3517,7,'3350    ','MOUNT HELEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3531,3518,7,'3350    ','MOUNT PLEASANT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3532,3519,7,'3350    ','NERRINA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3533,3520,7,'3350    ','REDAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3534,3521,7,'3350    ','SOVEREIGN HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3535,3522,7,'3351    ','BERRINGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3536,3523,7,'3351    ','CAPE CLEAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3537,3524,7,'3351    ','CARNGHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3538,3525,7,'3351    ','CHEPSTOWE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3539,3526,7,'3351    ','HADDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3540,3527,7,'3351    ','HILLCREST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3541,3528,7,'3351    ','ILLABAROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3542,3529,7,'3351    ','LAKE BOLAC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3543,3530,7,'3351    ','MININERA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3544,3531,7,'3351    ','NERRIN NERRIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3545,3532,7,'3351    ','ROKEWOOD JUNCTION');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3546,3533,7,'3351    ','ROSS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3547,3534,7,'3351    ','SCARSDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3548,3535,7,'3351    ','SMYTHES CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3549,3536,7,'3351    ','SMYTHESDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3550,3537,7,'3351    ','SNAKE VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3551,3538,7,'3351    ','STREATHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3552,3539,7,'3351    ','WESTMERE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3553,3540,7,'3352    ','ADDINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3554,3541,7,'3352    ','BLOWHARD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3555,3542,7,'3352    ','BOLWARRAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3556,3543,7,'3352    ','BULLAROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3557,3544,7,'3352    ','BUNGAREE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3558,3545,7,'3352    ','BURRUMBEET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3559,3546,7,'3352    ','CAMBRIAN HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3560,3547,7,'3352    ','CARDIGAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3561,3548,7,'3352    ','CLARENDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3562,3549,7,'3352    ','CLARKES HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3563,3550,7,'3352    ','CORINDHAP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3564,3551,7,'3352    ','DEAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3565,3552,7,'3352    ','DEREEL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3566,3553,7,'3352    ','DUNNSTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3567,3554,7,'3352    ','DURHAM LEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3568,3555,7,'3352    ','ENFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3569,3556,7,'3352    ','INVERMAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3570,3557,7,'3352    ','LAL LAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3571,3558,7,'3352    ','LEARMONTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3572,3559,7,'3352    ','LEIGH CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3573,3560,7,'3352    ','LEXTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3574,3561,7,'3352    ','MAGPIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3575,3562,7,'3352    ','MILLBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3576,3563,7,'3352    ','MINERS REST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3577,3564,7,'3352    ','MITCHELL PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3578,3565,7,'3352    ','MOLLONGGHIP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3579,3566,7,'3352    ','MOUNT EGERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3580,3567,7,'3352    ','MOUNT ROWAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3581,3568,7,'3352    ','NAPOLEONS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3582,3569,7,'3352    ','NAVIGATORS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3583,3570,7,'3352    ','POOTILLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3584,3571,7,'3352    ','SCOTSBURN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3585,3572,7,'3352    ','SPRINGBANK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3586,3573,7,'3352    ','WALLACE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3587,3574,7,'3352    ','WARRENHEIP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3588,3575,7,'3352    ','WAUBRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3589,3576,7,'3352    ','WEATHERBOARD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3590,3577,7,'3352    ','WERNETH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3591,3578,7,'3352    ','WINDERMERE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3592,3579,7,'3352    ','YENDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3593,3580,7,'3353    ','BALLARAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3594,3581,7,'3354    ','BAKERY HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3595,3582,7,'3354    ','BALLARAT MC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3596,3583,7,'3355    ','MITCHELL PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3597,3584,7,'3355    ','WENDOUREE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3598,3585,7,'3355    ','WENDOUREE VILLAGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3599,3586,7,'3356    ','DELACOMBE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3600,3587,7,'3356    ','SEBASTOPOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3601,3588,7,'3357    ','BUNINYONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3602,3589,7,'3360    ','LINTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3603,3590,7,'3361    ','CARRANBALLAC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3604,3591,7,'3361    ','SKIPTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3605,3592,7,'3363    ','CRESWICK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3606,3593,7,'3364    ','ALLENDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3607,3594,7,'3364    ','ASCOT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3608,3595,7,'3364    ','BARKSTEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3609,3596,7,'3364    ','BLAMPIED');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3610,3597,7,'3364    ','BROOMFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3611,3598,7,'3364    ','CAMPBELLTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3612,3599,7,'3364    ','COGHILLS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3613,3600,7,'3364    ','KINGSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3614,3601,7,'3364    ','NEWLYN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3615,3602,7,'3364    ','ROCKLYN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3616,3603,7,'3364    ','SMEATON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3617,3604,7,'3364    ','ULLINA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3618,3605,7,'3370    ','CLUNES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3619,3606,7,'3371    ','EVANSFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3620,3607,7,'3371    ','STONY CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3621,3608,7,'3371    ','TALBOT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3622,3609,7,'3373    ','BEAUFORT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3623,3610,7,'3373    ','TRAWALLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3624,3611,7,'3375    ','BAYINDEEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3625,3612,7,'3375    ','BUANGOR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3626,3613,7,'3377    ','ARARAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3627,3614,7,'3377    ','CROWLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3628,3615,7,'3377    ','GREAT WESTERN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3629,3616,7,'3377    ','MAROONA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3630,3617,7,'3377    ','MOYSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3631,3618,7,'3377    ','WARRAK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3632,3619,7,'3378    ','TATYOON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3633,3620,7,'3379    ','CHATSWORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3634,3621,7,'3379    ','STAVELY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3635,3622,7,'3379    ','WICKLIFFE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3636,3623,7,'3379    ','WILLAURA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3637,3624,7,'3380    ','STAWELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3638,3625,7,'3381    ','BARKLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3639,3626,7,'3381    ','CAMPBELLS BRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3640,3627,7,'3381    ','HALLS GAP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3641,3628,7,'3381    ','LUBECK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3642,3629,7,'3381    ','POMONAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3643,3630,7,'3384    ','LANDSBOROUGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3644,3631,7,'3384    ','NAVARRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3645,3632,7,'3385    ','DADSWELLS BRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3646,3633,7,'3385    ','GLENORCHY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3647,3634,7,'3387    ','MARNOO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3648,3635,7,'3388    ','BANYENA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3649,3636,7,'3388    ','RUPANYUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3650,3637,7,'3390    ','MURTOA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3651,3638,7,'3391    ','BRIM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3652,3639,7,'3392    ','MINYIP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3653,3640,7,'3392    ','SHEEP HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3654,3641,7,'3393    ','WARRACKNABEAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3655,3642,7,'3395    ','BEULAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3656,3643,7,'3396    ','HOPETOUN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3657,3644,7,'3399    ','JUNG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3658,3645,7,'3400    ','HORSHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3659,3646,7,'3401    ','DOOEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3660,3647,7,'3401    ','DOUGLAS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3661,3648,7,'3401    ','GYMBOWEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3662,3649,7,'3401    ','KARNAK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3663,3650,7,'3401    ','MITRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3664,3651,7,'3401    ','NORADJUHA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3665,3652,7,'3401    ','QUANTONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3666,3653,7,'3401    ','ROCKLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3667,3654,7,'3401    ','TELANGATUK EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3668,3655,7,'3401    ','TOOLONDO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3669,3656,7,'3401    ','WALLUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3670,3657,7,'3401    ','WOMBELANO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3671,3658,7,'3402    ','HORSHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3672,3659,7,'3407    ','BALMORAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3673,3660,7,'3407    ','GATUM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3674,3661,7,'3407    ','VASEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3675,3662,7,'3409    ','NATIMUK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3676,3663,7,'3412    ','GOROKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3677,3664,7,'3413    ','MINIMAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3678,3665,7,'3413    ','OZENKADNOOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3679,3666,7,'3413    ','PERONNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3680,3667,7,'3414    ','ANTWERP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3681,3668,7,'3414    ','DIMBOOLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3682,3669,7,'3415    ','LILLIMUR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3683,3670,7,'3415    ','MIRAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3684,3671,7,'3418    ','GERANG GERUNG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3685,3672,7,'3418    ','KIATA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3686,3673,7,'3418    ','LAWLOIT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3687,3674,7,'3418    ','NHILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3688,3675,7,'3418    ','YANAC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3689,3676,7,'3419    ','KANIVA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3690,3677,7,'3420    ','SERVICETON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3691,3678,7,'3422    ','TARRANYURK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3692,3679,7,'3423    ','JEPARIT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3693,3680,7,'3424    ','RAINBOW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3694,3681,7,'3424    ','YAAPEET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3695,3682,7,'3427    ','DIGGERS REST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3696,3683,7,'3428    ','BULLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3697,3684,7,'3429    ','SUNBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3698,3685,7,'3430    ','CLARKEFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3699,3686,7,'3431    ','RIDDELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3700,3687,7,'3431    ','RIDDELLS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3701,3688,7,'3432    ','BOLINDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3702,3689,7,'3434    ','KERRIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3703,3690,7,'3434    ','MONEGEETTA NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3704,3691,7,'3434    ','ROMSEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3705,3692,7,'3435    ','LANCEFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3706,3693,7,'3437    ','BULLENGAROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3707,3694,7,'3437    ','COUANGALT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3708,3695,7,'3437    ','GISBORNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3709,3696,7,'3438    ','NEW GISBORNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3710,3697,7,'3440    ','MACEDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3711,3698,7,'3441    ','MOUNT MACEDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3712,3699,7,'3442    ','ASHBOURNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3713,3700,7,'3442    ','CARLSRUHE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3714,3701,7,'3442    ','HESKET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3715,3702,7,'3442    ','NEWHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3716,3703,7,'3442    ','ROCHFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3717,3704,7,'3442    ','WOODEND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3718,3705,7,'3444    ','KYNETON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3719,3706,7,'3444    ','MIA MIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3720,3707,7,'3444    ','REDESDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3721,3708,7,'3444    ','TYLDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3722,3709,7,'3446    ','MALMSBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3723,3710,7,'3447    ','TARADALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3724,3711,7,'3448    ','ELPHINSTONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3725,3712,7,'3448    ','METCALFE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3726,3713,7,'3448    ','SUTTON GRANGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3727,3714,7,'3450    ','CASTLEMAINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3728,3715,7,'3451    ','BARKERS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3729,3716,7,'3451    ','CAMPBELLS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3730,3717,7,'3451    ','CHEWTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3731,3718,7,'3451    ','FRYERSTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3732,3719,7,'3451    ','GUILDFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3733,3720,7,'3451    ','MUCKLEFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3734,3721,7,'3453    ','HARCOURT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3735,3722,7,'3453    ','RAVENSWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3736,3723,7,'3458    ','BLACKWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3737,3724,7,'3458    ','FERN HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3738,3725,7,'3458    ','NEWBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3739,3726,7,'3458    ','TRENTHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3740,3727,7,'3460    ','DAYLESFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3741,3728,7,'3461    ','BULLARTO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3742,3729,7,'3461    ','DRUMMOND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3743,3730,7,'3461    ','FRANKLINFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3744,3731,7,'3461    ','GLENLYON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3745,3732,7,'3461    ','HEPBURN SPRINGS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3746,3733,7,'3461    ','KORWEINGUBOORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3747,3734,7,'3461    ','LYONVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3748,3735,7,'3461    ','MUSK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3749,3736,7,'3461    ','YANDOIT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3750,3737,7,'3462    ','MUCKLEFORD SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3751,3738,7,'3462    ','NEWSTEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3752,3739,7,'3463    ','BARINGHUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3753,3740,7,'3463    ','LAANECOORIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3754,3741,7,'3463    ','MALDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3755,3742,7,'3463    ','SHELBOURNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3756,3743,7,'3463    ','WOODSTOCK WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3757,3744,7,'3464    ','CARISBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3758,3745,7,'3465    ','MAJORCA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3759,3746,7,'3465    ','MARYBOROUGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3760,3747,7,'3465    ','NATTE YALLOCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3761,3748,7,'3465    ','RATHSCAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3762,3749,7,'3465    ','WAREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3763,3750,7,'3467    ','AVOCA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3764,3751,7,'3468    ','AMPHITHEATRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3765,3752,7,'3468    ','MOUNT LONARCH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3766,3753,7,'3469    ','ELMHURST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3767,3754,7,'3472    ','BET BET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3768,3755,7,'3472    ','BETLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3769,3756,7,'3472    ','DUNOLLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3770,3757,7,'3472    ','EDDINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3771,3758,7,'3472    ','MOLIAGUL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3772,3759,7,'3475    ','BEALIBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3773,3760,7,'3475    ','EMU');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3774,3761,7,'3475    ','LOGAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3775,3762,7,'3478    ','MOONAMBEL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3776,3763,7,'3478    ','REDBANK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3777,3764,7,'3478    ','ST ARNAUD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3778,3765,7,'3478    ','STUART MILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3779,3766,7,'3480    ','AREEGRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3780,3767,7,'3480    ','CORACK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3781,3768,7,'3480    ','DONALD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3782,3769,7,'3480    ','LITCHFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3783,3770,7,'3482    ','WATCHEM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3784,3771,7,'3483    ','BIRCHIP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3785,3772,7,'3485    ','WATCHUPGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3786,3773,7,'3485    ','WOOMELANG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3787,3774,7,'3487    ','LASCELLES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3788,3775,7,'3488    ','SPEED');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3789,3776,7,'3489    ','TEMPY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3790,3777,7,'3490    ','OUYEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3791,3778,7,'3491    ','PATCHEWOLLOCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3792,3779,7,'3494    ','CARWARP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3793,3780,7,'3494    ','COLIGNAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3794,3781,7,'3494    ','NANGILOC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3795,3782,7,'3496    ','CARDROSS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3796,3783,7,'3496    ','CULLULLERAINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3797,3784,7,'3496    ','MERINGUR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3798,3785,7,'3496    ','RED CLIFFS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3799,3786,7,'3496    ','SUNNYCLIFFS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3800,3787,7,'3496    ','WERRIMULL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3801,3788,7,'3498    ','IRYMPLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3802,3789,7,'3500    ','MILDURA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3803,3790,2,'3500    ','PARINGI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3804,3791,7,'3501    ','KOORLONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3805,3792,7,'3501    ','MILDURA CENTRE PLAZA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3806,3793,7,'3501    ','NICHOLS POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3807,3794,7,'3502    ','MILDURA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3808,3795,7,'3505    ','CABARITA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3809,3796,7,'3505    ','MERBEIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3810,3797,7,'3506    ','COWANGIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3811,3798,7,'3507    ','WALPEUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3812,3799,7,'3509    ','UNDERBOOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3813,3800,7,'3512    ','MURRAYVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3814,3801,7,'3515    ','MARONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3815,3802,7,'3516    ','BRIDGEWATER ON LODDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3816,3803,7,'3516    ','DERBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3817,3804,7,'3516    ','LEICHARDT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3818,3805,7,'3517    ','INGLEWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3819,3806,7,'3517    ','JARKLIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3820,3807,7,'3517    ','SALISBURY WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3821,3808,7,'3517    ','SERPENTINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3822,3809,7,'3518    ','BERRIMAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3823,3810,7,'3518    ','BORUNG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3824,3811,7,'3518    ','FERNIHURST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3825,3812,7,'3518    ','MYSIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3826,3813,7,'3518    ','WEDDERBURN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3827,3814,7,'3520    ','KORONG VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3828,3815,7,'3521    ','PYALONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3829,3816,7,'3522    ','TOOBORAC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3830,3817,7,'3523    ','COSTERFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3831,3818,7,'3523    ','HEATHCOTE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3832,3819,7,'3523    ','KNOWSLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3833,3820,7,'3525    ','CHARLTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3834,3821,7,'3525    ','WYCHITELLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3835,3822,7,'3527    ','WYCHEPROOF');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3836,3823,7,'3529    ','NULLAWIL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3837,3824,7,'3530    ','CULGOA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3838,3825,7,'3531    ','BERRIWILLOCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3839,3826,7,'3533    ','NANDALY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3840,3827,7,'3533    ','SEA LAKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3841,3828,7,'3537    ','BOORT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3842,3829,7,'3537    ','GREDGWIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3843,3830,7,'3540    ','CANNIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3844,3831,7,'3540    ','QUAMBATOOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3845,3832,7,'3542    ','LALBERT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3846,3833,7,'3544    ','ULTIMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3847,3834,7,'3544    ','WAITCHIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3848,3835,7,'3546    ','BOLTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3849,3836,7,'3546    ','CHINKAPOOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3850,3837,7,'3546    ','MANANGATANG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3851,3838,7,'3549    ','ROBINVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3852,3839,7,'3550    ','BENDIGO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3853,3840,7,'3550    ','KENNINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3854,3841,7,'3550    ','LONG GULLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3855,3842,7,'3550    ','NORTH BENDIGO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3856,3843,7,'3550    ','QUARRY HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3857,3844,7,'3550    ','SANDHURST EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3858,3845,7,'3550    ','SPRING GULLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3859,3846,7,'3550    ','STRATHDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3860,3847,7,'3550    ','TYSONS REEF');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3861,3848,7,'3550    ','WHITE HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3862,3849,7,'3551    ','ARNOLD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3863,3850,7,'3551    ','AXEDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3864,3851,7,'3551    ','EPPALOCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3865,3852,7,'3551    ','EPSOM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3866,3853,7,'3551    ','HUNTLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3867,3854,7,'3551    ','JUNORTOUN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3868,3855,7,'3551    ','LLANELLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3869,3856,7,'3551    ','LONGLEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3870,3857,7,'3551    ','MAIDEN GULLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3871,3858,7,'3551    ','MANDURANG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3872,3859,7,'3551    ','NEWBRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3873,3860,7,'3551    ','STRATHFIELDSAYE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3874,3861,7,'3551    ','TARNAGULLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3875,3862,7,'3551    ','TOOLLEEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3876,3863,7,'3552    ','BENDIGO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3877,3864,7,'3554    ','BENDIGO DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3878,3865,7,'3555    ','GOLDEN SQUARE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3879,3866,7,'3555    ','KANGAROO FLAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3880,3867,7,'3556    ','CALIFORNIA GULLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3881,3868,7,'3556    ','CAMPBELLS FOREST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3882,3869,7,'3556    ','COMET HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3883,3870,7,'3556    ','EAGLEHAWK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3884,3871,7,'3556    ','MYERS FLAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3885,3872,7,'3556    ','SEBASTIAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3886,3873,7,'3557    ','BARNADOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3887,3874,7,'3557    ','FOSTERVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3888,3875,7,'3557    ','GOORNONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3889,3876,7,'3558    ','ELMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3890,3877,7,'3558    ','HUNTER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3891,3878,7,'3559    ','COLBINABBIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3892,3879,7,'3559    ','COROP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3893,3880,7,'3561    ','BAMAWM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3894,3881,7,'3561    ','NANNEELLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3895,3882,7,'3561    ','ROCHESTER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3896,3883,7,'3562    ','TORRUMBARRY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3897,3884,7,'3563    ','LOCKINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3898,3885,7,'3564    ','ECHUCA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3899,3886,7,'3564    ','KANYAPELLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3900,3887,7,'3564    ','PATHO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3901,3888,7,'3564    ','SIMMIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3902,3889,7,'3565    ','KOTTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3903,3890,7,'3566    ','GUNBOWER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3904,3891,7,'3567    ','LEITCHVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3905,3892,7,'3567    ','MINCHA WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3906,3893,7,'3568    ','COHUNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3907,3894,7,'3570    ','RAYWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3908,3895,7,'3571    ','DINGEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3909,3896,7,'3571    ','TANDARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3910,3897,7,'3572    ','MILLOO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3911,3898,7,'3572    ','PIAVELLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3912,3899,7,'3572    ','PRAIRIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3913,3900,7,'3572    ','TENNYSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3914,3901,7,'3573    ','CALIVIL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3915,3902,7,'3573    ','MITIAMO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3916,3903,7,'3575    ','MINCHA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3917,3904,7,'3575    ','PYRAMID HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3918,3905,7,'3575    ','YARRAWALLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3919,3906,7,'3576    ','DURHAM OX');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3920,3907,7,'3579    ','KERANG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3921,3908,7,'3579    ','MACORNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3922,3909,7,'3579    ','MURRABIT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3923,3910,7,'3580    ','KOONDROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3924,3911,7,'3581    ','LAKE CHARM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3925,3912,7,'3583    ','TRESCO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3926,3913,7,'3584    ','LAKE BOGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3927,3914,7,'3585    ','SWAN HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3928,3915,7,'3588    ','WOORINEN SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3929,3916,7,'3589    ','WOORINEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3930,3917,7,'3590    ','BEVERFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3931,3918,7,'3591    ','VINIFERA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3932,3919,7,'3594    ','NYAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3933,3920,7,'3595    ','NYAH WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3934,3921,7,'3596    ','WOOD WOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3935,3922,7,'3597    ','PIANGIL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3936,3923,7,'3599    ','BOUNDARY BEND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3937,3924,7,'3607    ','TABILK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3938,3925,7,'3608    ','BAILIESTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3939,3926,7,'3608    ','DARGALONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3940,3927,7,'3608    ','GOULBURN WEIR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3941,3928,7,'3608    ','GRAYTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3942,3929,7,'3608    ','NAGAMBIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3943,3930,7,'3608    ','WAHRING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3944,3931,7,'3610    ','DHURRINGILE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3945,3932,7,'3610    ','MURCHISON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3946,3933,7,'3612    ','MATHIESONS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3947,3934,7,'3612    ','RUSHWORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3948,3935,7,'3612    ','WANALTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3949,3936,7,'3614    ','TOOLAMBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3950,3937,7,'3616    ','COOMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3951,3938,7,'3616    ','GILLIESTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3952,3939,7,'3616    ','HARSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3953,3940,7,'3616    ','TATURA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3954,3941,7,'3616    ','TOOLAMBA EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3955,3942,7,'3617    ','BYRNESIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3956,3943,7,'3618    ','MERRIGUM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3957,3944,7,'3619    ','KYABRAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3958,3945,7,'3620    ','KYABRAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3959,3946,7,'3620    ','LANCASTER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3960,3947,7,'3620    ','PEDERICK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3961,3948,7,'3620    ','WYUNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3962,3949,7,'3621    ','KOYUGA SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3963,3950,7,'3621    ','TONGALA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3964,3951,7,'3621    ','YAMBUNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3965,3952,7,'3622    ','KOYUGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3966,3953,7,'3622    ','STRATHALLAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3967,3954,7,'3623    ','STANHOPE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3968,3955,7,'3624    ','GIRGARRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3969,3956,7,'3629    ','ARDMONA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3970,3957,7,'3629    ','COOMBOONA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3971,3958,7,'3629    ','MOOROOPNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3972,3959,7,'3629    ','UNDERA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3973,3960,7,'3630    ','BENARCH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3974,3961,7,'3630    ','BRANDITT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3975,3962,7,'3630    ','CANIAMBO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3976,3963,7,'3630    ','COLLIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3977,3964,7,'3630    ','DUNKIRK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3978,3965,7,'3630    ','SHEPPARTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3979,3966,7,'3631    ','ARCADIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3980,3967,7,'3631    ','COSGROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3981,3968,7,'3631    ','KIALLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3982,3969,7,'3631    ','KIALLA EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3983,3970,7,'3631    ','KIALLA WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3984,3971,7,'3631    ','LEMNOS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3985,3972,7,'3631    ','PINE LODGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3986,3973,7,'3631    ','SHEPPARTON EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3987,3974,7,'3631    ','TAMLEUGH WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3988,3975,7,'3632    ','SHEPPARTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3989,3976,7,'3633    ','CONGUPNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3990,3977,7,'3634    ','BUNBARTHA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3991,3978,7,'3634    ','INVERGORDON SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3992,3979,7,'3634    ','KATANDRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3993,3980,7,'3634    ','MARUNGI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3994,3981,7,'3634    ','TALLYGAROOPNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3995,3982,7,'3635    ','WUNGHNU');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3996,3983,7,'3636    ','DUNBULBALANE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3997,3984,7,'3636    ','INVERGORDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3998,3985,7,'3636    ','NUMURKAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (3999,3986,7,'3637    ','WAAIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4000,3987,7,'3638    ','KOTUPNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4001,3988,7,'3638    ','NATHALIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4002,3989,7,'3639    ','BARMAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4003,3990,7,'3639    ','PICOLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4004,3991,7,'3640    ','KATUNGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4005,3992,7,'3641    ','STRATHMERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4006,3993,7,'3643    ','COBRAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4007,3994,2,'3644    ','BAROOGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4008,3995,7,'3644    ','COBRAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4009,3996,7,'3644    ','YARROWEYAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4010,3997,7,'3646    ','DOOKIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4011,3998,7,'3646    ','KATANDRA NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4012,3999,7,'3646    ','YABBA NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4013,4000,7,'3646    ','YOUANMITE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4014,4001,7,'3647    ','DOOKIE COLLEGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4015,4002,7,'3649    ','KATAMATITE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4016,4003,7,'3658    ','BROADFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4017,4004,7,'3658    ','CLONBINANE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4018,4005,7,'3658    ','HAZELDENE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4019,4006,7,'3658    ','KING PARROT CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4020,4007,7,'3658    ','PETERSONS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4021,4008,7,'3658    ','REEDY CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4022,4009,7,'3658    ','STRATH CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4023,4010,7,'3659    ','TALLAROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4024,4011,7,'3660    ','KERRISDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4025,4012,7,'3660    ','SEYMOUR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4026,4013,7,'3660    ','TRAWOOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4027,4014,7,'3661    ','SEYMOUR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4028,4015,7,'3662    ','PUCKAPUNYAL MILPO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4029,4016,7,'3663    ','MANGALORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4030,4017,7,'3664    ','AVENEL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4031,4018,7,'3665    ','LOCKSLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4032,4019,7,'3665    ','LONGWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4033,4020,7,'3666    ','BALMATTUM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4034,4021,7,'3666    ','CREIGHTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4035,4022,7,'3666    ','EUROA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4036,4023,7,'3666    ','GOORAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4037,4024,7,'3666    ','KITHBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4038,4025,7,'3666    ','RUFFY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4039,4026,7,'3666    ','SEVEN CREEKS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4040,4027,7,'3666    ','STRATHBOGIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4041,4028,7,'3669    ','BOHO SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4042,4029,7,'3669    ','CREEK JUNCTION');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4043,4030,7,'3669    ','GOWANGARDIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4044,4031,7,'3669    ','KOONDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4045,4032,7,'3669    ','STRATHBOGIE NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4046,4033,7,'3669    ','TAMLEUGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4047,4034,7,'3669    ','VIOLET TOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4048,4035,7,'3670    ','BADDAGINNIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4049,4036,7,'3670    ','WARRENBAYNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4050,4037,7,'3671    ','BENALLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4051,4038,7,'3672    ','BENALLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4052,4039,7,'3673    ','BENALLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4053,4040,7,'3673    ','LIMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4054,4041,7,'3673    ','MOLYULLAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4055,4042,7,'3673    ','SWANPOOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4056,4043,7,'3673    ','TATONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4057,4044,7,'3673    ','WINTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4058,4045,7,'3675    ','GLENROWAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4059,4046,7,'3675    ','GRETA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4060,4047,7,'3675    ','HANSONVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4061,4048,7,'3676    ','WANGARATTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4062,4049,7,'3677    ','APPIN PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4063,4050,7,'3677    ','MURDOCH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4064,4051,7,'3677    ','WANGARATTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4065,4052,7,'3677    ','YARRUNGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4066,4053,7,'3678    ','BOORHAMAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4067,4054,7,'3678    ','CHESHUNT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4068,4055,7,'3678    ','EVERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4069,4056,7,'3678    ','MILAWA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4070,4057,7,'3678    ','OXLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4071,4058,7,'3682    ','NORONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4072,4059,7,'3682    ','SPRINGHURST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4073,4060,7,'3683    ','CHILTERN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4074,4061,7,'3685    ','BOORHAMAN NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4075,4062,7,'3685    ','BROWNS PLAINS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4076,4063,7,'3685    ','GOORAMADDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4077,4064,7,'3685    ','PRENTICE NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4078,4065,7,'3685    ','RUTHERGLEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4079,4066,7,'3687    ','WAHGUNYAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4080,4067,7,'3688    ','BARNAWARTHA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4081,4068,7,'3688    ','WOORAGEE NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4082,4069,7,'3689    ','WODONGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4083,4070,7,'3690    ','WODONGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4084,4071,7,'3690    ','WODONGA PLAZA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4085,4072,7,'3691    ','ALLANS FLAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4086,4073,7,'3691    ','BARANDUDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4087,4074,7,'3691    ','BELLBRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4088,4075,7,'3691    ','BERRINGAMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4089,4076,7,'3691    ','BETHANGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4090,4077,7,'3691    ','BONEGILLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4091,4078,7,'3691    ','DEDERANG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4092,4079,7,'3691    ','EBDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4093,4080,7,'3691    ','GLEN CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4094,4081,7,'3691    ','GUNDOWRING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4095,4082,7,'3691    ','HUME WEIR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4096,4083,7,'3691    ','KERGUNYAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4097,4084,7,'3691    ','KIEWA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4098,4085,7,'3691    ','LENEVA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4099,4086,7,'3691    ','LONE PINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4100,4087,7,'3691    ','MOUNT ALFRED');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4101,4088,7,'3691    ','STAGHORN FLAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4102,4089,7,'3691    ','TALGARNO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4103,4090,7,'3691    ','TANGAMBALANGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4104,4091,7,'3694    ','BANDIANA MILPO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4105,4092,7,'3695    ','CHARLEROI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4106,4093,7,'3695    ','HUON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4107,4094,7,'3695    ','RED BLUFF');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4108,4095,7,'3695    ','SANDY CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4109,4096,7,'3697    ','TAWONGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4110,4097,7,'3698    ','TAWONGA SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4111,4098,7,'3699    ','BOGONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4112,4099,7,'3699    ','FALLS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4113,4100,7,'3699    ','MOUNT BEAUTY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4114,4101,7,'3700    ','MULLINS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4115,4102,7,'3700    ','TALLANDOON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4116,4103,7,'3700    ','TALLANGATTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4117,4104,7,'3701    ','DARTMOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4118,4105,7,'3701    ','ESKDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4119,4106,7,'3701    ','GRANYA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4120,4107,7,'3701    ','MITTA MITTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4121,4108,7,'3701    ','SHELLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4122,4109,7,'3704    ','KOETONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4123,4110,7,'3705    ','CUDGEWA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4124,4111,7,'3705    ','NARIEL VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4125,4112,7,'3707    ','BIGGARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4126,4113,7,'3707    ','COLAC COLAC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4127,4114,7,'3707    ','CORRYONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4128,4115,7,'3707    ','THOWGLA VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4129,4116,7,'3707    ','TOWONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4130,4117,7,'3708    ','TINTALDRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4131,4118,7,'3708    ','WALWA EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4132,4119,7,'3709    ','BURROWYE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4133,4120,7,'3709    ','GUYS FOREST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4134,4121,7,'3709    ','WALWA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4135,4122,7,'3711    ','BUXTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4136,4123,7,'3712    ','RUBICON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4137,4124,7,'3712    ','THORNTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4138,4125,7,'3713    ','EILDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4139,4126,7,'3714    ','ACHERON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4140,4127,7,'3714    ','ALEXANDRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4141,4128,7,'3714    ','CATHKIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4142,4129,7,'3714    ','KORIELLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4143,4130,7,'3714    ','TAGGERTY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4144,4131,7,'3715    ','ANCONA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4145,4132,7,'3715    ','MERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4146,4133,7,'3715    ','WOODFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4147,4134,7,'3717    ','FLOWERDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4148,4135,7,'3717    ','GLENBURN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4149,4136,7,'3717    ','HOMEWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4150,4137,7,'3717    ','MURRINDINDI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4151,4138,7,'3717    ','YEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4152,4139,7,'3718    ','MOLESWORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4153,4140,7,'3719    ','GOBUR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4154,4141,7,'3719    ','KANUMBRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4155,4142,7,'3719    ','YARCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4156,4143,7,'3720    ','BONNIE DOON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4157,4144,7,'3722    ','MANSFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4158,4145,7,'3722    ','MIRIMBAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4159,4146,7,'3723    ','A1 MINE SETTLEMENT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4160,4147,7,'3723    ','GOUGHS BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4161,4148,7,'3723    ','JAMIESON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4162,4149,7,'3723    ','MATLOCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4163,4150,7,'3723    ','MERRIJIG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4164,4151,7,'3723    ','MOUNT BULLER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4165,4152,7,'3723    ','WOODS POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4166,4153,7,'3724    ','MANSFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4167,4154,7,'3725    ','BOXWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4168,4155,7,'3725    ','GOORAMBAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4169,4156,7,'3726    ','BUNGEET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4170,4157,7,'3726    ','DEVENISH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4171,4158,7,'3726    ','THOONA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4172,4159,7,'3727    ','LAKE ROWAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4173,4160,7,'3727    ','ST JAMES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4174,4161,7,'3727    ','YUNDOOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4175,4162,7,'3728    ','TUNGAMAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4176,4163,7,'3728    ','WILBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4177,4164,7,'3730    ','BUNDALONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4178,4165,7,'3730    ','TELFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4179,4166,7,'3730    ','YARRAWONGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4180,4167,7,'3732    ','MOYHU');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4181,4168,7,'3733    ','WHITFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4182,4169,7,'3733    ','WHITLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4183,4170,7,'3735    ','BOWMANS FOREST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4184,4171,7,'3735    ','WHOROULY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4185,4172,7,'3736    ','MYRTLEFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4186,4173,7,'3737    ','BUFFALO RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4187,4174,7,'3737    ','DANDONGADALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4188,4175,7,'3737    ','GAPSTED');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4189,4176,7,'3737    ','MUDGEGONGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4190,4177,7,'3737    ','MYRTLEFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4191,4178,7,'3738    ','OVENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4192,4179,7,'3739    ','EUROBIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4193,4180,7,'3740    ','MOUNT BUFFALO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4194,4181,7,'3740    ','POREPUNKAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4195,4182,7,'3741    ','BRIGHT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4196,4183,7,'3741    ','FREEBURGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4197,4184,7,'3741    ','HARRIETVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4198,4185,7,'3741    ','HOTHAM HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4199,4186,7,'3741    ','MOUNT HOTHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4200,4187,7,'3744    ','WANDILIGONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4201,4188,7,'3746    ','ELDORADO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4202,4189,7,'3747    ','BAARMUTHA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4203,4190,7,'3747    ','BEECHWORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4204,4191,7,'3747    ','MURMUNGEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4205,4192,7,'3747    ','STANLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4206,4193,7,'3747    ','WOORAGEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4207,4194,7,'3749    ','BRUARONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4208,4195,7,'3749    ','YACKANDANDAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4209,4196,7,'3750    ','WOLLERT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4210,4197,7,'3751    ','WOODSTOCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4211,4198,7,'3752    ','SOUTH MORANG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4212,4199,7,'3753    ','BEVERIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4213,4200,7,'3754    ','DOREEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4214,4201,7,'3754    ','MERNDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4215,4202,7,'3754    ','YAN YEAN SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4216,4203,7,'3755    ','YAN YEAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4217,4204,7,'3756    ','DARRAWEIT GUIM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4218,4205,7,'3756    ','UPPER PLENTY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4219,4206,7,'3756    ','WALLAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4220,4207,7,'3757    ','EDEN PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4221,4208,7,'3757    ','GLENVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4222,4209,7,'3757    ','HUMEVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4223,4210,7,'3757    ','KINGLAKE WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4224,4211,7,'3757    ','PHEASANT CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4225,4212,7,'3757    ','WHITTLESEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4226,4213,7,'3758    ','HEATHCOTE JUNCTION');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4227,4214,7,'3758    ','WANDONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4228,4215,7,'3759    ','PANTON HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4229,4216,7,'3760    ','SMITHS GULLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4230,4217,7,'3761    ','ST ANDREWS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4231,4218,7,'3762    ','BYLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4232,4219,7,'3763    ','KINGLAKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4233,4220,7,'3764    ','KILMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4234,4221,7,'3765    ','MONTROSE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4235,4222,7,'3766    ','KALORAMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4236,4223,7,'3767    ','MOUNT DANDENONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4237,4224,7,'3770    ','COLDSTREAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4238,4225,7,'3770    ','GRUYERE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4239,4226,7,'3775    ','CHRISTMAS HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4240,4227,7,'3775    ','DIXONS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4241,4228,7,'3775    ','STEELS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4242,4229,7,'3775    ','YARRA GLEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4243,4230,7,'3777    ','HEALESVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4244,4231,7,'3777    ','TOOLANGI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4245,4232,7,'3778    ','NARBETHONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4246,4233,7,'3779    ','MARYSVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4247,4234,7,'3781    ','COCKATOO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4248,4235,7,'3782    ','AVONSLEIGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4249,4236,7,'3782    ','CLEMATIS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4250,4237,7,'3782    ','EMERALD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4251,4238,7,'3782    ','MACCLESFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4252,4239,7,'3783    ','GEMBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4253,4240,7,'3786    ','FERNY CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4254,4241,7,'3787    ','SASSAFRAS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4255,4242,7,'3787    ','SASSAFRAS GULLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4256,4243,7,'3788    ','OLINDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4257,4244,7,'3789    ','SHERBROOKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4258,4245,7,'3791    ','KALLISTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4259,4246,7,'3792    ','THE PATCH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4260,4247,7,'3793    ','MONBULK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4261,4248,7,'3795    ','SILVAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4262,4249,7,'3796    ','MOUNT EVELYN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4263,4250,7,'3797    ','GILDEROY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4264,4251,7,'3797    ','GLADYSDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4265,4252,7,'3797    ','POWELLTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4266,4253,7,'3797    ','THREE BRIDGES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4267,4254,7,'3797    ','YARRA JUNCTION');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4268,4255,7,'3799    ','MCMAHONS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4269,4256,7,'3799    ','MILLGROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4270,4257,7,'3799    ','WARBURTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4271,4258,7,'3799    ','WESBURN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4272,4259,7,'3802    ','ENDEAVOUR HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4273,4260,7,'3803    ','HALLAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4274,4261,7,'3804    ','NARRE WARREN EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4275,4262,7,'3804    ','NARRE WARREN NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4276,4263,7,'3805    ','FOUNTAIN GATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4277,4264,7,'3805    ','NARRE WARREN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4278,4265,7,'3806    ','BERWICK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4279,4266,7,'3806    ','HARKAWAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4280,4267,7,'3807    ','BEACONSFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4281,4268,7,'3807    ','GUYS HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4282,4269,7,'3808    ','BEACONSFIELD UPPER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4283,4270,7,'3809    ','OFFICER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4284,4271,7,'3810    ','PAKENHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4285,4272,7,'3810    ','PAKENHAM UPPER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4286,4273,7,'3812    ','MARYKNOLL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4287,4274,7,'3812    ','NAR NAR GOON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4288,4275,7,'3813    ','TYNONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4289,4276,7,'3814    ','CORA LYNN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4290,4277,7,'3814    ','GARFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4291,4278,7,'3814    ','VERVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4292,4279,7,'3815    ','BUNYIP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4293,4280,7,'3815    ','IONA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4294,4281,7,'3815    ','TONIMBUK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4295,4282,7,'3816    ','LABERTOUCHE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4296,4283,7,'3816    ','LONGWARRY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4297,4284,7,'3816    ','MODELLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4298,4285,7,'3818    ','ATHLONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4299,4286,7,'3818    ','DROUIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4300,4287,7,'3818    ','RIPPLEBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4301,4288,7,'3820    ','WARRAGUL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4302,4289,7,'3821    ','BULN BULN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4303,4290,7,'3821    ','NEERIM JUNCTION');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4304,4291,7,'3821    ','NEERIM NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4305,4292,7,'3821    ','NILMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4306,4293,7,'3821    ','ROKEBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4307,4294,7,'3822    ','DARNUM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4308,4295,7,'3823    ','YARRAGON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4309,4296,7,'3824    ','CHILDERS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4310,4297,7,'3824    ','THORPDALE SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4311,4298,7,'3824    ','TRAFALGAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4312,4299,7,'3824    ','YULUNGAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4313,4300,7,'3825    ','ABERFELDY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4314,4301,7,'3825    ','COALVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4315,4302,7,'3825    ','ERICA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4316,4303,7,'3825    ','HERNES OAK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4317,4304,7,'3825    ','HILL END');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4318,4305,7,'3825    ','MOE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4319,4306,7,'3825    ','MOONDARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4320,4307,7,'3825    ','NEWBOROUGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4321,4308,7,'3825    ','PARKERS CORNER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4322,4309,7,'3825    ','RAWSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4323,4310,7,'3825    ','TANJIL SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4324,4311,7,'3825    ','WALHALLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4325,4312,7,'3825    ','WILLOW GROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4326,4313,7,'3825    ','YALLOURN NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4327,4314,7,'3831    ','NEERIM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4328,4315,7,'3831    ','NEERIM SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4329,4316,7,'3833    ','NOOJEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4330,4317,7,'3835    ','THORPDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4331,4318,7,'3840    ','JEERALANG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4332,4319,7,'3840    ','MID VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4333,4320,7,'3840    ','MORWELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4334,4321,7,'3841    ','MORWELL MC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4335,4322,7,'3842    ','CHURCHILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4336,4323,7,'3844    ','CALLIGNEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4337,4324,7,'3844    ','CARRAJUNG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4338,4325,7,'3844    ','FLYNN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4339,4326,7,'3844    ','KOORNALLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4340,4327,7,'3844    ','TRARALGON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4341,4328,7,'3844    ','TYERS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4342,4329,7,'3844    ','WILLUNG SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4343,4330,7,'3847    ','NAMBROK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4344,4331,7,'3847    ','ROSEDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4345,4332,7,'3847    ','WILLUNG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4346,4333,7,'3850    ','GUTHRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4347,4334,7,'3850    ','SALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4348,4335,7,'3850    ','WURRUK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4349,4336,7,'3851    ','BUNDALAGUAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4350,4337,7,'3851    ','DARRIMAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4351,4338,7,'3851    ','KILMANY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4352,4339,7,'3851    ','LOCH SPORT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4353,4340,7,'3851    ','LONGFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4354,4341,7,'3851    ','MYRTLEBANK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4355,4342,7,'3851    ','PARADISE BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4356,4343,7,'3851    ','SEASPRAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4357,4344,7,'3852    ','EAST SALE RAAF');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4358,4345,7,'3853    ','SALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4359,4346,7,'3854    ','GLENGARRY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4360,4347,7,'3856    ','TOONGABBIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4361,4348,7,'3857    ','COWWARR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4362,4349,7,'3858    ','GLENMAGGIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4363,4350,7,'3858    ','HEYFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4364,4351,7,'3858    ','LICOLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4365,4352,7,'3858    ','SEATON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4366,4353,7,'3859    ','NEWRY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4367,4354,7,'3859    ','TINAMBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4368,4355,7,'3860    ','BOISDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4369,4356,7,'3860    ','BRIAGOLONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4370,4357,7,'3860    ','MAFFRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4371,4358,7,'3860    ','VALENCIA CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4372,4359,7,'3862    ','DARGO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4373,4360,7,'3862    ','MEERLIEU');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4374,4361,7,'3862    ','STRATFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4375,4362,7,'3864    ','FERNBANK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4376,4363,7,'3865    ','LINDENOW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4377,4364,7,'3869    ','JUMBUK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4378,4365,7,'3869    ','YINNAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4379,4366,7,'3870    ','BOOLARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4380,4367,7,'3870    ','MORWELL RIVER PRISON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4381,4368,7,'3871    ','DARLIMURLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4382,4369,7,'3871    ','MIRBOO NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4383,4370,7,'3873    ','GORMANDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4384,4371,7,'3874    ','CARRAJUNG SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4385,4372,7,'3874    ','WOODSIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4386,4373,7,'3875    ','BAIRNSDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4387,4374,7,'3875    ','BENGWORDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4388,4375,7,'3875    ','CALULU');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4389,4376,7,'3875    ','HILLSIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4390,4377,7,'3875    ','LINDENOW SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4391,4378,7,'3875    ','LUCKNOW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4392,4379,7,'3875    ','MOUNT TAYLOR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4393,4380,7,'3875    ','NEWLANDS ARM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4394,4381,7,'3875    ','SARSFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4395,4382,7,'3875    ','WALPA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4396,4383,7,'3875    ','WY YUNG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4397,4384,7,'3878    ','EAGLE POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4398,4385,7,'3880    ','PAYNESVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4399,4386,7,'3880    ','RAYMOND ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4400,4387,7,'3882    ','NICHOLSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4401,4388,7,'3885    ','BRUTHEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4402,4389,7,'3885    ','BUCHAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4403,4390,7,'3885    ','BUTCHERS RIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4404,4391,7,'3885    ','GELANTIPY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4405,4392,7,'3885    ','MOSSIFACE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4406,4393,7,'3885    ','TAMBO UPPER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4407,4394,7,'3885    ','W TREE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4408,4395,7,'3885    ','WISELEIGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4409,4396,7,'3885    ','WULGULMERANG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4410,4397,7,'3886    ','NEWMERELLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4411,4398,7,'3887    ','LAKE TYERS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4412,4399,7,'3887    ','NOWA NOWA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4413,4400,7,'3887    ','WAIREWA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4414,4401,7,'3888    ','BENDOC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4415,4402,7,'3888    ','BONANG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4416,4403,7,'3888    ','MARLO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4417,4404,7,'3888    ','ORBOST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4418,4405,7,'3888    ','TUBBUT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4419,4406,7,'3889    ','BEMM RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4420,4407,7,'3889    ','CABBAGE TREE CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4421,4408,7,'3889    ','CLUB TERRACE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4422,4409,7,'3889    ','COMBIENBAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4423,4410,7,'3889    ','SYDENHAM INLET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4424,4411,7,'3890    ','CANN RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4425,4412,7,'3890    ','NOORINBEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4426,4413,7,'3891    ','GENOA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4427,4414,7,'3891    ','GIPSY POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4428,4415,7,'3892    ','MALLACOOTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4429,4416,7,'3893    ','TAMBO CROSSING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4430,4417,7,'3895    ','ENSAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4431,4418,7,'3896    ','SWIFTS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4432,4419,7,'3898    ','DINNER PLAIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4433,4420,7,'3898    ','OMEO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4434,4421,7,'3900    ','BENAMBRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4435,4422,7,'3902    ','JOHNSONVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4436,4423,7,'3903    ','SWAN REACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4437,4424,7,'3904    ','METUNG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4438,4425,7,'3909    ','KALIMNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4439,4426,7,'3909    ','LAKE TYERS BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4440,4427,7,'3909    ','LAKES ENTRANCE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4441,4428,7,'3910    ','LANGWARRIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4442,4429,7,'3911    ','BAXTER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4443,4430,7,'3912    ','PEARCEDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4444,4431,7,'3912    ','SOMERVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4445,4432,7,'3913    ','TYABB');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4446,4433,7,'3915    ','HASTINGS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4447,4434,7,'3915    ','TUERONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4448,4435,7,'3916    ','MERRICKS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4449,4436,7,'3916    ','SHOREHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4450,4437,7,'3918    ','BITTERN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4451,4438,7,'3919    ','CRIB POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4452,4439,7,'3920    ','HMAS CERBERUS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4453,4440,7,'3921    ','TANKERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4454,4441,7,'3922    ','COWES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4455,4442,7,'3923    ','RHYLL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4456,4443,7,'3925    ','CAPE WOOLAMAI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4457,4444,7,'3925    ','NEWHAVEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4458,4445,7,'3925    ','SAN REMO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4459,4446,7,'3926    ','BALNARRING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4460,4447,7,'3926    ','MERRICKS BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4461,4448,7,'3926    ','MERRICKS NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4462,4449,7,'3927    ','SOMERS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4463,4450,7,'3928    ','MAIN RIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4464,4451,7,'3929    ','FLINDERS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4465,4452,7,'3930    ','KUNYUNG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4466,4453,7,'3930    ','MOUNT ELIZA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4467,4454,7,'3931    ','MORNINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4468,4455,7,'3933    ','MOOROODUC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4469,4456,7,'3934    ','MOUNT MARTHA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4470,4457,7,'3936    ','ARTHURS SEAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4471,4458,7,'3936    ','DROMANA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4472,4459,7,'3936    ','SAFETY BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4473,4460,7,'3937    ','RED HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4474,4461,7,'3937    ','RED HILL SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4475,4462,7,'3938    ','MCCRAE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4476,4463,7,'3939    ','ROSEBUD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4477,4464,7,'3940    ','ROSEBUD WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4478,4465,7,'3941    ','RYE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4479,4466,7,'3941    ','ST ANDREWS BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4480,4467,7,'3941    ','TOOTGAROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4481,4468,7,'3942    ','BLAIRGOWRIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4482,4469,7,'3943    ','SORRENTO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4483,4470,7,'3944    ','PORTSEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4484,4471,7,'3945    ','JEETHO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4485,4472,7,'3945    ','KROWERA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4486,4473,7,'3945    ','LOCH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4487,4474,7,'3945    ','WOODLEIGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4488,4475,7,'3946    ','BENA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4489,4476,7,'3950    ','KORUMBURRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4490,4477,7,'3951    ','JUMBUNNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4491,4478,7,'3951    ','KARDELLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4492,4479,7,'3951    ','KONGWAK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4493,4480,7,'3951    ','OUTTRIM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4494,4481,7,'3953    ','BERRYS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4495,4482,7,'3953    ','HALLSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4496,4483,7,'3953    ','LEONGATHA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4497,4484,7,'3953    ','NERRENA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4498,4485,7,'3954    ','KOONWARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4499,4486,7,'3956    ','DUMBALK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4500,4487,7,'3956    ','MEENIYAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4501,4488,7,'3956    ','TARWIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4502,4489,7,'3956    ','TARWIN LOWER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4503,4490,7,'3956    ','VENUS BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4504,4491,7,'3956    ','WALKERVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4505,4492,7,'3956    ','WALKERVILLE SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4506,4493,7,'3957    ','STONY CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4507,4494,7,'3958    ','BUFFALO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4508,4495,7,'3959    ','FISH CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4509,4496,7,'3959    ','SANDY POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4510,4497,7,'3959    ','WARATAH BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4511,4498,7,'3960    ','BENNISON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4512,4499,7,'3960    ','FOSTER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4513,4500,7,'3960    ','MOUNT BEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4514,4501,7,'3960    ','TIDAL RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4515,4502,7,'3960    ','YANAKIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4516,4503,7,'3962    ','AGNES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4517,4504,7,'3962    ','BARRY BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4518,4505,7,'3962    ','TOORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4519,4506,7,'3964    ','PORT FRANKLIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4520,4507,7,'3965    ','PORT WELSHPOOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4521,4508,7,'3966    ','BINGINWARRI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4522,4509,7,'3966    ','WELSHPOOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4523,4510,7,'3967    ','HEDLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4524,4511,7,'3971    ','ALBERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4525,4512,7,'3971    ','BALOOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4526,4513,7,'3971    ','DEVON NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4527,4514,7,'3971    ','GELLIONDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4528,4515,7,'3971    ','MACKS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4529,4516,7,'3971    ','PORT ALBERT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4530,4517,7,'3971    ','TARRAVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4531,4518,7,'3971    ','WON WRON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4532,4519,7,'3971    ','YARRAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4533,4520,7,'3975    ','LYNBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4534,4521,7,'3975    ','LYNDHURST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4535,4522,7,'3976    ','HAMPTON PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4536,4523,7,'3977    ','CANNONS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4537,4524,7,'3977    ','CRANBOURNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4538,4525,7,'3977    ','CRANBOURNE NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4539,4526,7,'3977    ','CRANBOURNE SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4540,4527,7,'3977    ','DEVON MEADOWS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4541,4528,7,'3977    ','FIVE WAYS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4542,4529,7,'3977    ','SKYE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4543,4530,7,'3977    ','TOORADIN NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4544,4531,7,'3978    ','CARDINIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4545,4532,7,'3978    ','CLYDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4546,4533,7,'3979    ','ALMURTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4547,4534,7,'3979    ','GLEN ALVIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4548,4535,7,'3979    ','KERNOT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4549,4536,7,'3980    ','BLIND BIGHT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4550,4537,7,'3980    ','TOORADIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4551,4538,7,'3980    ','WARNEET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4552,4539,7,'3981    ','BAYLES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4553,4540,7,'3981    ','CATANI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4554,4541,7,'3981    ','DALMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4555,4542,7,'3981    ','KOO WEE RUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4556,4543,7,'3981    ','YANNATHAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4557,4544,7,'3984    ','CALDERMEADE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4558,4545,7,'3984    ','CORINELLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4559,4546,7,'3984    ','CORONET BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4560,4547,7,'3984    ','GRANTVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4561,4548,7,'3984    ','JAM JERRUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4562,4549,7,'3984    ','LANG LANG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4563,4550,7,'3984    ','MONOMEITH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4564,4551,7,'3984    ','TENBY POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4565,4552,7,'3984    ','THE GURDIES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4566,4553,7,'3987    ','NYORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4567,4554,7,'3988    ','POOWONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4568,4555,7,'3990    ','GLEN FORBES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4569,4556,7,'3991    ','BASS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4570,4557,7,'3992    ','DALYSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4571,4558,7,'3995    ','ARCHIES CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4572,4559,7,'3995    ','CAPE PATERSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4573,4560,7,'3995    ','KILCUNDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4574,4561,7,'3995    ','SOUTH DUDLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4575,4562,7,'3995    ','WONTHAGGI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4576,4563,7,'3995    ','WOOLAMAI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4577,4564,7,'3996    ','INVERLOCH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4578,4565,6,'4000    ','BRISBANE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4579,4566,6,'4000    ','BRISBANE ADELAIDE STREET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4580,4567,6,'4000    ','BRISBANE-CITY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4581,4568,6,'4000    ','PARLIAMENT HOUSE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4582,4569,6,'4000    ','PETRIE TERRACE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4583,4570,6,'4000    ','SPRING HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4584,4571,6,'4001    ','BRISBANE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4585,4572,6,'4001    ','CENTRAL PLAZA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4586,4573,6,'4001    ','RIVERSIDE CENTRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4587,4574,6,'4001    ','WATERFRONT PLACE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4588,4575,6,'4002    ','BRISBANE ALBERT STREET BC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4589,4576,6,'4002    ','WINTERGARDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4590,4577,6,'4003    ','GEORGE STREET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4591,4578,6,'4004    ','SPRING HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4592,4579,6,'4005    ','NEW FARM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4593,4580,6,'4005    ','TENERIFFE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4594,4581,6,'4006    ','BOWEN HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4595,4582,6,'4006    ','BRISBANE EXHIBITION');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4596,4583,6,'4006    ','FORTITUDE VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4597,4584,6,'4006    ','HERSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4598,4585,6,'4006    ','NEWSTEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4599,4586,6,'4007    ','ASCOT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4600,4587,6,'4007    ','BRISBANE AIRPORT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4601,4588,6,'4007    ','DOOMBEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4602,4589,6,'4007    ','HAMILTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4603,4590,6,'4007    ','WHINSTANES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4604,4591,6,'4008    ','MEEANDAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4605,4592,6,'4008    ','PINKENBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4606,4593,6,'4009    ','EAGLE FARM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4607,4594,6,'4010    ','ALBION');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4608,4595,6,'4010    ','BREAKFAST CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4609,4596,6,'4011    ','CLAYFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4610,4597,6,'4011    ','EAGLE JUNCTION');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4611,4598,6,'4011    ','HENDRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4612,4599,6,'4012    ','NUNDAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4613,4600,6,'4012    ','TOOMBUL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4614,4601,6,'4012    ','WAVELL HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4615,4602,6,'4012    ','WAVELL HEIGHTS NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4616,4603,6,'4013    ','NORTHGATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4617,4604,6,'4014    ','BANYO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4618,4605,6,'4014    ','NUDGEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4619,4606,6,'4014    ','NUDGEE BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4620,4607,6,'4014    ','VIRGINIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4621,4608,6,'4017    ','BRACKEN RIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4622,4609,6,'4017    ','BRIGHTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4623,4610,6,'4017    ','DEAGON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4624,4611,6,'4017    ','NASHVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4625,4612,6,'4017    ','SANDGATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4626,4613,6,'4017    ','SHORNCLIFFE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4627,4614,6,'4018    ','FITZGIBBON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4628,4615,6,'4018    ','TAIGUM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4629,4616,6,'4019    ','CLONTARF');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4630,4617,6,'4019    ','MARGATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4631,4618,6,'4019    ','MARGATE BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4632,4619,6,'4019    ','WOODY POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4633,4620,6,'4020    ','REDCLIFFE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4634,4621,6,'4020    ','SCARBOROUGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4635,4622,6,'4021    ','KIPPA-RING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4636,4623,6,'4022    ','ROTHWELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4637,4624,6,'4025    ','CAPE MORETON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4638,4625,6,'4025    ','COWAN COWAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4639,4626,6,'4025    ','KOORINGAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4640,4627,6,'4025    ','TANGALOOMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4641,4628,6,'4029    ','ROYAL BRISBANE HOSPITAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4642,4629,6,'4030    ','KALINGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4643,4630,6,'4030    ','LUTWYCHE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4644,4631,6,'4030    ','WINDSOR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4645,4632,6,'4030    ','WOOLOOWIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4646,4633,6,'4031    ','GORDON PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4647,4634,6,'4031    ','KEDRON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4648,4635,6,'4032    ','CHERMSIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4649,4636,6,'4032    ','CHERMSIDE WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4650,4637,6,'4032    ','CRAIGSLEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4651,4638,6,'4034    ','ASPLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4652,4639,6,'4034    ','BOONDALL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4653,4640,6,'4034    ','CARSELDINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4654,4641,6,'4034    ','GEEBUNG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4655,4642,6,'4034    ','ZILLMERE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4656,4643,6,'4035    ','ALBANY CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4657,4644,6,'4035    ','BRIDGEMAN DOWNS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4658,4645,6,'4036    ','BALD HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4659,4646,6,'4037    ','EATONS HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4660,4647,6,'4051    ','ALDERLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4661,4648,6,'4051    ','ENOGGERA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4662,4649,6,'4051    ','GAYTHORNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4663,4650,6,'4051    ','GRANGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4664,4651,6,'4051    ','NEWMARKET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4665,4652,6,'4051    ','WILSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4666,4653,6,'4053    ','BROOKSIDE CENTRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4667,4654,6,'4053    ','EVERTON HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4668,4655,6,'4053    ','EVERTON PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4669,4656,6,'4053    ','MCDOWALL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4670,4657,6,'4053    ','MITCHELTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4671,4658,6,'4053    ','OXFORD PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4672,4659,6,'4053    ','STAFFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4673,4660,6,'4053    ','STAFFORD HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4674,4661,6,'4054    ','ARANA HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4675,4662,6,'4054    ','GROVELY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4676,4663,6,'4054    ','KEPERRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4677,4664,6,'4055    ','BUNYA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4678,4665,6,'4055    ','FERNY GROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4679,4666,6,'4055    ','FERNY HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4680,4667,6,'4055    ','UPPER KEDRON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4681,4668,6,'4059    ','ITHACA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4682,4669,6,'4059    ','KELVIN GROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4683,4670,6,'4059    ','KELVIN GROVE BC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4684,4671,6,'4059    ','KELVIN GROVE DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4685,4672,6,'4059    ','NORMANBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4686,4673,6,'4059    ','RED HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4687,4674,6,'4060    ','ASHGROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4688,4675,6,'4060    ','DORRINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4689,4676,6,'4060    ','ST JOHNS WOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4690,4677,6,'4061    ','THE GAP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4691,4678,6,'4064    ','MILTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4692,4679,6,'4064    ','PADDINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4693,4680,6,'4064    ','ROSALIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4694,4681,6,'4065    ','BARDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4695,4682,6,'4065    ','RAINWORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4696,4683,6,'4066    ','AUCHENFLOWER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4697,4684,6,'4066    ','MOUNT COOT-THA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4698,4685,6,'4066    ','TOOWONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4699,4686,6,'4066    ','TORWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4700,4687,6,'4067    ','IRONSIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4701,4688,6,'4067    ','ST LUCIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4702,4689,6,'4068    ','CHELMER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4703,4690,6,'4068    ','INDOOROOPILLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4704,4691,6,'4068    ','LONG POCKET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4705,4692,6,'4068    ','TARINGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4706,4693,6,'4069    ','BROOKFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4707,4694,6,'4069    ','CHAPEL HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4708,4695,6,'4069    ','FIG TREE POCKET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4709,4696,6,'4069    ','KENMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4710,4697,6,'4069    ','KENMORE HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4711,4698,6,'4069    ','PINJARRA HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4712,4699,6,'4069    ','PULLENVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4713,4700,6,'4069    ','UPPER BROOKFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4714,4701,6,'4070    ','ANSTEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4715,4702,6,'4070    ','BELLBOWRIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4716,4703,6,'4070    ','MOGGILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4717,4704,6,'4072    ','UNIVERSITY OF QUEENSLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4718,4705,6,'4073    ','SEVENTEEN MILE ROCKS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4719,4706,6,'4073    ','SINNAMON PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4720,4707,6,'4074    ','JAMBOREE HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4721,4708,6,'4074    ','JINDALEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4722,4709,6,'4074    ','MIDDLE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4723,4710,6,'4074    ','MOUNT OMMANEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4724,4711,6,'4074    ','RIVERHILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4725,4712,6,'4074    ','SUMNER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4726,4713,6,'4074    ','SUMNER PARK BC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4727,4714,6,'4074    ','WESTLAKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4728,4715,6,'4075    ','CORINDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4729,4716,6,'4075    ','GRACEVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4730,4717,6,'4075    ','GRACEVILLE EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4731,4718,6,'4075    ','OXLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4732,4719,6,'4075    ','SHERWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4733,4720,6,'4076    ','DARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4734,4721,6,'4076    ','WACOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4735,4722,6,'4077    ','DOOLANDELLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4736,4723,6,'4077    ','DURACK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4737,4724,6,'4077    ','INALA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4738,4725,6,'4077    ','RICHLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4739,4726,6,'4078    ','ELLEN GROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4740,4727,6,'4078    ','FOREST LAKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4741,4728,6,'4101    ','HIGHGATE HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4742,4729,6,'4101    ','HILL END');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4743,4730,6,'4101    ','MATER HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4744,4731,6,'4101    ','MATER HOSPITAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4745,4732,6,'4101    ','SOUTH BANK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4746,4733,6,'4101    ','SOUTH BRISBANE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4747,4734,6,'4101    ','WEST END');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4748,4735,6,'4102    ','BURANDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4749,4736,6,'4102    ','DUTTON PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4750,4737,6,'4102    ','PRINCESS ALEXANDRA HOSPITAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4751,4738,6,'4102    ','WOOLLOONGABBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4752,4739,6,'4103    ','ANNERLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4753,4740,6,'4103    ','FAIRFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4754,4741,6,'4104    ','YERONGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4755,4742,6,'4105    ','MOOROOKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4756,4743,6,'4105    ','TENNYSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4757,4744,6,'4105    ','YEERONGPILLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4758,4745,6,'4106    ','BRISBANE MARKET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4759,4746,6,'4106    ','ROCKLEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4760,4747,6,'4107    ','SALISBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4761,4748,6,'4108    ','ARCHERFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4762,4749,6,'4108    ','COOPERS PLAINS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4763,4750,6,'4109    ','MACGREGOR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4764,4751,6,'4109    ','ROBERTSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4765,4752,6,'4109    ','SUNNYBANK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4766,4753,6,'4109    ','SUNNYBANK HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4767,4754,6,'4110    ','ACACIA RIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4768,4755,6,'4110    ','ACACIA RIDGE DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4769,4756,6,'4110    ','HEATHWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4770,4757,6,'4110    ','LARAPINTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4771,4758,6,'4110    ','PALLARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4772,4759,6,'4110    ','WILLAWONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4773,4760,6,'4111    ','GRIFFITH UNIVERSITY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4774,4761,6,'4111    ','NATHAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4775,4762,6,'4112    ','KURABY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4776,4763,6,'4113    ','EIGHT MILE PLAINS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4777,4764,6,'4113    ','FRUITGROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4778,4765,6,'4113    ','RUNCORN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4779,4766,6,'4114    ','KINGSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4780,4767,6,'4114    ','LOGAN CENTRAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4781,4768,6,'4114    ','LOGAN CITY DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4782,4769,6,'4114    ','WOODRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4783,4770,6,'4115    ','ALGESTER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4784,4771,6,'4115    ','PARKINSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4785,4772,6,'4116    ','CALAMVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4786,4773,6,'4116    ','DREWVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4787,4774,6,'4116    ','STRETTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4788,4775,6,'4117    ','BERRINBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4789,4776,6,'4117    ','KARAWATHA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4790,4777,6,'4118    ','BROWNS PLAINS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4791,4778,6,'4118    ','FORESTDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4792,4779,6,'4118    ','HERITAGE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4793,4780,6,'4118    ','HILLCREST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4794,4781,6,'4118    ','REGENTS PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4795,4782,6,'4119    ','UNDERWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4796,4783,6,'4120    ','GREENSLOPES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4797,4784,6,'4120    ','STONES CORNER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4798,4785,6,'4121    ','EKIBIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4799,4786,6,'4121    ','HOLLAND PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4800,4787,6,'4121    ','HOLLAND PARK WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4801,4788,6,'4121    ','TARRAGINDI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4802,4789,6,'4121    ','WELLERS HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4803,4790,6,'4122    ','MANSFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4804,4791,6,'4122    ','MOUNT GRAVATT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4805,4792,6,'4122    ','MOUNT GRAVATT EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4806,4793,6,'4122    ','UPPER MOUNT GRAVATT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4807,4794,6,'4122    ','WISHART');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4808,4795,6,'4123    ','ROCHEDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4809,4796,6,'4123    ','ROCHEDALE SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4810,4797,6,'4124    ','BORONIA HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4811,4798,6,'4124    ','GREENBANK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4812,4799,6,'4125    ','MUNRUBEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4813,4800,6,'4125    ','PARK RIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4814,4801,6,'4127    ','CHATSWOOD HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4815,4802,6,'4127    ','DAISY HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4816,4803,6,'4127    ','PRIESTDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4817,4804,6,'4127    ','SLACKS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4818,4805,6,'4127    ','SPRINGWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4819,4806,6,'4128    ','KIMBERLEY PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4820,4807,6,'4128    ','SHAILER PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4821,4808,6,'4128    ','TANAH MERAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4822,4809,6,'4129    ','LOGANDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4823,4810,6,'4129    ','LOGANHOLME');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4824,4811,6,'4130    ','CARBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4825,4812,6,'4130    ','CORNUBIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4826,4813,6,'4131    ','LOGANLEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4827,4814,6,'4131    ','MEADOWBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4828,4815,6,'4132    ','CRESTMEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4829,4816,6,'4132    ','MARSDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4830,4817,6,'4133    ','CHAMBERS FLAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4831,4818,6,'4133    ','LOGAN RESERVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4832,4819,6,'4133    ','WATERFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4833,4820,6,'4133    ','WATERFORD WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4834,4821,6,'4151    ','COORPAROO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4835,4822,6,'4152    ','CAMP HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4836,4823,6,'4152    ','CARINA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4837,4824,6,'4152    ','CARINA HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4838,4825,6,'4152    ','CARINDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4839,4826,6,'4153    ','BELMONT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4840,4827,6,'4154    ','GUMDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4841,4828,6,'4154    ','RANSOME');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4842,4829,6,'4154    ','WAKERLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4843,4830,6,'4155    ','CHANDLER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4844,4831,6,'4156    ','BURBANK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4845,4832,6,'4156    ','MACKENZIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4846,4833,6,'4157    ','CAPALABA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4847,4834,6,'4157    ','CAPALABA WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4848,4835,6,'4157    ','SHELDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4849,4836,6,'4158    ','THORNESIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4850,4837,6,'4159    ','AQUATIC PARADISE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4851,4838,6,'4159    ','BIRKDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4852,4839,6,'4160    ','ORMISTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4853,4840,6,'4160    ','WELLINGTON POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4854,4841,6,'4161    ','ALEXANDRA HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4855,4842,6,'4161    ','BURWOOD HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4856,4843,6,'4163    ','CLEVELAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4857,4844,6,'4163    ','RABY BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4858,4845,6,'4164    ','PINKLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4859,4846,6,'4164    ','THORNLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4860,4847,6,'4165    ','MOUNT COTTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4861,4848,6,'4165    ','POINT HALLORAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4862,4849,6,'4165    ','POINT TALBURPIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4863,4850,6,'4165    ','REDLAND BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4864,4851,6,'4165    ','VICTORIA POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4865,4852,6,'4169    ','EAST BRISBANE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4866,4853,6,'4169    ','KANGAROO POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4867,4854,6,'4170    ','CANNON HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4868,4855,6,'4170    ','COLMSLIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4869,4856,6,'4170    ','MORNINGSIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4870,4857,6,'4170    ','NORMAN PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4871,4858,6,'4170    ','SEVEN HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4872,4859,6,'4171    ','BALMORAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4873,4860,6,'4171    ','BULIMBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4874,4861,6,'4171    ','GALLOWAYS HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4875,4862,6,'4171    ','HAWTHORNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4876,4863,6,'4172    ','MURARRIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4877,4864,6,'4173    ','TINGALPA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4878,4865,6,'4173    ','TINGALPA BC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4879,4866,6,'4173    ','TINGALPA DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4880,4867,6,'4174    ','HEMMANT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4881,4868,6,'4178    ','LINDUM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4882,4869,6,'4178    ','LYTTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4883,4870,6,'4178    ','WYNNUM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4884,4871,6,'4178    ','WYNNUM WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4885,4872,6,'4179    ','LOTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4886,4873,6,'4179    ','MANLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4887,4874,6,'4179    ','MANLY WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4888,4875,6,'4183    ','AMITY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4889,4876,6,'4183    ','AMITY POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4890,4877,6,'4183    ','DUNWICH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4891,4878,6,'4183    ','POINT LOOKOUT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4892,4879,6,'4184    ','COOCHIEMUDLO ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4893,4880,6,'4184    ','KARRAGARRA ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4894,4881,6,'4184    ','LAMB ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4895,4882,6,'4184    ','MACLEAY ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4896,4883,6,'4184    ','PEEL ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4897,4884,6,'4184    ','RUSSELL ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4898,4885,6,'4205    ','BETHANIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4899,4886,6,'4207    ','ALBERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4900,4887,6,'4207    ','BAHRS SCRUB');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4901,4888,6,'4207    ','BANNOCKBURN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4902,4889,6,'4207    ','BEENLEIGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4903,4890,6,'4207    ','BELIVAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4904,4891,6,'4207    ','BUCCAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4905,4892,6,'4207    ','CEDAR CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4906,4893,6,'4207    ','EAGLEBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4907,4894,6,'4207    ','EDENS LANDING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4908,4895,6,'4207    ','HOLMVIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4909,4896,6,'4207    ','LOGAN VILLAGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4910,4897,6,'4207    ','LUSCOMBE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4911,4898,6,'4207    ','MOUNT WARREN PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4912,4899,6,'4207    ','STAPYLTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4913,4900,6,'4207    ','STEIGLITZ');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4914,4901,6,'4207    ','WINDAROO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4915,4902,6,'4207    ','WOLFFDENE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4916,4903,6,'4207    ','WOONGOOLBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4917,4904,6,'4207    ','YATALA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4918,4905,6,'4208    ','GILBERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4919,4906,6,'4208    ','JACOBS WELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4920,4907,6,'4208    ','KINGSHOLME');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4921,4908,6,'4208    ','NORWELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4922,4909,6,'4208    ','ORMEAU');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4923,4910,6,'4209    ','CANOWINDRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4924,4911,6,'4209    ','COOMERA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4925,4912,6,'4209    ','PIMPAMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4926,4913,6,'4209    ','UPPER COOMERA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4927,4914,6,'4209    ','WILLOW VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4928,4915,6,'4210    ','GUANABA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4929,4916,6,'4210    ','MAUDSLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4930,4917,6,'4210    ','OXENFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4931,4918,6,'4210    ','STUDIO VILLAGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4932,4919,6,'4210    ','WONGAWALLAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4933,4920,6,'4211    ','ADVANCETOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4934,4921,6,'4211    ','BEECHMONT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4935,4922,6,'4211    ','CARRARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4936,4923,6,'4211    ','CLAGIRABA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4937,4924,6,'4211    ','GAVEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4938,4925,6,'4211    ','GILSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4939,4926,6,'4211    ','LATIMER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4940,4927,6,'4211    ','MOUNT NATHAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4941,4928,6,'4211    ','NATURAL BRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4942,4929,6,'4211    ','NERANG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4943,4930,6,'4211    ','NUMINBAH VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4944,4931,6,'4211    ','PACIFIC PINES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4945,4932,6,'4212    ','BOYKAMBIL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4946,4933,6,'4212    ','HELENSVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4947,4934,6,'4212    ','HOPE ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4948,4935,6,'4212    ','SANCTUARY COVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4949,4936,6,'4212    ','SANTA BARBARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4950,4937,6,'4213    ','AUSTINVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4951,4938,6,'4213    ','BONOGIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4952,4939,6,'4213    ','MUDGEERABA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4953,4940,6,'4213    ','NERANWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4954,4941,6,'4213    ','SPRINGBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4955,4942,6,'4213    ','TALLAI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4956,4943,6,'4213    ','WORONGARY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4957,4944,6,'4214    ','ARUNDEL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4958,4945,6,'4214    ','ARUNDEL BC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4959,4946,6,'4214    ','ARUNDEL DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4960,4947,6,'4214    ','ASHMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4961,4948,6,'4214    ','ERNEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4962,4949,6,'4214    ','MOLENDINAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4963,4950,6,'4214    ','PARKWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4964,4951,6,'4215    ','CHIRN PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4965,4952,6,'4215    ','LABRADOR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4966,4953,6,'4215    ','SOUTHPORT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4967,4954,6,'4216    ','ANGLERS PARADISE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4968,4955,6,'4216    ','BIGGERA WATERS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4969,4956,6,'4216    ','COOMBABAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4970,4957,6,'4216    ','HOLLYWELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4971,4958,6,'4216    ','PARADISE POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4972,4959,6,'4216    ','PARADISE POINT KEYS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4973,4960,6,'4216    ','RUNAWAY BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4974,4961,6,'4216    ','SOVEREIGN ISLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4975,4962,6,'4217    ','BENOWA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4976,4963,6,'4217    ','BUNDALL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4977,4964,6,'4217    ','CHEVRON ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4978,4965,6,'4217    ','ISLE OF CAPRI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4979,4966,6,'4217    ','MAIN BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4980,4967,6,'4217    ','PARADISE ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4981,4968,6,'4217    ','PARADISE WATERS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4982,4969,6,'4217    ','SORRENTO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4983,4970,6,'4217    ','SURFERS PARADISE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4984,4971,6,'4217    ','THE SPIT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4985,4972,6,'4218    ','BROADBEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4986,4973,6,'4218    ','BROADBEACH WATERS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4987,4974,6,'4218    ','CYPRESS GARDENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4988,4975,6,'4218    ','FLORIDA GARDENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4989,4976,6,'4218    ','MERMAID BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4990,4977,6,'4218    ','MERMAID WATERS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4991,4978,6,'4218    ','MIAMI KEYS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4992,4979,6,'4218    ','NOBBY BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4993,4980,6,'4218    ','PACIFIC FAIR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4994,4981,6,'4218    ','Q SUPERCENTRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4995,4982,6,'4218    ','RIO VISTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4996,4983,6,'4219    ','WEST BURLEIGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4997,4984,6,'4220    ','ANDREWS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4998,4985,6,'4220    ','BURLEIGH HEADS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (4999,4986,6,'4220    ','BURLEIGH TOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5000,4987,6,'4220    ','BURLEIGH WATERS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5001,4988,6,'4220    ','MIAMI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5002,4989,6,'4221    ','ELANORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5003,4990,6,'4221    ','PALM BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5004,4991,6,'4223    ','CURRUMBIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5005,4992,6,'4223    ','CURRUMBIN DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5006,4993,6,'4223    ','CURRUMBIN VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5007,4994,6,'4223    ','CURRUMBIN WATERS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5008,4995,6,'4224    ','TUGUN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5009,4996,6,'4225    ','BILINGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5010,4997,6,'4225    ','COOLANGATTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5011,4998,6,'4225    ','GREENMOUNT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5012,4999,6,'4225    ','KIRRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5013,5000,6,'4225    ','RAINBOW BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5014,5001,6,'4226    ','CLEAR ISLAND WATERS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5015,5002,6,'4226    ','KERRYDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5016,5003,6,'4226    ','MERRIMAC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5017,5004,6,'4226    ','ROBINA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5018,5005,6,'4227    ','STEPHENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5019,5006,6,'4228    ','REEDY CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5020,5007,6,'4228    ','TALLEBUDGERA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5021,5008,6,'4228    ','TALLEBUDGERA VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5022,5009,6,'4229    ','BOND UNIVERSITY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5023,5010,6,'4230    ','ROBINA TOWN CENTRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5024,5011,6,'4270    ','TAMBORINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5025,5012,6,'4270    ','TAMBORINE VILLAGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5026,5013,6,'4271    ','EAGLE HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5027,5014,6,'4272    ','MOUNT TAMBORINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5028,5015,6,'4272    ','NORTH TAMBORINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5029,5016,6,'4275    ','CANUNGRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5030,5017,6,'4275    ','LAMINGTON NATIONAL PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5031,5018,6,'4275    ','WITHEREN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5032,5019,6,'4275    ','WONGLEPONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5033,5020,6,'4280    ','JIMBOOMBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5034,5021,6,'4280    ','MACLEAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5035,5022,6,'4285    ','BEAUDESERT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5036,5023,6,'4285    ','CEDAR VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5037,5024,6,'4285    ','KOORALBYN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5038,5025,6,'4287    ','PALEN CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5039,5026,6,'4287    ','RATHDOWNEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5040,5027,6,'4300    ','BELLBIRD PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5041,5028,6,'4300    ','CAMIRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5042,5029,6,'4300    ','CAROLE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5043,5030,6,'4300    ','GAILES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5044,5031,6,'4300    ','GOODNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5045,5032,6,'4300    ','OPOSSUM CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5046,5033,6,'4300    ','SPRINGFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5047,5034,6,'4300    ','SPRINGFIELD LAKES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5048,5035,6,'4301    ','COLLINGWOOD PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5049,5036,6,'4301    ','REDBANK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5050,5037,6,'4301    ','REDBANK PLAINS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5051,5038,6,'4303    ','DINMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5052,5039,6,'4303    ','NEW CHUM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5053,5040,6,'4303    ','RIVERVIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5054,5041,6,'4304    ','BLACKSTONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5055,5042,6,'4304    ','BOOVAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5056,5043,6,'4304    ','BUNDAMBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5057,5044,6,'4304    ','EBBW VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5058,5045,6,'4304    ','NORTH BOOVAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5059,5046,6,'4304    ','SILKSTONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5060,5047,6,'4305    ','BASIN POCKET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5061,5048,6,'4305    ','BRASSALL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5062,5049,6,'4305    ','BREMER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5063,5050,6,'4305    ','CHURCHILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5064,5051,6,'4305    ','COALFALLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5065,5052,6,'4305    ','EAST IPSWICH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5066,5053,6,'4305    ','EASTERN HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5067,5054,6,'4305    ','FLINDERS VIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5068,5055,6,'4305    ','IPSWICH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5069,5056,6,'4305    ','LEICHHARDT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5070,5057,6,'4305    ','LIMESTONE RIDGES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5071,5058,6,'4305    ','MOORES POCKET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5072,5059,6,'4305    ','NEWTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5073,5060,6,'4305    ','NORTH IPSWICH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5074,5061,6,'4305    ','NORTH TIVOLI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5075,5062,6,'4305    ','ONE MILE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5076,5063,6,'4305    ','RACEVIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5077,5064,6,'4305    ','RAYMONDS HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5078,5065,6,'4305    ','SADLIERS CROSSING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5079,5066,6,'4305    ','TIVOLI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5080,5067,6,'4305    ','WEST IPSWICH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5081,5068,6,'4305    ','WOODEND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5082,5069,6,'4305    ','WULKURAKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5083,5070,6,'4305    ','YAMANTO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5084,5071,6,'4306    ','AMBERLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5085,5072,6,'4306    ','AVOCA VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5086,5073,6,'4306    ','BANKS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5087,5074,6,'4306    ','BARELLAN POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5088,5075,6,'4306    ','BENARKIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5089,5076,6,'4306    ','BENARKIN NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5090,5077,6,'4306    ','BLACKBUTT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5091,5078,6,'4306    ','BLACKBUTT NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5092,5079,6,'4306    ','BLACKBUTT SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5093,5080,6,'4306    ','BLACKSOIL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5094,5081,6,'4306    ','BLACKWALL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5095,5082,6,'4306    ','BORALLON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5096,5083,6,'4306    ','CHERRY CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5097,5084,6,'4306    ','CHUWAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5098,5085,6,'4306    ','COLINTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5099,5086,6,'4306    ','DEEBING HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5100,5087,6,'4306    ','FAIRNEY VIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5101,5088,6,'4306    ','FERNVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5102,5089,6,'4306    ','GOOGA CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5103,5090,6,'4306    ','GOOLMAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5104,5091,6,'4306    ','HAIGSLEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5105,5092,6,'4306    ','HARLIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5106,5093,6,'4306    ','HOLTS HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5107,5094,6,'4306    ','IRONBARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5108,5095,6,'4306    ','KARALEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5109,5096,6,'4306    ','KARANA DOWNS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5110,5097,6,'4306    ','LAKE MANCHESTER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5111,5098,6,'4306    ','LINVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5112,5099,6,'4306    ','MONSILDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5113,5100,6,'4306    ','MOORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5114,5101,6,'4306    ','MOUNT BINGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5115,5102,6,'4306    ','MOUNT CROSBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5116,5103,6,'4306    ','MOUNT STANLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5117,5104,6,'4306    ','MUIRLEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5118,5105,6,'4306    ','NUKKU');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5119,5106,6,'4306    ','PEAK CROSSING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5120,5107,6,'4306    ','PINE MOUNTAIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5121,5108,6,'4306    ','RIPLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5122,5109,6,'4306    ','SOUTH RIPLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5123,5110,6,'4306    ','TEELAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5124,5111,6,'4306    ','THAGOONA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5125,5112,6,'4306    ','WALLOON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5126,5113,6,'4306    ','WILLOWBANK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5127,5114,6,'4307    ','HARRISVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5128,5115,6,'4309    ','ARATULA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5129,5116,6,'4309    ','FRAZERVIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5130,5117,6,'4309    ','KALBAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5131,5118,6,'4309    ','WASHPOOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5132,5119,6,'4310    ','BOONAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5133,5120,6,'4310    ','ROADVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5134,5121,6,'4311    ','BUARABA SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5135,5122,6,'4311    ','CHURCHABLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5136,5123,6,'4311    ','COOMINYA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5137,5124,6,'4311    ','LOCKYER WATERS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5138,5125,6,'4311    ','LOWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5139,5126,6,'4311    ','MINDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5140,5127,6,'4311    ','PATRICK ESTATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5141,5128,6,'4311    ','WIVENHOE HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5142,5129,6,'4312    ','BRYDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5143,5130,6,'4312    ','CABOONBAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5144,5131,6,'4312    ','CROSSDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5145,5132,6,'4312    ','ESK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5146,5133,6,'4312    ','GLEN ESK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5147,5134,6,'4312    ','MOOMBRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5148,5135,6,'4312    ','MOUNT BYRON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5149,5136,6,'4312    ','REDBANK CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5150,5137,6,'4312    ','SOMERSET DAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5151,5138,6,'4313    ','BRAEMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5152,5139,6,'4313    ','COOEEIMBARDI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5153,5140,6,'4313    ','FULHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5154,5141,6,'4313    ','LOWER CRESSBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5155,5142,6,'4313    ','OTTABA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5156,5143,6,'4313    ','SCRUB CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5157,5144,6,'4313    ','TOOGOOLAWAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5158,5145,6,'4313    ','YIMBUN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5159,5146,6,'4340    ','GRANDCHESTER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5160,5147,6,'4340    ','LANEFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5161,5148,6,'4340    ','LOWER MOUNT WALKER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5162,5149,6,'4340    ','MERRYVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5163,5150,6,'4340    ','MOUNT WALKER WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5164,5151,6,'4340    ','ROSEWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5165,5152,6,'4340    ','THE BLUFF');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5166,5153,6,'4341    ','KENSINGTON GROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5167,5154,6,'4341    ','LAIDLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5168,5155,6,'4341    ','LAIDLEY CREEK WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5169,5156,6,'4341    ','LAIDLEY HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5170,5157,6,'4341    ','LAIDLEY NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5171,5158,6,'4341    ','PLAINLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5172,5159,6,'4341    ','TOWNSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5173,5160,6,'4342    ','FOREST HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5174,5161,6,'4342    ','GLEN CAIRN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5175,5162,6,'4342    ','GLENORE GROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5176,5163,6,'4342    ','LYNFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5177,5164,6,'4343    ','ADARE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5178,5165,6,'4343    ','BLACK DUCK CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5179,5166,6,'4343    ','CAFFEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5180,5167,6,'4343    ','COLLEGE VIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5181,5168,6,'4343    ','EAST HALDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5182,5169,6,'4343    ','FORDSDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5183,5170,6,'4343    ','GATTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5184,5171,6,'4343    ','INGOLDSBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5185,5172,6,'4343    ','JUNCTION VIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5186,5173,6,'4343    ','LAKE CLARENDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5187,5174,6,'4343    ','LAWES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5188,5175,6,'4343    ','LEFTHAND BRANCH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5189,5176,6,'4343    ','LOWER TENTHILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5190,5177,6,'4343    ','MORTON VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5191,5178,6,'4343    ','MOUNT SYLVIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5192,5179,6,'4343    ','PLACID HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5193,5180,6,'4343    ','RINGWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5194,5181,6,'4343    ','ROCKSIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5195,5182,6,'4343    ','ROPELEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5196,5183,6,'4343    ','SPRING CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5197,5184,6,'4343    ','UPPER TENTHILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5198,5185,6,'4343    ','VINEGAR HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5199,5186,6,'4343    ','WOODBINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5200,5187,6,'4343    ','WOODLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5201,5188,6,'4344    ','CARPENDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5202,5189,6,'4344    ','EGYPT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5203,5190,6,'4344    ','FLAGSTONE CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5204,5191,6,'4344    ','HELIDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5205,5192,6,'4344    ','HELIDON SPA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5206,5193,6,'4344    ','LILYDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5207,5194,6,'4344    ','LOCKYER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5208,5195,6,'4344    ','ROCKMOUNT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5209,5196,6,'4344    ','SEVENTEEN MILE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5210,5197,6,'4344    ','SILVER PINCH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5211,5198,6,'4344    ','SILVER RIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5212,5199,6,'4344    ','STOCKYARD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5213,5200,6,'4344    ','UPPER FLAGSTONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5214,5201,6,'4345    ','GATTON COLLEGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5215,5202,6,'4346    ','MARBURG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5216,5203,6,'4347    ','GRANTHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5217,5204,6,'4347    ','MA MA CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5218,5205,6,'4347    ','MOUNT WHITESTONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5219,5206,6,'4347    ','VERADILLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5220,5207,6,'4347    ','WINWILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5221,5208,6,'4350    ','ATHOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5222,5209,6,'4350    ','CENTENARY HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5223,5210,6,'4350    ','CRANLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5224,5211,6,'4350    ','DARLING HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5225,5212,6,'4350    ','DRAYTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5226,5213,6,'4350    ','EAST TOOWOOMBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5227,5214,6,'4350    ','EASTLAKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5228,5215,6,'4350    ','FINNIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5229,5216,6,'4350    ','GLENVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5230,5217,6,'4350    ','HARLAXTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5231,5218,6,'4350    ','HARRISTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5232,5219,6,'4350    ','KEARNEYS SPRING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5233,5220,6,'4350    ','MIDDLE RIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5234,5221,6,'4350    ','MOUNT KYNOCH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5235,5222,6,'4350    ','MOUNT LOFTY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5236,5223,6,'4350    ','MOUNT RASCAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5237,5224,6,'4350    ','NEWTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5238,5225,6,'4350    ','NORTH TOOWOOMBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5239,5226,6,'4350    ','NORTHLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5240,5227,6,'4350    ','PICNIC POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5241,5228,6,'4350    ','PRINCE HENRY HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5242,5229,6,'4350    ','RANGEVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5243,5230,6,'4350    ','REDWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5244,5231,6,'4350    ','ROCKVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5245,5232,6,'4350    ','SOUTH TOOWOOMBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5246,5233,6,'4350    ','SOUTHTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5247,5234,6,'4350    ','TOOWOOMBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5248,5235,6,'4350    ','TOOWOOMBA CITY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5249,5236,6,'4350    ','TOOWOOMBA EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5250,5237,6,'4350    ','TOOWOOMBA SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5251,5238,6,'4350    ','TOOWOOMBA WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5252,5239,6,'4350    ','TOP CAMP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5253,5240,6,'4350    ','WELLCAMP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5254,5241,6,'4350    ','WESTBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5255,5242,6,'4350    ','WILSONTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5256,5243,6,'4352    ','ACLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5257,5244,6,'4352    ','AMIENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5258,5245,6,'4352    ','BALLARD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5259,5246,6,'4352    ','BAPAUME');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5260,5247,6,'4352    ','BIRNAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5261,5248,6,'4352    ','BLANCHVIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5262,5249,6,'4352    ','BRANCHVIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5263,5250,6,'4352    ','CABARLAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5264,5251,6,'4352    ','CEMENT MILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5265,5252,6,'4352    ','DERRYMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5266,5253,6,'4352    ','DJUAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5267,5254,6,'4352    ','FIFTEEN MILE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5268,5255,6,'4352    ','GEHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5269,5256,6,'4352    ','GORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5270,5257,6,'4352    ','GRAPE TREE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5271,5258,6,'4352    ','GROOMSVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5272,5259,6,'4352    ','HIGHFIELDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5273,5260,6,'4352    ','IREDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5274,5261,6,'4352    ','KARARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5275,5262,6,'4352    ','KLEINTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5276,5263,6,'4352    ','KULPI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5277,5264,6,'4352    ','KURROWAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5278,5265,6,'4352    ','LYRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5279,5266,6,'4352    ','MACLAGAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5280,5267,6,'4352    ','MERINGANDAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5281,5268,6,'4352    ','MERRITTS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5282,5269,6,'4352    ','MOUNT LUKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5283,5270,6,'4352    ','MURPHYS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5284,5271,6,'4352    ','OMAN AMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5285,5272,6,'4352    ','PALM TREE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5286,5273,6,'4352    ','PAMPAS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5287,5274,6,'4352    ','PECHEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5288,5275,6,'4352    ','PERANGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5289,5276,6,'4352    ','PERSEVERANCE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5290,5277,6,'4352    ','POSTMANS RIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5291,5278,6,'4352    ','POZIERES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5292,5279,6,'4352    ','PRESTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5293,5280,6,'4352    ','RAMSAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5294,5281,6,'4352    ','RAVENSBOURNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5295,5282,6,'4352    ','SEVERNLEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5296,5283,6,'4352    ','SPRING BLUFF');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5297,5284,6,'4352    ','ST AUBYN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5298,5285,6,'4352    ','THORNVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5299,5286,6,'4352    ','TOOWOOMBA MC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5300,5287,6,'4352    ','TUMMAVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5301,5288,6,'4352    ','UMBIRAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5302,5289,6,'4352    ','UPPER LOCKYER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5303,5290,6,'4352    ','WHICHELLO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5304,5291,6,'4352    ','WHITE MOUNTAIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5305,5292,6,'4352    ','WITHCOTT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5306,5293,6,'4352    ','WOOLMER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5307,5294,6,'4352    ','WYREEMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5308,5295,6,'4352    ','YANDILLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5309,5296,6,'4353    ','HADEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5310,5297,6,'4354    ','DOUGLAS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5311,5298,6,'4354    ','GOOMBUNGEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5312,5299,6,'4355    ','CROWS NEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5313,5300,6,'4355    ','GLENHAVEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5314,5301,6,'4355    ','PIERCE CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5315,5302,6,'4355    ','THE BLUFF');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5316,5303,6,'4356    ','BONGEEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5317,5304,6,'4356    ','BROXBURN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5318,5305,6,'4356    ','EVANSLEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5319,5306,6,'4356    ','IRONGATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5320,5307,6,'4356    ','KINCORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5321,5308,6,'4356    ','LINTHORPE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5322,5309,6,'4356    ','MOTLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5323,5310,6,'4356    ','MOUNT TYSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5324,5311,6,'4356    ','NORTH BRANCH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5325,5312,6,'4356    ','NORWIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5326,5313,6,'4356    ','PITTSWORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5327,5314,6,'4356    ','PURRAWUNDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5328,5315,6,'4356    ','ROSSVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5329,5316,6,'4356    ','SCRUBBY MOUNTAIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5330,5317,6,'4356    ','SPRINGSIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5331,5318,6,'4356    ','ST HELENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5332,5319,6,'4356    ','STONELEIGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5333,5320,6,'4356    ','YARRANLEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5334,5321,6,'4357    ','BRINGALILY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5335,5322,6,'4357    ','KOOROONGARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5336,5323,6,'4357    ','MILLMERRAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5337,5324,6,'4358    ','CAMBOOYA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5338,5325,6,'4359    ','GREENMOUNT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5339,5326,6,'4359    ','WEST HALDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5340,5327,6,'4360    ','NOBBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5341,5328,6,'4361    ','CLIFTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5342,5329,6,'4361    ','SPRING CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5343,5330,6,'4362    ','ALLORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5344,5331,6,'4362    ','GOOMBURRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5345,5332,6,'4363    ','SOUTHBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5346,5333,6,'4364    ','BROOKSTEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5347,5334,6,'4365    ','LEYBURN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5348,5335,6,'4370    ','GLENNIE HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5349,5336,6,'4370    ','MARYVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5350,5337,6,'4370    ','WARWICK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5351,5338,6,'4371    ','EMU VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5352,5339,6,'4371    ','YANGAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5353,5340,6,'4372    ','TANNYMOREL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5354,5341,6,'4373    ','KILLARNEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5355,5342,6,'4374    ','DALVEEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5356,5343,6,'4375    ','COTTONVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5357,5344,6,'4376    ','THULIMBAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5358,5345,6,'4377    ','THE SUMMIT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5359,5346,6,'4378    ','APPLETHORPE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5360,5347,6,'4380    ','STANTHORPE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5361,5348,6,'4381    ','GLEN APLIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5362,5349,6,'4382    ','BALLANDEAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5363,5350,6,'4383    ','WALLANGARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5364,5351,6,'4384    ','LIMEVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5365,5352,6,'4385    ','GLENARBON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5366,5353,6,'4385    ','TEXAS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5367,5354,6,'4387    ','INGLEWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5368,5355,6,'4388    ','YELARBON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5369,5356,6,'4390    ','GOONDIWINDI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5370,5357,6,'4400    ','KINGSTHORPE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5371,5358,6,'4401    ','OAKEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5372,5359,6,'4402    ','COOYAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5373,5360,6,'4403    ','JONDARYAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5374,5361,6,'4403    ','QUINALOW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5375,5362,6,'4404    ','BOWENVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5376,5363,6,'4404    ','IRVINGDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5377,5364,6,'4405    ','DALBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5378,5365,6,'4406    ','HANNAFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5379,5366,6,'4406    ','JIMBOUR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5380,5367,6,'4406    ','KAIMKILLENBUN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5381,5368,6,'4406    ','KOGAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5382,5369,6,'4406    ','MACALISTER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5383,5370,6,'4406    ','MOONIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5384,5371,6,'4406    ','THE GUMS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5385,5372,6,'4407    ','CECIL PLAINS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5386,5373,6,'4408    ','BELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5387,5374,6,'4408    ','COORANGA NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5388,5375,6,'4410    ','JANDOWAE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5389,5376,6,'4411    ','WARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5390,5377,6,'4412    ','BRIGALOW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5391,5378,6,'4413    ','CHINCHILLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5392,5379,6,'4413    ','HOPELAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5393,5380,6,'4415    ','MILES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5394,5381,6,'4416    ','CONDAMINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5395,5382,6,'4417    ','SURAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5396,5383,6,'4418    ','GULUGUBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5397,5384,6,'4419    ','WANDOAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5398,5385,6,'4420    ','SPRING CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5399,5386,6,'4420    ','TAROOM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5400,5387,6,'4421    ','TARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5401,5388,6,'4422    ','MEANDARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5402,5389,6,'4423    ','GLENMORGAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5403,5390,6,'4424    ','DRILLHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5404,5391,6,'4425    ','DULACCA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5405,5392,6,'4426    ','JACKSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5406,5393,6,'4427    ','YULEBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5407,5394,6,'4428    ','WALLUMBILLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5408,5395,6,'4454    ','INJUNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5409,5396,6,'4455    ','ANGELLALA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5410,5397,6,'4455    ','ROMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5411,5398,6,'4461    ','MUCKADILLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5412,5399,6,'4462    ','AMBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5413,5400,6,'4465    ','MITCHELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5414,5401,6,'4467    ','MUNGALLALA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5415,5402,6,'4468    ','MORVEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5416,5403,6,'4470    ','CHARLEVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5417,5404,6,'4471    ','CLAVERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5418,5405,6,'4472    ','BLACKALL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5419,5406,6,'4474    ','ADAVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5420,5407,6,'4475    ','CHEEPIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5421,5408,6,'4477    ','AUGATHELLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5422,5409,6,'4478    ','TAMBO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5423,5410,6,'4479    ','COOLADDI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5424,5411,6,'4480    ','EROMANGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5425,5412,6,'4480    ','QUILPIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5426,5413,6,'4481    ','WINDORAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5427,5414,6,'4482    ','BIRDSVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5428,5415,6,'4486    ','DIRRANBANDI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5429,5416,6,'4486    ','HEBEL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5430,5417,6,'4487    ','ST GEORGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5431,5418,6,'4488    ','BOLLON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5432,5419,6,'4489    ','WYANDRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5433,5420,6,'4490    ','CUNNAMULLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5434,5421,6,'4490    ','YOWAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5435,5422,6,'4491    ','EULO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5436,5423,6,'4492    ','THARGOMINDAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5437,5424,6,'4493    ','HUNGERFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5438,5425,6,'4494    ','BUNGUNYA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5439,5426,6,'4496    ','TALWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5440,5427,6,'4497    ','DAYMAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5441,5428,6,'4497    ','THALLON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5442,5429,6,'4498    ','TOOBEAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5443,5430,6,'4500    ','BRAY PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5444,5431,6,'4500    ','BRENDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5445,5432,6,'4500    ','CASHMERE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5446,5433,6,'4500    ','CLEAR MOUNTAIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5447,5434,6,'4500    ','JOYNER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5448,5435,6,'4500    ','STRATHPINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5449,5436,6,'4500    ','WARNER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5450,5437,6,'4501    ','LAWNTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5451,5438,6,'4502    ','PETRIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5452,5439,6,'4503    ','DAKABIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5453,5440,6,'4503    ','GRIFFIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5454,5441,6,'4503    ','KALLANGUR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5455,5442,6,'4503    ','KURWONGBAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5456,5443,6,'4503    ','MURRUMBA DOWNS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5457,5444,6,'4503    ','WHITESIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5458,5445,6,'4504    ','NARANGBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5459,5446,6,'4505    ','BURPENGARY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5460,5447,6,'4506    ','MOORINA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5461,5448,6,'4506    ','MORAYFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5462,5449,6,'4507    ','BANKSIA BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5463,5450,6,'4507    ','BELLARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5464,5451,6,'4507    ','BONGAREE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5465,5452,6,'4507    ','BRIBIE ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5466,5453,6,'4507    ','BRIBIE ISLAND DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5467,5454,6,'4507    ','WELSBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5468,5455,6,'4507    ','WHITE PATCH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5469,5456,6,'4507    ','WOORIM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5470,5457,6,'4508    ','DECEPTION BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5471,5458,6,'4509    ','MANGO HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5472,5459,6,'4510    ','BEACHMERE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5473,5460,6,'4510    ','CABOOLTURE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5474,5461,6,'4510    ','DONNYBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5475,5462,6,'4510    ','TOORBUL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5476,5463,6,'4511    ','GODWIN BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5477,5464,6,'4511    ','NINGI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5478,5465,6,'4511    ','SANDSTONE POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5479,5466,6,'4511    ','TOORBUL POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5480,5467,6,'4512    ','WAMURAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5481,5468,6,'4514    ','D''AGUILAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5482,5469,6,'4514    ','WOODFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5483,5470,6,'4515    ','JIMNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5484,5471,6,'4515    ','KILCOY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5485,5472,6,'4516    ','ELIMBAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5486,5473,6,'4517    ','BEERBURRUM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5487,5474,6,'4518    ','GLASS HOUSE MOUNTAINS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5488,5475,6,'4519    ','BEERWAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5489,5476,6,'4520    ','CAMP MOUNTAIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5490,5477,6,'4520    ','CEDAR CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5491,5478,6,'4520    ','CLOSEBURN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5492,5479,6,'4520    ','DRAPER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5493,5480,6,'4520    ','ENOGGERA RESERVOIR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5494,5481,6,'4520    ','HIGHVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5495,5482,6,'4520    ','MOUNT GLORIOUS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5496,5483,6,'4520    ','MOUNT NEBO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5497,5484,6,'4520    ','MOUNT SAMSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5498,5485,6,'4520    ','SAMFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5499,5486,6,'4520    ','SAMSONVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5500,5487,6,'4520    ','WIGHTS MOUNTAIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5501,5488,6,'4520    ','YUGAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5502,5489,6,'4521    ','DAYBORO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5503,5490,6,'4521    ','KING SCRUB');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5504,5491,6,'4521    ','MOUNT MEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5505,5492,6,'4521    ','MOUNT PLEASANT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5506,5493,6,'4521    ','OCEAN VIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5507,5494,6,'4550    ','LANDSBOROUGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5508,5495,6,'4551    ','AROONA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5509,5496,6,'4551    ','BATTERY HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5510,5497,6,'4551    ','CALOUNDRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5511,5498,6,'4551    ','CALOUNDRA WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5512,5499,6,'4551    ','CURRIMUNDI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5513,5500,6,'4551    ','DICKY BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5514,5501,6,'4551    ','GOLDEN BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5515,5502,6,'4551    ','KINGS BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5516,5503,6,'4551    ','LITTLE MOUNTAIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5517,5504,6,'4551    ','MOFFAT BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5518,5505,6,'4551    ','PELICAN WATERS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5519,5506,6,'4551    ','SHELLY BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5520,5507,6,'4552    ','CONONDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5521,5508,6,'4552    ','MALENY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5522,5509,6,'4553    ','MOOLOOLAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5523,5510,6,'4553    ','PALMVIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5524,5511,6,'4554    ','EUDLO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5525,5512,6,'4554    ','ILKLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5526,5513,6,'4555    ','PALMWOODS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5527,5514,6,'4556    ','BUDERIM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5528,5515,6,'4556    ','KUNDA PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5529,5516,6,'4556    ','TANAWHA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5530,5517,6,'4557    ','MOOLOOLABA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5531,5518,6,'4557    ','MOUNTAIN CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5532,5519,6,'4558    ','COTTON TREE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5533,5520,6,'4558    ','MAROOCHYDORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5534,5521,6,'4558    ','MAROOCHYDORE BC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5535,5522,6,'4558    ','SUNSHINE PLAZA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5536,5523,6,'4559    ','DIDDILLIBAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5537,5524,6,'4559    ','KIELS MOUNTAIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5538,5525,6,'4559    ','WOOMBYE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5539,5526,6,'4560    ','BLI BLI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5540,5527,6,'4560    ','DULONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5541,5528,6,'4560    ','MAPLETON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5542,5529,6,'4560    ','MONTVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5543,5530,6,'4560    ','NAMBOUR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5544,5531,6,'4560    ','PERWILLOWEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5545,5532,6,'4561    ','MAROOCHY RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5546,5533,6,'4561    ','YANDINA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5547,5534,6,'4562    ','EUMUNDI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5548,5535,6,'4563    ','COOROY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5549,5536,6,'4563    ','COOROY MOUNTAIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5550,5537,6,'4563    ','LAKE MACDONALD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5551,5538,6,'4563    ','TINBEERWAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5552,5539,6,'4564    ','MARCOOLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5553,5540,6,'4564    ','MUDJIMBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5554,5541,6,'4564    ','PACIFIC PARADISE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5555,5542,6,'4565    ','BOREEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5556,5543,6,'4565    ','BOREEN POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5557,5544,6,'4565    ','COOROIBAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5558,5545,6,'4565    ','NORTH SHORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5559,5546,6,'4565    ','RINGTAIL CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5560,5547,6,'4565    ','TEWANTIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5561,5548,6,'4566    ','NOOSAVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5562,5549,6,'4567    ','CASTAWAYS BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5563,5550,6,'4567    ','NOOSA HEADS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5564,5551,6,'4567    ','SUNRISE BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5565,5552,6,'4567    ','SUNSHINE BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5566,5553,6,'4568    ','FEDERAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5567,5554,6,'4568    ','PINBARREN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5568,5555,6,'4568    ','POMONA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5569,5556,6,'4569    ','COORAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5570,5557,6,'4570    ','AMAMOOR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5571,5558,6,'4570    ','ANDERLEIGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5572,5559,6,'4570    ','ARALUEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5573,5560,6,'4570    ','CORELLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5574,5561,6,'4570    ','GLANMIRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5575,5562,6,'4570    ','GLEN ECHO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5576,5563,6,'4570    ','GLENWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5577,5564,6,'4570    ','GUNALDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5578,5565,6,'4570    ','GYMPIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5579,5566,6,'4570    ','IMBIL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5580,5567,6,'4570    ','JONES HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5581,5568,6,'4570    ','KANDANGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5582,5569,6,'4570    ','KANIGAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5583,5570,6,'4570    ','KIA ORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5584,5571,6,'4570    ','MIVA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5585,5572,6,'4570    ','MONKLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5586,5573,6,'4570    ','MUNNA CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5587,5574,6,'4570    ','PATERSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5588,5575,6,'4570    ','SCOTCHY POCKET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5589,5576,6,'4570    ','ST MARY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5590,5577,6,'4570    ','TOOLARA FOREST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5591,5578,6,'4570    ','WOOLOOGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5592,5579,6,'4571    ','KIN KIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5593,5580,6,'4572    ','ALEXANDRA HEADLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5594,5581,6,'4573    ','COOLUM BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5595,5582,6,'4573    ','MARCUS BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5596,5583,6,'4573    ','MOUNT COOLUM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5597,5584,6,'4573    ','PEREGIAN BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5598,5585,6,'4573    ','YAROOMBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5599,5586,6,'4574    ','KENILWORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5600,5587,6,'4575    ','BIRTINYA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5601,5588,6,'4575    ','BOKARINA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5602,5589,6,'4575    ','BUDDINA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5603,5590,6,'4575    ','KAWANA WATERS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5604,5591,6,'4575    ','MINYAMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5605,5592,6,'4575    ','PARREARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5606,5593,6,'4575    ','WARANA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5607,5594,6,'4575    ','WARANA BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5608,5595,6,'4575    ','WURTULLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5609,5596,6,'4580    ','TIN CAN BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5610,5597,6,'4581    ','EURONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5611,5598,6,'4581    ','RAINBOW BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5612,5599,6,'4600    ','KILKIVAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5613,5600,6,'4601    ','GOOMERI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5614,5601,6,'4601    ','TANSEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5615,5602,6,'4605    ','CHERBOURG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5616,5603,6,'4605    ','CLOYNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5617,5604,6,'4605    ','MURGON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5618,5605,6,'4606    ','WONDAI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5619,5606,6,'4608    ','TINGOORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5620,5607,6,'4608    ','WOOROOLIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5621,5608,6,'4610    ','ALICE CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5622,5609,6,'4610    ','BENAIR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5623,5610,6,'4610    ','BOOIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5624,5611,6,'4610    ','BOYNESIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5625,5612,6,'4610    ','CHAHPINGAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5626,5613,6,'4610    ','COOLABUNIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5627,5614,6,'4610    ','CORNDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5628,5615,6,'4610    ','DANGORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5629,5616,6,'4610    ','DURONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5630,5617,6,'4610    ','DURONG SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5631,5618,6,'4610    ','GOODGER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5632,5619,6,'4610    ','GORDONBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5633,5620,6,'4610    ','HALY CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5634,5621,6,'4610    ','INVERLAW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5635,5622,6,'4610    ','IRONPOT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5636,5623,6,'4610    ','KINGAROY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5637,5624,6,'4610    ','KUMBIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5638,5625,6,'4610    ','MANNUEM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5639,5626,6,'4610    ','TAABINGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5640,5627,6,'4610    ','WATTLE GROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5641,5628,6,'4611    ','MONDURE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5642,5629,6,'4612    ','HIVESVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5643,5630,6,'4613    ','ABBEYWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5644,5631,6,'4613    ','PROSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5645,5632,6,'4614    ','YARRAMAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5646,5633,6,'4615    ','MAIDENWELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5647,5634,6,'4615    ','NANANGO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5648,5635,6,'4615    ','TARONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5649,5636,6,'4620    ','BROOWEENA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5650,5637,6,'4620    ','GLENBAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5651,5638,6,'4621    ','BIGGENDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5652,5639,6,'4625    ','GAYNDAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5653,5640,6,'4626    ','MUNDUBBERA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5654,5641,6,'4627    ','ABERCORN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5655,5642,6,'4627    ','EIDSVOLD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5656,5643,6,'4630    ','KALPOWAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5657,5644,6,'4630    ','MONTO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5658,5645,6,'4630    ','MULGILDIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5659,5646,6,'4650    ','ANTIGUA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5660,5647,6,'4650    ','BADDOW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5661,5648,6,'4650    ','BAUPLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5662,5649,6,'4650    ','BAUPLE FOREST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5663,5650,6,'4650    ','BOONOOROO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5664,5651,6,'4650    ','DUNMORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5665,5652,6,'4650    ','GOOTCHIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5666,5653,6,'4650    ','GRANVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5667,5654,6,'4650    ','GUNDIAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5668,5655,6,'4650    ','MARYBOROUGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5669,5656,6,'4650    ','MOUNT URAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5670,5657,6,'4650    ','MUNGAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5671,5658,6,'4650    ','NETHERBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5672,5659,6,'4650    ','OWANYILLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5673,5660,6,'4650    ','PILERWA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5674,5661,6,'4650    ','PIONEERS REST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5675,5662,6,'4650    ','TALEGALLA WEIR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5676,5663,6,'4650    ','TEDDINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5677,5664,6,'4650    ','THINOOMBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5678,5665,6,'4650    ','TIARO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5679,5666,6,'4650    ','TINANA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5680,5667,6,'4650    ','TUAN FOREST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5681,5668,6,'4655    ','BOORAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5682,5669,6,'4655    ','DUNDOWRAN BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5683,5670,6,'4655    ','HAPPY VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5684,5671,6,'4655    ','HERVEY BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5685,5672,6,'4655    ','HERVEY BAY DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5686,5673,6,'4655    ','KAWUNGAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5687,5674,6,'4655    ','KINGFISHER BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5688,5675,6,'4655    ','NIKENBAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5689,5676,6,'4655    ','PIALBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5690,5677,6,'4655    ','POINT VERNON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5691,5678,6,'4655    ','SCARNESS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5692,5679,6,'4655    ','TORQUAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5693,5680,6,'4655    ','URANGAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5694,5681,6,'4655    ','URRAWEEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5695,5682,6,'4655    ','WALLIGAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5696,5683,6,'4655    ','WONDUNNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5697,5684,6,'4659    ','BURRUM HEADS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5698,5685,6,'4659    ','HOWARD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5699,5686,6,'4660    ','ABINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5700,5687,6,'4660    ','CHILDERS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5701,5688,6,'4660    ','CORDALBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5702,5689,6,'4660    ','GOODWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5703,5690,6,'4660    ','ISIS CENTRAL MILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5704,5691,6,'4660    ','WOODGATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5705,5692,6,'4662    ','TORBANLEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5706,5693,6,'4670    ','ABBOTSFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5707,5694,6,'4670    ','ASHFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5708,5695,6,'4670    ','AVENELL HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5709,5696,6,'4670    ','AVOCA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5710,5697,6,'4670    ','AVONDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5711,5698,6,'4670    ','BARGARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5712,5699,6,'4670    ','BRANYAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5713,5700,6,'4670    ','BUNDABERG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5714,5701,6,'4670    ','BUNDABERG CENTRAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5715,5702,6,'4670    ','BUNDABERG DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5716,5703,6,'4670    ','BUNDABERG EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5717,5704,6,'4670    ','BUNDABERG NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5718,5705,6,'4670    ','BUNDABERG SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5719,5706,6,'4670    ','BUNDABERG WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5720,5707,6,'4670    ','BURNETT HEADS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5721,5708,6,'4670    ','ELLIOTT HEADS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5722,5709,6,'4670    ','KALKIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5723,5710,6,'4670    ','KENSINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5724,5711,6,'4670    ','KEPNOCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5725,5712,6,'4670    ','MILLBANK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5726,5713,6,'4670    ','MOORE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5727,5714,6,'4670    ','NORVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5728,5715,6,'4670    ','SHARON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5729,5716,6,'4670    ','SOUTH KOLAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5730,5717,6,'4670    ','SVENSSON HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5731,5718,6,'4670    ','THABEBAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5732,5719,6,'4670    ','WALKERVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5733,5720,6,'4670    ','WATALGAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5734,5721,6,'4671    ','BOOYAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5735,5722,6,'4671    ','GIN GIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5736,5723,6,'4671    ','MOUNT PERRY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5737,5724,6,'4671    ','WALLAVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5738,5725,6,'4673    ','YANDARAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5739,5726,6,'4674    ','BAFFLE CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5740,5727,6,'4674    ','BERAJONDO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5741,5728,6,'4674    ','DEEPWATER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5742,5729,6,'4674    ','EULEILAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5743,5730,6,'4674    ','MOUNT MARIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5744,5731,6,'4674    ','OYSTER CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5745,5732,6,'4674    ','ROSEDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5746,5733,6,'4674    ','RULES BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5747,5734,6,'4674    ','TAUNTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5748,5735,6,'4676    ','GINDORAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5749,5736,6,'4676    ','LOWMEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5750,5737,6,'4677    ','AGNES WATER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5751,5738,6,'4677    ','CAPTAIN CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5752,5739,6,'4677    ','COLOSSEUM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5753,5740,6,'4677    ','EURIMBULA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5754,5741,6,'4677    ','MIRIAM VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5755,5742,6,'4677    ','MOUNT TOM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5756,5743,6,'4677    ','SEVENTEEN SEVENTY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5757,5744,6,'4678    ','BOROREN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5758,5745,6,'4678    ','FORESHORES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5759,5746,6,'4678    ','RODDS BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5760,5747,6,'4680    ','BARNEY POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5761,5748,6,'4680    ','BENARABY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5762,5749,6,'4680    ','BOYNE ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5763,5750,6,'4680    ','BUILYAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5764,5751,6,'4680    ','BYELLEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5765,5752,6,'4680    ','CALLEMONDAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5766,5753,6,'4680    ','CALLIOPE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5767,5754,6,'4680    ','CLINTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5768,5755,6,'4680    ','GLADSTONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5769,5756,6,'4680    ','GLEN EDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5770,5757,6,'4680    ','HERON ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5771,5758,6,'4680    ','HETHERINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5772,5759,6,'4680    ','KIN KORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5773,5760,6,'4680    ','KIRKWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5774,5761,6,'4680    ','NEW AUCKLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5775,5762,6,'4680    ','O''CONNELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5776,5763,6,'4680    ','SOUTH GLADSTONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5777,5764,6,'4680    ','SOUTH TREES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5778,5765,6,'4680    ','SUN VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5779,5766,6,'4680    ','TANNUM SANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5780,5767,6,'4680    ','TELINA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5781,5768,6,'4680    ','TOOLOOA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5782,5769,6,'4680    ','UBOBO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5783,5770,6,'4680    ','WEST GLADSTONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5784,5771,6,'4694    ','YARWUN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5785,5772,6,'4695    ','MOUNT LARCOM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5786,5773,6,'4697    ','RAGLAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5787,5774,6,'4699    ','BAJOOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5788,5775,6,'4700    ','ALLENSTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5789,5776,6,'4700    ','GREAT KEPPEL ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5790,5777,6,'4700    ','ROCKHAMPTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5791,5778,6,'4700    ','WANDAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5792,5779,6,'4701    ','CENTRAL QUEENSLAND UNIVERSITY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5793,5780,6,'4701    ','FRENCHVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5794,5781,6,'4701    ','KOONGAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5795,5782,6,'4701    ','NORTH ROCKHAMPTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5796,5783,6,'4701    ','PARK AVENUE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5797,5784,6,'4702    ','AMBROSE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5798,5785,6,'4702    ','ANAKIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5799,5786,6,'4702    ','BANANA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5800,5787,6,'4702    ','BARALABA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5801,5788,6,'4702    ','BLUFF');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5802,5789,6,'4702    ','BOULDERCOMBE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5803,5790,6,'4702    ','CENTRAL QUEENSLAND MC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5804,5791,6,'4702    ','COMET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5805,5792,6,'4702    ','DINGO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5806,5793,6,'4702    ','DULULU');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5807,5794,6,'4702    ','GOGANGO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5808,5795,6,'4702    ','GOOVIGEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5809,5796,6,'4702    ','GRACEMERE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5810,5797,6,'4702    ','JAMBIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5811,5798,6,'4702    ','KALAPA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5812,5799,6,'4702    ','KEPPEL SANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5813,5800,6,'4702    ','PARKHURST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5814,5801,6,'4702    ','ROLLESTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5815,5802,6,'4702    ','RUBYVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5816,5803,6,'4702    ','SAPPHIRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5817,5804,6,'4702    ','STANAGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5818,5805,6,'4702    ','STANWELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5819,5806,6,'4702    ','WESTWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5820,5807,6,'4702    ','WILLOWS GEMFIELDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5821,5808,6,'4702    ','WOWAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5822,5809,6,'4702    ','WYCARBAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5823,5810,6,'4702    ','YALLEROI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5824,5811,6,'4702    ','YARAKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5825,5812,6,'4703    ','BAYFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5826,5813,6,'4703    ','BYFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5827,5814,6,'4703    ','COOEE BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5828,5815,6,'4703    ','LAMMERMOOR BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5829,5816,6,'4703    ','STOCKYARD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5830,5817,6,'4703    ','TARANGANBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5831,5818,6,'4703    ','YEPPOON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5832,5819,6,'4704    ','YAAMBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5833,5820,6,'4705    ','MARLBOROUGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5834,5821,6,'4706    ','OGMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5835,5822,6,'4707    ','ST LAWRENCE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5836,5823,6,'4709    ','TIERI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5837,5824,6,'4710    ','EMU PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5838,5825,6,'4710    ','ZILZIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5839,5826,6,'4712    ','DUARINGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5840,5827,6,'4713    ','WOORABINDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5841,5828,6,'4714    ','MOUNT MORGAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5842,5829,6,'4715    ','BILOELA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5843,5830,6,'4716    ','THANGOOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5844,5831,6,'4717    ','BLACKWATER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5845,5832,6,'4718    ','MOURA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5846,5833,6,'4719    ','CRACOW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5847,5834,6,'4719    ','THEODORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5848,5835,6,'4720    ','EMERALD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5849,5836,6,'4721    ','CLERMONT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5850,5837,6,'4722    ','SPRINGSURE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5851,5838,6,'4723    ','CAPELLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5852,5839,6,'4724    ','ALPHA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5853,5840,6,'4725    ','BARCALDINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5854,5841,6,'4726    ','ARAMAC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5855,5842,6,'4727    ','ILFRACOMBE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5856,5843,6,'4728    ','JERICHO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5857,5844,6,'4730    ','LONGREACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5858,5845,6,'4730    ','MORELLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5859,5846,6,'4730    ','STONEHENGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5860,5847,6,'4731    ','ISISFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5861,5848,6,'4732    ','MUTTABURRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5862,5849,6,'4733    ','CORFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5863,5850,6,'4735    ','WINTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5864,5851,6,'4736    ','JUNDAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5865,5852,6,'4737    ','ARMSTRONG BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5866,5853,6,'4737    ','CAMPWIN BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5867,5854,6,'4737    ','FRESHWATER POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5868,5855,6,'4737    ','SARINA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5869,5856,6,'4737    ','SARINA BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5870,5857,6,'4737    ','SARINA RANGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5871,5858,6,'4738    ','KOUMALA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5872,5859,6,'4739    ','CARMILA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5873,5860,6,'4740    ','ALEXANDRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5874,5861,6,'4740    ','ALLIGATOR CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5875,5862,6,'4740    ','ANDERGROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5876,5863,6,'4740    ','BAKERS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5877,5864,6,'4740    ','BALNAGOWAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5878,5865,6,'4740    ','BEACONSFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5879,5866,6,'4740    ','BLACKS BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5880,5867,6,'4740    ','CAPE HILLSBOROUGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5881,5868,6,'4740    ','CONINGSBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5882,5869,6,'4740    ','DOLPHIN HEADS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5883,5870,6,'4740    ','DUNDULA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5884,5871,6,'4740    ','EAST MACKAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5885,5872,6,'4740    ','EIMEO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5886,5873,6,'4740    ','ERAKALA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5887,5874,6,'4740    ','GLENELLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5888,5875,6,'4740    ','GRASSTREE BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5889,5876,6,'4740    ','HABANA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5890,5877,6,'4740    ','HALF TIDE BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5891,5878,6,'4740    ','HAY POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5892,5879,6,'4740    ','HOMEBUSH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5893,5880,6,'4740    ','MACKAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5894,5881,6,'4740    ','MOUNT PLEASANT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5895,5882,6,'4740    ','NINDAROO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5896,5883,6,'4740    ','NORTH MACKAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5897,5884,6,'4740    ','OORALEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5898,5885,6,'4740    ','PAGET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5899,5886,6,'4740    ','PLANLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5900,5887,6,'4740    ','RACECOURSE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5901,5888,6,'4740    ','RICHMOND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5902,5889,6,'4740    ','ROSELLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5903,5890,6,'4740    ','RURAL VIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5904,5891,6,'4740    ','SALONIKA BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5905,5892,6,'4740    ','SLADE POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5906,5893,6,'4740    ','SOUTH MACKAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5907,5894,6,'4740    ','TE KOWAI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5908,5895,6,'4740    ','THE LEAP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5909,5896,6,'4740    ','TIMBERLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5910,5897,6,'4740    ','WEST MACKAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5911,5898,6,'4741    ','BRAMPTON ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5912,5899,6,'4741    ','DAYDREAM ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5913,5900,6,'4741    ','ETON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5914,5901,6,'4741    ','FARLEIGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5915,5902,6,'4741    ','GARGETT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5916,5903,6,'4741    ','KUTTABUL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5917,5904,6,'4741    ','LINDEMAN ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5918,5905,6,'4741    ','LONG ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5919,5906,6,'4741    ','MACKAY MC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5920,5907,6,'4741    ','MOUNT OSSA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5921,5908,6,'4741    ','PINNACLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5922,5909,6,'4741    ','PLEYSTOWE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5923,5910,6,'4741    ','SEAFORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5924,5911,6,'4741    ','SOUTH MOLLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5925,5912,6,'4742    ','NEBO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5926,5913,6,'4743    ','GLENDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5927,5914,6,'4744    ','MORANBAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5928,5915,6,'4745    ','DYSART');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5929,5916,6,'4746    ','MAY DOWNS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5930,5917,6,'4746    ','MIDDLEMOUNT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5931,5918,6,'4750    ','BUCASIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5932,5919,6,'4750    ','SHOAL POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5933,5920,6,'4751    ','WALKERSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5934,5921,6,'4753    ','MARIAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5935,5922,6,'4754    ','MIRANI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5936,5923,6,'4756    ','FINCH HATTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5937,5924,6,'4756    ','NETHERDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5938,5925,6,'4757    ','DALRYMPLE HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5939,5926,6,'4798    ','CALEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5940,5927,6,'4798    ','PINDI PINDI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5941,5928,6,'4798    ','WAGOORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5942,5929,6,'4799    ','BLOOMSBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5943,5930,6,'4800    ','CONWAY BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5944,5931,6,'4800    ','PRESTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5945,5932,6,'4800    ','PROSERPINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5946,5933,6,'4800    ','WILSON BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5947,5934,6,'4801    ','HAYMAN ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5948,5935,6,'4802    ','AIRLIE BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5949,5936,6,'4802    ','CANNONVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5950,5937,6,'4802    ','SHUTE HARBOUR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5951,5938,6,'4802    ','WHITSUNDAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5952,5939,6,'4803    ','HAMILTON ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5953,5940,6,'4804    ','COLLINSVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5954,5941,6,'4804    ','MOUNT COOLON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5955,5942,6,'4804    ','MOUNT WYATT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5956,5943,6,'4804    ','NEWLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5957,5944,6,'4804    ','SPRINGLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5958,5945,6,'4805    ','BOGIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5959,5946,6,'4805    ','BOWEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5960,5947,6,'4805    ','GUTHALUNGRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5961,5948,6,'4805    ','MERINDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5962,5949,6,'4805    ','QUEENS BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5963,5950,6,'4806    ','HOME HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5964,5951,6,'4807    ','AYR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5965,5952,6,'4807    ','CLAREDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5966,5953,6,'4807    ','PARKSIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5967,5954,6,'4808    ','BRANDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5968,5955,6,'4809    ','GIRU');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5969,5956,6,'4810    ','BELGIAN GARDENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5970,5957,6,'4810    ','CASTLE HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5971,5958,6,'4810    ','NORTH WARD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5972,5959,6,'4810    ','PALLARENDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5973,5960,6,'4810    ','RAILWAY ESTATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5974,5961,6,'4810    ','ROWES BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5975,5962,6,'4810    ','SOUTH TOWNSVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5976,5963,6,'4810    ','TOWNSVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5977,5964,6,'4810    ','WEST END');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5978,5965,6,'4811    ','CLUDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5979,5966,6,'4811    ','IDALIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5980,5967,6,'4811    ','JAMES COOK UNIVERSITY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5981,5968,6,'4811    ','OAK VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5982,5969,6,'4811    ','OONOONBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5983,5970,6,'4811    ','ROSENEATH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5984,5971,6,'4811    ','STUART');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5985,5972,6,'4811    ','WULGURU');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5986,5973,6,'4812    ','CURRAJONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5987,5974,6,'4812    ','GULLIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5988,5975,6,'4812    ','HERMIT PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5989,5976,6,'4812    ','HYDE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5990,5977,6,'4812    ','MUNDINGBURRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5991,5978,6,'4812    ','MYSTERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5992,5979,6,'4812    ','PIMLICO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5993,5980,6,'4812    ','ROSSLEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5994,5981,6,'4813    ','LAVARACK BARRACKS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5995,5982,6,'4813    ','TOWNSVILLE MILPO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5996,5983,6,'4814    ','AITKENVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5997,5984,6,'4814    ','ANNANDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5998,5985,6,'4814    ','CRANBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (5999,5986,6,'4814    ','DOUGLAS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6000,5987,6,'4814    ','GARBUTT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6001,5988,6,'4814    ','HEATLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6002,5989,6,'4814    ','MOUNT LOUISA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6003,5990,6,'4814    ','MURRAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6004,5991,6,'4814    ','VINCENT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6005,5992,6,'4815    ','CONDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6006,5993,6,'4815    ','KELSO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6007,5994,6,'4815    ','RASMUSSEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6008,5995,6,'4816    ','ALLIGATOR CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6009,5996,6,'4816    ','CUNGULLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6010,5997,6,'4816    ','DUNK ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6011,5998,6,'4816    ','GREENVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6012,5999,6,'4816    ','HIDDEN VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6013,6000,6,'4816    ','HOMESTEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6014,6001,6,'4816    ','JULAGO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6015,6002,6,'4816    ','KENNEDY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6016,6003,6,'4816    ','MACROSSAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6017,6004,6,'4816    ','MAXWELTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6018,6005,6,'4816    ','MINGELA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6019,6006,6,'4816    ','MUTARNEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6020,6007,6,'4816    ','NELIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6021,6008,6,'4816    ','NOME');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6022,6009,6,'4816    ','PALM ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6023,6010,6,'4816    ','PALUMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6024,6011,6,'4816    ','PENTLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6025,6012,6,'4816    ','PRAIRIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6026,6013,6,'4816    ','RAVENSWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6027,6014,6,'4816    ','ROLLINGSTONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6028,6015,6,'4816    ','SELLHEIM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6029,6016,6,'4816    ','TORRENS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6030,6017,6,'4816    ','WOODSTOCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6031,6018,6,'4817    ','ALICE RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6032,6019,6,'4817    ','BOHLE PLAINS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6033,6020,6,'4817    ','KIRWAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6034,6021,6,'4817    ','RUPERTSWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6035,6022,6,'4817    ','THURINGOWA CENTRAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6036,6023,6,'4818    ','BLACK RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6037,6024,6,'4818    ','BLUEWATER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6038,6025,6,'4818    ','BLUEWATER PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6039,6026,6,'4818    ','BOHLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6040,6027,6,'4818    ','BUSHLAND BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6041,6028,6,'4818    ','DEERAGUN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6042,6029,6,'4818    ','SAUNDERS BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6043,6030,6,'4818    ','TOOLAKEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6044,6031,6,'4818    ','YABULU');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6045,6032,6,'4819    ','ARCADIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6046,6033,6,'4819    ','HORSESHOE BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6047,6034,6,'4819    ','MAGNETIC ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6048,6035,6,'4819    ','NELLY BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6049,6036,6,'4819    ','PICNIC BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6050,6037,6,'4820    ','CHARTERS TOWERS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6051,6038,6,'4820    ','QUEENTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6052,6039,6,'4820    ','RICHMOND HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6053,6040,6,'4821    ','HUGHENDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6054,6041,6,'4821    ','STAMFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6055,6042,6,'4822    ','RICHMOND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6056,6043,6,'4823    ','JULIA CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6057,6044,6,'4823    ','KYNUNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6058,6045,6,'4823    ','MCKINLAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6059,6046,6,'4824    ','CLONCURRY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6060,6047,6,'4824    ','OORINDI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6061,6048,6,'4825    ','BREAKAWAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6062,6049,6,'4825    ','DAJARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6063,6050,6,'4825    ','FISHER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6064,6051,6,'4825    ','HAPPY VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6065,6052,6,'4825    ','HEALY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6066,6053,6,'4825    ','MENZIES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6067,6054,6,'4825    ','MICA CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6068,6055,6,'4825    ','MILES END');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6069,6056,6,'4825    ','MOUNT ISA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6070,6057,6,'4825    ','PARKSIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6071,6058,6,'4825    ','PIONEER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6072,6059,6,'4825    ','RYAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6073,6060,6,'4825    ','SOLDIERS HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6074,6061,6,'4825    ','SUNSET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6075,6062,6,'4825    ','THE GAP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6076,6063,6,'4825    ','THE MONUMENT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6077,6064,6,'4825    ','TOWNVIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6078,6065,6,'4825    ','WINSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6079,6066,6,'4828    ','CAMOOWEAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6080,6067,6,'4829    ','BEDOURIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6081,6068,6,'4829    ','BOULIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6082,6069,6,'4830    ','BURKETOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6083,6070,6,'4830    ','DOOMADGEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6084,6071,6,'4849    ','CARDWELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6085,6072,6,'4850    ','ABERGOWRIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6086,6073,6,'4850    ','ALLINGHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6087,6074,6,'4850    ','HALIFAX');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6088,6075,6,'4850    ','INGHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6089,6076,6,'4850    ','LUCINDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6090,6077,6,'4850    ','MACKNADE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6091,6078,6,'4850    ','TAYLORS BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6092,6079,6,'4850    ','UPPER STONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6093,6080,6,'4850    ','VICTORIA ESTATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6094,6081,6,'4852    ','BINGIL BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6095,6082,6,'4852    ','CLUMP POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6096,6083,6,'4852    ','MISSION BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6097,6084,6,'4852    ','SOUTH MISSION BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6098,6085,6,'4852    ','WONGALING BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6099,6086,6,'4854    ','CARDSTONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6100,6087,6,'4854    ','EURAMO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6101,6088,6,'4854    ','MURRAY UPPER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6102,6089,6,'4854    ','TULLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6103,6090,6,'4855    ','EL ARISH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6104,6091,6,'4856    ','SILKWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6105,6092,6,'4857    ','SILKWOOD EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6106,6093,6,'4858    ','MOURILYAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6107,6094,6,'4859    ','SOUTH JOHNSTONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6108,6095,6,'4860    ','CULLINANE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6109,6096,6,'4860    ','FLYING FISH POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6110,6097,6,'4860    ','GARRADUNGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6111,6098,6,'4860    ','GOONDI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6112,6099,6,'4860    ','INNISFAIL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6113,6100,6,'4860    ','SUNDOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6114,6101,6,'4861    ','BABINDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6115,6102,6,'4861    ','BARTLE FRERE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6116,6103,6,'4865    ','GORDONVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6117,6104,6,'4868    ','BAYVIEW HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6118,6105,6,'4868    ','TARRAWARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6119,6106,6,'4868    ','WHITE ROCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6120,6107,6,'4868    ','WOREE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6121,6108,6,'4869    ','CENTENARY PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6122,6109,6,'4869    ','EDMONTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6123,6110,6,'4870    ','AEROGLEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6124,6111,6,'4870    ','BRINSMEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6125,6112,6,'4870    ','BUNGALOW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6126,6113,6,'4870    ','CAIRNS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6127,6114,6,'4870    ','CAIRNS NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6128,6115,6,'4870    ','CAIRNS ORCHID PLAZA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6129,6116,6,'4870    ','EARLVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6130,6117,6,'4870    ','EDGE HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6131,6118,6,'4870    ','FRESHWATER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6132,6119,6,'4870    ','KAMERUNGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6133,6120,6,'4870    ','KANIMBLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6134,6121,6,'4870    ','MANOORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6135,6122,6,'4870    ','MANUNDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6136,6123,6,'4870    ','MARTYNVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6137,6124,6,'4870    ','MOOROOBOOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6138,6125,6,'4870    ','PARRAMATTA PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6139,6126,6,'4870    ','REDLYNCH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6140,6127,6,'4870    ','STRATFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6141,6128,6,'4870    ','WESTCOURT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6142,6129,6,'4870    ','WHITFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6143,6130,6,'4871    ','ALMADEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6144,6131,6,'4871    ','ALOOMBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6145,6132,6,'4871    ','AURUKUN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6146,6133,6,'4871    ','BELLENDEN KER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6147,6134,6,'4871    ','BOOGAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6148,6135,6,'4871    ','CHILLAGOE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6149,6136,6,'4871    ','COEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6150,6137,6,'4871    ','COOKTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6151,6138,6,'4871    ','COWLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6152,6139,6,'4871    ','CROYDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6153,6140,6,'4871    ','DEERAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6154,6141,6,'4871    ','EDWARD RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6155,6142,6,'4871    ','EINASLEIGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6156,6143,6,'4871    ','FISHERY FALLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6157,6144,6,'4871    ','FORSAYTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6158,6145,6,'4871    ','FOUR MILE BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6159,6146,6,'4871    ','GEORGETOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6160,6147,6,'4871    ','GLEN BOUGHTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6161,6148,6,'4871    ','GREEN ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6162,6149,6,'4871    ','GUNUNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6163,6150,6,'4871    ','HOPE VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6164,6151,6,'4871    ','JULATTEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6165,6152,6,'4871    ','KIDSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6166,6153,6,'4871    ','KOWANYAMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6167,6154,6,'4871    ','KURRIMINE BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6168,6155,6,'4871    ','LAURA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6169,6156,6,'4871    ','LOCKHART RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6170,6157,6,'4871    ','MENA CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6171,6158,6,'4871    ','MIRIWINNI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6172,6159,6,'4871    ','MOUNT CARBINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6173,6160,6,'4871    ','MOUNT MOLLOY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6174,6161,6,'4871    ','MOUNT SURPRISE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6175,6162,6,'4871    ','PORMPURAAW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6176,6163,6,'4871    ','PORT DOUGLAS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6177,6164,6,'4871    ','WANGAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6178,6165,6,'4871    ','WANGETTI BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6179,6166,6,'4871    ','YARRABAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6180,6167,6,'4872    ','DIMBULAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6181,6168,6,'4872    ','EVELYN CENTRAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6182,6169,6,'4872    ','HERBERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6183,6170,6,'4872    ','INNOT HOT SPRINGS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6184,6171,6,'4872    ','IRVINEBANK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6185,6172,6,'4872    ','KAIRI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6186,6173,6,'4872    ','KURANDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6187,6174,6,'4872    ','MOUNT GARNET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6188,6175,6,'4872    ','MUTCHILBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6189,6176,6,'4872    ','RAVENSHOE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6190,6177,6,'4872    ','TUMOULIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6191,6178,6,'4872    ','WALKAMIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6192,6179,6,'4872    ','YUNGABURRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6193,6180,6,'4873    ','DAINTREE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6194,6181,6,'4873    ','MOSSMAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6195,6182,6,'4873    ','NEWELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6196,6183,6,'4873    ','WONGA BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6197,6184,6,'4874    ','WEIPA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6198,6185,6,'4875    ','BADU ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6199,6186,6,'4875    ','THURSDAY ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6200,6187,6,'4876    ','BAMAGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6201,6188,6,'4878    ','CARAVONICA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6202,6189,6,'4878    ','HOLLOWAYS BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6203,6190,6,'4878    ','LAKE PLACID');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6204,6191,6,'4878    ','MACHANS BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6205,6192,6,'4878    ','SMITHFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6206,6193,6,'4878    ','SMITHFIELD HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6207,6194,6,'4878    ','YORKEYS KNOB');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6208,6195,6,'4879    ','CLIFTON BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6209,6196,6,'4879    ','ELLIS BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6210,6197,6,'4879    ','KEWARRA BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6211,6198,6,'4879    ','PALM COVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6212,6199,6,'4879    ','TRINITY BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6213,6200,6,'4879    ','TRINITY PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6214,6201,6,'4880    ','MAREEBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6215,6202,6,'4882    ','TOLGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6216,6203,6,'4883    ','ATHERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6217,6204,6,'4885    ','MALANDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6218,6205,6,'4886    ','MILLAA MILLAA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6219,6206,6,'4890    ','NORMANTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6220,6207,6,'4891    ','KARUMBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6221,6208,4,'5000    ','ADELAIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6222,6209,4,'5000    ','ADELAIDE BC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6223,6210,4,'5000    ','HALIFAX STREET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6224,6211,4,'5000    ','HUTT STREET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6225,6212,4,'5000    ','RUNDLE MALL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6226,6213,4,'5000    ','STATION ARCADE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6227,6214,4,'5001    ','ADELAIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6228,6215,4,'5005    ','ADELAIDE UNIVERSITY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6229,6216,4,'5005    ','THE UNIVERSITY OF ADELAIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6230,6217,4,'5006    ','NORTH ADELAIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6231,6218,4,'5007    ','BOWDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6232,6219,4,'5007    ','BROMPTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6233,6220,4,'5007    ','HINDMARSH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6234,6221,4,'5007    ','WELLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6235,6222,4,'5008    ','CROYDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6236,6223,4,'5008    ','DEVON PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6237,6224,4,'5008    ','DUDLEY PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6238,6225,4,'5008    ','RENOWN PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6239,6226,4,'5008    ','RIDLEYTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6240,6227,4,'5009    ','ALLENBY GARDENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6241,6228,4,'5009    ','BEVERLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6242,6229,4,'5009    ','KILKENNY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6243,6230,4,'5010    ','ANGLE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6244,6231,4,'5010    ','FERRYDEN PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6245,6232,4,'5010    ','REGENCY PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6246,6233,4,'5010    ','REGENCY PARK BC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6247,6234,4,'5011    ','WOODVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6248,6235,4,'5012    ','ATHOL PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6249,6236,4,'5012    ','MANSFIELD PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6250,6237,4,'5012    ','WOODVILLE GARDENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6251,6238,4,'5012    ','WOODVILLE NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6252,6239,4,'5013    ','GILLMAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6253,6240,4,'5013    ','OTTOWAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6254,6241,4,'5013    ','PENNINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6255,6242,4,'5013    ','ROSEWATER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6256,6243,4,'5013    ','ROSEWATER EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6257,6244,4,'5013    ','WINGFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6258,6245,4,'5014    ','ALBERT PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6259,6246,4,'5014    ','ALBERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6260,6247,4,'5014    ','CHELTENHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6261,6248,4,'5014    ','HENDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6262,6249,4,'5014    ','QUEENSTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6263,6250,4,'5014    ','ROYAL PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6264,6251,4,'5015    ','BIRKENHEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6265,6252,4,'5015    ','ETHELTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6266,6253,4,'5015    ','GLANVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6267,6254,4,'5015    ','PORT ADELAIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6268,6255,4,'5016    ','LARGS BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6269,6256,4,'5016    ','LARGS NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6270,6257,4,'5016    ','PETERHEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6271,6258,4,'5017    ','OSBORNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6272,6259,4,'5017    ','TAPEROO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6273,6260,4,'5018    ','NORTH HAVEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6274,6261,4,'5018    ','OUTER HARBOR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6275,6262,4,'5019    ','EXETER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6276,6263,4,'5019    ','SEMAPHORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6277,6264,4,'5020    ','WEST LAKES SHORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6278,6265,4,'5021    ','WEST LAKES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6279,6266,4,'5022    ','GRANGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6280,6267,4,'5022    ','HENLEY BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6281,6268,4,'5022    ','HENLEY BEACH SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6282,6269,4,'5022    ','TENNYSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6283,6270,4,'5023    ','FINDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6284,6271,4,'5023    ','SEATON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6285,6272,4,'5024    ','FULHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6286,6273,4,'5024    ','FULHAM GARDENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6287,6274,4,'5024    ','WEST BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6288,6275,4,'5025    ','FLINDERS PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6289,6276,4,'5025    ','KIDMAN PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6290,6277,4,'5031    ','MILE END');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6291,6278,4,'5031    ','THEBARTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6292,6279,4,'5031    ','TORRENSVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6293,6280,4,'5031    ','TORRENSVILLE PLAZA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6294,6281,4,'5032    ','BROOKLYN PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6295,6282,4,'5032    ','LOCKLEYS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6296,6283,4,'5032    ','UNDERDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6297,6284,4,'5033    ','COWANDILLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6298,6285,4,'5033    ','HILTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6299,6286,4,'5033    ','MARLESTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6300,6287,4,'5033    ','RICHMOND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6301,6288,4,'5033    ','WEST RICHMOND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6302,6289,4,'5034    ','CLARENCE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6303,6290,4,'5034    ','GOODWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6304,6291,4,'5034    ','KINGS PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6305,6292,4,'5034    ','MILLSWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6306,6293,4,'5034    ','WAYVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6307,6294,4,'5035    ','ASHFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6308,6295,4,'5035    ','BLACK FOREST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6309,6296,4,'5035    ','EVERARD PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6310,6297,4,'5035    ','FORESTVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6311,6298,4,'5035    ','KESWICK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6312,6299,4,'5037    ','GLANDORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6313,6300,4,'5037    ','KURRALTA PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6314,6301,4,'5037    ','NETLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6315,6302,4,'5037    ','NORTH PLYMPTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6316,6303,4,'5038    ','CAMDEN PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6317,6304,4,'5038    ','PLYMPTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6318,6305,4,'5038    ','PLYMPTON PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6319,6306,4,'5038    ','SOUTH PLYMPTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6320,6307,4,'5039    ','CLARENCE GARDENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6321,6308,4,'5039    ','EDWARDSTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6322,6309,4,'5039    ','MELROSE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6323,6310,4,'5040    ','NOVAR GARDENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6324,6311,4,'5041    ','COLONEL LIGHT GARDENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6325,6312,4,'5041    ','CUMBERLAND PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6326,6313,4,'5041    ','DAW PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6327,6314,4,'5041    ','PANORAMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6328,6315,4,'5041    ','WESTBOURNE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6329,6316,4,'5042    ','BEDFORD PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6330,6317,4,'5042    ','CLOVELLY PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6331,6318,4,'5042    ','FLINDERS UNIVERSITY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6332,6319,4,'5042    ','PASADENA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6333,6320,4,'5042    ','ST MARYS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6334,6321,4,'5043    ','ASCOT PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6335,6322,4,'5043    ','MARION');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6336,6323,4,'5043    ','MITCHELL PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6337,6324,4,'5043    ','MORPHETTVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6338,6325,4,'5043    ','PARK HOLME');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6339,6326,4,'5044    ','GLENGOWRIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6340,6327,4,'5044    ','SOMERTON PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6341,6328,4,'5045    ','GLENELG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6342,6329,4,'5045    ','GLENELG SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6343,6330,4,'5046    ','OAKLANDS PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6344,6331,4,'5046    ','WARRADALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6345,6332,4,'5046    ','WARRADALE NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6346,6333,4,'5047    ','DARLINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6347,6334,4,'5047    ','SEACOMBE GARDENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6348,6335,4,'5047    ','SEACOMBE HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6349,6336,4,'5047    ','STURT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6350,6337,4,'5048    ','BRIGHTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6351,6338,4,'5048    ','DOVER GARDENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6352,6339,4,'5048    ','HOVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6353,6340,4,'5048    ','SOUTH BRIGHTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6354,6341,4,'5049    ','KINGSTON PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6355,6342,4,'5049    ','MARINO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6356,6343,4,'5049    ','SEACLIFF');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6357,6344,4,'5049    ','SEACLIFF PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6358,6345,4,'5049    ','SEAVIEW DOWNS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6359,6346,4,'5050    ','BELLEVUE HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6360,6347,4,'5050    ','EDEN HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6361,6348,4,'5051    ','BLACKWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6362,6349,4,'5051    ','COROMANDEL VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6363,6350,4,'5051    ','CRAIGBURN FARM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6364,6351,4,'5051    ','HAWTHORNDENE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6365,6352,4,'5052    ','BELAIR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6366,6353,4,'5052    ','GLENALTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6367,6354,4,'5061    ','HYDE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6368,6355,4,'5061    ','MALVERN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6369,6356,4,'5061    ','UNLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6370,6357,4,'5062    ','BROWN HILL CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6371,6358,4,'5062    ','CLAPHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6372,6359,4,'5062    ','HAWTHORN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6373,6360,4,'5062    ','KINGSWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6374,6361,4,'5062    ','LOWER MITCHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6375,6362,4,'5062    ','LYNTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6376,6363,4,'5062    ','MITCHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6377,6364,4,'5062    ','MITCHAM SHOPPING CENTRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6378,6365,4,'5062    ','NETHERBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6379,6366,4,'5062    ','SPRINGFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6380,6367,4,'5062    ','TORRENS PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6381,6368,4,'5063    ','EASTWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6382,6369,4,'5063    ','FREWVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6383,6370,4,'5063    ','FULLARTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6384,6371,4,'5063    ','HIGHGATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6385,6372,4,'5063    ','PARKSIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6386,6373,4,'5064    ','GLEN OSMOND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6387,6374,4,'5064    ','GLENUNGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6388,6375,4,'5064    ','MOUNT OSMOND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6389,6376,4,'5064    ','MYRTLE BANK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6390,6377,4,'5064    ','ST GEORGES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6391,6378,4,'5064    ','URRBRAE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6392,6379,4,'5065    ','DULWICH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6393,6380,4,'5065    ','GLENSIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6394,6381,4,'5065    ','LINDEN PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6395,6382,4,'5065    ','TOORAK GARDENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6396,6383,4,'5065    ','TUSMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6397,6384,4,'5066    ','BEAUMONT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6398,6385,4,'5066    ','BURNSIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6399,6386,4,'5066    ','ERINDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6400,6387,4,'5066    ','HAZELWOOD PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6401,6388,4,'5066    ','STONYFELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6402,6389,4,'5066    ','WATERFALL GULLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6403,6390,4,'5066    ','WATTLE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6404,6391,4,'5067    ','BEULAH PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6405,6392,4,'5067    ','KENT TOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6406,6393,4,'5067    ','NORWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6407,6394,4,'5067    ','NORWOOD SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6408,6395,4,'5067    ','ROSE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6409,6396,4,'5068    ','HEATHPOOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6410,6397,4,'5068    ','KENSINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6411,6398,4,'5068    ','KENSINGTON GARDENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6412,6399,4,'5068    ','KENSINGTON PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6413,6400,4,'5068    ','LEABROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6414,6401,4,'5068    ','MARRYATVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6415,6402,4,'5068    ','ST MORRIS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6416,6403,4,'5068    ','TRINITY GARDENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6417,6404,4,'5069    ','COLLEGE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6418,6405,4,'5069    ','EVANDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6419,6406,4,'5069    ','HACKNEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6420,6407,4,'5069    ','MAYLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6421,6408,4,'5069    ','ST PETERS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6422,6409,4,'5069    ','STEPNEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6423,6410,4,'5070    ','FELIXSTOW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6424,6411,4,'5070    ','FIRLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6425,6412,4,'5070    ','GLYNDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6426,6413,4,'5070    ','GLYNDE PLAZA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6427,6414,4,'5070    ','JOSLIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6428,6415,4,'5070    ','MARDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6429,6416,4,'5070    ','PAYNEHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6430,6417,4,'5070    ','ROYSTON PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6431,6418,4,'5071    ','KENT TOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6432,6419,4,'5072    ','AULDANA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6433,6420,4,'5072    ','MAGILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6434,6421,4,'5072    ','MAGILL NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6435,6422,4,'5072    ','ROSSLYN PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6436,6423,4,'5072    ','SKYE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6437,6424,4,'5072    ','TERINGIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6438,6425,4,'5072    ','WOODFORDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6439,6426,4,'5073    ','HECTORVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6440,6427,4,'5073    ','ROSTREVOR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6441,6428,4,'5073    ','TRANMERE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6442,6429,4,'5073    ','TRANMERE NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6443,6430,4,'5074    ','CAMPBELLTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6444,6431,4,'5074    ','NEWTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6445,6432,4,'5075    ','DERNANCOURT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6446,6433,4,'5075    ','PARADISE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6447,6434,4,'5076    ','ATHELSTONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6448,6435,4,'5076    ','CASTAMBUL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6449,6436,4,'5081    ','COLLINSWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6450,6437,4,'5081    ','GILBERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6451,6438,4,'5081    ','MEDINDIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6452,6439,4,'5081    ','VALE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6453,6440,4,'5081    ','WALKERVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6454,6441,4,'5082    ','FITZROY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6455,6442,4,'5082    ','OVINGHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6456,6443,4,'5082    ','PROSPECT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6457,6444,4,'5082    ','PROSPECT EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6458,6445,4,'5082    ','THORNGATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6459,6446,4,'5083    ','BROADVIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6460,6447,4,'5083    ','NAILSWORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6461,6448,4,'5083    ','SEFTON PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6462,6449,4,'5084    ','BLAIR ATHOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6463,6450,4,'5084    ','BLAIR ATHOL WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6464,6451,4,'5084    ','KILBURN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6465,6452,4,'5084    ','KILBURN NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6466,6453,4,'5085    ','CLEARVIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6467,6454,4,'5085    ','ENFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6468,6455,4,'5085    ','ENFIELD PLAZA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6469,6456,4,'5085    ','NORTHFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6470,6457,4,'5085    ','NORTHGATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6471,6458,4,'5086    ','GILLES PLAINS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6472,6459,4,'5086    ','GREENACRES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6473,6460,4,'5086    ','HAMPSTEAD GARDENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6474,6461,4,'5086    ','HILLCREST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6475,6462,4,'5086    ','MANNINGHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6476,6463,4,'5086    ','OAKDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6477,6464,4,'5087    ','KLEMZIG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6478,6465,4,'5087    ','WINDSOR GARDENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6479,6466,4,'5088    ','HOLDEN HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6480,6467,4,'5089    ','HIGHBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6481,6468,4,'5090    ','HOPE VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6482,6469,4,'5091    ','BANKSIA PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6483,6470,4,'5091    ','TEA TREE GULLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6484,6471,4,'5091    ','VISTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6485,6472,4,'5092    ','MODBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6486,6473,4,'5092    ','MODBURY NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6487,6474,4,'5093    ','PARA VISTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6488,6475,4,'5093    ','VALLEY VIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6489,6476,4,'5094    ','CAVAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6490,6477,4,'5094    ','DRY CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6491,6478,4,'5094    ','GEPPS CROSS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6492,6479,4,'5095    ','MAWSON LAKES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6493,6480,4,'5095    ','POORAKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6494,6481,4,'5095    ','THE LEVELS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6495,6482,4,'5096    ','GULFVIEW HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6496,6483,4,'5096    ','PARA HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6497,6484,4,'5097    ','REDWOOD PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6498,6485,4,'5097    ','RIDGEHAVEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6499,6486,4,'5097    ','ST AGNES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6500,6487,4,'5098    ','INGLE FARM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6501,6488,4,'5098    ','WALKLEY HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6502,6489,4,'5106    ','PARAFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6503,6490,4,'5106    ','SALISBURY SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6504,6491,4,'5107    ','GREEN FIELDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6505,6492,4,'5107    ','PARAFIELD GARDENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6506,6493,4,'5108    ','PARALOWIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6507,6494,4,'5108    ','SALISBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6508,6495,4,'5108    ','SALISBURY DOWNS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6509,6496,4,'5108    ','SALISBURY NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6510,6497,4,'5109    ','BRAHMA LODGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6511,6498,4,'5109    ','SALISBURY EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6512,6499,4,'5109    ','SALISBURY HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6513,6500,4,'5109    ','SALISBURY PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6514,6501,4,'5109    ','SALISBURY PLAIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6515,6502,4,'5110    ','BOLIVAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6516,6503,4,'5110    ','BURTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6517,6504,4,'5110    ','DIREK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6518,6505,4,'5110    ','GLOBE DERBY PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6519,6506,4,'5110    ','ST KILDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6520,6507,4,'5110    ','WATERLOO CORNER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6521,6508,4,'5111    ','EDINBURGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6522,6509,4,'5112    ','ELIZABETH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6523,6510,4,'5112    ','ELIZABETH EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6524,6511,4,'5112    ','ELIZABETH SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6525,6512,4,'5112    ','ELIZABETH VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6526,6513,4,'5112    ','HILLBANK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6527,6514,4,'5113    ','DAVOREN PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6528,6515,4,'5113    ','ELIZABETH DOWNS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6529,6516,4,'5113    ','ELIZABETH NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6530,6517,4,'5113    ','ELIZABETH PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6531,6518,4,'5113    ','ELIZABETH WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6532,6519,4,'5114    ','ANDREWS FARM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6533,6520,4,'5114    ','BLAKEVIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6534,6521,4,'5114    ','CRAIGMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6535,6522,4,'5114    ','ONE TREE HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6536,6523,4,'5114    ','SMITHFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6537,6524,4,'5114    ','SMITHFIELD PLAINS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6538,6525,4,'5114    ','ULEYBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6539,6526,4,'5115    ','KUDLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6540,6527,4,'5115    ','MUNNO PARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6541,6528,4,'5116    ','EVANSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6542,6529,4,'5116    ','HILLIER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6543,6530,4,'5117    ','ANGLE VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6544,6531,4,'5118    ','BUCHFELDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6545,6532,4,'5118    ','GAWLER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6546,6533,4,'5118    ','GAWLER BELT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6547,6534,4,'5118    ','HEWETT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6548,6535,4,'5118    ','KALBEEBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6549,6536,4,'5118    ','KINGSFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6550,6537,4,'5118    ','WILLASTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6551,6538,4,'5120    ','BUCKLAND PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6552,6539,4,'5120    ','VIRGINIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6553,6540,4,'5121    ','MACDONALD PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6554,6541,4,'5121    ','PENFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6555,6542,4,'5125    ','GOLDEN GROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6556,6543,4,'5125    ','GOLDEN GROVE VILLAGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6557,6544,4,'5125    ','GREENWITH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6558,6545,4,'5126    ','FAIRVIEW PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6559,6546,4,'5126    ','SURREY DOWNS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6560,6547,4,'5126    ','YATALA VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6561,6548,4,'5127    ','WYNN VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6562,6549,4,'5131    ','HOUGHTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6563,6550,4,'5131    ','LOWER HERMITAGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6564,6551,4,'5131    ','UPPER HERMITAGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6565,6552,4,'5132    ','PARACOMBE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6566,6553,4,'5133    ','INGLEWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6567,6554,4,'5134    ','CHERRYVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6568,6555,4,'5134    ','MONTACUTE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6569,6556,4,'5136    ','NORTON SUMMIT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6570,6557,4,'5137    ','ASHTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6571,6558,4,'5138    ','BASKET RANGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6572,6559,4,'5139    ','FOREST RANGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6573,6560,4,'5140    ','GREENHILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6574,6561,4,'5141    ','SUMMERTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6575,6562,4,'5142    ','URAIDLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6576,6563,4,'5144    ','CAREY GULLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6577,6564,4,'5150    ','EAGLE ON THE HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6578,6565,4,'5150    ','LEAWOOD GARDENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6579,6566,4,'5151    ','PICCADILLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6580,6567,4,'5152    ','CRAFERS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6581,6568,4,'5152    ','STIRLING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6582,6569,4,'5153    ','BIGGS FLAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6583,6570,4,'5153    ','BRADBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6584,6571,4,'5153    ','ECHUNGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6585,6572,4,'5153    ','FLAXLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6586,6573,4,'5153    ','HEATHFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6587,6574,4,'5153    ','IRONBANK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6588,6575,4,'5153    ','LONGWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6589,6576,4,'5153    ','MACCLESFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6590,6577,4,'5153    ','MYLOR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6591,6578,4,'5153    ','SCOTT CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6592,6579,4,'5154    ','ALDGATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6593,6580,4,'5155    ','BRIDGEWATER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6594,6581,4,'5155    ','MOUNT GEORGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6595,6582,4,'5156    ','UPPER STURT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6596,6583,4,'5157    ','ASHBOURNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6597,6584,4,'5157    ','CHERRY GARDENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6598,6585,4,'5157    ','CLARENDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6599,6586,4,'5157    ','COROMANDEL EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6600,6587,4,'5157    ','KANGARILLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6601,6588,4,'5158    ','HALLETT COVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6602,6589,4,'5158    ','O''HALLORAN HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6603,6590,4,'5158    ','SHEIDOW PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6604,6591,4,'5158    ','TROTT PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6605,6592,4,'5159    ','ABERFOYLE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6606,6593,4,'5159    ','CHANDLERS HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6607,6594,4,'5159    ','FLAGSTAFF HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6608,6595,4,'5159    ','HAPPY VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6609,6596,4,'5160    ','LONSDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6610,6597,4,'5161    ','REYNELLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6611,6598,4,'5162    ','MORPHETT VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6612,6599,4,'5162    ','WOODCROFT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6613,6600,4,'5163    ','HACKHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6614,6601,4,'5163    ','HUNTFIELD HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6615,6602,4,'5163    ','ONKAPARINGA HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6616,6603,4,'5164    ','CHRISTIE DOWNS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6617,6604,4,'5165    ','CHRISTIES BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6618,6605,4,'5165    ','CHRISTIES BEACH NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6619,6606,4,'5166    ','O''SULLIVAN BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6620,6607,4,'5167    ','PORT NOARLUNGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6621,6608,4,'5168    ','NOARLUNGA CENTRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6622,6609,4,'5168    ','NOARLUNGA DOWNS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6623,6610,4,'5168    ','OLD NOARLUNGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6624,6611,4,'5169    ','MOANA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6625,6612,4,'5169    ','SEAFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6626,6613,4,'5169    ','SEAFORD HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6627,6614,4,'5169    ','SEAFORD MEADOWS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6628,6615,4,'5170    ','MASLIN BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6629,6616,4,'5171    ','MCLAREN FLAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6630,6617,4,'5171    ','MCLAREN VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6631,6618,4,'5171    ','PEDLER CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6632,6619,4,'5172    ','WILLUNGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6633,6620,4,'5173    ','ALDINGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6634,6621,4,'5173    ','ALDINGA BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6635,6622,4,'5173    ','PORT WILLUNGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6636,6623,4,'5174    ','SELLICKS BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6637,6624,4,'5174    ','SELLICKS HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6638,6625,4,'5201    ','MEADOWS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6639,6626,4,'5202    ','MYPONGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6640,6627,4,'5203    ','YANKALILLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6641,6628,4,'5204    ','CARRICKALINGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6642,6629,4,'5204    ','DELAMERE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6643,6630,4,'5204    ','NORMANVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6644,6631,4,'5204    ','RAPID BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6645,6632,4,'5204    ','SECOND VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6646,6633,4,'5210    ','MOUNT COMPASS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6647,6634,4,'5211    ','ENCOUNTER BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6648,6635,4,'5211    ','HAYBOROUGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6649,6636,4,'5211    ','INMAN VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6650,6637,4,'5211    ','MCCRACKEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6651,6638,4,'5211    ','VICTOR HARBOR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6652,6639,4,'5212    ','PORT ELLIOT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6653,6640,4,'5213    ','MIDDLETON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6654,6641,4,'5214    ','CURRENCY CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6655,6642,4,'5214    ','GOOLWA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6656,6643,4,'5220    ','PARNDANA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6657,6644,4,'5221    ','AMERICAN RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6658,6645,4,'5222    ','PENNESHAW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6659,6646,4,'5223    ','KINGSCOTE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6660,6647,4,'5231    ','KERSBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6661,6648,4,'5232    ','CUDLEE CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6662,6649,4,'5233    ','GUMERACHA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6663,6650,4,'5234    ','BIRDWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6664,6651,4,'5235    ','EDEN VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6665,6652,4,'5235    ','MOUNT PLEASANT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6666,6653,4,'5235    ','SPRINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6667,6654,4,'5236    ','TUNGKILLO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6668,6655,4,'5237    ','PALMER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6669,6656,4,'5237    ','SANDERSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6670,6657,4,'5238    ','BOWHILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6671,6658,4,'5238    ','MANNUM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6672,6659,4,'5238    ','NILDOTTIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6673,6660,4,'5240    ','LENSWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6674,6661,4,'5241    ','LOBETHAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6675,6662,4,'5242    ','BALHANNAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6676,6663,4,'5243    ','OAKBANK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6677,6664,4,'5244    ','CHARLESTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6678,6665,4,'5244    ','MOUNT TORRENS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6679,6666,4,'5244    ','WOODSIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6680,6667,4,'5245    ','HAHNDORF');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6681,6668,4,'5245    ','VERDUN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6682,6669,4,'5250    ','LITTLEHAMPTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6683,6670,4,'5251    ','MOUNT BARKER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6684,6671,4,'5251    ','WISTOW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6685,6672,4,'5252    ','BRUKUNGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6686,6673,4,'5252    ','KANMANTOO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6687,6674,4,'5252    ','NAIRNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6688,6675,4,'5253    ','MURRAY BRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6689,6676,4,'5253    ','MURRAY BRIDGE EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6690,6677,4,'5253    ','MURRAY BRIDGE SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6691,6678,4,'5254    ','CALLINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6692,6679,4,'5254    ','MONARTO SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6693,6680,4,'5254    ','MURRAY BRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6694,6681,4,'5254    ','MYPOLONGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6695,6682,4,'5255    ','FINNISS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6696,6683,4,'5255    ','LANGHORNE CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6697,6684,4,'5255    ','STRATHALBYN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6698,6685,4,'5256    ','CLAYTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6699,6686,4,'5256    ','MILANG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6700,6687,4,'5259    ','JERVOIS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6701,6688,4,'5259    ','NARRUNG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6702,6689,4,'5259    ','POINT MCLEAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6703,6690,4,'5259    ','RAUKKAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6704,6691,4,'5259    ','WELLINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6705,6692,4,'5260    ','TAILEM BEND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6706,6693,4,'5261    ','COOKE PLAINS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6707,6694,4,'5261    ','COOMANDOOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6708,6695,4,'5261    ','CULBURRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6709,6696,4,'5261    ','KI KI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6710,6697,4,'5261    ','YUMALI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6711,6698,4,'5262    ','BINNUM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6712,6699,4,'5262    ','FRANCES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6713,6700,4,'5262    ','HYNAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6714,6701,4,'5262    ','KYBYBOLITE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6715,6702,4,'5263    ','COONAWARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6716,6703,4,'5264    ','MENINGIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6717,6704,4,'5265    ','COONALPYN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6718,6705,4,'5266    ','TINTINARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6719,6706,4,'5267    ','KEITH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6720,6707,4,'5268    ','BORDERTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6721,6708,4,'5269    ','WOLSELEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6722,6709,4,'5270    ','MUNDULLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6723,6710,4,'5271    ','NARACOORTE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6724,6711,4,'5271    ','PADTHAWAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6725,6712,4,'5272    ','GREENWAYS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6726,6713,4,'5272    ','LUCINDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6727,6714,4,'5273    ','AVENUE RANGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6728,6715,4,'5275    ','KINGSTON SE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6729,6716,4,'5276    ','ROBE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6730,6717,4,'5277    ','NANGWARRY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6731,6718,4,'5277    ','PENOLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6732,6719,4,'5277    ','TARPEENA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6733,6720,4,'5278    ','KALANGADOO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6734,6721,4,'5279    ','MOUNT BURR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6735,6722,4,'5279    ','TRIHI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6736,6723,4,'5280    ','BEACHPORT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6737,6724,4,'5280    ','HATHERLEIGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6738,6725,4,'5280    ','MILLICENT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6739,6726,4,'5280    ','RENDELSHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6740,6727,4,'5280    ','SOUTHEND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6741,6728,4,'5280    ','TANTANOOLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6742,6729,4,'5290    ','MOUNT GAMBIER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6743,6730,4,'5291    ','ALLENDALE EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6744,6731,4,'5291    ','CARPENTER ROCKS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6745,6732,4,'5291    ','GLENCOE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6746,6733,4,'5291    ','KONGORONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6747,6734,4,'5291    ','MIL LEL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6748,6735,4,'5291    ','MOORAK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6749,6736,4,'5291    ','MOUNT GAMBIER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6750,6737,4,'5291    ','MOUNT GAMBIER EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6751,6738,4,'5291    ','MOUNT GAMBIER WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6752,6739,4,'5291    ','O B FLAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6753,6740,4,'5291    ','PORT MACDONNELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6754,6741,4,'5291    ','YAHL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6755,6742,4,'5301    ','GERANIUM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6756,6743,4,'5301    ','JABUK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6757,6744,4,'5301    ','MOORLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6758,6745,4,'5301    ','PARRAKIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6759,6746,4,'5301    ','PEAKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6760,6747,4,'5301    ','SHERLOCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6761,6748,4,'5302    ','LAMEROO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6762,6749,4,'5303    ','PARILLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6763,6750,4,'5304    ','PEEBINGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6764,6751,4,'5304    ','PINNAROO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6765,6752,4,'5306    ','WYNARKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6766,6753,4,'5307    ','KAROONDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6767,6754,4,'5307    ','MARAMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6768,6755,4,'5308    ','COPEVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6769,6756,4,'5308    ','GALGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6770,6757,4,'5308    ','MANTUNG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6771,6758,4,'5308    ','MERCUNDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6772,6759,4,'5308    ','PERPONDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6773,6760,4,'5309    ','BORRIKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6774,6761,4,'5309    ','HALIDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6775,6762,4,'5309    ','MINDARIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6776,6763,4,'5309    ','SANDALWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6777,6764,4,'5310    ','WANBI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6778,6765,4,'5311    ','ALAWOONA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6779,6766,4,'5311    ','PARUNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6780,6767,4,'5311    ','TALDRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6781,6768,4,'5312    ','VEITCH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6782,6769,4,'5320    ','MORGAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6783,6770,4,'5321    ','CADELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6784,6771,4,'5322    ','RAMCO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6785,6772,4,'5330    ','LOWBANK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6786,6773,4,'5330    ','WAIKERIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6787,6774,4,'5331    ','KINGSTON-ON-MURRAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6788,6775,4,'5332    ','MOOROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6789,6776,4,'5333    ','LOXTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6790,6777,4,'5333    ','LOXTON NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6791,6778,4,'5333    ','TAPLAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6792,6779,4,'5340    ','PARINGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6793,6780,4,'5341    ','COOLTONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6794,6781,4,'5341    ','RENMARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6795,6782,4,'5341    ','RENMARK SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6796,6783,4,'5342    ','MONASH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6797,6784,4,'5343    ','BERRI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6798,6785,4,'5343    ','LYRUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6799,6786,4,'5343    ','WINKIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6800,6787,4,'5344    ','GLOSSOP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6801,6788,4,'5345    ','BARMERA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6802,6789,4,'5345    ','LOVEDAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6803,6790,4,'5346    ','COBDOGLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6804,6791,4,'5350    ','SANDY CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6805,6792,4,'5351    ','COCKATOO VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6806,6793,4,'5351    ','LYNDOCH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6807,6794,4,'5351    ','WILLIAMSTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6808,6795,4,'5352    ','ROWLAND FLAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6809,6796,4,'5352    ','STONE WELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6810,6797,4,'5352    ','TANUNDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6811,6798,4,'5353    ','ANGASTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6812,6799,4,'5353    ','BLACK HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6813,6800,4,'5353    ','CAMBRAI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6814,6801,4,'5353    ','KEYNETON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6815,6802,4,'5353    ','MOCULTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6816,6803,4,'5353    ','SEDAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6817,6804,4,'5354    ','SWAN REACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6818,6805,4,'5355    ','MARANANGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6819,6806,4,'5355    ','NURIOOTPA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6820,6807,4,'5355    ','SEPPELTSFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6821,6808,4,'5355    ','STOCKWELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6822,6809,4,'5356    ','TRURO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6823,6810,4,'5357    ','BLANCHETOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6824,6811,4,'5357    ','NEW WELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6825,6812,4,'5360    ','GREENOCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6826,6813,4,'5360    ','NAIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6827,6814,4,'5371    ','ROSEWORTHY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6828,6815,4,'5371    ','SHEA-OAK LOG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6829,6816,4,'5371    ','TEMPLERS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6830,6817,4,'5372    ','FREELING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6831,6818,4,'5373    ','HAMILTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6832,6819,4,'5373    ','KAPUNDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6833,6820,4,'5374    ','BOWER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6834,6821,4,'5374    ','EUDUNDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6835,6822,4,'5374    ','SUTHERLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6836,6823,4,'5381    ','ROBERTSTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6837,6824,4,'5400    ','PINKERTON PLAINS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6838,6825,4,'5400    ','WASLEYS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6839,6826,4,'5401    ','HAMLEY BRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6840,6827,4,'5410    ','LINWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6841,6828,4,'5410    ','STOCKPORT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6842,6829,4,'5411    ','TARLEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6843,6830,4,'5412    ','RIVERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6844,6831,4,'5413    ','MARRABEL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6845,6832,4,'5413    ','SADDLEWORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6846,6833,4,'5414    ','MANOORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6847,6834,4,'5415    ','MINTARO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6848,6835,4,'5416    ','FARRELL FLAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6849,6836,4,'5417    ','BOOBOROWIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6850,6837,4,'5417    ','BURRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6851,6838,4,'5418    ','MOUNT BRYAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6852,6839,4,'5419    ','HALLETT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6853,6840,4,'5420    ','WHYTE YARCOWIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6854,6841,4,'5421    ','TEROWIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6855,6842,4,'5422    ','PETERBOROUGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6856,6843,4,'5431    ','HAMMOND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6857,6844,4,'5431    ','MORCHARD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6858,6845,4,'5431    ','ORROROO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6859,6846,4,'5431    ','TARCOWIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6860,6847,4,'5432    ','CARRIETON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6861,6848,4,'5432    ','CRADOCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6862,6849,4,'5433    ','QUORN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6863,6850,4,'5434    ','HAWKER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6864,6851,4,'5440    ','COCKBURN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6865,6852,4,'5440    ','MANNA HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6866,6853,4,'5440    ','OLARY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6867,6854,4,'5440    ','YUNTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6868,6855,4,'5451    ','AUBURN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6869,6856,4,'5452    ','WATERVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6870,6857,4,'5453    ','CLARE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6871,6858,4,'5453    ','HOYLETON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6872,6859,4,'5454    ','SPALDING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6873,6860,4,'5455    ','HILLTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6874,6861,4,'5460    ','OWEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6875,6862,4,'5461    ','BALAKLAVA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6876,6863,4,'5462    ','BLYTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6877,6864,4,'5464    ','BRINKWORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6878,6865,4,'5464    ','KOOLUNGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6879,6866,4,'5470    ','YACKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6880,6867,4,'5471    ','GULNARE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6881,6868,4,'5472    ','GEORGETOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6882,6869,4,'5473    ','GLADSTONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6883,6870,4,'5480    ','APPILA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6884,6871,4,'5480    ','LAURA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6885,6872,4,'5481    ','MURRAY TOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6886,6873,4,'5481    ','WIRRABARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6887,6874,4,'5482    ','BOOLEROO CENTRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6888,6875,4,'5483    ','MELROSE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6889,6876,4,'5485    ','WILMINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6890,6877,4,'5490    ','CALTOWIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6891,6878,4,'5491    ','JAMESTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6892,6879,4,'5493    ','YONGALA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6893,6880,4,'5495    ','MAMBRAY CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6894,6881,4,'5495    ','PORT GERMEIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6895,6882,4,'5501    ','DUBLIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6896,6883,4,'5501    ','LEWISTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6897,6884,4,'5501    ','LOWER LIGHT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6898,6885,4,'5501    ','MIDDLE BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6899,6886,4,'5501    ','PORT GAWLER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6900,6887,4,'5501    ','TWO WELLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6901,6888,4,'5501    ','WINDSOR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6902,6889,4,'5502    ','MALLALA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6903,6890,4,'5502    ','REEVES PLAINS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6904,6891,4,'5510    ','LOCHIEL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6905,6892,4,'5520    ','SNOWTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6906,6893,4,'5521    ','REDHILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6907,6894,4,'5522    ','PORT BROUGHTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6908,6895,4,'5523    ','CRYSTAL BROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6909,6896,4,'5523    ','MERRITON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6910,6897,4,'5540    ','PORT PIRIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6911,6898,4,'5540    ','PORT PIRIE SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6912,6899,4,'5540    ','PORT PIRIE WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6913,6900,4,'5540    ','RISDON PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6914,6901,4,'5540    ','RISDON PARK SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6915,6902,4,'5540    ','SOLOMONTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6916,6903,4,'5550    ','BOWMANS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6917,6904,4,'5550    ','PORT WAKEFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6918,6905,4,'5552    ','PASKEVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6919,6906,4,'5554    ','KADINA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6920,6907,4,'5555    ','ALFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6921,6908,4,'5555    ','LAKE VIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6922,6909,4,'5555    ','MUNDOORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6923,6910,4,'5556    ','WALLAROO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6924,6911,4,'5558    ','MOONTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6925,6912,4,'5558    ','PORT HUGHES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6926,6913,4,'5560    ','BUTE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6927,6914,4,'5570    ','CLINTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6928,6915,4,'5570    ','PORT CLINTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6929,6916,4,'5570    ','PRICE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6930,6917,4,'5571    ','ARDROSSAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6931,6918,4,'5571    ','PINE POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6932,6919,4,'5572    ','ARTHURTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6933,6920,4,'5573    ','BALGOWAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6934,6921,4,'5573    ','MAITLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6935,6922,4,'5573    ','POINT PEARCE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6936,6923,4,'5573    ','PORT VICTORIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6937,6924,4,'5573    ','SOUTH KILKERRAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6938,6925,4,'5573    ','WEETULTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6939,6926,4,'5575    ','BRENTWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6940,6927,4,'5575    ','CORNY POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6941,6928,4,'5575    ','MARION BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6942,6929,4,'5575    ','MINLATON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6943,6930,4,'5575    ','POINT TURTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6944,6931,4,'5575    ','STENHOUSE BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6945,6932,4,'5575    ','WOOL BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6946,6933,4,'5576    ','YORKETOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6947,6934,4,'5577    ','WAROOKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6948,6935,4,'5580    ','CURRAMULKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6949,6936,4,'5581    ','PORT VINCENT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6950,6937,4,'5582    ','STANSBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6951,6938,4,'5583    ','COOBOWIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6952,6939,4,'5583    ','EDITHBURGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6953,6940,4,'5600    ','IRON BARON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6954,6941,4,'5600    ','WHYALLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6955,6942,4,'5600    ','WHYALLA PLAYFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6956,6943,4,'5601    ','IRON KNOB');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6957,6944,4,'5602    ','COWELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6958,6945,4,'5603    ','ARNO BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6959,6946,4,'5603    ','WHARMINDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6960,6947,4,'5604    ','PORT NEILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6961,6948,4,'5605    ','BUTLER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6962,6949,4,'5605    ','TUMBY BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6963,6950,4,'5606    ','PORT LINCOLN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6964,6951,4,'5607    ','COFFIN BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6965,6952,4,'5607    ','COULTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6966,6953,4,'5607    ','KARKOO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6967,6954,4,'5607    ','LIPSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6968,6955,4,'5607    ','LOUTH BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6969,6956,4,'5607    ','MURDINGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6970,6957,4,'5607    ','NORTH SHIELDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6971,6958,4,'5607    ','PORT LINCOLN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6972,6959,4,'5607    ','UNGARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6973,6960,4,'5607    ','VENUS BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6974,6961,4,'5607    ','WANGARY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6975,6962,4,'5607    ','WANILLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6976,6963,4,'5607    ','WARRACHIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6977,6964,4,'5607    ','WARROW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6978,6965,4,'5608    ','WHYALLA NORRIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6979,6966,4,'5608    ','WHYALLA NORRIE EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6980,6967,4,'5608    ','WHYALLA NORRIE NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6981,6968,4,'5608    ','WHYALLA STUART');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6982,6969,4,'5609    ','WHYALLA JENKINS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6983,6970,4,'5630    ','EDILLILIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6984,6971,4,'5631    ','CUMMINS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6985,6972,4,'5632    ','YEELANNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6986,6973,4,'5633    ','LOCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6987,6974,4,'5640    ','CLEVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6988,6975,4,'5641    ','BUCKLEBOO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6989,6976,4,'5641    ','KIMBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6990,6977,4,'5642    ','DARKE PEAK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6991,6978,4,'5642    ','KIELPA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6992,6979,4,'5642    ','RUDALL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6993,6980,4,'5650    ','WARRAMBOO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6994,6981,4,'5651    ','KYANCUTTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6995,6982,4,'5652    ','WUDINNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6996,6983,4,'5653    ','YANINEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6997,6984,4,'5654    ','MINNIPA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6998,6985,4,'5655    ','POOCHERA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (6999,6986,4,'5660    ','CUNGENA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7000,6987,4,'5661    ','WIRRULLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7001,6988,4,'5670    ','ELLISTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7002,6989,4,'5671    ','CALCA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7003,6990,4,'5671    ','PORT KENNY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7004,6991,4,'5680    ','HASLAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7005,6992,4,'5680    ','SMOKY BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7006,6993,4,'5680    ','STREAKY BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7007,6994,4,'5690    ','CEDUNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7008,6995,4,'5690    ','COORABIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7009,6996,4,'5690    ','PENONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7010,6997,4,'5690    ','THEVENARD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7011,6998,4,'5690    ','YALATA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7012,6999,4,'5700    ','PORT AUGUSTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7013,7000,4,'5700    ','PORT AUGUSTA NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7014,7001,4,'5700    ','PORT AUGUSTA WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7015,7002,4,'5710    ','COOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7016,7003,4,'5710    ','KINGOONYA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7017,7004,4,'5710    ','NONNING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7018,7005,4,'5710    ','PORT AUGUSTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7019,7006,4,'5710    ','STIRLING NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7020,7007,4,'5710    ','TARCOOLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7021,7008,4,'5720    ','WOOMERA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7022,7009,4,'5722    ','ANDAMOOKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7023,7010,4,'5723    ','COOBER PEDY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7024,7011,4,'5724    ','MARLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7025,7012,4,'5724    ','MINTABIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7026,7013,4,'5725    ','OLYMPIC DAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7027,7014,4,'5725    ','ROXBY DOWNS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7028,7015,4,'5730    ','BELTANA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7029,7016,4,'5730    ','BLINMAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7030,7017,4,'5730    ','PARACHILNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7031,7018,4,'5731    ','LEIGH CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7032,7019,4,'5731    ','LYNDHURST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7033,7020,4,'5732    ','COPLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7034,7021,4,'5733    ','MARREE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7035,7022,4,'5734    ','OODNADATTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7036,7023,4,'5942    ','REGENCY PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7037,7024,4,'5950    ','ADELAIDE AIRPORT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7038,7025,4,'5950    ','EXPORT PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7039,7026,8,'6000    ','PERTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7040,7027,8,'6003    ','HIGHGATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7041,7028,8,'6003    ','NORTHBRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7042,7029,8,'6004    ','EAST PERTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7043,7030,8,'6005    ','KINGS PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7044,7031,8,'6005    ','WEST PERTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7045,7032,8,'6006    ','NORTH PERTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7046,7033,8,'6007    ','LEEDERVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7047,7034,8,'6007    ','WEST LEEDERVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7048,7035,8,'6008    ','DAGLISH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7049,7036,8,'6008    ','SHENTON PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7050,7037,8,'6008    ','SUBIACO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7051,7038,8,'6009    ','BROADWAY NEDLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7052,7039,8,'6009    ','CRAWLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7053,7040,8,'6009    ','DALKEITH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7054,7041,8,'6009    ','NEDLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7055,7042,8,'6010    ','CLAREMONT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7056,7043,8,'6010    ','CLAREMONT NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7057,7044,8,'6010    ','KARRAKATTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7058,7045,8,'6010    ','MOUNT CLAREMONT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7059,7046,8,'6010    ','SWANBOURNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7060,7047,8,'6011    ','COTTESLOE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7061,7048,8,'6011    ','PEPPERMINT GROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7062,7049,8,'6012    ','MOSMAN PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7063,7050,8,'6014    ','FLOREAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7064,7051,8,'6014    ','JOLIMONT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7065,7052,8,'6014    ','WEMBLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7066,7053,8,'6015    ','CITY BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7067,7054,8,'6016    ','GLENDALOUGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7068,7055,8,'6016    ','MOUNT HAWTHORN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7069,7056,8,'6017    ','OSBORNE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7070,7057,8,'6018    ','CHURCHLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7071,7058,8,'6018    ','DOUBLEVIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7072,7059,8,'6018    ','GWELUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7073,7060,8,'6018    ','INNALOO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7074,7061,8,'6018    ','KARRINYUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7075,7062,8,'6018    ','WOODLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7076,7063,8,'6019    ','SCARBOROUGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7077,7064,8,'6019    ','WEMBLEY DOWNS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7078,7065,8,'6020    ','CARINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7079,7066,8,'6020    ','MARMION');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7080,7067,8,'6020    ','NORTH BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7081,7068,8,'6020    ','SORRENTO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7082,7069,8,'6020    ','WATERMAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7083,7070,8,'6021    ','BALCATTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7084,7071,8,'6021    ','STIRLING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7085,7072,8,'6022    ','HAMERSLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7086,7073,8,'6023    ','DUNCRAIG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7087,7074,8,'6023    ','GLENGARRY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7088,7075,8,'6024    ','GREENWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7089,7076,8,'6024    ','WARWICK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7090,7077,8,'6025    ','CRAIGIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7091,7078,8,'6025    ','HILLARYS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7092,7079,8,'6025    ','KALLAROO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7093,7080,8,'6025    ','PADBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7094,7081,8,'6026    ','KINGSLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7095,7082,8,'6026    ','WOODVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7096,7083,8,'6027    ','BELDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7097,7084,8,'6027    ','CONNOLLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7098,7085,8,'6027    ','EDGEWATER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7099,7086,8,'6027    ','HEATHRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7100,7087,8,'6027    ','JOONDALUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7101,7088,8,'6027    ','MULLALOO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7102,7089,8,'6027    ','OCEAN REEF');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7103,7090,8,'6028    ','BURNS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7104,7091,8,'6028    ','CURRAMBINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7105,7092,8,'6028    ','ILUKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7106,7093,8,'6028    ','KINROSS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7107,7094,8,'6029    ','TRIGG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7108,7095,8,'6030    ','CLARKSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7109,7096,8,'6030    ','MERRIWA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7110,7097,8,'6030    ','MINDARIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7111,7098,8,'6030    ','QUINNS ROCKS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7112,7099,8,'6030    ','RIDGEWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7113,7100,8,'6030    ','TAMALA PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7114,7101,8,'6031    ','BANKSIA GROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7115,7102,8,'6031    ','CARRAMAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7116,7103,8,'6031    ','NEERABUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7117,7104,8,'6032    ','NOWERGUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7118,7105,8,'6033    ','CARABOODA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7119,7106,8,'6034    ','EGLINTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7120,7107,8,'6035    ','YANCHEP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7121,7108,8,'6036    ','BUTLER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7122,7109,8,'6036    ','JINDALEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7123,7110,8,'6037    ','TWO ROCKS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7124,7111,8,'6038    ','ALKIMOS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7125,7112,8,'6041    ','CARABAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7126,7113,8,'6041    ','GUILDERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7127,7114,8,'6041    ','WILBINGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7128,7115,8,'6041    ','WOODRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7129,7116,8,'6042    ','GABBADAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7130,7117,8,'6042    ','SEABIRD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7131,7118,8,'6043    ','BRETON BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7132,7119,8,'6043    ','LEDGE POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7133,7120,8,'6044    ','KARAKIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7134,7121,8,'6044    ','LANCELIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7135,7122,8,'6044    ','NILGEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7136,7123,8,'6050    ','COOLBINIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7137,7124,8,'6050    ','MENORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7138,7125,8,'6050    ','MOUNT LAWLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7139,7126,8,'6051    ','MAYLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7140,7127,8,'6052    ','BEDFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7141,7128,8,'6052    ','INGLEWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7142,7129,8,'6053    ','BAYSWATER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7143,7130,8,'6054    ','ASHFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7144,7131,8,'6054    ','BASSENDEAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7145,7132,8,'6054    ','EDEN HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7146,7133,8,'6054    ','KIARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7147,7134,8,'6054    ','LOCKRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7148,7135,8,'6055    ','CAVERSHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7149,7136,8,'6055    ','GUILDFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7150,7137,8,'6055    ','HAZELMERE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7151,7138,8,'6055    ','HENLEY BROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7152,7139,8,'6055    ','SOUTH GUILDFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7153,7140,8,'6055    ','WEST SWAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7154,7141,8,'6056    ','BASKERVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7155,7142,8,'6056    ','BELLEVUE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7156,7143,8,'6056    ','BOYA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7157,7144,8,'6056    ','GREENMOUNT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7158,7145,8,'6056    ','HELENA VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7159,7146,8,'6056    ','HERNE HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7160,7147,8,'6056    ','JANE BROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7161,7148,8,'6056    ','KOONGAMIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7162,7149,8,'6056    ','MIDDLE SWAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7163,7150,8,'6056    ','MIDLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7164,7151,8,'6056    ','MIDVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7165,7152,8,'6056    ','MILLENDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7166,7153,8,'6056    ','RED HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7167,7154,8,'6056    ','STRATTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7168,7155,8,'6056    ','SWAN VIEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7169,7156,8,'6056    ','VIVEASH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7170,7157,8,'6056    ','WOODBRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7171,7158,8,'6057    ','HIGH WYCOMBE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7172,7159,8,'6057    ','MAIDA VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7173,7160,8,'6058    ','FORRESTFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7174,7161,8,'6059    ','DIANELLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7175,7162,8,'6060    ','DOG SWAMP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7176,7163,8,'6060    ','JOONDANNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7177,7164,8,'6060    ','TUART HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7178,7165,8,'6060    ','YOKINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7179,7166,8,'6061    ','BALGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7180,7167,8,'6061    ','MIRRABOOKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7181,7168,8,'6061    ','NOLLAMARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7182,7169,8,'6061    ','WESTMINSTER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7183,7170,8,'6062    ','EMBLETON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7184,7171,8,'6062    ','MORLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7185,7172,8,'6062    ','NORANDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7186,7173,8,'6063    ','BEECHBORO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7187,7174,8,'6064    ','ALEXANDER HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7188,7175,8,'6064    ','GIRRAWHEEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7189,7176,8,'6064    ','KOONDOOLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7190,7177,8,'6064    ','MARANGAROO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7191,7178,8,'6065    ','ASHBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7192,7179,8,'6065    ','DARCH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7193,7180,8,'6065    ','GNANGARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7194,7181,8,'6065    ','HOCKING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7195,7182,8,'6065    ','JANDABUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7196,7183,8,'6065    ','KINGSWAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7197,7184,8,'6065    ','LANDSDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7198,7185,8,'6065    ','LEXIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7199,7186,8,'6065    ','MADELEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7200,7187,8,'6065    ','MARIGINIUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7201,7188,8,'6065    ','PEARSALL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7202,7189,8,'6065    ','PINJAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7203,7190,8,'6065    ','SINAGRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7204,7191,8,'6065    ','TAPPING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7205,7192,8,'6065    ','WANGARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7206,7193,8,'6065    ','WANNEROO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7207,7194,8,'6066    ','BALLAJURA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7208,7195,8,'6067    ','CULLACABARDEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7209,7196,8,'6068    ','WHITEMAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7210,7197,8,'6069    ','BELHUS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7211,7198,8,'6069    ','BRIGADOON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7212,7199,8,'6069    ','ELLENBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7213,7200,8,'6069    ','ELLENBROOK EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7214,7201,8,'6069    ','THE VINES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7215,7202,8,'6069    ','UPPER SWAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7216,7203,8,'6070    ','DARLINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7217,7204,8,'6071    ','GLEN FORREST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7218,7205,8,'6071    ','HOVEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7219,7206,8,'6072    ','MAHOGANY CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7220,7207,8,'6073    ','MUNDARING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7221,7208,8,'6074    ','SAWYERS VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7222,7209,8,'6076    ','BICKLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7223,7210,8,'6076    ','CARMEL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7224,7211,8,'6076    ','GOOSEBERRY HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7225,7212,8,'6076    ','HACKETTS GULLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7226,7213,8,'6076    ','KALAMUNDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7227,7214,8,'6076    ','LESMURDIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7228,7215,8,'6076    ','PAULLS VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7229,7216,8,'6076    ','PICKERING BROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7230,7217,8,'6076    ','PIESSE BROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7231,7218,8,'6076    ','RESERVOIR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7232,7219,8,'6076    ','WALLISTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7233,7220,8,'6081    ','PARKERVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7234,7221,8,'6081    ','STONEVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7235,7222,8,'6082    ','MOUNT HELENA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7236,7223,8,'6083    ','GIDGEGANNUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7237,7224,8,'6083    ','MORANGUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7238,7225,8,'6084    ','BULLSBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7239,7226,8,'6084    ','CHITTERING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7240,7227,8,'6084    ','LOWER CHITTERING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7241,7228,8,'6090    ','MALAGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7242,7229,8,'6100    ','BURSWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7243,7230,8,'6100    ','LATHLAIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7244,7231,8,'6100    ','VICTORIA PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7245,7232,8,'6101    ','CARLISLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7246,7233,8,'6101    ','EAST VICTORIA PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7247,7234,8,'6102    ','BENTLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7248,7235,8,'6102    ','ST JAMES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7249,7236,8,'6103    ','RIVERVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7250,7237,8,'6104    ','ASCOT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7251,7238,8,'6104    ','BELMONT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7252,7239,8,'6104    ','REDCLIFFE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7253,7240,8,'6105    ','CLOVERDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7254,7241,8,'6105    ','KEWDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7255,7242,8,'6105    ','PERTH AIRPORT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7256,7243,8,'6106    ','WELSHPOOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7257,7244,8,'6107    ','BECKENHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7258,7245,8,'6107    ','CANNINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7259,7246,8,'6107    ','KENWICK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7260,7247,8,'6107    ','QUEENS PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7261,7248,8,'6107    ','WATTLE GROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7262,7249,8,'6107    ','WILSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7263,7250,8,'6108    ','THORNLIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7264,7251,8,'6109    ','MADDINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7265,7252,8,'6109    ','ORANGE GROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7266,7253,8,'6110    ','GOSNELLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7267,7254,8,'6110    ','HUNTINGDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7268,7255,8,'6110    ','MARTIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7269,7256,8,'6110    ','SOUTHERN RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7270,7257,8,'6111    ','CANNING MILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7271,7258,8,'6111    ','KARRAGULLEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7272,7259,8,'6111    ','KELMSCOTT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7273,7260,8,'6111    ','ROLEYSTONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7274,7261,8,'6111    ','WESTFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7275,7262,8,'6112    ','ARMADALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7276,7263,8,'6112    ','BEDFORDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7277,7264,8,'6112    ','BROOKDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7278,7265,8,'6112    ','FORRESTDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7279,7266,8,'6112    ','MOUNT NASURA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7280,7267,8,'6112    ','WUNGONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7281,7268,8,'6121    ','OAKFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7282,7269,8,'6121    ','OLDBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7283,7270,8,'6122    ','BYFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7284,7271,8,'6122    ','CARDUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7285,7272,8,'6122    ','DARLING DOWNS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7286,7273,8,'6122    ','KARRAKUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7287,7274,8,'6123    ','MUNDIJONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7288,7275,8,'6123    ','WHITBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7289,7276,8,'6124    ','JARRAHDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7290,7277,8,'6125    ','HOPELAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7291,7278,8,'6125    ','MARDELLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7292,7279,8,'6125    ','SERPENTINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7293,7280,8,'6126    ','KEYSBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7294,7281,8,'6147    ','LANGFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7295,7282,8,'6147    ','LYNWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7296,7283,8,'6147    ','PARKWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7297,7284,8,'6148    ','FERNDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7298,7285,8,'6148    ','RIVERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7299,7286,8,'6148    ','ROSSMOYNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7300,7287,8,'6148    ','SHELLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7301,7288,8,'6149    ','BULL CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7302,7289,8,'6149    ','LEEMING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7303,7290,8,'6150    ','BATEMAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7304,7291,8,'6150    ','MURDOCH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7305,7292,8,'6150    ','WINTHROP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7306,7293,8,'6151    ','KENSINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7307,7294,8,'6151    ','SOUTH PERTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7308,7295,8,'6152    ','COMO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7309,7296,8,'6152    ','KARAWARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7310,7297,8,'6152    ','MANNING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7311,7298,8,'6152    ','SALTER POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7312,7299,8,'6152    ','WATERFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7313,7300,8,'6153    ','APPLECROSS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7314,7301,8,'6153    ','ARDROSS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7315,7302,8,'6153    ','BRENTWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7316,7303,8,'6153    ','CANNING BRIDGE APPLECROSS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7317,7304,8,'6153    ','MOUNT PLEASANT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7318,7305,8,'6154    ','ALFRED COVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7319,7306,8,'6154    ','BOORAGOON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7320,7307,8,'6154    ','MYAREE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7321,7308,8,'6155    ','CANNING VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7322,7309,8,'6155    ','CANNING VALE SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7323,7310,8,'6155    ','WILLETTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7324,7311,8,'6156    ','ATTADALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7325,7312,8,'6156    ','MELVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7326,7313,8,'6156    ','WILLAGEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7327,7314,8,'6156    ','WILLAGEE CENTRAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7328,7315,8,'6157    ','BICTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7329,7316,8,'6157    ','PALMYRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7330,7317,8,'6158    ','EAST FREMANTLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7331,7318,8,'6159    ','NORTH FREMANTLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7332,7319,8,'6160    ','FREMANTLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7333,7320,8,'6161    ','ROTTNEST ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7334,7321,8,'6162    ','BEACONSFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7335,7322,8,'6162    ','SOUTH FREMANTLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7336,7323,8,'6162    ','WHITE GUM VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7337,7324,8,'6163    ','BIBRA LAKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7338,7325,8,'6163    ','COOLBELLUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7339,7326,8,'6163    ','HAMILTON HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7340,7327,8,'6163    ','HILTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7341,7328,8,'6163    ','KARDINYA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7342,7329,8,'6163    ','NORTH LAKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7343,7330,8,'6163    ','O''CONNOR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7344,7331,8,'6163    ','SAMSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7345,7332,8,'6163    ','SPEARWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7346,7333,8,'6164    ','ATWELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7347,7334,8,'6164    ','BANJUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7348,7335,8,'6164    ','BEELIAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7349,7336,8,'6164    ','JANDAKOT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7350,7337,8,'6164    ','SOUTH LAKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7351,7338,8,'6164    ','SUCCESS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7352,7339,8,'6164    ','YANGEBUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7353,7340,8,'6165    ','HOPE VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7354,7341,8,'6165    ','NAVAL BASE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7355,7342,8,'6166    ','COOGEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7356,7343,8,'6166    ','HENDERSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7357,7344,8,'6166    ','MUNSTER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7358,7345,8,'6166    ','WATTLEUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7359,7346,8,'6167    ','ANKETELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7360,7347,8,'6167    ','BERTRAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7361,7348,8,'6167    ','CALISTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7362,7349,8,'6167    ','CASUARINA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7363,7350,8,'6167    ','KWINANA BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7364,7351,8,'6167    ','KWINANA TOWN CENTRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7365,7352,8,'6167    ','MANDOGALUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7366,7353,8,'6167    ','MEDINA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7367,7354,8,'6167    ','ORELIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7368,7355,8,'6167    ','PARMELIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7369,7356,8,'6167    ','POSTANS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7370,7357,8,'6167    ','THE SPECTACLES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7371,7358,8,'6167    ','WANDI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7372,7359,8,'6168    ','COOLOONGUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7373,7360,8,'6168    ','EAST ROCKINGHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7374,7361,8,'6168    ','GARDEN ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7375,7362,8,'6168    ','HILLMAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7376,7363,8,'6168    ','PERON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7377,7364,8,'6168    ','ROCKINGHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7378,7365,8,'6169    ','SAFETY BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7379,7366,8,'6169    ','SHOALWATER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7380,7367,8,'6169    ','WAIKIKI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7381,7368,8,'6169    ','WARNBRO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7382,7369,8,'6170    ','LEDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7383,7370,8,'6170    ','WELLARD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7384,7371,8,'6171    ','BALDIVIS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7385,7372,8,'6172    ','PORT KENNEDY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7386,7373,8,'6173    ','SECRET HARBOUR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7387,7374,8,'6174    ','GOLDEN BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7388,7375,8,'6175    ','SINGLETON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7389,7376,8,'6176    ','KARNUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7390,7377,8,'6207    ','MYARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7391,7378,8,'6207    ','NAMBEELUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7392,7379,8,'6207    ','NORTH DANDALUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7393,7380,8,'6207    ','SOLUS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7394,7381,8,'6207    ','WHITTAKER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7395,7382,8,'6208    ','BLYTHEWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7396,7383,8,'6208    ','FAIRBRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7397,7384,8,'6208    ','NIRIMBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7398,7385,8,'6208    ','NORTH YUNDERUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7399,7386,8,'6208    ','OAKLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7400,7387,8,'6208    ','PINJARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7401,7388,8,'6208    ','POINT GREY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7402,7389,8,'6208    ','RAVENSWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7403,7390,8,'6208    ','SOUTH YUNDERUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7404,7391,8,'6208    ','WEST PINJARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7405,7392,8,'6210    ','BARRAGUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7406,7393,8,'6210    ','BOUVARD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7407,7394,8,'6210    ','CLIFTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7408,7395,8,'6210    ','COODANUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7409,7396,8,'6210    ','DAWESVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7410,7397,8,'6210    ','DUDLEY PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7411,7398,8,'6210    ','ERSKINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7412,7399,8,'6210    ','FALCON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7413,7400,8,'6210    ','FURNISSDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7414,7401,8,'6210    ','GEOGRUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7415,7402,8,'6210    ','GREENFIELDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7416,7403,8,'6210    ','HALLS HEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7417,7404,8,'6210    ','HERRON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7418,7405,8,'6210    ','LAKELANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7419,7406,8,'6210    ','MADORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7420,7407,8,'6210    ','MANDURAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7421,7408,8,'6210    ','MANDURAH EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7422,7409,8,'6210    ','MANDURAH NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7423,7410,8,'6210    ','MEADOW SPRINGS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7424,7411,8,'6210    ','PARKLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7425,7412,8,'6210    ','SAN REMO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7426,7413,8,'6210    ','SILVER SANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7427,7414,8,'6210    ','STAKE HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7428,7415,8,'6210    ','WANNANUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7429,7416,8,'6213    ','BANKSIADALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7430,7417,8,'6213    ','DWELLINGUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7431,7418,8,'6213    ','ETMILYN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7432,7419,8,'6213    ','HOLYOAKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7433,7420,8,'6213    ','INGLEHOPE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7434,7421,8,'6213    ','MARRINUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7435,7422,8,'6213    ','TEESDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7436,7423,8,'6213    ','WURAMING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7437,7424,8,'6214    ','BIRCHMONT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7438,7425,8,'6214    ','COOLUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7439,7426,8,'6214    ','KOOLJERRENUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7440,7427,8,'6215    ','HAMEL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7441,7428,8,'6215    ','LAKE CLIFTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7442,7429,8,'6215    ','NANGA BROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7443,7430,8,'6215    ','PRESTON BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7444,7431,8,'6215    ','WAGERUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7445,7432,8,'6215    ','WAROONA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7446,7433,8,'6218    ','YARLOOP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7447,7434,8,'6220    ','COOKERNUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7448,7435,8,'6220    ','HARVEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7449,7436,8,'6220    ','HOFFMAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7450,7437,8,'6220    ','MYALUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7451,7438,8,'6220    ','UDUC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7452,7439,8,'6220    ','WARAWARRUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7453,7440,8,'6221    ','MORNINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7454,7441,8,'6221    ','WOKALUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7455,7442,8,'6223    ','BENGER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7456,7443,8,'6224    ','BEELA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7457,7444,8,'6224    ','BRUNSWICK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7458,7445,8,'6225    ','ALLANSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7459,7446,8,'6225    ','BOWELLING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7460,7447,8,'6225    ','COLLIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7461,7448,8,'6225    ','MCALINDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7462,7449,8,'6225    ','MUMBALLUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7463,7450,8,'6225    ','NOGGERUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7464,7451,8,'6225    ','SHOTTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7465,7452,8,'6225    ','TREESVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7466,7453,8,'6225    ','WORSLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7467,7454,8,'6226    ','ROELANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7468,7455,8,'6227    ','BUREKUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7469,7456,8,'6228    ','WATERLOO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7470,7457,8,'6229    ','PICTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7471,7458,8,'6229    ','PICTON EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7472,7459,8,'6230    ','BUNBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7473,7460,8,'6230    ','CAREY PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7474,7461,8,'6230    ','COLLEGE GROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7475,7462,8,'6230    ','DALYELLUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7476,7463,8,'6230    ','DAVENPORT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7477,7464,8,'6230    ','EAST BUNBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7478,7465,8,'6230    ','GELORUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7479,7466,8,'6230    ','GLEN IRIS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7480,7467,8,'6230    ','PELICAN POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7481,7468,8,'6230    ','SOUTH BUNBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7482,7469,8,'6230    ','USHER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7483,7470,8,'6230    ','VITTORIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7484,7471,8,'6230    ','WITHERS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7485,7472,8,'6231    ','BUNBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7486,7473,8,'6232    ','EATON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7487,7474,8,'6233    ','AUSTRALIND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7488,7475,8,'6233    ','BINNINGUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7489,7476,8,'6233    ','LESCHENAULT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7490,7477,8,'6233    ','PARKFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7491,7478,8,'6233    ','WELLESLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7492,7479,8,'6236    ','CROOKED BROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7493,7480,8,'6236    ','DARDANUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7494,7481,8,'6236    ','DARDANUP WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7495,7482,8,'6236    ','FERGUSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7496,7483,8,'6236    ','HENTY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7497,7484,8,'6236    ','PARADISE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7498,7485,8,'6236    ','WELLINGTON FORREST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7499,7486,8,'6236    ','WELLINGTON MILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7500,7487,8,'6237    ','BOYANUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7501,7488,8,'6237    ','ELGIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7502,7489,8,'6237    ','GWINDINUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7503,7490,8,'6237    ','NORTH BOYANUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7504,7491,8,'6237    ','STRATHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7505,7492,8,'6237    ','THE PLAINS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7506,7493,8,'6239    ','ARGYLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7507,7494,8,'6239    ','BEELERUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7508,7495,8,'6239    ','BROOKHAMPTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7509,7496,8,'6239    ','CHARLEY CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7510,7497,8,'6239    ','DONNYBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7511,7498,8,'6239    ','GLEN MERVYN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7512,7499,8,'6239    ','PAYNEDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7513,7500,8,'6239    ','QUEENWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7514,7501,8,'6239    ','THOMSON BROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7515,7502,8,'6239    ','UPPER CAPEL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7516,7503,8,'6239    ','YABBERUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7517,7504,8,'6240    ','LOWDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7518,7505,8,'6243    ','WILGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7519,7506,8,'6243    ','WILGA WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7520,7507,8,'6244    ','BOYUP BROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7521,7508,8,'6244    ','CHOWERUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7522,7509,8,'6244    ','DINNINUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7523,7510,8,'6244    ','KULIKUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7524,7511,8,'6244    ','MAYANUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7525,7512,8,'6244    ','SCOTTS BROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7526,7513,8,'6244    ','TONEBRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7527,7514,8,'6251    ','BRAZIER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7528,7515,8,'6251    ','KIRUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7529,7516,8,'6251    ','NEWLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7530,7517,8,'6252    ','MULLALYUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7531,7518,8,'6253    ','BALINGUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7532,7519,8,'6253    ','GRIMWADE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7533,7520,8,'6253    ','SOUTHAMPTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7534,7521,8,'6254    ','GREENBUSHES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7535,7522,8,'6254    ','NORTH GREENBUSHES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7536,7523,8,'6255    ','BENJINUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7537,7524,8,'6255    ','BRIDGETOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7538,7525,8,'6255    ','CATTERICK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7539,7526,8,'6255    ','DONNELLY RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7540,7527,8,'6255    ','HESTER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7541,7528,8,'6255    ','HESTER BROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7542,7529,8,'6255    ','KANGAROO GULLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7543,7530,8,'6255    ','WINNEJUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7544,7531,8,'6256    ','GLENLYNN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7545,7532,8,'6256    ','KINGSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7546,7533,8,'6256    ','MARANUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7547,7534,8,'6256    ','SUNNYSIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7548,7535,8,'6256    ','WANDILLUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7549,7536,8,'6256    ','YORNUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7550,7537,8,'6258    ','JARDEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7551,7538,8,'6258    ','MANJIMUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7552,7539,8,'6258    ','MORDALUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7553,7540,8,'6258    ','NYAMUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7554,7541,8,'6258    ','QUINNINUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7555,7542,8,'6258    ','SHANNON RIVER MILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7556,7543,8,'6258    ','WHEATLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7557,7544,8,'6260    ','BIDDELIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7558,7545,8,'6260    ','EASTBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7559,7546,8,'6260    ','LAKE JASPER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7560,7547,8,'6260    ','PEERABEELUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7561,7548,8,'6260    ','PEMBERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7562,7549,8,'6262    ','NORTHCLIFFE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7563,7550,8,'6271    ','CAPEL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7564,7551,8,'6271    ','CAPEL RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7565,7552,8,'6271    ','FORREST BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7566,7553,8,'6271    ','PEPPERMINT GROVE BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7567,7554,8,'6271    ','STIRLING ESTATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7568,7555,8,'6275    ','BARRABUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7569,7556,8,'6275    ','CARLOTTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7570,7557,8,'6275    ','CUNDINUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7571,7558,8,'6275    ','DARRADUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7572,7559,8,'6275    ','EAST NANNUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7573,7560,8,'6275    ','JALBARRAGUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7574,7561,8,'6275    ','JARRAHWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7575,7562,8,'6275    ','NANNUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7576,7563,8,'6275    ','SCOTT RIVER EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7577,7564,8,'6275    ','YOGANUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7578,7565,8,'6280    ','ABBA RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7579,7566,8,'6280    ','ABBEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7580,7567,8,'6280    ','ACTON PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7581,7568,8,'6280    ','AMBERGATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7582,7569,8,'6280    ','ANNIEBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7583,7570,8,'6280    ','BOALLIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7584,7571,8,'6280    ','BOVELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7585,7572,8,'6280    ','BROADWATER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7586,7573,8,'6280    ','BUSSELTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7587,7574,8,'6280    ','CARBUNUP RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7588,7575,8,'6280    ','CHAPMAN HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7589,7576,8,'6280    ','GEOGRAPHE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7590,7577,8,'6280    ','HITHERGREEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7591,7578,8,'6280    ','JINDONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7592,7579,8,'6280    ','KALGUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7593,7580,8,'6280    ','KALOORUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7594,7581,8,'6280    ','KEALY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7595,7582,8,'6280    ','LUDLOW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7596,7583,8,'6280    ','MARYBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7597,7584,8,'6280    ','METRICUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7598,7585,8,'6280    ','NORTH JINDONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7599,7586,8,'6280    ','REINSCOURT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7600,7587,8,'6280    ','RUABON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7601,7588,8,'6280    ','SABINA RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7602,7589,8,'6280    ','SIESTA PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7603,7590,8,'6280    ','TUTUNUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7604,7591,8,'6280    ','VASSE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7605,7592,8,'6280    ','WALSALL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7606,7593,8,'6280    ','WEST BUSSELTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7607,7594,8,'6280    ','WILYABRUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7608,7595,8,'6280    ','WONNERUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7609,7596,8,'6280    ','YALYALUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7610,7597,8,'6280    ','YELVERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7611,7598,8,'6280    ','YOONGARILLUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7612,7599,8,'6281    ','DUNSBOROUGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7613,7600,8,'6281    ','EAGLE BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7614,7601,8,'6281    ','NATURALISTE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7615,7602,8,'6281    ','QUEDJINUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7616,7603,8,'6281    ','QUINDALUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7617,7604,8,'6281    ','YALLINGUP SIDING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7618,7605,8,'6282    ','YALLINGUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7619,7606,8,'6284    ','BAUDIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7620,7607,8,'6284    ','COWARAMUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7621,7608,8,'6284    ','GRACETOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7622,7609,8,'6284    ','TREETON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7623,7610,8,'6285    ','BRAMLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7624,7611,8,'6285    ','BURNSIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7625,7612,8,'6285    ','GNARABUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7626,7613,8,'6285    ','MARGARET RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7627,7614,8,'6285    ','OSMINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7628,7615,8,'6285    ','PREVELLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7629,7616,8,'6285    ','REDGATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7630,7617,8,'6285    ','ROSA BROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7631,7618,8,'6285    ','ROSA GLEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7632,7619,8,'6285    ','SCHROEDER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7633,7620,8,'6286    ','BORANUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7634,7621,8,'6286    ','FOREST GROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7635,7622,8,'6286    ','WITCHCLIFFE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7636,7623,8,'6288    ','ALEXANDRA BRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7637,7624,8,'6288    ','COURTENAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7638,7625,8,'6288    ','HAMELIN BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7639,7626,8,'6288    ','KARRIDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7640,7627,8,'6288    ','NILLUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7641,7628,8,'6288    ','SCOTT RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7642,7629,8,'6288    ','WARNER GLEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7643,7630,8,'6290    ','AUGUSTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7644,7631,8,'6290    ','DEEPDENE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7645,7632,8,'6290    ','EAST AUGUSTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7646,7633,8,'6290    ','KUDARDUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7647,7634,8,'6290    ','LEEUWIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7648,7635,8,'6290    ','MOLLOY ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7649,7636,8,'6302    ','BADGIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7650,7637,8,'6302    ','BALLADONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7651,7638,8,'6302    ','BURGES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7652,7639,8,'6302    ','CALJIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7653,7640,8,'6302    ','COLD HARBOUR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7654,7641,8,'6302    ','DALIAK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7655,7642,8,'6302    ','FLINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7656,7643,8,'6302    ','FLYNN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7657,7644,8,'6302    ','GILGERING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7658,7645,8,'6302    ','GREENHILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7659,7646,8,'6302    ','GWAMBYGINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7660,7647,8,'6302    ','INKPEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7661,7648,8,'6302    ','KAURING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7662,7649,8,'6302    ','MALEBELLING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7663,7650,8,'6302    ','MOUNT HARDEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7664,7651,8,'6302    ','MOUNT OBSERVATION');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7665,7652,8,'6302    ','NARRALOGGAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7666,7653,8,'6302    ','QUELLINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7667,7654,8,'6302    ','SAINT RONANS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7668,7655,8,'6302    ','TALBOT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7669,7656,8,'6302    ','TALBOT WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7670,7657,8,'6302    ','WILBERFORCE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7671,7658,8,'6302    ','YORK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7672,7659,8,'6304    ','BALLY BALLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7673,7660,8,'6304    ','BEVERLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7674,7661,8,'6304    ','DALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7675,7662,8,'6304    ','EAST BEVERLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7676,7663,8,'6304    ','KOKEBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7677,7664,8,'6304    ','MORBINNING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7678,7665,8,'6304    ','WESTDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7679,7666,8,'6306    ','ALDERSYDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7680,7667,8,'6306    ','BROOKTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7681,7668,8,'6306    ','BULYEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7682,7669,8,'6306    ','JELCOBINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7683,7670,8,'6306    ','KWEDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7684,7671,8,'6308    ','BOYAGIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7685,7672,8,'6308    ','CODJATOTINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7686,7673,8,'6308    ','DWARDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7687,7674,8,'6308    ','GILLIMANINNG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7688,7675,8,'6308    ','HASTINGS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7689,7676,8,'6308    ','HOTHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7690,7677,8,'6308    ','JINGARING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7691,7678,8,'6308    ','MOORUMBINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7692,7679,8,'6308    ','NOONEBIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7693,7680,8,'6308    ','PINGELLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7694,7681,8,'6308    ','PUMPHREYS BRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7695,7682,8,'6308    ','TUTANNING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7696,7683,8,'6308    ','WANDERING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7697,7684,8,'6309    ','EAST POPANYINNING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7698,7685,8,'6309    ','POPANYINNING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7699,7686,8,'6309    ','STRATHERNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7700,7687,8,'6309    ','WEST POPANYINNING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7701,7688,8,'6311    ','COMMODINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7702,7689,8,'6311    ','CONTINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7703,7690,8,'6311    ','CUBALLING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7704,7691,8,'6311    ','DRYANDRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7705,7692,8,'6311    ','LOL GRAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7706,7693,8,'6311    ','TOWNSENDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7707,7694,8,'6311    ','WARDERING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7708,7695,8,'6311    ','YORNANING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7709,7696,8,'6312    ','BOUNDAIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7710,7697,8,'6312    ','DUMBERNING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7711,7698,8,'6312    ','HILLSIDE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7712,7699,8,'6312    ','MINIGIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7713,7700,8,'6312    ','NARROGIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7714,7701,8,'6312    ','NARROGIN VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7715,7702,8,'6312    ','NOMANS LAKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7716,7703,8,'6312    ','TOOLIBIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7717,7704,8,'6312    ','YILLIMINNING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7718,7705,8,'6313    ','HIGHBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7719,7706,8,'6315    ','ARTHUR RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7720,7707,8,'6315    ','BALLAYING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7721,7708,8,'6315    ','CANCANNING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7722,7709,8,'6315    ','COLLANILLING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7723,7710,8,'6315    ','JALORAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7724,7711,8,'6315    ','LIME LAKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7725,7712,8,'6315    ','PIESSEVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7726,7713,8,'6315    ','WAGIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7727,7714,8,'6315    ','WEDGECARRUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7728,7715,8,'6316    ','BOYERINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7729,7716,8,'6316    ','CARTMETICUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7730,7717,8,'6316    ','GLENCOE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7731,7718,8,'6316    ','KENMARE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7732,7719,8,'6316    ','WESTWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7733,7720,8,'6316    ','WOODANILLING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7734,7721,8,'6317    ','KATANNING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7735,7722,8,'6318    ','BROOMEHILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7736,7723,8,'6318    ','BROOMEHILL EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7737,7724,8,'6318    ','BROOMEHILL VILLAGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7738,7725,8,'6318    ','BROOMEHILL WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7739,7726,8,'6320    ','BOBALONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7740,7727,8,'6320    ','BORDERDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7741,7728,8,'6320    ','DARTNALL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7742,7729,8,'6320    ','LAKE TOOLBRUNUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7743,7730,8,'6320    ','MOONIES HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7744,7731,8,'6320    ','TAMBELLUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7745,7732,8,'6320    ','WANSBROUGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7746,7733,8,'6321    ','CRANBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7747,7734,8,'6322    ','TENTERDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7748,7735,8,'6323    ','KENDENUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7749,7736,8,'6324    ','CARBARUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7750,7737,8,'6324    ','DENBARKER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7751,7738,8,'6324    ','FOREST HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7752,7739,8,'6324    ','MOUNT BARKER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7753,7740,8,'6324    ','PERILLUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7754,7741,8,'6324    ','PORONGURUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7755,7742,8,'6324    ','SAINT WERBURGHS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7756,7743,8,'6324    ','SOUTH STIRLING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7757,7744,8,'6324    ','TAKALARUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7758,7745,8,'6324    ','TEDDINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7759,7746,8,'6324    ','WOOGENILUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7760,7747,8,'6326    ','NARRIKUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7761,7748,8,'6326    ','YELLANUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7762,7749,8,'6327    ','REDMOND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7763,7750,8,'6327    ','REDMOND WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7764,7751,8,'6328    ','CAPE RICHE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7765,7752,8,'6328    ','CHEYNES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7766,7753,8,'6328    ','GNOWELLEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7767,7754,8,'6328    ','GREEN RANGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7768,7755,8,'6328    ','KOJANEERUP SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7769,7756,8,'6328    ','MANYPEAKS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7770,7757,8,'6328    ','METTLER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7771,7758,8,'6328    ','PALMDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7772,7759,8,'6328    ','WELLSTEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7773,7760,8,'6330    ','ALBANY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7774,7761,8,'6330    ','BAYONET HEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7775,7762,8,'6330    ','BIG GROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7776,7763,8,'6330    ','BORNHOLM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7777,7764,8,'6330    ','CENTENNIAL PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7778,7765,8,'6330    ','COLLINGWOOD HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7779,7766,8,'6330    ','COLLINGWOOD PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7780,7767,8,'6330    ','CUTHBERT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7781,7768,8,'6330    ','DROME');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7782,7769,8,'6330    ','ELLEKER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7783,7770,8,'6330    ','EMU POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7784,7771,8,'6330    ','FRENCHMAN BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7785,7772,8,'6330    ','GLEDHOW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7786,7773,8,'6330    ','GREEN VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7787,7774,8,'6330    ','HUNWICK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7788,7775,8,'6330    ','KALGAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7789,7776,8,'6330    ','KING RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7790,7777,8,'6330    ','KRONKUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7791,7778,8,'6330    ','LANGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7792,7779,8,'6330    ','LITTLE GROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7793,7780,8,'6330    ','LOCKYER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7794,7781,8,'6330    ','LOWER KING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7795,7782,8,'6330    ','LOWLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7796,7783,8,'6330    ','MARBELLUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7797,7784,8,'6330    ','MCKAIL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7798,7785,8,'6330    ','MIDDLETON BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7799,7786,8,'6330    ','MILLBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7800,7787,8,'6330    ','MILPARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7801,7788,8,'6330    ','MINDIJUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7802,7789,8,'6330    ','MIRA MAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7803,7790,8,'6330    ','MOUNT CLARENCE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7804,7791,8,'6330    ','MOUNT ELPHINSTONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7805,7792,8,'6330    ','MOUNT MELVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7806,7793,8,'6330    ','NANARUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7807,7794,8,'6330    ','NAPIER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7808,7795,8,'6330    ','NULLAKI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7809,7796,8,'6330    ','ORANA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7810,7797,8,'6330    ','PORT ALBANY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7811,7798,8,'6330    ','ROBINSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7812,7799,8,'6330    ','ROCKY CROSSING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7813,7800,8,'6330    ','SANDPATCH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7814,7801,8,'6330    ','SEPPINGS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7815,7802,8,'6330    ','SPENCER PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7816,7803,8,'6330    ','TORBAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7817,7804,8,'6330    ','TORNDIRRUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7818,7805,8,'6330    ','VANCOUVER PENINSULA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7819,7806,8,'6330    ','WALMSLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7820,7807,8,'6330    ','WARRENUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7821,7808,8,'6330    ','WEST CAPE HOWE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7822,7809,8,'6330    ','WILLYUNG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7823,7810,8,'6330    ','YAKAMIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7824,7811,8,'6330    ','YOUNGS SIDING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7825,7812,8,'6331    ','ALBANY DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7826,7813,8,'6332    ','ALBANY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7827,7814,8,'6333    ','DENMARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7828,7815,8,'6333    ','GOLDEN HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7829,7816,8,'6333    ','NORNALUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7830,7817,8,'6333    ','TINGLEDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7831,7818,8,'6335    ','GNOWANGERUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7832,7819,8,'6335    ','JACKITUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7833,7820,8,'6335    ','KEBARINGUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7834,7821,8,'6335    ','PALINUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7835,7822,8,'6336    ','COWALELLUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7836,7823,8,'6336    ','MILLS LAKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7837,7824,8,'6336    ','MINDARABIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7838,7825,8,'6336    ','NEEDILUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7839,7826,8,'6336    ','ONGERUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7840,7827,8,'6336    ','TOOMPUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7841,7828,8,'6337    ','GAIRDNER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7842,7829,8,'6337    ','JACUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7843,7830,8,'6337    ','JERRAMUNGUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7844,7831,8,'6338    ','AMELUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7845,7832,8,'6338    ','BORDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7846,7833,8,'6338    ','BOXWOOD HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7847,7834,8,'6338    ','BREMER BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7848,7835,8,'6338    ','FITZGERALD RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7849,7836,8,'6338    ','MAGITUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7850,7837,8,'6338    ','MONJEBUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7851,7838,8,'6338    ','NALYERLUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7852,7839,8,'6338    ','NORTH STIRLINGS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7853,7840,8,'6338    ','STIRLING RANGE NATIONAL PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7854,7841,8,'6341    ','NYABING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7855,7842,8,'6343    ','PINGRUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7856,7843,8,'6346    ','JERDACUTTUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7857,7844,8,'6346    ','RAVENSTHORPE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7858,7845,8,'6348    ','HOPETOUN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7859,7846,8,'6350    ','DUMBLEYUNG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7860,7847,8,'6352    ','KUKERIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7861,7848,8,'6353    ','LAKE GRACE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7862,7849,8,'6353    ','TARIN ROCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7863,7850,8,'6355    ','HOLT ROCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7864,7851,8,'6355    ','LAKE BIDDY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7865,7852,8,'6355    ','NEWDEGATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7866,7853,8,'6355    ','VARLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7867,7854,8,'6356    ','LAKE KING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7868,7855,8,'6356    ','MOUNT MADDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7869,7856,8,'6357    ','PINGARING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7870,7857,8,'6358    ','KARLGARIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7871,7858,8,'6359    ','FORRESTANIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7872,7859,8,'6359    ','HYDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7873,7860,8,'6361    ','HARRISMITH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7874,7861,8,'6361    ','TINCURRIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7875,7862,8,'6363    ','DUDININ');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7876,7863,8,'6365    ','JITARNING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7877,7864,8,'6365    ','KULIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7878,7865,8,'6367    ','BENDERING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7879,7866,8,'6367    ','KONDININ');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7880,7867,8,'6368    ','SOUTH KUMMININ');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7881,7868,8,'6369    ','MOUNT WALKER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7882,7869,8,'6369    ','NAREMBEEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7883,7870,8,'6370    ','EAST WICKEPIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7884,7871,8,'6370    ','KIRK ROCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7885,7872,8,'6370    ','MALYALLING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7886,7873,8,'6370    ','WICKEPIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7887,7874,8,'6370    ','WOGOLIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7888,7875,8,'6372    ','YEALERING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7889,7876,8,'6373    ','BULLARING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7890,7877,8,'6375    ','ADAMSVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7891,7878,8,'6375    ','BILBARIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7892,7879,8,'6375    ','CORRIGIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7893,7880,8,'6375    ','GORGE ROCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7894,7881,8,'6375    ','KUNJIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7895,7882,8,'6375    ','KURRENKUTTEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7896,7883,8,'6383    ','DANGIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7897,7884,8,'6383    ','MAWSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7898,7885,8,'6383    ','QUAIRADING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7899,7886,8,'6383    ','YOTING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7900,7887,8,'6384    ','PANTAPIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7901,7888,8,'6385    ','KWOLYIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7902,7889,8,'6386    ','SHACKLETON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7903,7890,8,'6390    ','BANNISTER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7904,7891,8,'6390    ','BODDINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7905,7892,8,'6390    ','CROSSMAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7906,7893,8,'6390    ','MOUNT WELLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7907,7894,8,'6390    ','RANFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7908,7895,8,'6391    ','BORANING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7909,7896,8,'6391    ','CONGELIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7910,7897,8,'6391    ','CULBIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7911,7898,8,'6391    ','HILLMAN RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7912,7899,8,'6391    ','LOWER HOTHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7913,7900,8,'6391    ','MARRADONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7914,7901,8,'6391    ','MOUNT COOKE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7915,7902,8,'6391    ','NARRAKINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7916,7903,8,'6391    ','NORTH BANNISTER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7917,7904,8,'6391    ','QUINDANNING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7918,7905,8,'6391    ','SPRINGS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7919,7906,8,'6391    ','TARWONGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7920,7907,8,'6391    ','WILLIAMS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7921,7908,8,'6392    ','BOKAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7922,7909,8,'6392    ','BOOLADING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7923,7910,8,'6392    ','DARKAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7924,7911,8,'6393    ','CORDERING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7925,7912,8,'6393    ','DURANILLIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7926,7913,8,'6393    ','MOODIARRUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7927,7914,8,'6393    ','TRIGWELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7928,7915,8,'6394    ','BEAUFORT RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7929,7916,8,'6394    ','BOILUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7930,7917,8,'6394    ','BOSCABEL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7931,7918,8,'6394    ','CHANGERUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7932,7919,8,'6394    ','MURADUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7933,7920,8,'6394    ','ORCHID VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7934,7921,8,'6394    ','QUALEUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7935,7922,8,'6395    ','CHERRY TREE POOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7936,7923,8,'6395    ','JINGALUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7937,7924,8,'6395    ','KOJONUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7938,7925,8,'6395    ','LUMEAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7939,7926,8,'6395    ','MOBRUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7940,7927,8,'6395    ','RYANSBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7941,7928,8,'6396    ','FRANKLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7942,7929,8,'6397    ','ROCKY GULLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7943,7930,8,'6398    ','WALPOLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7944,7931,8,'6401    ','BUCKLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7945,7932,8,'6401    ','BURLONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7946,7933,8,'6401    ','CUNJARDINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7947,7934,8,'6401    ','IRISHTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7948,7935,8,'6401    ','JENNACUBBINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7949,7936,8,'6401    ','JENNAPULLIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7950,7937,8,'6401    ','MALABAINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7951,7938,8,'6401    ','MEENAAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7952,7939,8,'6401    ','MOKINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7953,7940,8,'6401    ','MULUCKINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7954,7941,8,'6401    ','MUMBERKINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7955,7942,8,'6401    ','MURESK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7956,7943,8,'6401    ','NORTHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7957,7944,8,'6401    ','ROSSMORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7958,7945,8,'6401    ','SOUTHERN BROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7959,7946,8,'6401    ','SPENCERS BROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7960,7947,8,'6401    ','THROSSELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7961,7948,8,'6401    ','WONGAMINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7962,7949,8,'6403    ','GRASS VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7963,7950,8,'6405    ','GREENWOODS VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7964,7951,8,'6405    ','MECKERING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7965,7952,8,'6405    ','QUELAGETTING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7966,7953,8,'6405    ','WARDING EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7967,7954,8,'6407    ','CUNDERDIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7968,7955,8,'6407    ','WAEEL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7969,7956,8,'6407    ','WATERCARRIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7970,7957,8,'6407    ','WYOLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7971,7958,8,'6407    ','WYOLA WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7972,7959,8,'6407    ','YOUNDEGIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7973,7960,8,'6409    ','DOONGIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7974,7961,8,'6409    ','TAMMIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7975,7962,8,'6409    ','YORKRAKINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7976,7963,8,'6410    ','BUNGULLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7977,7964,8,'6410    ','DAADENNING CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7978,7965,8,'6410    ','KELLERBERRIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7979,7966,8,'6410    ','MOUNT CAROLINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7980,7967,8,'6410    ','NORTH KELLERBERRIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7981,7968,8,'6411    ','DOODLAKINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7982,7969,8,'6411    ','SOUTH DOODLAKINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7983,7970,8,'6412    ','BAANDEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7984,7971,8,'6412    ','NORTH BAANDEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7985,7972,8,'6413    ','BUNGULLUPING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7986,7973,8,'6413    ','HINES HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7987,7974,8,'6414    ','NANGEENAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7988,7975,8,'6415    ','GOOMARIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7989,7976,8,'6415    ','KORBEL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7990,7977,8,'6415    ','MERREDIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7991,7978,8,'6415    ','NOKANING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7992,7979,8,'6415    ','NORPA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7993,7980,8,'6415    ','TANDEGIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7994,7981,8,'6418    ','BRUCE ROCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7995,7982,8,'6418    ','YARDING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7996,7983,8,'6419    ','ARDATH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7997,7984,8,'6420    ','MUNTADGIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7998,7985,8,'6421    ','BURRACOPPIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (7999,7986,8,'6421    ','SOUTH BURRACOPPIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8000,7987,8,'6422    ','WALGOOLAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8001,7988,8,'6423    ','WESTONIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8002,7989,8,'6424    ','BODALLIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8003,7990,8,'6424    ','NORTH BODALLIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8004,7991,8,'6424    ','SOUTH BODALLIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8005,7992,8,'6425    ','DULYALBIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8006,7993,8,'6425    ','MOORINE ROCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8007,7994,8,'6426    ','CORINTHIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8008,7995,8,'6426    ','GHOOLI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8009,7996,8,'6426    ','HOLLETON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8010,7997,8,'6426    ','MARVEL LOCH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8011,7998,8,'6426    ','MOUNT HAMPTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8012,7999,8,'6426    ','MOUNT HOLLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8013,8000,8,'6426    ','MOUNT JACKSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8014,8001,8,'6426    ','MOUNT PALMER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8015,8002,8,'6426    ','PARKER RANGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8016,8003,8,'6426    ','SKELETON ROCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8017,8004,8,'6426    ','SOUTH YILGARN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8018,8005,8,'6426    ','SOUTHERN CROSS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8019,8006,8,'6426    ','TURKEY HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8020,8007,8,'6426    ','YELLOWDINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8021,8008,8,'6427    ','KOOLYANOBBING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8022,8009,8,'6428    ','BABAKIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8023,8010,8,'6429    ','BOORABBIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8024,8011,8,'6429    ','BULLABULLING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8025,8012,8,'6429    ','COOLGARDIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8026,8013,8,'6429    ','KARRAMINDIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8027,8014,8,'6429    ','LONDONDERRY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8028,8015,8,'6429    ','MOUNT BURGES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8029,8016,8,'6429    ','VICTORIA ROCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8030,8017,8,'6429    ','WALLAROO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8031,8018,8,'6430    ','BINDULI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8032,8019,8,'6430    ','BROADWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8033,8020,8,'6430    ','HANNANS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8034,8021,8,'6430    ','KALGOORLIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8035,8022,8,'6430    ','KARLKURLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8036,8023,8,'6430    ','MULLINGAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8037,8024,8,'6430    ','PICCADILLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8038,8025,8,'6430    ','SOUTH KALGOORLIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8039,8026,8,'6430    ','WEST KALGOORLIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8040,8027,8,'6430    ','WEST LAMINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8041,8028,8,'6430    ','WILLIAMSTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8042,8029,8,'6430    ','YILKARI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8043,8030,8,'6431    ','BOORARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8044,8031,8,'6431    ','BROAD ARROW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8045,8032,8,'6431    ','BROWN HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8046,8033,8,'6431    ','BULONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8047,8034,8,'6431    ','EMU FLAT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8048,8035,8,'6431    ','FEYSVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8049,8036,8,'6431    ','KANOWNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8050,8037,8,'6431    ','KURNALPI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8051,8038,8,'6431    ','LAKEWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8052,8039,8,'6431    ','ORA BANDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8053,8040,8,'6431    ','PLUMRIDGE LAKES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8054,8041,8,'6431    ','TRAFALGAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8055,8042,8,'6432    ','BOULDER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8056,8043,8,'6432    ','FIMISTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8057,8044,8,'6432    ','SOUTH BOULDER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8058,8045,8,'6432    ','VICTORY HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8059,8046,8,'6433    ','HANNANS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8060,8047,8,'6433    ','KALGOORLIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8061,8048,8,'6433    ','KALGOORLIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8062,8049,8,'6434    ','CUNDEELEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8063,8050,8,'6434    ','FORREST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8064,8051,8,'6434    ','RAWLINNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8065,8052,8,'6434    ','REID');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8066,8053,8,'6434    ','ZANTHUS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8067,8054,8,'6436    ','MENZIES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8068,8055,8,'6436    ','ULARRING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8069,8056,8,'6437    ','LEINSTER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8070,8057,8,'6438    ','LEONORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8071,8058,8,'6438    ','TEUTONIC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8072,8059,8,'6440    ','BANDYA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8073,8060,8,'6440    ','BEADELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8074,8061,8,'6440    ','BURTVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8075,8062,8,'6440    ','COSMO NEWBERY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8076,8063,8,'6440    ','LAKE WELLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8077,8064,8,'6440    ','LAVERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8078,8065,8,'6440    ','NEALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8079,8066,8,'6442    ','KAMBALDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8080,8067,8,'6443    ','BALLADONIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8081,8068,8,'6443    ','CAIGUNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8082,8069,8,'6443    ','COCKLEBIDDY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8083,8070,8,'6443    ','DUNDAS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8084,8071,8,'6443    ','EUCLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8085,8072,8,'6443    ','FRASER RANGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8086,8073,8,'6443    ','HIGGINSVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8087,8074,8,'6443    ','MADURA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8088,8075,8,'6443    ','MUNDRABILLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8089,8076,8,'6443    ','NORSEMAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8090,8077,8,'6443    ','WIDGIEMOOLTHA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8091,8078,8,'6445    ','SALMON GUMS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8092,8079,8,'6446    ','GRASS PATCH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8093,8080,8,'6448    ','GIBSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8094,8081,8,'6450    ','ESPERANCE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8095,8082,8,'6450    ','NERIDUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8096,8083,8,'6450    ','SINCLAIR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8097,8084,8,'6460    ','GOOMALLING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8098,8085,8,'6460    ','KARRANADGIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8099,8086,8,'6460    ','UCARTY WEST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8100,8087,8,'6460    ','WALYORMOURING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8101,8088,8,'6461    ','DOWERIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8102,8089,8,'6461    ','KOOMBERKINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8103,8090,8,'6462    ','HINDMARSH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8104,8091,8,'6462    ','MINNIVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8105,8092,8,'6462    ','UCARTY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8106,8093,8,'6465    ','MANMANNING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8107,8094,8,'6466    ','CADOUX');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8108,8095,8,'6467    ','BURAKIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8109,8096,8,'6468    ','GOODLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8110,8097,8,'6468    ','KALANNIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8111,8098,8,'6468    ','PETRUDOR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8112,8099,8,'6470    ','KULJA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8113,8100,8,'6472    ','BEACON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8114,8101,8,'6472    ','BIMBIJY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8115,8102,8,'6472    ','CLEARY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8116,8103,8,'6472    ','KARROUN HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8117,8104,8,'6472    ','MOUROUBRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8118,8105,8,'6472    ','REMLAP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8119,8106,8,'6473    ','NORTH WIALKI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8120,8107,8,'6473    ','WIALKI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8121,8108,8,'6475    ','BOORALAMING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8122,8109,8,'6475    ','KOORDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8123,8110,8,'6475    ','MOLLERIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8124,8111,8,'6475    ','NEWCARLBEON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8125,8112,8,'6476    ','GABBIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8126,8113,8,'6477    ','BENCUBBIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8127,8114,8,'6479    ','BARBALIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8128,8115,8,'6479    ','BONNIE ROCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8129,8116,8,'6479    ','DANDANNING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8130,8117,8,'6479    ','KARLONING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8131,8118,8,'6479    ','LAKE BROWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8132,8119,8,'6479    ','MUKINBUDIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8133,8120,8,'6479    ','WATTONING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8134,8121,8,'6479    ','WILGOYNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8135,8122,8,'6484    ','BULLFINCH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8136,8123,8,'6484    ','ENNUIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8137,8124,8,'6484    ','LAKE DEBORAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8138,8125,8,'6485    ','WYALKATCHEM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8139,8126,8,'6488    ','TRAYNING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8140,8127,8,'6489    ','KUNUNOPPIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8141,8128,8,'6490    ','NUNGARIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8142,8129,8,'6501    ','MUCHEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8143,8130,8,'6502    ','BINDOON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8144,8131,8,'6503    ','GINGIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8145,8132,8,'6505    ','WANNAMAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8146,8133,8,'6506    ','MOGUMBER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8147,8134,8,'6507    ','DANDARAGAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8148,8135,8,'6509    ','GLENTROMIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8149,8136,8,'6509    ','NEW NORCIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8150,8137,8,'6509    ','WADDINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8151,8138,8,'6509    ','YARAWINDAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8152,8139,8,'6510    ','GILLINGARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8153,8140,8,'6510    ','KOOJAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8154,8141,8,'6510    ','MOORA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8155,8142,8,'6510    ','ROUND HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8156,8143,8,'6511    ','CERVANTES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8157,8144,8,'6512    ','COOMBERDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8158,8145,8,'6513    ','WATHEROO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8159,8146,8,'6514    ','GREEN HEAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8160,8147,8,'6514    ','LEEMAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8161,8148,8,'6515    ','COOROW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8162,8149,8,'6516    ','JURIEN BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8163,8150,8,'6517    ','CARNAMAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8164,8151,8,'6518    ','ENEABBA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8165,8152,8,'6518    ','WARRADARGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8166,8153,8,'6519    ','ARRINO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8167,8154,8,'6519    ','ARROWSMITH EAST');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8168,8155,8,'6519    ','DUDAWA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8169,8156,8,'6519    ','KADATHINNI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8170,8157,8,'6519    ','THREE SPRINGS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8171,8158,8,'6519    ','WOMARDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8172,8159,8,'6521    ','BADGINGARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8173,8160,8,'6522    ','BUNDANOON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8174,8161,8,'6522    ','HOLMWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8175,8162,8,'6522    ','IKEWA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8176,8163,8,'6522    ','LOCKIER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8177,8164,8,'6522    ','MINGENEW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8178,8165,8,'6522    ','MOORIARY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8179,8166,8,'6522    ','MOUNT BUDD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8180,8167,8,'6522    ','NANGETTY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8181,8168,8,'6522    ','YANDANOOKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8182,8169,8,'6522    ','YARRAGADEE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8183,8170,8,'6525    ','DONGARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8184,8171,8,'6528    ','MOUNT HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8185,8172,8,'6528    ','SOUTH GREENOUGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8186,8173,8,'6528    ','WALKAWAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8187,8174,8,'6530    ','BEACHLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8188,8175,8,'6530    ','BERESFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8189,8176,8,'6530    ','BLUFF POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8190,8177,8,'6530    ','GERALDTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8191,8178,8,'6530    ','KARLOO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8192,8179,8,'6530    ','MAHOMETS FLATS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8193,8180,8,'6530    ','MERU');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8194,8181,8,'6530    ','MORESBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8195,8182,8,'6530    ','MOUNT TARCOOLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8196,8183,8,'6530    ','RANGEWAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8197,8184,8,'6530    ','SPALDING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8198,8185,8,'6530    ','STRATHALBYN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8199,8186,8,'6530    ','SUNSET BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8200,8187,8,'6530    ','TARCOOLA BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8201,8188,8,'6530    ','UTAKARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8202,8189,8,'6530    ','WAGGRAKINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8203,8190,8,'6530    ','WANDINA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8204,8191,8,'6530    ','WEBBERTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8205,8192,8,'6530    ','WONTHELLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8206,8193,8,'6530    ','WOORREE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8207,8194,8,'6531    ','GERALDTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8208,8195,8,'6532    ','AJANA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8209,8196,8,'6532    ','BINNU');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8210,8197,8,'6532    ','BOOTENAL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8211,8198,8,'6532    ','BRINGO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8212,8199,8,'6532    ','BURMA ROAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8213,8200,8,'6532    ','CAPE BURNEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8214,8201,8,'6532    ','COOLCALALAYA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8215,8202,8,'6532    ','DARTMOOR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8216,8203,8,'6532    ','DEEPDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8217,8204,8,'6532    ','DRUMMOND COVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8218,8205,8,'6532    ','DRUMMOND NORTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8219,8206,8,'6532    ','DURAWAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8220,8207,8,'6532    ','EAST CHAPMAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8221,8208,8,'6532    ','EAST NABAWA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8222,8209,8,'6532    ','EAST YUNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8223,8210,8,'6532    ','ELLENDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8224,8211,8,'6532    ','ERADU');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8225,8212,8,'6532    ','ERADU SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8226,8213,8,'6532    ','GEORGINA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8227,8214,8,'6532    ','GLENFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8228,8215,8,'6532    ','GREENOUGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8229,8216,8,'6532    ','HAMELIN POOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8230,8217,8,'6532    ','HICKETY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8231,8218,8,'6532    ','KOJARENA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8232,8219,8,'6532    ','MARRAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8233,8220,8,'6532    ','MINNENOOKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8234,8221,8,'6532    ','MOONYOONOOKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8235,8222,8,'6532    ','NABAWA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8236,8223,8,'6532    ','NARALING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8237,8224,8,'6532    ','NARNGULU');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8238,8225,8,'6532    ','NORTH ERADU');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8239,8226,8,'6532    ','NORTHERN GULLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8240,8227,8,'6532    ','RUDDS GULLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8241,8228,8,'6532    ','SANDSPRINGS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8242,8229,8,'6532    ','SOUTH YUNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8243,8230,8,'6532    ','TIBRADDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8244,8231,8,'6532    ','VALENTINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8245,8232,8,'6532    ','WEST BINNU');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8246,8233,8,'6532    ','WICHERINA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8247,8234,8,'6532    ','WICHERINA SOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8248,8235,8,'6532    ','YETNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8249,8236,8,'6532    ','YUNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8250,8237,8,'6535    ','ALMA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8251,8238,8,'6535    ','BOWES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8252,8239,8,'6535    ','EAST BOWES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8253,8240,8,'6535    ','GREGORY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8254,8241,8,'6535    ','HORROCKS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8255,8242,8,'6535    ','ISSEKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8256,8243,8,'6535    ','NORTHAMPTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8257,8244,8,'6535    ','OGILVIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8258,8245,8,'6535    ','SANDY GULLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8259,8246,8,'6535    ','YALLABATHARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8260,8247,8,'6536    ','KALBARRI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8261,8248,8,'6536    ','KALBARRI NATIONAL PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8262,8249,8,'6536    ','ZUYTDORP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8263,8250,8,'6537    ','DENHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8264,8251,8,'6556    ','CHIDLOW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8265,8252,8,'6558    ','WOOROLOO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8266,8253,8,'6560    ','WUNDOWIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8267,8254,8,'6562    ','BAKERS HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8268,8255,8,'6562    ','COPLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8269,8256,8,'6562    ','WOOTTATING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8270,8257,8,'6564    ','CLACKLINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8271,8258,8,'6566    ','TOODYAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8272,8259,8,'6567    ','JULIMAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8273,8260,8,'6568    ','BOLGART');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8274,8261,8,'6569    ','CALINGIRI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8275,8262,8,'6569    ','OLD PLAINS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8276,8263,8,'6571    ','YERECOIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8277,8264,8,'6572    ','PIAWANING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8278,8265,8,'6574    ','BINDI BINDI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8279,8266,8,'6575    ','MILING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8280,8267,8,'6603    ','KONNONGORRING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8281,8268,8,'6603    ','WONGAN HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8282,8269,8,'6605    ','KONDUT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8283,8270,8,'6606    ','BALLIDU');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8284,8271,8,'6608    ','EAST DAMBORING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8285,8272,8,'6608    ','MARNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8286,8273,8,'6608    ','PITHARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8287,8274,8,'6609    ','DALWALLINU');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8288,8275,8,'6609    ','NUGADONG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8289,8276,8,'6609    ','XANTIPPE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8290,8277,8,'6612    ','JIBBERDING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8291,8278,8,'6612    ','MIAMOON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8292,8279,8,'6612    ','WUBIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8293,8280,8,'6613    ','BUNTINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8294,8281,8,'6614    ','MAYA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8295,8282,8,'6616    ','LATHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8296,8283,8,'6620    ','PERENJORI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8297,8284,8,'6623    ','GUTHA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8298,8285,8,'6623    ','KOOLANOOKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8299,8286,8,'6623    ','MORAWA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8300,8287,8,'6623    ','PINTHARUKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8301,8288,8,'6625    ','MERKANOOKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8302,8289,8,'6627    ','CANNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8303,8290,8,'6628    ','TARDUN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8304,8291,8,'6630    ','MULLEWA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8305,8292,8,'6632    ','TENINDEWA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8306,8293,8,'6635    ','YALGOO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8307,8294,8,'6638    ','COOLADAR HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8308,8295,8,'6638    ','DAGGAR HILLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8309,8296,8,'6638    ','MOUNT MAGNET');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8310,8297,8,'6638    ','PAYNESVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8311,8298,8,'6639    ','SANDSTONE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8312,8299,8,'6640    ','CUE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8313,8300,8,'6640    ','REEDY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8314,8301,8,'6642    ','ANGELO RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8315,8302,8,'6642    ','CAPRICORN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8316,8303,8,'6642    ','KUMARINA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8317,8304,8,'6642    ','MEEKATHARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8318,8305,8,'6642    ','PEAK HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8319,8306,8,'6646    ','WILUNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8320,8307,8,'6701    ','BABBAGE ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8321,8308,8,'6701    ','BERNIER ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8322,8309,8,'6701    ','BROCKMAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8323,8310,8,'6701    ','BROWN RANGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8324,8311,8,'6701    ','CARNARVON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8325,8312,8,'6701    ','CORAL BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8326,8313,8,'6701    ','DORRE ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8327,8314,8,'6701    ','EAST CARNARVON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8328,8315,8,'6701    ','GREYS PLAIN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8329,8316,8,'6701    ','INGGARDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8330,8317,8,'6701    ','KENNEDY RANGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8331,8318,8,'6701    ','KINGSFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8332,8319,8,'6701    ','LYNDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8333,8320,8,'6701    ','MACLEOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8334,8321,8,'6701    ','MASSEY BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8335,8322,8,'6701    ','MAUDS LANDING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8336,8323,8,'6701    ','MINILYA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8337,8324,8,'6701    ','MORGANTOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8338,8325,8,'6701    ','NINGALOO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8339,8326,8,'6701    ','NORTH PLANTATIONS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8340,8327,8,'6701    ','SOUTH CARNARVON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8341,8328,8,'6701    ','SOUTH PLANTATIONS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8342,8329,8,'6701    ','WOORAMEL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8343,8330,8,'6701    ','YANDOO CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8344,8331,8,'6705    ','EAST LYONS RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8345,8332,8,'6705    ','GASCOYNE JUNCTION');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8346,8333,8,'6705    ','GASCOYNE RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8347,8334,8,'6705    ','WEST LYONS RIVER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8348,8335,8,'6707    ','CAPE RANGE NATIONAL PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8349,8336,8,'6707    ','EXMOUTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8350,8337,8,'6707    ','EXMOUTH GULF');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8351,8338,8,'6707    ','LEARMONTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8352,8339,8,'6707    ','NORTH WEST CAPE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8353,8340,8,'6710    ','CANE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8354,8341,8,'6710    ','ONSLOW');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8355,8342,8,'6710    ','PEEDAMULLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8356,8343,8,'6710    ','TALANDJI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8357,8344,8,'6710    ','YANNARIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8358,8345,8,'6711    ','THEVENARD ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8359,8346,8,'6712    ','BARROW ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8360,8347,8,'6713    ','DAMPIER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8361,8348,8,'6714    ','ANTONYMYRE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8362,8349,8,'6714    ','BALLA BALLA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8363,8350,8,'6714    ','BAYNTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8364,8351,8,'6714    ','BULGARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8365,8352,8,'6714    ','BURRUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8366,8353,8,'6714    ','CLEAVERVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8367,8354,8,'6714    ','COOYA POOYA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8368,8355,8,'6714    ','GAP RIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8369,8356,8,'6714    ','GNOOREA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8370,8357,8,'6714    ','KARRATHA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8371,8358,8,'6714    ','KARRATHA INDUSTRIAL ESTATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8372,8359,8,'6714    ','MAITLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8373,8360,8,'6714    ','MARDIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8374,8361,8,'6714    ','MILLARS WELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8375,8362,8,'6714    ','MOUNT ANKETELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8376,8363,8,'6714    ','MULATAGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8377,8364,8,'6714    ','NICKOL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8378,8365,8,'6714    ','PEGS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8379,8366,8,'6714    ','SHERLOCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8380,8367,8,'6714    ','STOVE HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8381,8368,8,'6716    ','FORTESCUE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8382,8369,8,'6716    ','HAMERSLEY RANGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8383,8370,8,'6716    ','MILLSTREAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8384,8371,8,'6716    ','PANNAWONICA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8385,8372,8,'6718    ','ROEBOURNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8386,8373,8,'6720    ','COSSACK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8387,8374,8,'6720    ','WICKHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8388,8375,8,'6721    ','PORT HEDLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8389,8376,8,'6722    ','BOODARIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8390,8377,8,'6722    ','DE GREY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8391,8378,8,'6722    ','FINUCANE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8392,8379,8,'6722    ','PIPPINGARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8393,8380,8,'6722    ','SOUTH HEDLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8394,8381,8,'6723    ','GOLDSWORTHY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8395,8382,8,'6725    ','BROOME');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8396,8383,8,'6725    ','DAMPIER PENINSULA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8397,8384,8,'6725    ','EIGHTY MILE BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8398,8385,8,'6725    ','GINGERAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8399,8386,8,'6725    ','LAGRANGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8400,8387,8,'6725    ','ROEBUCK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8401,8388,8,'6725    ','WATERBANK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8402,8389,8,'6726    ','CABLE BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8403,8390,8,'6728    ','DERBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8404,8391,8,'6733    ','KOOLAN ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8405,8392,8,'6740    ','WYNDHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8406,8393,8,'6743    ','KUNUNURRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8407,8394,8,'6743    ','WARMUN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8408,8395,8,'6751    ','INNAWANGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8409,8396,8,'6751    ','JUNA DOWNS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8410,8397,8,'6751    ','KARIJINI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8411,8398,8,'6751    ','MOUNT SHEILA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8412,8399,8,'6751    ','MULGA DOWNS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8413,8400,8,'6751    ','NANUTARRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8414,8401,8,'6751    ','ROCKLEA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8415,8402,8,'6751    ','TOM PRICE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8416,8403,8,'6753    ','MUNDIWINDI');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8417,8404,8,'6753    ','NEWMAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8418,8405,8,'6754    ','CHICHESTER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8419,8406,8,'6754    ','PARABURDOO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8420,8407,8,'6754    ','WITTENOOM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8421,8408,8,'6758    ','NULLAGINE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8422,8409,8,'6760    ','MARBLE BAR');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8423,8410,8,'6761    ','SHAY GAP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8424,8411,8,'6762    ','TELFER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8425,8412,8,'6765    ','FITZROY CROSSING');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8426,8413,8,'6770    ','HALLS CREEK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8427,8414,8,'6770    ','MCBEATH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8428,8415,8,'6798    ','CHRISTMAS ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8429,8416,8,'6799    ','HOME ISLAND COCOS (KEELING) ISLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8430,8417,8,'6799    ','WEST ISLAND COCOS (KEELING) ISLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8431,8418,8,'6831    ','PERTH ST GEORGES TCE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8432,8419,8,'6832    ','PERTH EAST ST GEORGES TCE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8433,8420,8,'6837    ','PERTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8434,8421,8,'6838    ','PERTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8435,8422,8,'6839    ','PERTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8436,8423,8,'6840    ','PERTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8437,8424,8,'6841    ','PERTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8438,8425,8,'6842    ','PERTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8439,8426,8,'6843    ','PERTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8440,8427,8,'6844    ','PERTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8441,8428,8,'6845    ','PERTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8442,8429,8,'6846    ','PERTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8443,8430,8,'6847    ','PERTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8444,8431,8,'6848    ','PERTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8445,8432,8,'6849    ','PERTH BC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8446,8433,8,'6850    ','CLOISTERS SQUARE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8447,8434,8,'6865    ','NORTHBRIDGE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8448,8435,8,'6872    ','WEST PERTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8449,8436,8,'6892    ','EAST PERTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8450,8437,8,'6901    ','WEST LEEDERVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8451,8438,8,'6902    ','LEEDERVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8452,8439,8,'6903    ','LEEDERVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8453,8440,8,'6904    ','SUBIACO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8454,8441,8,'6905    ','NORTHLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8455,8442,8,'6906    ','NORTH PERTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8456,8443,8,'6907    ','NEDLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8457,8444,8,'6909    ','NEDLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8458,8445,8,'6910    ','CLAREMONT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8459,8446,8,'6911    ','COTTESLOE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8460,8447,8,'6912    ','MOSMAN PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8461,8448,8,'6913    ','WEMBLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8462,8449,8,'6914    ','BALCATTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8463,8450,8,'6915    ','MOUNT HAWTHORN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8464,8451,8,'6916    ','OSBORNE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8465,8452,8,'6916    ','OSBORNE PARK DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8466,8453,8,'6917    ','OSBORNE PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8467,8454,8,'6918    ','INNALOO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8468,8455,8,'6919    ','JOONDALUP DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8469,8456,8,'6920    ','NORTH BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8470,8457,8,'6921    ','KARRINYUP');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8471,8458,8,'6922    ','SCARBOROUGH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8472,8459,8,'6923    ','HILLARYS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8473,8460,8,'6924    ','GREENWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8474,8461,8,'6925    ','WALLISTON DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8475,8462,8,'6926    ','KALAMUNDA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8476,8463,8,'6929    ','MOUNT LAWLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8477,8464,8,'6931    ','MAYLANDS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8478,8465,8,'6932    ','INGLEWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8479,8466,8,'6933    ','BAYSWATER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8480,8467,8,'6934    ','BASSENDEAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8481,8468,8,'6935    ','GUILDFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8482,8469,8,'6936    ','MIDLAND DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8483,8470,8,'6939    ','TUART HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8484,8471,8,'6941    ','MIRRABOOKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8485,8472,8,'6942    ','BASSENDEAN DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8486,8473,8,'6943    ','MORLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8487,8474,8,'6944    ','MALAGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8488,8475,8,'6945    ','MALAGA DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8489,8476,8,'6946    ','WANNEROO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8490,8477,8,'6947    ','WANGARA DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8491,8478,8,'6951    ','SOUTH PERTH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8492,8479,8,'6952    ','COMO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8493,8480,8,'6953    ','APPLECROSS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8494,8481,8,'6954    ','BOORAGOON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8495,8482,8,'6955    ','WILLETTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8496,8483,8,'6956    ','MELVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8497,8484,8,'6957    ','PALMYRA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8498,8485,8,'6958    ','ROYAL AUSTRALIAN NAVY WARSHIPS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8499,8486,8,'6959    ','FREMANTLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8500,8487,8,'6960    ','MYAREE BC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8501,8488,8,'6961    ','PALMYRA DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8502,8489,8,'6963    ','HAMILTON HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8503,8490,8,'6964    ','SUCCESS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8504,8491,8,'6965    ','BIBRA LAKE DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8505,8492,8,'6966    ','KWINANA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8506,8493,8,'6967    ','ROCKINGHAM DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8507,8494,8,'6968    ','ROCKINGHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8508,8495,8,'6969    ','ROCKINGHAM BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8509,8496,8,'6970    ','CANNING VALE DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8510,8497,8,'6979    ','VICTORIA PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8511,8498,8,'6981    ','EAST VICTORIA PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8512,8499,8,'6982    ','BENTLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8513,8500,8,'6983    ','BENTLEY DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8514,8501,8,'6984    ','BELMONT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8515,8502,8,'6985    ','CLOVERDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8516,8503,8,'6986    ','WELSHPOOL DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8517,8504,8,'6987    ','CANNINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8518,8505,8,'6988    ','THORNLIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8519,8506,8,'6989    ','MADDINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8520,8507,8,'6990    ','GOSNELLS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8521,8508,8,'6991    ','KELMSCOTT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8522,8509,8,'6992    ','ARMADALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8523,8510,8,'6997    ','KELMSCOTT DC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8524,8511,5,'7000    ','GLEBE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8525,8512,5,'7000    ','HOBART');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8526,8513,5,'7000    ','MOUNT STUART');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8527,8514,5,'7000    ','NORTH HOBART');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8528,8515,5,'7000    ','PARLIAMENT HOUSE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8529,8516,5,'7000    ','WEST HOBART');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8530,8517,5,'7001    ','HOBART');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8531,8518,5,'7001    ','MAATSUYKER ISLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8532,8519,5,'7001    ','PORT DAVEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8533,8520,5,'7002    ','NORTH HOBART');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8534,8521,5,'7004    ','BATTERY POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8535,8522,5,'7004    ','SOUTH HOBART');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8536,8523,5,'7005    ','DYNNYRNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8537,8524,5,'7005    ','SANDY BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8538,8525,5,'7005    ','UNIVERSITY OF TASMANIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8539,8526,5,'7006    ','SANDY BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8540,8527,5,'7007    ','MOUNT NELSON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8541,8528,5,'7008    ','CORNELIAN BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8542,8529,5,'7008    ','LENAH VALLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8543,8530,5,'7008    ','NEW TOWN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8544,8531,5,'7009    ','DERWENT PARK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8545,8532,5,'7009    ','LUTANA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8546,8533,5,'7009    ','MOONAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8547,8534,5,'7010    ','DOWSING POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8548,8535,5,'7010    ','ELWICK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8549,8536,5,'7010    ','GLENORCHY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8550,8537,5,'7010    ','GOODWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8551,8538,5,'7010    ','MONTROSE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8552,8539,5,'7010    ','ROSETTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8553,8540,5,'7011    ','AUSTINS FERRY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8554,8541,5,'7011    ','BERRIEDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8555,8542,5,'7011    ','CHIGWELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8556,8543,5,'7011    ','CLAREMONT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8557,8544,5,'7012    ','COLLINSVALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8558,8545,5,'7012    ','GLENLUSK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8559,8546,5,'7015    ','FLAGSTAFF GULLY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8560,8547,5,'7015    ','GEILSTON BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8561,8548,5,'7015    ','LINDISFARNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8562,8549,5,'7015    ','ROSE BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8563,8550,5,'7016    ','RISDON VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8564,8551,5,'7017    ','GRASSTREE HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8565,8552,5,'7017    ','HONEYWOOD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8566,8553,5,'7017    ','OLD BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8567,8554,5,'7017    ','OTAGO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8568,8555,5,'7017    ','TEA TREE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8569,8556,5,'7018    ','BELLERIVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8570,8557,5,'7018    ','HOWRAH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8571,8558,5,'7018    ','MONTAGU BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8572,8559,5,'7018    ','MORNINGTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8573,8560,5,'7018    ','ROSNY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8574,8561,5,'7018    ','TRANMERE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8575,8562,5,'7018    ','WARRANE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8576,8563,5,'7019    ','CLARENDON VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8577,8564,5,'7019    ','ROKEBY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8578,8565,5,'7020    ','CLIFTON BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8579,8566,5,'7020    ','SANDFORD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8580,8567,5,'7021    ','LAUDERDALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8581,8568,5,'7022    ','SOUTH ARM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8582,8569,5,'7023    ','OPOSSUM BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8583,8570,5,'7024    ','CREMORNE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8584,8571,5,'7025    ','DULCOT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8585,8572,5,'7025    ','RICHMOND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8586,8573,5,'7026    ','CAMPANIA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8587,8574,5,'7026    ','LOWDINA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8588,8575,5,'7026    ','REKUNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8589,8576,5,'7027    ','COLEBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8590,8577,5,'7027    ','ELDON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8591,8578,5,'7030    ','APSLEY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8592,8579,5,'7030    ','BAGDAD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8593,8580,5,'7030    ','BOTHWELL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8594,8581,5,'7030    ','BRIDGEWATER');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8595,8582,5,'7030    ','BRIGHTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8596,8583,5,'7030    ','BROADMARSH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8597,8584,5,'7030    ','CLIFTON VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8598,8585,5,'7030    ','DROMEDARY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8599,8586,5,'7030    ','DYSART');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8600,8587,5,'7030    ','ELDERSLIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8601,8588,5,'7030    ','GAGEBROOK');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8602,8589,5,'7030    ','GRANTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8603,8590,5,'7030    ','INTERLAKEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8604,8591,5,'7030    ','JERICHO');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8605,8592,5,'7030    ','KEMPTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8606,8593,5,'7030    ','LOWER MARSHES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8607,8594,5,'7030    ','MANGALORE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8608,8595,5,'7030    ','MELTON MOWBRAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8609,8596,5,'7030    ','MIENA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8610,8597,5,'7030    ','PELHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8611,8598,5,'7030    ','PONTVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8612,8599,5,'7030    ','RUTLAND');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8613,8600,5,'7030    ','SHANNON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8614,8601,5,'7030    ','SPRING HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8615,8602,5,'7030    ','STEPPES');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8616,8603,5,'7030    ','WADDAMANA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8617,8604,5,'7030    ','WIHAREJA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8618,8605,5,'7050    ','ALBION HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8619,8606,5,'7050    ','KINGSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8620,8607,5,'7050    ','KINGSTON BEACH');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8621,8608,5,'7050    ','MARANOA HEIGHTS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8622,8609,5,'7051    ','KINGSTON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8623,8610,5,'7052    ','BLACKMANS BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8624,8611,5,'7053    ','BONNET HILL');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8625,8612,5,'7053    ','TARONGA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8626,8613,5,'7053    ','TAROONA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8627,8614,5,'7054    ','BARRETTA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8628,8615,5,'7054    ','CONINGHAM');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8629,8616,5,'7054    ','ELECTRONA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8630,8617,5,'7054    ','FERN TREE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8631,8618,5,'7054    ','HOWDEN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8632,8619,5,'7054    ','LESLIE VALE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8633,8620,5,'7054    ','MARGATE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8634,8621,5,'7054    ','NEIKA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8635,8622,5,'7054    ','NIERINNA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8636,8623,5,'7054    ','PIERSONS POINT');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8637,8624,5,'7054    ','RIDGEWAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8638,8625,5,'7054    ','SNUG');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8639,8626,5,'7054    ','TINDERBOX');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8640,8627,5,'7055    ','HUNTINGFIELD');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8641,8628,5,'7109    ','CATAMARAN');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8642,8629,5,'7109    ','CRABTREE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8643,8630,5,'7109    ','CRADOC');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8644,8631,5,'7109    ','GLAZIERS BAY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8645,8632,5,'7109    ','GLEN HUON');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8646,8633,5,'7109    ','GLENDEVIE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8647,8634,5,'7109    ','GROVE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8648,8635,5,'7109    ','HASTINGS');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8649,8636,5,'7109    ','HUONVILLE');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8650,8637,5,'7109    ','JUDBURY');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8651,8638,5,'7109    ','LOLLARA');
INSERT INTO "urb" ("audit_id","id","statecode","postcode","name") VALUES (8652,8639,5,'7109    ','LONNAV