/*
 * Mach Operating System
 * Copyright (c) 1991,1990,1989 Carnegie Mellon University
 * All Rights Reserved.
 *
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 *
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * Carnegie Mellon requests users of this software to return to
 *
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */
/*
 * HISTORY
 * $Log: vm_types.h,v $
 * Revision 1.2  2002/05/28 07:35:05  roland
 * 2002-05-28  Roland McGrath  <roland@frob.com>
 *
 * 	* alpha/alpha/prom_interface.h: Fix obsolescent #else/#endif syntax.
 * 	* alpha/alpha/pmap.c: Likewise.
 * 	* alpha/alpha/pmap.h: Likewise.
 * 	* alpha/alpha/pcb.c: Likewise.
 * 	* alpha/alpha/context.h: Likewise.
 * 	* alpha/alpha/thread.h: Likewise.
 * 	* alpha/include/mach/alpha/alpha_instruction.h: Likewise.
 * 	* alpha/include/mach/alpha/vm_param.h: Likewise.
 * 	* alpha/include/mach/alpha/vm_types.h: Likewise.
 * 	* alpha/include/mach/alpha/boolean.h: Likewise.
 * 	* alpha/include/mach/alpha/kern_return.h: Likewise.
 * 	* alpha/include/mach/alpha/thread_status.h: Likewise.
 * 	* alpha/include/mach/alpha/syscall_sw.h: Likewise.
 * 	* alpha/include/mach/alpha/exception.h: Likewise.
 * 	* alpha/alpha/alpha_copyin.S: Likewise.
 * 	* alpha/alpha/machspl.h: Likewise.
 * 	* alpha/alpha/trap.c: Likewise.
 * 	* alpha/alpha/alpha_instruction.c: Likewise.
 * 	* alpha/alpha/alpha_init.c: Likewise.
 * 	* alpha/alpha/setjmp.h: Likewise.
 * 	* alpha/alpha/vm_tuning.h: Likewise.
 *
 * Revision 1.1  2002/05/28 06:27:03  roland
 * Alpha support files verbatim from CMU release MK83a.
 *
 * Revision 2.2  93/01/14  17:41:19  danner
 * 	Created.
 * 	[91/12/29            af]
 *
 */
/*
 *	File:	alpha/vm_types.h
 *	Author:	Alessandro Forin
 *	Date:	12/91
 *
 *	Header file for VM data types.  Alpha version.
 *
 */

#ifndef	_MACHINE_VM_TYPES_H_
#define	_MACHINE_VM_TYPES_H_	1

#ifdef	ASSEMBLER
#else	/* ASSEMBLER */

/*
 * A natural_t is the type for the native
 * integer type, e.g. 32 or 64 or.. whatever
 * register size the machine has.  Unsigned, it is
 * used for entities that might be either
 * unsigned integers or pointers, and for
 * type-casting between the two.
 * For instance, the IPC system represents
 * a port in user space as an integer and
 * in kernel space as a pointer.
 */
typedef unsigned long	natural_t;

/*
 * An integer_t is the signed counterpart
 * of the natural_t type. Both types are
 * only supposed to be used to define
 * other types in a machine-independent
 * way.
 */
typedef long		integer_t;

/*
 * An int32 is an integer that is at least 32 bits wide
 */
typedef int		int32;
typedef unsigned int	uint32;

/*
 * A vm_offset_t is a type-neutral pointer,
 * e.g. an offset into a virtual memory space.
 */
typedef	natural_t	vm_offset_t;

/*
 * A vm_size_t is the proper type for e.g.
 * expressing the difference between two
 * vm_offset_t entities.
 */
typedef	natural_t	vm_size_t;

#endif	/* ASSEMBLER */

/*
 * If composing messages by hand (please dont)
 */

#define	MACH_MSG_TYPE_INTEGER_T	MACH_MSG_TYPE_INTEGER_64

#endif	/* _MACHINE_VM_TYPES_H_ */
