/*
 * init helper for picotcp4dos
 * Copyright (C) 2015 Mateusz Viste
 *
 * http://picotcp4dos.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef PICOINIT_H_SENTINEL
#define PICOINIT_H_SENTINEL

#include "picotcp.h"

enum PICOINIT_RESULTS {
  PICOINIT_CONFIG   = -1,
  PICOINIT_PKTDRV   = -2,
  PICOINIT_DEVICE   = -3,
  PICOINIT_LINKADD  = -4,
  PICOINIT_ROUTEADD = -5,
  PICOINIT_DNSINIT  = -6,
  PICOINIT_DNSADD   = -7,
  PICOINIT_NOMEM    = -8
};

enum PICOINIT_FLAGS {
  PICOINIT_NOCONF   = 1
};

int picoinit(struct pico_device *picodev, int flags);
void picoquit(struct pico_device *picodev);
char *picover(void);

#endif
