
#include <stdio.h>
#include "sequence.h"
#include "bitarray.h"
#include "measures.h"
#include "atime.h"

class Afooclass
{
public:
			Afooclass(unsigned int nElements);
	
	ASequenceOf<unsigned char>	fBitSequence;
};

Afooclass::Afooclass(unsigned int nElements)
	: fBitSequence((unsigned long)((nElements+7)/8),0)
{
}

void
test_sequence()
{
	ABitSequence bitsy(10);
	Afooclass foo(10);
}

main()
{
	days day(1);
	hours hour(day);
	minutes minute(hour);
	seconds sec(minute);
	milliseconds mil(sec);
	microseconds micro(sec);
	nanoseconds nano(sec);
	picoseconds pico(sec);
	
	printf("Days: %f\n",(double)day);
	printf("Hours: %f\n",(double)hour);
	printf("Minutes: %f\n",(double)minute);
	printf("Seconds: %f\n",(double)sec);
	printf("Milliseconds: %f\n",(double)mil);
	printf("Microseconds: %f\n", (double)micro);
	printf("Nanoseconds: %f\n", (double)nano);
	printf("Picoseconds: %f\n", (double)pico);
	
	
	ASystemClock clock;
	AStopWatch watch;
		
	printf("Delaying for 3 seconds\n");
	watch.Start();
	clock.DelayFor(seconds(3));
	watch.Stop();
	microseconds time(0.0);
	watch.GetElapsedTime(time);
	printf("Finished: %f - microseconds\n", (double)time);
	
	
	thread_id myid = find_thread(0);
	printf("My ID: %d\n",myid);
	
	// Create and start a ticker
	ATicker *ticker = new ATicker(2.0);
	
	// busy wait so some tickers go off
	double baseTime = system_time();
	do {
		;
	} while (system_time() < baseTime + 10000000/2);
	
	delete ticker;
	
	return 0;
}
