class PRandomNumberGenerator
{
public:
	virtual void Reset() = 0;
	virtual	double Next() = 0;

	virtual	operator double() = 0;
	virtual	operator unsigned long() =0;
};


//============================================
//	Class: ALCGRandom
//
// A Linear Congruential Generator
//============================================
class ALCGRandom
{
public:
			ALCGRandom();
			ALCGRandom(int seed=0);

	virtual	void		Reset();
	virtual	double	Next();

			operator double();
			operator unsigned long();

protected:
	unsigned long	fSeed;
	unsigned long	fMultiplier;
	unsigned long	fAdder;
private:
};

//============================================
//	Class: ACombinedLCGRandom
//
// A Linear Congruential Generator
//============================================
class ACombinedLCGRandom
{
public:
			ACombinedLCGRandom();

	virtual	void	Reset();
	virtual	double	Next();

			operator double();

protected:

private:

};


class Random
{
public:
			Random(unsigned long seed = 1) : fSeed(seed) {};
	
	// Uniform distributions
	unsigned long 	RandomLong();
	double	RandomReal();
	long	Between(const long low, const long high);
	
	// Non-uniform distributions
	unsigned long Poisson(double expectedVal);
	double	NegExp(double expectedVal);
	
protected:
	unsigned long fSeed;
	
private:

};

