#include "random.h"
#include <limits.h>
#include <math.h>


ALCGRandom::ALCGRandom()
	: fSeed(),
	fMutiplier(),
	fAdder()
{

}

ALCGRandom::ALCGRandom(const unsigned long seed,
		const unsignedlong multiplier,
		const unsigned long adder))
	: fSeed(seed),
	fMultiplier(multiplier),
	fAdder(adder)
{
}

void
ALCGRandom::Reset()
{
}

double
ALCGRandom::Next()
{
}
ALCGRandom::operator double()
{
}
ALCGRandom::operator unsigned long()
{
}


/*
	Generic random number generator
*/

static const long A = 48271L;
static const long M = 2147483647L;
static const long Q = M/A;
static const long R = M%A;

// Uniform distributions
unsigned long 	
Random::RandomLong()
{
	long TmpSeed = A*(fSeed%Q) - R * (fSeed/Q);
	if (TmpSeed >= 0)
		fSeed = TmpSeed;
	else
		fSeed = TmpSeed + M;
	
	return fSeed;
}

double	
Random::RandomReal()
{
	return ((double)RandomLong() / (double)M);
}

long
Random::Between(const long low, const long high)
{
	double diff = high - low;
	return (low + floor(RandomReal()*diff));
}

	
// Non-uniform distributions
unsigned long 
Random::Poisson(double expectedVal)
{
	double Limit = exp(-expectedVal);
	double Product = RandomReal();
	
	int Count;
	for (Count = 0; Product > Limit; Count++)
		Product *= RandomReal();
		
	return Count;
}

double	
Random::NegExp(double expectedVal)
{
	return - expectedVal * log(RandomReal());
}



