#include "bitarray.h"

ABitSequence::ABitSequence(unsigned int nElements)
	: fBitSequence((unsigned long)((nElements+7)/8),0)
{
}

ABitSequence::ABitSequence(const ABitSequence& other)
	: fBitSequence(other.fBitSequence)
{
}

unsigned long
ABitSequence::Length() const
{
	return 8*fBitSequence.Length();
}

// Bit changing operations
void
ABitSequence::Set(unsigned long idx)
{
	fBitSequence[ByteNumber(idx)] |= (unsigned char)Mask(idx);
}

void
ABitSequence::Clear(unsigned long idx)
{
	fBitSequence[ByteNumber(idx)] &= ~(unsigned char)Mask(idx);
}

void
ABitSequence::ClearAll()
{
	fBitSequence.SetAllToValue(0);
}

int
ABitSequence::IsSet(unsigned long idx) const
{
	return (0 != (fBitSequence[ByteNumber(idx)] & Mask(idx)));
}

void
ABitSequence::Flip(unsigned long idx)
{
	fBitSequence[ByteNumber(idx)] ^= (unsigned char)Mask(idx);
}

// Set Operations
void
ABitSequence::Add(const ABitSequence& other)				// operator |=
{
	assert(Length() == other.Length());
	const unsigned long aLength = Length();
	
	for (unsigned long counter = 0; counter < aLength; counter++)
		fBitSequence[counter]|= other.fBitSequence[counter];
}

void
ABitSequence::Subtract(const ABitSequence& other)		// operator &= ~
{
	assert(Length() == other.Length());

	const unsigned long aLength = Length();
	for (unsigned long counter = 0; counter < aLength; counter++)
		fBitSequence[counter] &= ~other.fBitSequence[counter];
}

void
ABitSequence::IntersectWith(const ABitSequence& other)	//	operator &=
{
	assert(Length() == other.Length());
	const unsigned long aLength = Length();
	for (unsigned long counter = 0; counter < aLength; counter++)
		fBitSequence[counter] &= other.fBitSequence[counter];
}

int
ABitSequence::Includes(const ABitSequence& other) const
{
	assert(Length() == other.Length());
	const unsigned long aLength = Length();
	for (unsigned long counter = 0; counter < aLength; counter++)
		if (other.fBitSequence[counter] != (fBitSequence[counter] & other.fBitSequence[counter]))
			return 0;

	return 1;
}

// Some utility routines
unsigned long
ABitSequence::ByteNumber(unsigned long idx) const
{
	return idx >> 3;
}
unsigned long
ABitSequence::Mask(unsigned long idx) const
{
	const unsigned long shiftAmount = idx & 07;
	return 1 << shiftAmount;
}