// Class: ABinaryNode
//
template <class AType> class ABinaryNode
{
public:
				ABinaryNode(AType aValue);
				ABinaryNode(AType aValue, ABinaryNode* left, ABinaryNode* right);


				ABinaryNode*	Copy() const;
				void				Release();

				ABinaryNode*	Left() const;
				ABinaryNode*	Right() const;

				void				SetLeft(ABinaryNode<AType> *aValue);
				void				SetRight(ABinaryNode<AType> *aValue);

				AType	fValue;

protected:
				ABinaryNode*	fLeft;
				ABinaryNode*	fRight;

private:
};


//
// Template: ABinaryNode<AType>
// Implementation
//
template <class AType>
ABinaryNode::ABinaryNode(AType aValue)
{
	fValue = aValue;
}

template <class AType>
ABinaryNode::ABinaryNode(AType aValue, ABinaryNode* left, ABinaryNode* right)
{
	fValue = aValue;
	fLeft = left;
	fRight = right;
}


template <class AType>
ABinaryNode*
ABinaryNode::Copy() const
{
	ABinaryNode<AType> * newLeft;
	ABinaryNode<AType> * newRight;

	if (fLeft != 0)
		newLeft = fLeft->Copy();
	else
		newLeft = 0;

	if (fRight != 0)
		newRight = fRight->Copy();
	else
		newRight = 0;

	ABinaryNode<AType> * newNode = new ABinaryNode<AType>(fValue, newLeft, newRight);
	assert(newNode != 0);

	return newNode;
}

template <class AType>
void
ABinaryNode::Release()
{
	if (fLeft)
	{
		fLeft->Release();
		delete fLeft;
		fLeft = 0;
	}

	if (fRight)
	{
		fRight->Release();
		delete fRight;
		fRight = 0;
	}
}

template <class AType>
ABinaryNode*
ABinaryNode::Left() const
{
	return fLeft;
}

template <class AType>
ABinaryNode*
ABinaryNode::Right() const
{
	return fRight;
}

template <class AType>
void
ABinaryNode::SetLeft(ABinaryNode<AType> *aValue)
{
	fLeft = aValue;
}

template <class AType>
void
ABinaryNode::SetRight(ABinaryNode<AType> *aValue)
{
	fRight = aValue;
}
