#ifndef _B_BTSNETMSGCLIENT
#define _B_BTSNETMSGCLIENT 1

#include <net/socket.h>
#include <app/Looper.h>

#include "BTSNetMsgUtils.h"

#define kDefaultNetMsgClientName "NetMsg Client"
#define kConnectThreadName "Client Connector"

#define CONNECT_MSG 'CNCT'
#define DEAD_CONNECTION_MSG 'DDCT'

// =============================================================================

class BTSNetMsgClient : public BLooper
{
	public:
									BTSNetMsgClient(const unsigned short port, 
									const char* serverHostName,
									BLooper* messageReceiver = NULL,
									const int family = AF_INET, 
									const int type = SOCK_STREAM,
									const int protocol = IPPROTO_TCP,
									const long priority = B_NORMAL_PRIORITY);
		virtual BTSSocket&			Socket() {	return fSocket;};
		virtual const				BTSAddress&	Address() {	return fAddress;};
		virtual BLooper*			MessageReceiver() 
											{	return fMessageReceiver;};
;
		virtual bool				IsExiting() { 	return fExiting;};
		virtual thread_id			Run();
		virtual void				Quit();
		virtual void				MessageReceived(BMessage* inMessage);


	private:
	
		BLooper*					fMessageReceiver;
		const char*					fServerHostName;
		BTSSocket					fSocket;
		const BTSAddress			fAddress;
		thread_id					fConnectorID;
		thread_id					fSocketListenerID;
		const long					fPriority;		
		bool						fConnected;
		bool						fExiting;

		virtual bool				StartConnecting();
		static long					ListenToServer(void*arg);
		static long 				ConnectToServer(void* arg);
};

#endif