/***************************************************
**
**	File: wLink.cpp
**	Description: 3d link constructor.
**	Copyright 1997, Be Incorporated
**
***************************************************/

#ifndef _W_LINK_H_
#include <wLink.h>
#endif
#ifndef _3D_MATH_LIB_H_
#include <3dMathLib.h>
#endif
#ifndef _3D_THING_H_
#include <3dThing.h>
#endif

#include <Debug.h>

wLink::wLink(B3dThing  *m1,
			 B3dThing  *m2,
			 B3dThing  *ref,
			 B3dVector *axis) :
B3dLink(B_RIGID_LINK) {
// reference axis we are supposed to turn around
	ref_z = *axis;
// two masters, giving the direction of reference	
	masters[0] = m1;
	masters[1] = m2;
// object used to generate the angle
	masters[2] = ref;
}

void wLink::SetSlave(B3dThing *slave) {
	B3dVector    v;

// Memorize the distance between the slave and
// its first master at link time
	v = *slave->Origin() - *masters[0]->Origin();
	length = v.Norm(TRUE);
}

void wLink::DoLink(B3dThing  *Object,
				   bigtime_t time0,
				   bigtime_t time1) {
	float       cs, sn, scal;
	B3dVector   ref_x, ref_y, v;

// Get the direction of reference
	ref_x = *masters[0]->Origin()
	      - *masters[1]->Origin();
	ref_x.Norm();
// Calculate the y axis of the local referential
	ref_y = ref_z^ref_x;
	ref_y.Norm();
// Get the angle (sin and cos) from the position
// of the reference object
	sn = masters[2]->Rotation()->m12;
	cs = 20.0;
	scal = length * b_sqrt_inv(cs*cs + sn*sn);
	cs *= scal;
	sn *= scal;
// Calculate the new position of the slave
	v = ref_x * cs + ref_y * sn;
	v += *masters[0]->Origin();
	Object->SetOrigin(&v);
}

long wLink::GetRefs(B3dThing ***refs) {
	*refs = masters;
	return 3;
}








