#ifndef EFBITMAP_H
#define EFBITMAP_H

#include <InterfaceDefs.h>
#include "bempeg.h"

enum {	// Transfer Mode
	TM_OPAQUE = 0,
	TM_TRANSPARENT
};

#pragma export on
void
Y2DCopyPixelHLine32(pixel_buffer *fDestination, 
	pixel_buffer *fSource, 
	const long line, const int transferMode = TM_OPAQUE);

void
Y2DCopyPixels32(pixel_buffer *fDestination, 
	const pixel_buffer *src, 
	const int transferMode = TM_OPAQUE);

void
Y2DBlendPixels32(pixel_buffer *fDestination, 
	pixel_buffer *fFinal, const float destBlend, 
	pixel_buffer *fSource, 
	const ushort srcleft, const ushort srctop,
	const ushort srcright, const ushort srcbottom,
	const ushort x1=0, const ushort y1=0, 
	const long startRow=0, const long rowStep = 2, 
	const int transferMode=TM_OPAQUE);

void
Y2DCopyRect32(pixel_buffer *fDestination, 
	const pixel_buffer *src, 
	const ushort srcleft, const ushort srctop,
	const ushort srcright, const ushort srcbottom,
	const ushort x1=0, const ushort y1=0, 
	const int transferMode = TM_OPAQUE);

void 
Y2DRectFill32(const ulong dstleft, const ulong dsttop,
			const ulong dstright, const ulong dstbottom,
			const rgb_color *aColor, pixel_buffer *fDestination);

void 
Y2DClear32(pixel_buffer *fDestination, rgb_color *aColor);

#pragma export off

#endif
