#ifndef DITHER_H
#define DITHER_H

#include <stdlib.h>
#include <string.h>

extern int LUM_RANGE;
extern int CR_RANGE;
extern int CB_RANGE;


#define CB_BASE 1
#define CR_BASE (CB_BASE*CB_RANGE)
#define LUM_BASE (CR_BASE*CR_RANGE)

extern unsigned char pixel[256];
extern int *lum_values;
extern int *cr_values;
extern int *cb_values;
extern char *ditherFlags;

//===========================================================
// The straight 'C' interface to the dither code.
// Each dither module should make available a list of
// 'C' callable functions and fill in this structure
// with pointers to those functions.
// This provides for a nice dynamically loadable interface
// for the modules.
//===========================================================

typedef struct DITHERER
{
	struct DITHERER *next;
	char    *fName;
	char    *fVersion;
	void	(*InitDitherer)	(void);
	void	(*DitherImage)	(unsigned char *lum, unsigned char *cr, unsigned char *cb, 
							unsigned char *out, int rows, int cols);
} DITHERER;



//===========================================================
// class PImageDiter
//
// This is meant to be the abstract base class from which all
// dither modules implemented in C++ derive from.  They only 
// have to implement the one function to actually do the 
// dithering.
//===========================================================
class PImageDither 
{
public:
	virtual void	DitherImage(unsigned char *lum, 
				unsigned char *cr, unsigned char *cb, 
				unsigned char *out, 
				int rows, int cols) = 0;

protected:

private:
};




#endif
