//	Copyright 1995 Be Specific Inc., All Rights Reserved.

#ifndef MONTHVIEW_H
#include "MonthView.h"
#endif

#include <Application.h>
#include <Window.h>

//============================================================
// Class: BTSApplicationWindow
//
// Why create a window when all it does is implement the QuitRequested
// method?  Because the default behavior of a BWindow won't post the
// QUIT_REQUESTED message.  Thus, you'll close the window, but the
// app will still be running.
//============================================================
class BTSApplicationWindow : public BWindow 
{

public:
				BTSApplicationWindow(BRect frame); 
virtual	bool	QuitRequested();
};


//============================================================
// Constructor
//
// The specialized application window is used to instantiate
// the BTSMonthView, which is mainly responsible for the drawing.
//============================================================
BTSApplicationWindow::BTSApplicationWindow(BRect frame)
	: BWindow(frame, "January", B_TITLED_WINDOW, 0)
{
	BRect			aRect = frame;// rect same size as window.
	BTSMonthView	*aView;

	// Move rect so top left is at (0,0)
	aRect.OffsetTo(B_ORIGIN);
	aView = new BTSMonthView(aRect, "MonthView");
	
	Lock();
	// add view to window
	AddChild(aView);
	Unlock();
	
	// make window visible
	Show();
}


//============================================================
// Method: QuitRequested
//
// This method is called whenever the window's close box is 
// clicked on.  If you 
//============================================================
bool 
BTSApplicationWindow::QuitRequested()
{
	// Tell the application to quit!
	be_app->PostMessage(B_QUIT_REQUESTED);
	return(TRUE);
}

//============================================================
// This is a fairly generic and straight forward main program.
// Here the application is created and run.
//============================================================

main()
{	
	BTSApplicationWindow		*aWindow;
	BRect			aRect;

	// We can use a standard BApplication object, because
	// we don't have anything special to add to what it does
	// by default.
	BApplication *myApplication;

	myApplication = new BApplication('JANR');
	
	// set up a rectangle and instantiate a new window
	aRect.Set(20, 20, 200, 200);
	aWindow = new BTSApplicationWindow(aRect);

	// Once everything is setup, start running the application.
	myApplication->Run();
	
	delete(myApplication);
	return(0);
}

