//	Copyright 1996 Be Inc., All Rights Reserved.
#ifndef GMCGRAPHICS_H
#define GMCGRAPHICS_H

#include <View.h>

class BTSStringLabel;

//---- BTSMonthGraphic -----------------------------------------------------------

class BTSMonthGraphic
{
public:
					BTSMonthGraphic(BView *aView);
	virtual			~BTSMonthGraphic();
				
	virtual void			Invalidate();
	virtual void 			Draw (BView* aView);

			void			SetSize(BPoint newSize);
			
protected:
	virtual void			Init();
	virtual void 			CalibrateFontSizes(const long sizeIndex);
	virtual void			CalculateFontSizes();
	virtual void			CalculateColumnLabel(BTSStringLabel&,int);
	virtual void			CalculateDayLabels();
	virtual	void			CalculateParameters();
	virtual BTSStringLabel *	CreateDayLabel(const int column);

private:			
			double GridMargin;
			BPoint GridTopLeft;
			BPoint	GridCellSize;
			BPoint GridBottomRight;
			BRect GridRect;
			BPoint		fSize;			// Size of the graphic

	BView	*fView;			// The View that we will be drawing into	
	char 	**fDayNameArray;
	long	fSizeIndex;
	float	fMonthFontSize;
	float	fNumberFontSize;
	
	bool	fImageNeedsUpdate;

    // The String labels
	BTSStringLabel			*fdateLabel;
    BTSStringLabel			*fColumn0Label;
    BTSStringLabel			*fColumn1Label;
    BTSStringLabel			*fColumn2Label;
    BTSStringLabel			*fColumn3Label;
    BTSStringLabel			*fColumn4Label;
    BTSStringLabel			*fColumn5Label;
    BTSStringLabel			*fColumn6Label;
};

#endif
