/*
[.......*1......*..2....*....3..*......4*.......*5......*..6....*....7..*......]
	libSysCon.h
Support code for the System Console
(c) 1996 Benoit Triquet
*/
#ifndef LIB_SYSCON_H
#define LIB_SYSCON_H

#include <stdarg.h>

#define SYSCON_SIGNATURE 'SysC'
enum {
	SYSCON_PRINT_MESSAGE = 'SCpm',
};
enum {
	SYSCON_INFO,
	SYSCON_WARNING,
	SYSCON_ERROR,
};

long SysConPrintVA( long type, const char *fmt, va_list arg );

inline long SysConPrint( long type, const char *fmt, ... )
	{ return SysConPrintVA( type, fmt, __va_start( fmt ) ); }
// the portable way :
//	{ va_list a; va_start( a, fmt ); return SysConPrintVA( type, fmt, a ); }

inline long SysConPrintInfo( const char *fmt, ... )
	{ return SysConPrintVA( SYSCON_INFO, fmt, __va_start( fmt ) ); }

inline long SysConPrintWarning( const char *fmt, ... )
	{ return SysConPrintVA( SYSCON_WARNING, fmt, __va_start( fmt ) ); }

inline long SysConPrintError( const char *fmt, ... )
	{ return SysConPrintVA( SYSCON_ERROR, fmt, __va_start( fmt ) ); }

#endif
//  1996 Benot Triquet
