/*
[.......*1......*..2....*....3..*......4*.......*5......*..6....*....7..*......]
	SysCon.cpp

(c) 1996 Benoit Triquet
*/
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//															SysCon BApp & main
//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


#include "SysCon.h"
#include "SWindow.h"


//************************************ The main stuff * class SCApplication ****
//******************************************************************************


//	class SCApplication
//------------------------------------------------------------------------------
//	derived from BApplication.
//
class SCApplication : public BApplication {
public:
	SCApplication( );
	virtual ~SCApplication( );
	void AboutRequested( );
	bool QuitRequested( );
	void MenusWillShow( );
	void MessageReceived( BMessage * );
	void LogWrite( const char * );
private:
	SWindow *s_wnd;
	BRect snap;

	BPopUpMenu *menu;
	BMenuItem *menu_item_log_state, *menu_item_wnd_state, *menu_item_act_state,
	 *menu_item_show_state, *menu_item_beep_state, *menu_item_wlck_state;

	BDirectory app_dir;
	BFile log_file;
	BResourceFile pref_file;

	bool wnd_state; // TRUE : shown
	static const char *hide_label, *show_label;
};
const char *SCApplication::hide_label = "Hide window";
const char *SCApplication::show_label = "Show window";


//	Private messages
//------------------------------------------------------------------------------
//	mainly menu messages.
//
enum {
	SWITCH_LOGGING = 'SCsl',
	SWITCH_SHOW_ON_MESSAGE = 'SCss',
	SWITCH_ACT_ON_MESSAGE = 'SCsa',
	SWITCH_BEEP_ON_MESSAGE = 'SCsb',
	NYA = 'NYAV'
};


//	SCApplication::SCApplication
//------------------------------------------------------------------------------
//	Constructor.
//
SCApplication::SCApplication( )
	: BApplication( SYSCON_SIGNATURE )
{
// let's find our thread, team then the record_ref of the executable :
	thread_info ti;
	get_thread_info( find_thread( NULL ), &ti );
	app_info ai;
	be_roster->GetRunningAppInfo( ti.team, &ai );
	BFile app_file;
	app_file.SetRef( ai.ref );
	app_file.GetParent( &app_dir );

// set up a main menu
	menu = new BPopUpMenu( "SysCon", FALSE, FALSE);
	menu->AddItem( new BMenuItem( "About SysCon",
	 new BMessage( B_ABOUT_REQUESTED ) ) );
	menu->AddSeparatorItem( );

	menu->AddItem( menu_item_log_state = new BMenuItem( "Log to file",
	 new BMessage( SWITCH_LOGGING ) ) );
	menu_item_log_state->SetMarked( TRUE );

	menu->AddItem( menu_item_show_state =
	 new BMenuItem( "Show window on new message",
	 new BMessage( SWITCH_SHOW_ON_MESSAGE ) ) );
	menu_item_show_state->SetMarked( TRUE );

	menu->AddItem( menu_item_act_state =
	 new BMenuItem( "Activate window on new message",
	 new BMessage( SWITCH_ACT_ON_MESSAGE ) ) );

	menu->AddItem( menu_item_beep_state = new BMenuItem( "Beep on new message",
	 new BMessage( SWITCH_BEEP_ON_MESSAGE ) ) );

	menu->AddItem( menu_item_wnd_state = new BMenuItem( hide_label,
	 new BMessage( SWITCH_WINDOW ), 'H' ) );
	wnd_state = TRUE;

	menu->AddSeparatorItem( );
	menu->AddItem( new BMenuItem("Quit SysCon",
	 new BMessage( B_QUIT_REQUESTED ), 'Q' ) );
	SetMainMenu(menu);

// penser a mettre un fichier de preferences...
#define LOG_NAME "system log"
	if( !app_dir.Contains( LOG_NAME ) )
		app_dir.Create( LOG_NAME, &log_file );
	else
		app_dir.GetFile( LOG_NAME, &log_file );
	log_file.Open( B_READ_WRITE );
	if( log_file.Seek( 0, B_SEEK_BOTTOM )==B_ERROR )
		menu_item_log_state->SetMarked( FALSE );

#define PREF_NAME "SysCon prefs"
	if( !app_dir.Contains( PREF_NAME ) )
		app_dir.Create( PREF_NAME, &pref_file );
	else
		app_dir.GetFile( PREF_NAME, &pref_file );
	pref_file.Open( B_READ_WRITE );

	s_wnd = new SWindow( BMessenger( this ) );
	if( pref_file.Error( )==B_NO_ERROR ) {
		BRect f;
		screen_info si;
		get_screen_info( &si );

		if( pref_file.ReadResource( B_RECT_TYPE, 401, &f, 0,
		 sizeof( BRect ) )==sizeof( BRect )
		 && si.frame.Intersects( f ) ) {
			s_wnd->MoveTo( f.left, f.top );
			s_wnd->ResizeTo( f.Width( ), f.Height( ) );
			snap = f;
		} else
			snap = s_wnd->Frame( );
	}
	if( menu_item_show_state->IsMarked( ) )
		s_wnd->Show( );
}


//	SCApplication::~SCApplication
//------------------------------------------------------------------------------
//	Destructor.
//
SCApplication::~SCApplication( )
{
}


//	SCApplication::MessageReceived
//------------------------------------------------------------------------------
//	Dispatch non-system messages.
//
void SCApplication::MessageReceived( BMessage *msg )
{
	switch ( msg->what ) {
	case SYSCON_PRINT_MESSAGE:
		const char *l = msg->FindString( "message" );
		long status = msg->FindLong( "status" );
		if( msg->Error( )!=B_NO_ERROR ) {
			msg->SendReply( B_MESSAGE_NOT_UNDERSTOOD );
			return;
		}
		switch( status ) {
		case SYSCON_INFO:
			LogWrite( "info : " );
			break;
		case SYSCON_WARNING:
			LogWrite( "warning : " );
			break;
		case SYSCON_ERROR:
			LogWrite( "error : " );
			break;
		default:
			msg->SendReply( B_MESSAGE_NOT_UNDERSTOOD );
			return;
		}
		LogWrite( l );
		if( ( menu_item_show_state->IsMarked( ) ||
		 menu_item_act_state->IsMarked( ) ) && !wnd_state ) {
			wnd_state = TRUE;
			s_wnd->Show( );
		}
		if( menu_item_act_state->IsMarked( ) )
			s_wnd->Activate( );
		DetachCurrentMessage( );
		s_wnd->PostMessage( msg );
		if( menu_item_beep_state->IsMarked( ) )
			beep( );
		break;
	case SWITCH_LOGGING:
		menu_item_log_state->SetMarked( !menu_item_log_state->IsMarked( ) );
		break;
	case SWITCH_SHOW_ON_MESSAGE:
		menu_item_show_state->SetMarked( !menu_item_show_state->IsMarked( ) );
		break;
	case SWITCH_ACT_ON_MESSAGE:
		menu_item_act_state->SetMarked( !menu_item_act_state->IsMarked( ) );
		break;
	case SWITCH_BEEP_ON_MESSAGE:
		menu_item_beep_state->SetMarked( !menu_item_beep_state->IsMarked( ) );
		break;
	case SWITCH_WINDOW:
		if( wnd_state )
			s_wnd->Hide( );
		else
			s_wnd->Show( );
		wnd_state = !wnd_state;
		break;
	case SNAP_WINDOW:
		snap = s_wnd->Frame( );
		break;
	case BACK_TO_SNAPPED_WINDOW:
		s_wnd->MoveTo( snap.left, snap.top );
		s_wnd->ResizeTo( snap.Width( ), snap.Height( ) );
		break;
	default:
		inherited::MessageReceived( msg );
	}
}


//	SCApplication::MenusWillShow
//------------------------------------------------------------------------------
//	.
//
void SCApplication::MenusWillShow( )
{
	if( wnd_state )
		menu_item_wnd_state->SetLabel( hide_label );
	else
		menu_item_wnd_state->SetLabel( show_label );
}


//	SCApplication::LogWrite
//------------------------------------------------------------------------------
//	Write some text in the log file.
//
void SCApplication::LogWrite( const char *l )
{
	if( !menu_item_log_state->IsMarked( ) )
		return;
	if( log_file.Write( l, strlen( l ) )==B_ERROR ) {
		log_file.Close( );
		menu_item_log_state->SetMarked( FALSE );
		BAlert *al = new BAlert( "about", "SysCon :\n"
		 "There was an error when writing in the log file "
		 "(logging has been disabled)",
		 "OK" );
		al->Go( );
	}
	if( l[ strlen( l )-1 ]!='\n' )
		log_file.Write( "\n", 1 );
}


//	SCApplication::QuitRequested
//------------------------------------------------------------------------------
//	.
//
bool SCApplication::QuitRequested( )
{
	if( s_wnd ) {
		pref_file.AddResource( B_RECT_TYPE, 401, &snap, sizeof( BRect ),
		 "window frame" );
		s_wnd->Quit( );
	}
	log_file.Close( );
	pref_file.Close( );
	return TRUE;
// acting as a daemon, we can't ask for confirmation (only display errors)
}


//	SCApplication::AboutRequested
//------------------------------------------------------------------------------
//	.
//
void SCApplication::AboutRequested( )
{
	BAlert *al = new BAlert( "about", "SysCon v1.0 1996 Benot TRIQUET\n"
	 "<triquet_ben@lsi.supelec.fr>\n"
	 "The system console is a monitoring tool that displays text messages sent"
	 " by any application",
	 "OK" );
	al->Go( );
}




//**************************************************** entry point * main() ****
//******************************************************************************


//	main()
//------------------------------------------------------------------------------
//	my usual main function is always :
//
int main( void )
{
	SCApplication *app = new SCApplication( );
	app->Run( );
	delete app;
	return EXIT_SUCCESS;
}


//  1996 Benot Triquet
