#
# Makefile for ANTLR 1.33
#
# SOFTWARE RIGHTS
#
# We reserve no LEGAL rights to the Purdue Compiler Construction Tool
# Set (PCCTS) -- PCCTS is in the public domain.  An individual or
# company may do whatever they wish with source code distributed with
# PCCTS or the code generated by PCCTS, including the incorporation of
# PCCTS, or its output, into commerical software.
# 
# We encourage users to develop software with PCCTS.  However, we do ask
# that credit is given to us for developing PCCTS.  By "credit",
# we mean that if you incorporate our source code into one of your
# programs (commercial product, research project, or otherwise) that you
# acknowledge this fact somewhere in the documentation, research report,
# etc...  If you like PCCTS and have developed a nice tool with the
# output, please mention that you developed it using PCCTS.  In
# addition, we ask that this header remain intact in our source code.
# As long as these guidelines are kept, we expect to continue enhancing
# this system and expect to make other tools available as they are
# completed.
#
# ANTLR 1.33
# Terence Parr
# Parr Research Corporation
# with Purdue University
# and AHPCRC, University of Minnesota
# 1989-1995
#
# Ported to Borland C++, IBM C-Set/2 and Microsoft 6.0 by
# Ed Harfmann
# Micro Data Base Systems
# Lafayette, Indiana
#
SET=../support/set
PCCTS_H=../h

##
## Uncomment the appropriate section to build
## (both targets and 'make' variable definitions)
## Note that UNIX is the default
##

#
#   OS/2 & DOS 16 bit using MSC 6.0
#
#CC=cl
#ANTLR=..\bin\antlr
#DLG=..\bin\dlg
#CFLAGS= -I. -I$(SET) -I$(PCCTS_H) /AL /Za /W3 -DPC -DUSER_ZZSYN
#OUT_OBJ = -Fo
#LIBS=/NOD:LLIBCE LLIBCEP
#OBJ_EXT = obj
#
#antlr.exe: antlr.obj scan.obj err.obj bits.obj build.obj fset2.obj \
#        fset.obj gen.obj globals.obj hash.obj lex.obj main.obj \
#        misc.obj set.obj pred.obj
#       link @<<
#$** /NOI
#$@ /STACK:14336
#
#$(LIBS: = +^
#)
#$(DEF_FILE) $(LFLAGS) ;
#<<
#        bind $@ c:\os2\doscalls.lib
#        copy *.exe ..\bin
#

#
#   Borland C++ for DOS
#
#CC=bcc
#ANTLR=..\bin\antlr
#DLG=..\bin\dlg
#CFLAGS= -I. -I$(SET) -I$(PCCTS_H) -ml -ff- -w- -DPC -DUSER_ZZSYN
#OUT_OBJ = -o
#LIBS= emu mathl cl
#OBJ_EXT = obj
#
#antlr.exe: antlr.obj scan.obj err.obj bits.obj build.obj fset2.obj \
#        fset.obj gen.obj globals.obj hash.obj lex.obj main.obj \
#        misc.obj set.obj pred.obj
#       tlink @&&|
#C0L $**
#$@ /Tde /c
#
#$(LIBS)
#$(DEF_FILE) $(LFLAGS) ;
#|
#        copy *.exe ..\bin
#

#
# C-Set/2 for OS/2
#
#CC=icc
#CFLAGS= -I. -I$(SET) -I$(PCCTS_H) /Sa /W3 -DUSER_ZZSYN -D__STDC__
#OUT_OBJ = -Fo
#LIBS=
#ANTLR=..\bin\antlr
#DLG=..\bin\dlg
#OBJ_EXT = obj
#
#antlr.exe: antlr.obj scan.obj err.obj bits.obj build.obj fset2.obj \
#        fset.obj gen.obj globals.obj hash.obj lex.obj main.obj \
#        misc.obj set.obj pred.obj
#        link386 @<<
#$** /NOI
#$@ /STACK:32768
#
#$(LIBS: = +^
#)
#$(DEF_FILE) $(LFLAGS) ;
#<<
#        copy *.exe ..\bin
#

#
# Borland C++ for OS/2
#
#CC=bcc
#CFLAGS= -I. -I$(SET) -I$(PCCTS_H) -w- -v -DUSER_ZZSYN
#OUT_OBJ = -o
#LIBS= c2 os2
#
#ANTLR=..\bin\antlr
#DLG=..\bin\dlg
#OBJ_EXT = obj
#antlr.exe: antlr.obj scan.obj err.obj bits.obj build.obj fset2.obj \
#        fset.obj gen.obj globals.obj hash.obj lex.obj main.obj \
#        misc.obj set.obj pred.obj
#        tlink @&&|
#c02 $** -c -v
#antlr.exe
#
#C2 os2
#
#|
#        copy *.exe ..\bin
#

# *********** Target list of PC machines ***********
#
# Don't worry about the ambiguity messages coming from antlr
# for making antlr.c etc...  [should be 10 of them, I think]
#
#antlr.c stdpccts.h parser.dlg tokens.h err.c : antlr.g
#	$(ANTLR) antlr.g
#
#antlr.$(OBJ_EXT): antlr.c mode.h tokens.h
#
#scan.$(OBJ_EXT): scan.c mode.h tokens.h
#
#scan.c mode.h: parser.dlg
#	$(DLG) -C2 parser.dlg scan.c
#
#set.$(OBJ_EXT): $(SET)/set.c
#	$(CC) $(CFLAGS) -c $(OUT_OBJ)set.$(OBJ_EXT) $(SET)/set.c



#
#   UNIX  (default)
#
#CC=cc
CC=mwcc
ANTLR=../bin/antlr
DLG=../bin/dlg
OBJ_EXT=o
OUT_OBJ = -o
CFLAGS= -O -I. -I$(SET) -I$(PCCTS_H) -DUSER_ZZSYN
#
# SGI Users, use this CFLAGS
#
#CFLAGS= -O -I. -I$(SET) -I$(PCCTS_H) -DUSER_ZZSYN -woff 3262
OBJ=antlr.o scan.o err.o bits.o build.o fset2.o fset.o gen.o  \
        globals.o hash.o lex.o main.o misc.o set.o pred.o

antlr : $(OBJ) $(SRC)
		$(CC) $(CFLAGS) -o antlr $(OBJ)
		mv antlr ../bin

# what files does PCCTS generate (both ANTLR and DLG)
PCCTS_GEN=antlr.c scan.c err.c tokens.h mode.h parser.dlg stdpccts.h remap.h

SRC=antlr.c scan.c err.c bits.c build.c fset2.c fset.c gen.c globals.c \
	hash.c lex.c main.c misc.c $(SET)/set.c pred.c

#
# Don't worry about the ambiguity messages coming from antlr
# for making antlr.c etc...  [should be 10 of them, I think]
#
#antlr.c stdpccts.h parser.dlg tokens.h err.c : antlr.g
#	$(ANTLR) -gh antlr.g

antlr.o : antlr.c mode.h tokens.h

scan.o : scan.c mode.h tokens.h

#scan.c mode.h: parser.dlg
#	$(DLG) -C2 parser.dlg scan.c

set.o : $(SET)/set.c
	$(CC) $(CFLAGS) -c -o set.o $(SET)/set.c


#
# ****** These next targets are common to UNIX and PC world ********
#

#clean up all the intermediate files
clean:
	rm -f *.$(OBJ_EXT) core

#remove everything in clean plus the PCCTS files generated
scrub:
	rm -f $(PCCTS_GEN) *.$(OBJ_EXT) core
