//   SliderControl

#pragma once

const KNOB_WIDTH	=	 (18 - 1);
const KNOB_HEIGHT	=	 (16 - 1);
const SLIDER_BACK_WIDTH	= 174;
const SLIDER_BACK_HEIGHT = 15;
const long SLIDER_OFFSET = 11; 

class SliderControl : public BControl
{

	private:
		BBitmap*	fSlider;
		BBitmap*	fKnob;
		BView*		fOffView;
		long		fMin;
		long		fMax;
		rgb_color	slider_color;		
		
	public:
						SliderControl(	BRect frame,
										const char *name,
										const char *label,
										BMessage *message,
										ulong resizeMask = B_FOLLOW_LEFT | B_FOLLOW_TOP,
										ulong flags = B_WILL_DRAW | B_NAVIGABLE, 
										long theMin = 0,
										long theMax = 0,
										long initial = 0); 
						~SliderControl();
		virtual	void	Draw(BRect theRect);
		virtual void	MouseDown(BPoint thePoint);
		void			DrawSlider(void);
		void			FrameResized(float new_width, float new_height);
		void			SetValue(long newValue);
		void			SetMin(long newMin){fMin = newMin;}
		void			SetMax(long newMax){fMax = newMax;}
		long			Min(void){return fMin;}
		long			Max(void){return fMax;}
		rgb_color		SliderColor();
		void 			SetSliderColor(rgb_color color);
};

extern unsigned char knob[];
