#include "SliderControl.h"

//====================================================================

SliderControl::SliderControl(BRect frame, const char *name, const char *label,
							BMessage *message, ulong resizeMask, ulong flags, 
							long theMin, long theMax, long initial)
			:BControl(frame, name, label, message, resizeMask, flags),
			fMin(theMin), fMax(theMax)
{
	slider_color.red = 240;
	slider_color.green = 240;
	slider_color.blue = 240;

	BRect	r;
	SetValue(initial);
	// load in our canned slider knob bitmap
	r.Set(0, 0, ((KNOB_WIDTH + 7) & 0xfff8) - 1, KNOB_HEIGHT);
	fKnob = new BBitmap(r, B_COLOR_8_BIT);
	fKnob->SetBits((char*)knob, fKnob->BitsLength(), 0, B_COLOR_8_BIT);

	// create our offscreen drawing environment
	r = Bounds();
	fSlider = new BBitmap(r, B_COLOR_8_BIT, TRUE);
	fSlider->AddChild(fOffView = new BView(r, "", B_FOLLOW_LEFT_RIGHT, B_FRAME_EVENTS | B_WILL_DRAW));
}

//--------------------------------------------------------------------

SliderControl::~SliderControl()
{
	delete fSlider;
	delete fKnob;
}

///SliderColor
//--------------------------------------------------------------------

rgb_color SliderControl::SliderColor()
{
	return slider_color;
}

///SetSliderColor
//--------------------------------------------------------------------

void SliderControl::SetSliderColor(rgb_color color)
{
	slider_color = color;
}

//--------------------------------------------------------------------

void SliderControl::Draw(BRect)
{
	DrawSlider();
}

//--------------------------------------------------------------------

void SliderControl::MouseDown(BPoint thePoint)
{
	if(!IsEnabled())
		return;

	ulong	buttons;
	long	old_value;
	long	temp;
	BPoint	where;
	BRect	r;

	float sliderPoint = ((Value() - fMin) * Bounds().Width() + 1) / (fMax - fMin);
	r.left = sliderPoint - KNOB_WIDTH/2.0;
	r.top = 0.0;
	r.right = r.left + KNOB_WIDTH;
	r.bottom = KNOB_HEIGHT;

	if (!r.Contains(thePoint))
	{
		temp = fMin + (((thePoint.x - SLIDER_OFFSET) * (fMax - fMin))/(Bounds().Width() + 1 - (SLIDER_OFFSET * 2)));
		if (temp < fMin)
			temp = fMin;
		if (temp > fMax)
			temp = fMax;
		if (temp != Value())
			SetValue(temp);
	}
	old_value = Value();

	do {
		GetMouse(&where, &buttons);
		temp = fMin + (((where.x - SLIDER_OFFSET) * (fMax - fMin))/(Bounds().Width() + 1 - (SLIDER_OFFSET * 2)));
		if (temp < fMin)
			temp = fMin;
		if (temp > fMax)
			temp = fMax;
		if (temp != Value())
			SetValue(temp);
		snooze(500.0);
	} while (buttons);
	Invoke();
}

//--------------------------------------------------------------------

void SliderControl::DrawSlider()
{
	BRect	sr;
	BRect	dr;
	float	ratio;
	float	enabler;	
	fSlider->Lock();
	sr = fOffView->Bounds();

	// slider background
	fOffView->SetHighColor(slider_color);
	if (IsEnabled())
	{
		fOffView->FillRect(sr);
		ratio = (float)176/(float)255;
		fOffView->SetHighColor(slider_color.red * ratio, slider_color.green * ratio, slider_color.blue * ratio);
		fOffView->StrokeLine(BPoint(0, 5), BPoint(0, 5));
		fOffView->StrokeLine(BPoint(0, 10), BPoint(0, 10));
		fOffView->StrokeLine(BPoint(Bounds().Width() + 1, 5), BPoint(Bounds().Width() + 1, 5));
		fOffView->SetHighColor(slider_color.red, slider_color.green, slider_color.blue);
		fOffView->StrokeLine(BPoint(1, 10), BPoint(Bounds().Width() + 1, 10));
		fOffView->StrokeLine(BPoint(Bounds().Width() + 1, 9), BPoint(Bounds().Width() + 1, 6));
		ratio = (float)144/(float)255;
		fOffView->SetHighColor(slider_color.red * ratio, slider_color.green * ratio, slider_color.blue * ratio);
		fOffView->StrokeLine(BPoint(0, 6), BPoint (0, 9));
		fOffView->StrokeLine(BPoint(1, 5), BPoint(Bounds().Width() + 1 - 1, 5));
		fOffView->SetHighColor(0, 0, 0);
		fOffView->StrokeLine(BPoint(1, 6), BPoint(Bounds().Width(), 6));
		fOffView->StrokeLine(BPoint(1, 7), BPoint(Bounds().Width(), 7));
		fOffView->StrokeLine(BPoint(1, 8), BPoint(1, 9));
		fOffView->StrokeLine(BPoint(Bounds().Width(), 8), BPoint(Bounds().Width(), 9));
		ratio = (float)64/(float)255;
		fOffView->SetHighColor(slider_color.red * ratio, slider_color.green * ratio, slider_color.blue * ratio);
		sr.Set(2, 8, Bounds().Width() - 1, 9);
		fOffView->FillRect(sr);
	}
	else
	{
		fOffView->FillRect(sr, B_MIXED_COLORS);
		ratio = (float)176/(float)255;
		fOffView->SetHighColor(slider_color.red * ratio, slider_color.green * ratio, slider_color.blue * ratio);
		fOffView->StrokeLine(BPoint(0, 5), BPoint(0, 5), B_MIXED_COLORS);
		fOffView->StrokeLine(BPoint(0, 10), BPoint(0, 10), B_MIXED_COLORS);
		fOffView->StrokeLine(BPoint(Bounds().Width() + 1, 5), BPoint(Bounds().Width() + 1, 5), B_MIXED_COLORS);
		fOffView->SetHighColor(slider_color.red, slider_color.green, slider_color.blue);
		fOffView->StrokeLine(BPoint(1, 10), BPoint(Bounds().Width() + 1, 10), B_MIXED_COLORS);
		fOffView->StrokeLine(BPoint(Bounds().Width() + 1, 9), BPoint(Bounds().Width() + 1, 6), B_MIXED_COLORS);
		ratio = (float)144/(float)255;
		fOffView->SetHighColor(slider_color.red * ratio, slider_color.green * ratio, slider_color.blue * ratio);
		fOffView->StrokeLine(BPoint(0, 6), BPoint (0, 9), B_MIXED_COLORS);
		fOffView->StrokeLine(BPoint(1, 5), BPoint(Bounds().Width() + 1 - 1, 5), B_MIXED_COLORS);
		fOffView->SetHighColor(0, 0, 0);
		fOffView->StrokeLine(BPoint(1, 6), BPoint(Bounds().Width(), 6), B_MIXED_COLORS);
		fOffView->StrokeLine(BPoint(1, 7), BPoint(Bounds().Width(), 7), B_MIXED_COLORS);
		fOffView->StrokeLine(BPoint(1, 8), BPoint(1, 9), B_MIXED_COLORS);
		fOffView->StrokeLine(BPoint(Bounds().Width(), 8), BPoint(Bounds().Width(), 9), B_MIXED_COLORS);
		ratio = (float)64/(float)255;
		fOffView->SetHighColor(slider_color.red * ratio, slider_color.green * ratio, slider_color.blue * ratio);
		sr.Set(2, 8, Bounds().Width() - 1, 9);
		fOffView->FillRect(sr, B_MIXED_COLORS);
	}
	drawing_mode oldMode = fOffView->DrawingMode();
	fOffView->SetDrawingMode(B_OP_OVER);
	// knob
	float sliderPoint = SLIDER_OFFSET + ((Value() - fMin) * (Bounds().Width() + 1 - (SLIDER_OFFSET * 2))) / (fMax - fMin);
	sr.Set(0, 0, KNOB_WIDTH, KNOB_HEIGHT);
	dr.left = sliderPoint - KNOB_WIDTH/2.0;
	dr.top = 0;
	dr.right = dr.left + KNOB_WIDTH;
	dr.bottom = dr.top + KNOB_HEIGHT;
	
	fOffView->DrawBitmap(fKnob, sr, dr);
	fOffView->SetDrawingMode(oldMode);
	fOffView->SetHighColor(0, 0, 0);

	fOffView->Sync();	// make sure offscreen drawing completes

	// copy offscreen to screen
	DrawBitmap(fSlider, BPoint(0, 0));
	fSlider->Unlock();
}

//--------------------------------------------------------------------

void SliderControl::FrameResized(float new_width, float new_height)
{
	fSlider->RemoveChild(fOffView);
	delete fSlider;
	fSlider = new BBitmap(Bounds(), B_COLOR_8_BIT, TRUE);
	fOffView->ResizeTo(new_width, new_height);
	fSlider->AddChild(fOffView);
	DrawSlider();
}

//--------------------------------------------------------------------

void SliderControl::SetValue(long newValue)
{
	if ((newValue < fMin) || (newValue > fMax))
		newValue = fMin;
	inherited::SetValue(newValue);
	if (Window())
		DrawSlider();
}
