/*
 ********************************************
 *****     SliderInspector class        *****
 ********************************************
 *                                          *
 * 2/11/1997 : Based on AppSketcher's       *
 *             RoundButtonInspector         *
 *                        				    *
 ********************************************
*/


#include "SliderInspector.h"
#include "SliderControl.h"
#include "LRModule.h"

void SliderInspector::InitValues()
{
	BWindow			*win = NULL;
	SliderControl	*slider;
	char str[20];

	ViewInspector::InitValues();

	if (instance == NULL) return;	// In case of...

	slider = (SliderControl *) instance;
	 
	win = slider->Window();	
	win->Lock();	
	Lock();

	if (label == NULL) fprintf(stderr,"Label is null\n");
	else label->SetText(slider->Label());

	if (minValue == NULL)
		fprintf(stderr,"minValue is null\n");
	else
	{
		sprintf(str, "%i", slider->Min());
		minValue->SetText(str);
	}

	if (maxValue == NULL)		
		fprintf(stderr,"maxValue is null\n");
	else
	{
		sprintf(str, "%i", slider->Max());
		maxValue->SetText(str);
	}

	if (initValue == NULL)		
		fprintf(stderr,"initValue is null\n");
	else
	{
		sprintf(str, "%i", slider->Value());
		initValue->SetText(str);
	}

	if (enabled == NULL) fprintf(stderr,"Enabled is null\n");
	else {
		if (slider->IsEnabled()) enabled->SetValue(TRUE);
		else enabled->SetValue(FALSE);
	}
	
	if (color) {
		rgb_color col = slider->SliderColor();
		color->SetValue(col);
	}

	win->Unlock();	
	Unlock();
}

void SliderInspector::Valid()
{
	SliderControl	*slider;
	BWindow	*win = NULL;
	BRect	frame;
	ulong	follow = 0;
	
	if (instance == NULL) return;	// In case of...

	Lock();
	ViewInspector::Valid();

	slider = (SliderControl *) instance;

	win = slider->Window();
	if (win) win->Lock();

	slider->SetLabel(label->Text());
	if (enabled->Value()) slider->SetEnabled(TRUE);
	else slider->SetEnabled(FALSE);

	if (minValue)
		slider->SetMin(atoi(minValue->Text()));

	if (maxValue)
		slider->SetMax(atoi(maxValue->Text()));

	if (initValue)
		slider->SetValue(atoi(initValue->Text()));

	if (color) {
		rgb_color col = color->ValueAsColor();
		slider->SetSliderColor(col);
	}

	Unlock();
	if (win) win->Unlock();	
}
