#pragma export on
BMessage *ArchiveSliderControl(void *instance,BMessage *archive);
BWindow *ShowInspectorSliderControl();
#pragma export off

#include "SliderControl.h"
#include "LRModule.h"
#include "LRArchive.h"

BMessage *ArchiveSliderControl(void *instance,BMessage *archive)
{
	SliderControl*	slider;

	slider = (SliderControl *) instance;
	
	if (archive == NULL) archive = new BMessage('amif');
	
	slider->Window()->Lock();
	
	ArchiveBView(slider,archive);
	
	if (archive->HasString("Label")) {
		archive->ReplaceString("Label", slider->Label());
	}
	else {
		archive->AddString("Label", slider->Label());
	}

	if (archive->HasBool("Enabled")) {
		archive->ReplaceBool("Enabled", slider->IsEnabled());
	}
	else {
		archive->AddBool("Enabled", slider->IsEnabled());
	}
	
	if (archive->HasLong("Min")) {
		archive->ReplaceLong("Min", slider->Min());
	}
	else {
		archive->AddLong("Min", slider->Min());
	}

	if (archive->HasLong("Max")) {
		archive->ReplaceLong("Max", slider->Max());
	}
	else {
		archive->AddLong("Max", slider->Max());
	}

	if (archive->HasLong("Initial")) {
		archive->ReplaceLong("Initial", slider->Value());
	}
	else {
		archive->AddLong("Initial", slider->Value());
	}

	const rgb_color color = slider->SliderColor();
	if (archive->HasData("View Color",B_RGB_COLOR_TYPE)) {
		archive->ReplaceData("View Color",B_RGB_COLOR_TYPE,(void *)(&color),sizeof(rgb_color));
	}
	else {
		archive->AddData("View Color",B_RGB_COLOR_TYPE,(const void *)(&color),sizeof(rgb_color));
	}

	slider->Window()->Unlock();

	return archive;
}

BWindow *ShowInspectorSliderControl()
{
	LRModule	*inspectorModule;
	BWindow		*inspectorWindow;

	inspectorModule = new LRModule("SliderControlInspector");
	if (inspectorModule->LoadModule()) {
		if ((inspectorWindow = (BWindow *)(inspectorModule->MainInstance())) != NULL) {
			inspectorWindow->Show();
		}
		return inspectorWindow;
	}
	else {
		return NULL;
	}
}
