//******************************************************************************
//
//	File:		InstantiateSliderControl.h
//
//	Description:	Unarchiving a SliderControl instance.
//
//	Copyright 1996, International Lorienne Inc.
//
//******************************************************************************

#include "SliderControl.h"
#include <string.h>

#pragma export on
SliderControl* InstantiateSliderControl(BMessage *message);
#pragma export off



SliderControl* InstantiateSliderControl(BMessage *message)
{
	SliderControl	*instance;					// returned pointer
	BRect		frame;							// view frame
	char		*label = NULL;
	bool		enabled;
	long		follow;							// resizing mode
	float		value;
	long		newMin;
	long		newMax;
	long		initial;
	rgb_color	color;
	
	// Default values
	
	frame.left = 10;
	frame.top = 10;
	frame.right = 90;
	frame.bottom = 30;
	label = strdup("Slider");
	enabled = TRUE;
	follow = B_FOLLOW_LEFT | B_FOLLOW_TOP;

	newMin = newMax = 0;
	color.red = 240;
	color.green = 240;
	color.blue = 240;
	
	// Decode instance values
	
	if (message->HasPoint("Origin")) {
		BPoint origin = message->FindPoint("Origin");
		value = frame.Width();
		frame.left = origin.x;
		frame.right = frame.left + value;
		value = frame.Height();
		frame.top = origin.y;
		frame.bottom = frame.top + value;
	}	
	if (message->HasRect("Frame")) {
		frame = message->FindRect("Frame");
	}	
	if (message->HasString("Label")) {
		label = strdup(message->FindString("Label"));
	}	
	if (message->HasLong("Follow Mode")) {
		follow = message->FindLong("Follow Mode");
	}	
	if (message->HasBool("Enabled")) {
		enabled = message->FindBool("Enabled");
	}	
	if (message->HasLong("Min")) {
		newMin = message->FindLong("Min");
	}	
	if (message->HasLong("Max")) {
		newMax = message->FindLong("Max");
	}	
	if (message->HasLong("Initial")) {
		initial = message->FindLong("Initial");
	}	
	if (message->HasData("View Color",B_RGB_COLOR_TYPE)) {
		long size;
		color = *((rgb_color *) message->FindData("View Color",B_RGB_COLOR_TYPE,&size));			// Color
	}	

	if (label == NULL) label = strdup("Slider");

	instance = new SliderControl(frame,"SliderControl",label,NULL,follow,B_FRAME_EVENTS|B_FULL_UPDATE_ON_RESIZE|B_WILL_DRAW);

	instance->SetEnabled((bool)enabled);
	instance->SetMin(newMin);
	instance->SetMax(newMax);
	instance->SetValue(initial);
	instance->SetSliderColor(color);
	free(label);
	
	return instance;
}