// ============================================================
//  CStyledEditWindow.h	1996 Hiroshi Lockheimer
// ============================================================

#pragma once

#include <Window.h>
#include "CTextView.h"


class CStyledEditWindow : public BWindow {
public:
						CStyledEditWindow();
						CStyledEditWindow(record_ref inRef);
	virtual				~CStyledEditWindow();
						
	virtual void		MessageReceived(BMessage *inMessage);
	virtual	void		SaveRequested(record_ref directory, const char *name);
	virtual bool		QuitRequested();
	virtual	void		MenusWillShow();
	
	void				SetDirty(bool inDirty);
	
	static long					WindowCount();
	static CStyledEditWindow*	FindWindow(record_ref inRef);
	
protected:
	void				InitWindow();
	
	void				FontSelected(const char* font);
	void				SizeSelected(float size);
	void				UnderlineChanged(bool underline);
	void				ColorSelected(rgb_color color, bool penColor);

	void				Save();
	void				SaveAs();
	void				Revert();
	
	long				WriteData();
	long				ReadData();
	
	static BRect		GetFrameRect();
					
protected:
	BFile*				mFile;
	bool				mDirty;
	bool				mWaitForSave;
	CTextView*			mTextView;
	BMenu*				mFileMenu;
	BMenu*				mEditMenu;
	BMenu*				mFontMenu;
	BMenu*				mSizeMenu;
	BMenu*				mStyleMenu;
	BMenu*				mColorMenu;
	BMenu*				mBackColorMenu;
	bool				mStyled;
		
	static BList		sWindowList;
	static long			sUntitledCount;
};

inline long
CStyledEditWindow::WindowCount()
	{ return (sWindowList.CountItems()); }