// ============================================================
//  CStyledEditApp.cpp	1996 Hiroshi Lockheimer
// ============================================================

#include "CStyledEditApp.h"
#include "CStyledEditWindow.h"


const ulong	msg_NewWindow 	= 'NewW';
const ulong	msg_OpenWindow	= 'OpnW';


CStyledEditApp::CStyledEditApp()
	: BApplication('STEE')
{
	BPopUpMenu 	*menu = new BPopUpMenu(B_EMPTY_STRING, FALSE, FALSE);
	BMenuItem 	*item = NULL;
	
	item = new BMenuItem("About StyledEdit", new BMessage(B_ABOUT_REQUESTED));
	item->SetTarget(this);
	menu->AddItem(item);
	menu->AddSeparatorItem();
	item = new BMenuItem("New", new BMessage(msg_NewWindow), 'N');
	item->SetTarget(this);
	menu->AddItem(item);
	item = new BMenuItem("Open", new BMessage(msg_OpenWindow), 'O');
	item->SetTarget(this);
	menu->AddItem(item);
	menu->AddSeparatorItem();
	item = new BMenuItem("Quit", new BMessage(B_QUIT_REQUESTED), 'Q');
	item->SetTarget(this);
	menu->AddItem(item);
	
	SetMainMenu(menu);
}


void
CStyledEditApp::AboutRequested()
{
	(new BAlert(B_EMPTY_STRING,
				"StyledEdit 1.0a4\n"
				"The STE demo app\n"
				"Copyright  1996 by Hiroshi Lockheimer\n"
				"hiropee@twics.com\n"
				"http://www.twics.com/~hiropee",
				"OK"))->Go();
}	


void
CStyledEditApp::ReadyToRun()
{
	if (CStyledEditWindow::WindowCount() < 1)
		PostMessage(msg_NewWindow);
}


void
CStyledEditApp::MessageReceived(
	BMessage	*inMessage)
{
	switch (inMessage->what) {
		case msg_WindowAdded:
			break;
			
		case msg_WindowRemoved:
			if (CStyledEditWindow::WindowCount() < 1)
				PostMessage(B_QUIT_REQUESTED);
			break;
			
		case msg_NewWindow:
			MakeNewWindow();
			break;
			
		case msg_OpenWindow:
			RunFilePanel();
			break;
			
		default:
			BApplication::MessageReceived(inMessage);
			break;
	}
}


void
CStyledEditApp::RefsReceived(
	BMessage	*inMessage)
{
	ulong 	type;
	long	count;
	inMessage->GetInfo("refs", &type, &count);
	for (long i = --count; i >= 0; i--) {
		record_ref item = inMessage->FindRef("refs", i);
		if ((item.database >= 0) && (item.record >= 0)) {
			if (does_ref_conform(item, "File"))
				OpenWindow(item);
		}
	}
}


void
CStyledEditApp::MakeNewWindow()
{
	CStyledEditWindow *window = new CStyledEditWindow();
	window->Show();
}


void
CStyledEditApp::OpenWindow(
	record_ref	inRef)
{
	CStyledEditWindow *window = NULL;
	
	window = CStyledEditWindow::FindWindow(inRef);
	if (window != NULL)
		window->Activate();
	else {	
		window = new CStyledEditWindow(inRef);
		window->Show();
	}
}