/*******************************************************************
 * CloseView.cpp
 * written by Steve Sprang
 * Copyright  1997 Digital Dungeon Software
 ******************************************************************/
 
#include "CloseView.h"
#include "BarView.h"

/******************************************************************
 * CloseView::CloseView()
 *****************************************************************/
CloseView::CloseView(BRect rect)
	: BView(rect, "", B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW)
{
	open = new BBitmap(kBOXSIZE, B_COLOR_8_BIT, FALSE);
	close = new BBitmap(kBOXSIZE, B_COLOR_8_BIT, FALSE);
	
	// set the bits
	open->SetBits(box_open, 144, 0, B_COLOR_8_BIT);
	close->SetBits(box_close, 144, 0, B_COLOR_8_BIT);
	
	isPressed = false;
	
	bounds = rect; // store bounds for quick access
		
	// reduce flicker
	SetViewColor(kBARBGCOLOR);
}

/******************************************************************
 * CloseView::CloseView()
 *****************************************************************/
CloseView::~CloseView()
{
	delete open;
	delete close;
}

/******************************************************************
 * CloseView::MouseDown()
 *****************************************************************/
void CloseView::MouseDown(BPoint)
{
	BPoint	cursor;
	ulong	buttons;
	bool	oldState = isPressed;
	
	GetMouse(&cursor, &buttons);
	
	while(B_PRIMARY_MOUSE_BUTTON & buttons) { // while mouse down
		if(bounds.Contains(cursor)) {
			isPressed = true;
		}
		else {
			isPressed = false;
		}
		
		// if state changed then redraw
		if(isPressed != oldState) {
			Draw(Bounds());
		}
		GetMouse(&cursor, &buttons); // store for next iteration
		snooze(20000); // sleep a while
		oldState = isPressed;
	}

	// mouse is up, relax close button
	isPressed = false;
	Draw(Bounds());
	
	// quit if necessary
	if(Bounds().Contains(cursor)) {
		Window()->PostMessage(B_QUIT_REQUESTED);
		
		// don't need this is your window calls it
		be_app->PostMessage(B_QUIT_REQUESTED);
	}
}

/******************************************************************
 * CloseView::Draw()
 *****************************************************************/
void CloseView::Draw(BRect)
{
	if(isPressed) {
		DrawBitmapAsync(close);
	}
	else {
		DrawBitmapAsync(open);
	}
}
