/* BeOS daliclock by Abraham Flaxman (abie@kenlaw.com)
   Copyright (C) 1996

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 

#include <AppKit.h>
#include <InterfaceKit.h>

#include "SingleWindow.h"
#include "DaliClockView.h"

class MyApplication : public BApplication {
public:
	MyApplication();
	virtual void DispatchMessage(BMessage *message, BHandler *target);
	virtual void AboutRequested();
private:
	bool stick_mode;
};

MyApplication::MyApplication()
        :BApplication('DaLi') {
	SingleWindow *aWindow;
	DaliClockView *view;

	// set up a rectangle and instantiate a new window
	screen_info s_info;
	get_screen_info(&s_info);
	BRect aRect(s_info.frame.right-WIN_WIDTH-15,
				s_info.frame.bottom-WIN_HEIGHT-15,
				s_info.frame.right-16,
				s_info.frame.bottom-16);
	aWindow = new SingleWindow(aRect, "daliclock",
				B_TITLED_WINDOW, B_NOT_RESIZABLE|B_NOT_ZOOMABLE|B_WILL_ACCEPT_FIRST_CLICK,
				B_ALL_WORKSPACES);
	stick_mode = TRUE;

	// create a view and add it to window
	aRect.OffsetTo(B_ORIGIN);
	view = new DaliClockView(aRect);
	aWindow->AddChild(view);
	
	BMenuItem	*item;
	BPopUpMenu	*menu = MainMenu();
	BPopUpMenu	*sub;
	
	sub = new BPopUpMenu("Time Mode");
	item = new BMenuItem("12 Hour Mode",
					new BMessage('12hr'));
	item->SetMarked(FALSE);
	item->SetTarget(this);
	sub->AddItem(item);

	item = new BMenuItem("24 Hour Mode",
					new BMessage('24hr'));
	item->SetMarked(TRUE);
	item->SetTarget(this);
	sub->AddItem(item);

	menu->AddItem(sub,1);

	sub = new BPopUpMenu("Window Mode");
	item = new BMenuItem("All Workspaces",
					new BMessage('stik'));
	item->SetMarked(TRUE);
	item->SetTarget(this);
	sub->AddItem(item);

	item = new BMenuItem("Only This Workspace",
					new BMessage('nstk'));
	item->SetMarked(FALSE);
	item->SetTarget(this);
	sub->AddItem(item);
	menu->AddItem(sub,2);
	
	// make window visible
	aWindow->Show();
}

void MyApplication::DispatchMessage(BMessage *message, BHandler *target) {
	if(message->what == '24hr') {
		DaliClockView *view = (DaliClockView *)be_app->WindowAt(0)->FindView("DaliClockView");
		view->SetArmyTimeMode(TRUE);
	}
	
	else if(message->what == '12hr') {
		DaliClockView *view = (DaliClockView *)be_app->WindowAt(0)->FindView("DaliClockView");
		view->SetArmyTimeMode(FALSE);
	}
	
	else if(message->what == 'stik') {
		if(!stick_mode) {
			BWindow *old = (BWindow *)be_app->WindowAt(0);
			old->Lock();
			DaliClockView *view = (DaliClockView *)old->FindView("DaliClockView");
			view->RemoveSelf();
			BRect aRect = old->Frame();
			old->Unlock();
			SingleWindow *aWindow = new SingleWindow(aRect, "daliclock",
					B_TITLED_WINDOW, B_NOT_RESIZABLE|B_NOT_ZOOMABLE,
					B_ALL_WORKSPACES);
			aWindow->AddChild(view);
			aWindow->Show();
			old->Quit();
			stick_mode = TRUE;
		}
	}
	
	else if(message->what == 'nstk') {
		if(stick_mode) {
			BWindow *old = (BWindow *)be_app->WindowAt(0);
			old->Lock();
			DaliClockView *view = (DaliClockView *)old->FindView("DaliClockView");
			view->RemoveSelf();
			BRect aRect = old->Frame();
			old->Unlock();
			SingleWindow *aWindow = new SingleWindow(aRect, "daliclock",
					B_TITLED_WINDOW, B_NOT_RESIZABLE|B_NOT_ZOOMABLE);
			aWindow->AddChild(view);
			aWindow->Show();
			old->Quit();
			stick_mode = FALSE;
		}
	}
	
	else BApplication::DispatchMessage(message, target);
}

void MyApplication::AboutRequested() {
	BAlert *alert = new BAlert("daliclock", "...by abie, 1996", "worthless");
	alert->Go();
}

main() {
	MyApplication *myApplication;
	
	myApplication = new MyApplication();
	myApplication->Run();
	
	delete(myApplication);
	
	return 0;
}
