/* BeOS daliclock by Abraham Flaxman (abie@kenlaw.com)
   Copyright (C) 1996

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */ 

#ifndef __DaliClockView
#define __DaliClockView

#include <InterfaceKit.h>
#include <time.h>
#include <stdio.h>
#include <string.h>

#define WIN_WIDTH 224
#define WIN_HEIGHT 64
#define CHAR_WIDTH 32

enum {
CLOCK_MODE,		//display time
DATE_MODE,		//display date
TO_DATE_MODE,	//morph from time to date
TO_CLOCK_MODE,	//morph from date to time
ALMOST_TO_DATE_MODE	//after current morph completes, enter TO_DATE_MODE
};

class DaliClockView : public BView {
public:
	DaliClockView(BRect area);
	~DaliClockView();
	
	virtual void Draw(BRect area);
	virtual void MouseDown(BPoint point);
	void SetArmyTimeMode(bool mode);
private:
	static long _run_clock(void *data);
	inline bool morePixOnLine(long &t, long x, long y, BBitmap *line);
	long nextPixOnLine(long x, long y, BBitmap *line);
	inline void setPix(long x, long y, uchar color, BBitmap *line);
	int indexFromChar(char ch);

	thread_id painter;
	BBitmap **digits;
	BBitmap *offscreen;
	int mode;		//CLOCK_MODE, DATE_MODE, etc.
	time_t timer;		//last time, as returned by time() 
	float pct;		//pct of morph completed (between 0.0 and 1.0)
	char *old_msg, *new_msg;	//old and new time (or date)
	
	bool army_time;		//24 hours or 12?
};

#endif
