
/*
   Test app to diddle the /dev/ir devices

   Dominic Giampaolo
   dbg@be.com
*/   
#include <stdio.h>
#include <stdlib.h>
#include <KernelKit.h>
#include <Drivers.h>
#include <ir.h>


/* physically, /dev/ir1 corresponds to he port closest to the parallel port */
#define IR_PORT      "/dev/ir1"  
#define IR_BUF_SIZE  4096


main(int argc, char **argv)
{
    int fd, count, i;
    unsigned char data[IR_BUF_SIZE];
    int anal_data[2];
    char *ir_port = IR_PORT;

    if (argv[1] != NULL)
        ir_port = argv[1];


    /* this gets us access to the IR port */
    fd = open(ir_port, 0);
    if (fd < 0) {
        fprintf(stderr, "gack! can't open ir port!");
        exit(5);
    }

    printf("opened %s....\n", ir_port);


    /* not a bad idea to do a reset on open */
    if (ioctl(fd, IR_RESET, 0) < 0)
        perror("Reset of IR device failed");



    /*
       this code here shows you how to do an "analysis" for a given
       remote.  once you send the START_ANALYSIS command you should
       press all the buttons on the remote that you want to use (or 
       at least most of them).

       then when you're done pressing buttons, press return on the keyboard
       and that will get the analysis values back (so you can save them and
       reload them at another time).

       once you've done the analysis, you can set the port into LISTEN_MODE
       and then when you do a read(), it will return to you individual byte
       values for each key pressed.  chances are you'll want to do reads
       of only 1 or 2 bytes at a time as otherwise you'll hang until they all
       come in.
    */
    if (ioctl(fd, IR_START_ANALYSIS, 0) < 0)
        perror("Start Analysis failed");
                    
    printf("press some keys on the remote and then \n");
    printf("press return on your keyboard to continue:"); fflush(stdout);
    getc(stdin);
                    
    if (ioctl(fd, IR_STOP_ANALYSIS, 0) < 0)
        perror("Stop Analysis failed");

    if (ioctl(fd, IR_SEND_ANALYSIS, &anal_data[0]) < 0)
        perror("Send Analysis failed");
    printf("results: 0x%x 0x%x\n", anal_data[0], anal_data[1]); 



    /*
       now here's how you set yourself into LISTEN mode (notice that
       we reload the settings we got above with the SEND_ANALYSIS
       command).
    */
    if (ioctl(fd, IR_LOAD_SETTINGS, &anal_data[0]) < 0)
        perror("Load Settings failed");

    if (ioctl(fd, IR_SET_LISTEN_MODE, 0) < 0)
        perror("Set Listen Mode failed");


    /*
       at this point you could read bytes from the remote by doing
       the following (count should be a small value):
    */
    printf("press a few keys on the remote:\n");
    
    for(i=0; i < 5; i++) {
        if ((count = read(fd, data, 1)) < 0)
            perror("Read failed");
        printf("got value: 0x%x\n", data[0]);
    }



    /*
       The other mode of operation is SAMPLE_MODE which is essentially
       digitizing the IR signal and returning it to you.  It's really
       easy to do this, just set SAMPLE_MODE and start reading data.

       You'll want to read in reasonable sized chunks of say at least
       512 bytes.
    */   
    if (ioctl(fd, IR_SET_SAMPLE_MODE, 0) < 0)
        perror("Set Sample Mode failed");

    printf("now we're in sample mode. just press/hold down some keys.\n");
    count = sizeof(data);
    if ((count = read(fd, data, count)) < 0)
        perror("Read failed");


    /*
       Now that you're done sampling the signal into your buffer you could
       write it back out like this:
    */   
    printf("press return and I will replay your keys"); fflush(stdout);
    getc(stdin);
    if ((count = write(fd, data, count)) < 0)
        perror("Write failed");

    
    /* and when you're done this is all you have to do to clean up */
    close(fd);
}
