/*
    ListWindow.h

    Copyright  1997 Levin-Delson Software.  All Rights Reserved.
	
    $Header: /Bedazzle/dvlp/DbEd/RCS/ListWindow.h,v 1.14 1996/12/30 21:53:13 adamld Exp $
*/

#ifndef LISTWINDOW_H
#define LISTWINDOW_H

#include <OS.h>
#include <AppKit.h>
#include <InterfaceKit.h>

// Message IDs.
#define LW_MESSAGEWHAT_DND                  'IDnD'
#define LW_MESSAGEWHAT_ITEM_SELECTED	    'ISel'
#define LW_MESSAGEWHAT_ITEM_INVOKED 	    'IInv'
#define LW_MESSAGEWHAT_CHILD_QUIT_REQUESTED	'ChQR'
#define LW_MESSAGEWHAT_OK2QUIT              'OK2Q'
#define LW_MESSAGEWHAT_QUIT                 'Quit'
#define LW_MESSAGEWHAT_ACTIVATE             'Actv'
#define LW_MESSAGEWHAT_MENUEDIT             'EDIT'
#define LW_MESSAGEWHAT_MENUNEW              'NEW '
#define LW_MESSAGEWHAT_MENUDELETE           'DELT'
#define LW_MESSAGEWHAT_CAN_YOU_QUIT         'QIT?'
#define LW_MESSAGEWHAT_ACCEPTNEW	        'LWAN'
#define LW_MESSAGEWHAT_CANCELNEW	        'LWCN'
 
// Names for the items in messages.
#define LW_MESSAGEITEM_NAME                 "Name"
#define LW_MESSAGEITEM_NAMEPLUS             "Name+"
#define LW_MESSAGEITEM_OK2QUIT              "OK2Q"
#define LW_MESSAGEITEM_CHILD                "Child"
#define LW_MESSAGEITEM_HANDLER              "LWMH"

// Be's MessageItems
#define BE_MESSAGEITEM_INDEX                "index"

// Names for the views.
#define LW_NAME_SCROLLVIEW                  "LW_SV"
#define LW_NAME_LISTVIEW                    "LW_LV"
#define LW_NAME_MENUBAR                     "LW_MB"

// Labels for the menu items.
#define LW_LABEL_MENUEDIT                   "Edit"
#define LW_LABEL_MENUNEW                    "New"
#define LW_LABEL_MENUDELETE                 "Delete"

// Results for AcceptNew()
#define LW_ACCEPTRESULT_ACCEPT               1L
#define LW_ACCEPTRESULT_RETRY                2L
#define LW_ACCEPTRESULT_CANCEL               3L

// This percentage of a ListWindow must appear on-screen when it opens.
#define LW_PERCENTOFWINDOW_MUST_SHOW         5

#ifdef __cplusplus
extern "C"
{
#endif

/* The NamePlus struct is by a ListWindow to manage the items it owns.
   The struct holds:
       The name of the item.  The struct can be AddItem()ed to a BListView and
               the name is shown in the list.
       The ID is sometimes an identifier, sometimes a piece of additional 
               information needed to access the object.
       The handler is the BHandler of the window that is created when the item
               is selected for editing, creation or simply more information.
*/
typedef struct
{
	char      np_Name[ B_OS_NAME_LENGTH + 1 ];
	void     *np_ID;
	BHandler *np_Handler;
} NamePlus;

#ifdef __cplusplus
}
#endif

#include "ListWindow_protos.h"

// MenuFlags are used to indicate which menuitems are to be accessible in a window.
enum
{
	LW_MENUFLAG_NONE   = 0UL,
	LW_MENUFLAG_EDIT   = 1UL,
	LW_MENUFLAG_NEW    = ( 1UL << 1 ),
	LW_MENUFLAG_DELETE = ( 1UL << 2 )
};


/* This specialized BListView gives color to the list (on a per-item basis if "doRainbow" is TRUE)
   and gives access to functions that deal with item size.
*/
class MyListView : public BListView
{
	public:
	          MyListView( BRect frame, char *name, rgb_color *rgb_color = NULL, bool rainbow = FALSE );
		float GetItemHeight( void );
	    BRect ItemFrame(long index);
        void  DrawItem( BRect updateRect, long index );

    private:
    	bool  doRainbow;
};

inline MyListView :: MyListView( BRect frame, char *name, rgb_color *rgb_color, bool rainbow ) : BListView( frame, name, B_FOLLOW_ALL, ( B_WILL_DRAW | B_NAVIGABLE | B_FRAME_EVENTS ) )
{
	doRainbow = rainbow;

	if ( NULL != rgb_color )
	{
		SetViewColor( *rgb_color );
		SetLowColor( *rgb_color );
	}
	
}

inline float MyListView :: GetItemHeight( void )
{
	return( ItemHeight() );
}

inline BRect MyListView :: ItemFrame(long index)
{
	return( BListView::ItemFrame( index ) );
}

/* ListWindow combines a Window, a ListView and a ScrollBar into one relatively easy entity.
*/
class ListWindow : public BWindow
{
	public:
					  ListWindow( BRect frame, ulong menuFlags = LW_MENUFLAG_NONE, BHandler *callersHandler = NULL, rgb_color *rgb_color = NULL, bool rainbow = FALSE );
					 ~ListWindow();
		virtual bool  QuitRequested( void );
		virtual	void  MessageReceived( BMessage *message );
		virtual long  Status( void );
		virtual void  ItemDropped( BMessage *bMessage );
		virtual void  ItemSelected( long index );
		virtual void  ItemInvoked( long index );
		virtual long  EditItem( long index );
		virtual long  NewItem( void );
		virtual long  DeleteItem( long index );
		virtual void  QuitChildren( void );
		virtual void  QuitPending( void );
		virtual bool  CanYouQuit( void );
		virtual bool  CanChildrenQuit( void );
		virtual bool  CanPendingQuit( void );
		virtual bool  ChildQuitRequested( BHandler *childHandler );
		virtual long  AcceptNew( NamePlus *namePlus, BMessage *message );
				bool  AddItem( NamePlus *namePlus );
				bool  AddPendingItem( NamePlus *namePlus );
				NamePlus *RemoveItem( long index );
				bool      RemoveItem( NamePlus *namePlus );
				NamePlus *RemovePendingItem( long index );
				bool      RemovePendingItem( NamePlus *namePlus );
				NamePlus *ItemAt( long index );
				NamePlus *FindItem( char *name, void *id );
				NamePlus *FindItem( BHandler *handler );
				NamePlus *FindPendingItem( BHandler *handler );
				void  ResizeToFitText( long widthChars, long heightChars );
				void  SetSupportsSelection( bool doesIt );
				bool  SupportsSelection( void );
				void  SetSupportsInvocation( bool doesIt );
				bool  SupportsInvocation( void );
				void  StartDrag( BMessage *bMessage, long index );
				void  InsureOnScreen( void );

	protected:
		volatile long       status;
				 rgb_color  *color;
		
	private:
				 BHandler   *parentHandler;
				 MyListView *listView; 
				 BMenuBar   *menuBar;
				 BList      *pendingItems;
				 bool        supportsSelection;
				 bool        supportsInvocation;
};
					  
inline long ListWindow :: Status( void )
{
	return( status );
}

inline void ListWindow :: StartDrag( BMessage *bMessage, long index )
{
	listView->DragMessage( bMessage, listView->ItemFrame( index ), NULL );
}

inline void ListWindow :: SetSupportsSelection( bool doesIt )
{
	supportsSelection = doesIt;
}

inline bool ListWindow :: SupportsSelection( void )
{
	return( supportsSelection );
}

inline void ListWindow :: SetSupportsInvocation( bool doesIt )
{
	supportsInvocation = doesIt;
}

inline bool ListWindow :: SupportsInvocation( void )
{
	return( supportsInvocation );
}

#endif
