/*
    EditWindow.h

    Copyright  1997 Levin-Delson Software.  All Rights Reserved.
	
    $Header: /Bedazzle/dvlp/DbEd/RCS/EditWindow.h,v 1.9 1996/12/30 21:53:13 adamld Exp $
*/

#ifndef EDITWINDOW_H
#define EDITWINDOW_H

#include <OS.h>
#include <AppKit.h>
#include <InterfaceKit.h>
#include "ListWindow.h"

// Labels for the Menus
#define EW_LABEL_MENUACCEPT             "Accept"
#define EW_LABEL_MENUCANCEL             "Cancel"

// Message IDs.
#define EW_MESSAGEWHAT_MENUACCEPT	    'EWMA'
#define EW_MESSAGEWHAT_MENUCANCEL	    'EWMC'
#define EW_MESSAGEWHAT_MENUTYPE  	    'EWMT'

// Names of the views.
#define EW_NAME_BACKGROUND              "EW_BG"
#define EW_NAME_MENUBAR                 "EW_MB"
#define EW_NAME_BBOX                    "EW_BB"
#define EW_NAME_TEXTVIEW                "EW_TV"
#define EW_NAME_POPUP                   "EW_PU"
#define EW_NAME_MENUFIELD               "EW_MF"

// Initial window dimensions.
#define EW_WIDTH_WINDOW    200.0
#define EW_HEIGHT_WINDOW   100.0

// The width of a scrollbar makes a nice inter-gadget spacing.
#define EW_SPACING_H B_V_SCROLL_BAR_WIDTH
#define EW_SPACING_V B_H_SCROLL_BAR_HEIGHT

// This percentage of an EditWindow must appear on-screen when it opens.
#define EW_PERCENTOFWINDOW_MUST_SHOW 10

class EditWindow : public BWindow
{
	public:
					  EditWindow( BPoint origin, BHandler *callersHandler = NULL, rgb_color *rgb_color = NULL );
		virtual	void  MessageReceived( BMessage *message );
				long  Status( void );
				bool  IsUnchanged( void );
	    virtual long  PrepareAccept( BMessage *bMessage );
	    virtual long  PrepareCancel( BMessage *bMessage );
				long  SendParent( BMessage *bMessage );
				void  AutoResize( void );
				void  InsureOnScreen( void );

	protected:
		volatile long          status;
		volatile bool          isUnchanged;
				 float         fontCharWidth;
				 float         fontCharHeight;
				 BView        *background;
				 float         spacingH;
				 float         spacingV;
				 float         nextH;
				 float         nextV;
				 float         menuBarHeight;
		
	private:
				 BMessenger   *parentMessenger;
				 BMenuBar     *menuBar;
				 BTextView    *bTextView;
};

// Status is used to tell if the object was created successfully.					  
inline long EditWindow :: Status( void )
{
	return( status );
}

/* IsChanges is used to tell if the window is busy, and can't quit out of
   an edit.  Not currently implemented.
*/
inline bool EditWindow :: IsUnchanged( void )
{
	return( isUnchanged );
}

// Send a message to the window's parent.
inline long EditWindow :: SendParent( BMessage *bMessage )
{
	long result = B_ERROR;
	
	if ( NULL != bMessage )
	{
		result = parentMessenger->SendMessage( bMessage );
	}
	
	return( result );
}

// Resize large enough to hold all added gadgets.
inline void EditWindow :: AutoResize( void )
{
	ResizeTo( nextH, nextV + menuBarHeight + 1.0 );
}

#endif
