/*
    DbEdWindow.h

    Copyright  1997 Levin-Delson Software.  All Rights Reserved.
	
    $Header: /Bedazzle/dvlp/DbEd/RCS/DbEdWindow.h,v 1.16 1997/01/03 20:17:36 adamld Exp $
*/

#ifndef DBEDWINDOW_H
#define DBEDWINDOW_H

#include <OS.h>
#include <AppKit.h>
#include <InterfaceKit.h>
#include <StorageKit.h>
#include "ListWindow.h"
#include "EditWindow.h"
#include "DbEdCommon.h"


// Message items.
#define EW_MESSAGEITEM_NAME             "EWMN"
#define EW_MESSAGEITEM_TYPE             "EWMT"
#define EW_MESSAGEITEM_FLAGS            "EWMF"
#define DBED_MESSAGEITEM_INHERIT        "EDIF"
#define DBED_MESSAGEITEM_VOLUMEID       "EDVI"
#define DBED_MESSAGEITEM_TABLENAME      "EDTN"
#define DBED_MESSAGEITEM_DROPTYPE       "EDDT"

// Types of items in drop messages.
#define DBED_DROPTYPE_TABLE 'EDDT'
#define DBED_DROPTYPE_FIELD 'EDDF'

// Be data types used as fields.
#define BE_TYPENAME_RAW     "Raw"
#define BE_TYPENAME_LONG    "Long"
#define BE_TYPENAME_STRING  "String"
#define BE_TYPENAME_RECORD  "Record"
#define BE_TYPENAME_TIME    "Time"
#define BE_TYPENAME_UNKNOWN "Unknown"
#define BE_FLAGNAME_INDEXED "Indexed"

// Names for objects.
#define DBED_NAME_TYPEMENU    "DBTM"
#define DBED_NAME_TEXTVIEW    "DBTV"
#define DBED_NAME_TEXTBOX     "DBTe"
#define DBED_NAME_TYPEBOX     "DBTy"
#define DBED_NAME_FLAGBOX     "DBFB"
#define DBED_NAME_CHECKBOX    "DBCB"
#define DBED_NAME_INHERITBOX  "DBIB"
#define DBED_NAME_INHERITMENU "DBIM"

// Label for table creation item
#define DBED_INHERIT_NONE    "None"

// The DbEd window lists the databases (volumes) on the BeBox.
class DbEdWindow : public ListWindow
{
	public:
					  DbEdWindow( BRect frame, BHandler *callersHandler );
		       	void  MessageReceived( BMessage *message );
		       	void  ItemInvoked( long index );

	protected:
		volatile long       status;
};


// The Database window lists the tables in a database.
class DatabaseWindow : public ListWindow
{
	public:
					  DatabaseWindow( BRect frame, long callersVolumeID, BHandler *callersHandler, rgb_color *color );
		       	void  ItemDropped( BMessage *bMessage );
		       	void  ItemSelected( long index );
		       	void  ItemInvoked( long index );
		        long  NewItem( void );
		        long  AcceptNew( NamePlus *namePlus, BMessage *message );

	protected:
		volatile long       status;

	private:
	            long volumeID;
				void CreateTitle( const char *name );
};


// The table window lists the fields in a table.
class TableWindow : public ListWindow
{
	public:
					  TableWindow( BRect frame, long callersVolumeID, BTable *callersBTable, BHandler *callersHandler, rgb_color *color );
		       	void  ItemDropped( BMessage *bMessage );
		       	void  ItemSelected( long index );
		       	void  ItemInvoked( long index );
		        long  NewItem( void );
		        long  AcceptNew( NamePlus *namePlus, BMessage *message );

	protected:
		volatile long       status;

	private:
				long    volumeID;
				BTable *bTable;
				void CreateTitle( long volumeID, const char *name );
	
};


// The field window displays the attributes of a field.
class FieldWindow : public ListWindow
{
	public:
					  FieldWindow( BRect frame, long callersVolumeID, BTable *callersBTable, field_key myKey, BHandler *callersHandler, rgb_color *color );

	protected:
		volatile long       status;

	private:
				long       volumeID;
				BTable    *bTable;
				field_key  key;
				void CreateTitle( long volumeID, const char *tableName, const char *fieldName );
	
};


/*
**************************************************************************************
**************************************************************************************
**************************************************************************************
*/


// The DatabaseEditWindow allows the creation of a Database's table.
class DatabaseEditWindow : EditWindow
{
	public:
		              DatabaseEditWindow( BPoint origin, long volumeID, BHandler *callersHandler, rgb_color *rgb_color );
		        long  PrepareAccept( BMessage *bMessage );
		
	private:
		BTextView  *bTextView;
		BPopUpMenu *popUp;
};


// The TableEditWindow allows the creation of a Table's field.
class TableEditWindow : EditWindow
{
	public:
		              TableEditWindow( BPoint origin, long volumeID, BTable *bTable, BHandler *callersHandler,  rgb_color *rgb_color );
		        long  PrepareAccept( BMessage *bMessage );
		
	private:
		BTextView  *bTextView;
		BPopUpMenu *popUp;
		BCheckBox  *bCheckBox;
};

#ifdef NEVERDEF
// The RecordEditWindow allows the editing of a Table's Record.
class RecordEditWindow : EditWindow
{
	public:
		              TableEditWindow( BPoint origin, long volumeID, BTable *bTable, BHandler *callersHandler,  rgb_color *rgb_color );
		        long  PrepareAccept( BMessage *bMessage );
		
	private:
		BTextView  *bTextView;
		BPopUpMenu *popUp;
		BCheckBox  *bCheckBox;
};

#endif

#endif
