# include	"CRingModRingFilter.h"

CRingModRingFilter::CRingModRingFilter( long inFrequency )
	: mSubscriber( "RingModRing Filter" )
{
	mIsRunning = FALSE;	
	SetFrequency( inFrequency );
}

CRingModRingFilter::~CRingModRingFilter( )
{
	if ( mIsRunning )
		Stop( );
}

void CRingModRingFilter::Start( )
{
	//ASSERT( !mIsRunning );

	mSubscriber.Subscribe( B_DAC_STREAM, B_SHARED_SUBSCRIBER_ID, FALSE );
	mSubscriber.SetDACSampleInfo( 2, 2, B_BIG_ENDIAN, B_LINEAR_SAMPLES );
	mSubscriber.EnterStream( NULL, FALSE, this, &FilterCallback, NULL, TRUE );

	mIsRunning = TRUE;
}

void CRingModRingFilter::Stop( )
{
	//ASSERT( mIsRunning );
	mSubscriber.ExitStream( TRUE );
	mIsRunning = FALSE;
}

void CRingModRingFilter::SetFrequency( long inFrequency )
{
	bool wasRunning = mIsRunning;
	
	if ( wasRunning )
		Stop( );

	mFrequency = inFrequency;
	mFilterCoefficient = 2.0 * cos( 2.0 * PI / (float) inFrequency );

	mNMinus1 = sin( 2.0 * PI / (float) mFrequency );
	mNMinus2 = 0.0;

	if ( wasRunning )
		Start( );
}

bool CRingModRingFilter::FilterCallback( void* inArg, char* ioBuff, long inCount )
{
	return ((CRingModRingFilter*) inArg)->FilterSound( ioBuff, inCount );
}

bool CRingModRingFilter::FilterSound( char* ioBuff, long inCount )
{
	short* buff = (short*) ioBuff;
	long count = inCount * sizeof(char) / sizeof(short);

	float nMinus1		= mNMinus1;
	float nMinus2		= mNMinus2;
	float coef			= mFilterCoefficient;
	float temp;
		
	for ( long n = 0; n < count - 1; n++ )
	{
		temp = coef * nMinus1 - nMinus2;
		nMinus2 = nMinus1;
		nMinus1 = temp;
		buff[n] = (float) buff[n] * temp;
		buff[n+1] = 1.5 * (float) buff[n+1] * temp;
	}
	
	mNMinus1 = nMinus1;
	mNMinus2 = nMinus2;
	
	return TRUE;
}
	
