# include	"CControlsView.h"
# include	"CRingModRingApp.h"

CControlsView::CControlsView(BRect rect, char *name)
	: BView(rect, name, B_FOLLOW_ALL, B_WILL_DRAW)
{
	BRect ctrlRect;

	BMessage* msg = new BMessage( FREQUENCY_CHANGED );
	ctrlRect.Set( 10, 30, 150, 46 );
	mFrequencyField = new BTextControl( ctrlRect, "Frequency field",
		"Frequency:", "1250", msg, B_FOLLOW_ALL, B_WILL_DRAW );

	msg = new BMessage( FILTER_TOGGLED );
	ctrlRect.Set( 10, 10, 150, 21 );
	mFilterToggle = new BCheckBox( ctrlRect, "Filter toggle",
		"Filter Audio Output", msg, B_FOLLOW_ALL, B_WILL_DRAW );
	mFilterToggle->SetValue( B_CONTROL_ON );
	
	AddChild( mFrequencyField );
	AddChild( mFilterToggle );
}


void CControlsView::AttachedToWindow()
{
	BView::AttachedToWindow( );

	mFrequencyField->SetTarget( this );
	mFilterToggle->SetTarget( this );
	SetFontName( "Emily" );
	SetFontSize( 12 );
}

void CControlsView::Draw(BRect updateRect)
{
	BView::Draw( updateRect );
}

void CControlsView::MessageReceived( BMessage* inMsg )
{
	switch ( inMsg->what )
	{
		case FREQUENCY_CHANGED:
			long newFreq = atol( mFrequencyField->Text( ) );
			((CRingModRingApp*) be_app)->mFilter.SetFrequency( newFreq );
			break;
		
		case FILTER_TOGGLED:
			if ( mFilterToggle->Value( ) == B_CONTROL_ON )
				((CRingModRingApp*) be_app)->mFilter.Start( );
			else
				((CRingModRingApp*) be_app)->mFilter.Stop( );
			break;
				
		
		default:
			BView::MessageReceived( inMsg );
	}
}
