/* CYGNUS LOCAL (entire file) nickc/thumb-pe */
/* Definitions of target machine for GNU compiler,
   for Thumb with PE object format.
   Copyright (C) 1998 Free Software Foundation, Inc.
   Derived from arm/coff.h and arm/pe.h originally by Doug Evans (evans@cygnus.com).

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

#include "arm/thumb.h"

#define THUMB_PE 1

/* Run-time Target Specification.  */
#undef TARGET_VERSION
#define TARGET_VERSION fputs (" (Thumb/pe)", stderr)

/* Support the __declspec keyword by turning them into attributes.
   We currently only support: naked, dllimport, and dllexport.
   Note that the current way we do this may result in a collision with
   predefined attributes later on.  This can be solved by using one attribute,
   say __declspec__, and passing args to it.  The problem with that approach
   is that args are not accumulated: each new appearance would clobber any
   existing args.  */
#undef CPP_PREDEFINES
#define CPP_PREDEFINES "\
-Dthumb -D__thumb -D__pe__ -Acpu(arm) -Amachine(arm) \
-D__declspec(x)=__attribute__((x)) \
"

/* Experimental addition for pr 7885.
   Ignore dllimport for functions.  */
#define ARM_FLAG_NOP_FUN_IMPORT		0x20000
#define TARGET_NOP_FUN_DLLIMPORT (target_flags & ARM_FLAG_NOP_FUN_IMPORT)

#undef SUBTARGET_SWITCHES
#define SUBTARGET_SWITCHES \
{ "nop-fun-dllimport",		  ARM_FLAG_NOP_FUN_IMPORT }, \
{ "no-nop-fun-dllimport",	 -ARM_FLAG_NOP_FUN_IMPORT }, 

#undef TARGET_DEFAULT
#define TARGET_DEFAULT ARM_FLAG_NOP_FUN_IMPORT

/* Setting this to 32 produces more efficient code, but the value set in previous
   versions of this toolchain was 8, which produces more compact structures. The
   command line option -mstructure_size_boundary=<n> can be used to change this
   value.  */
#undef STRUCTURE_SIZE_BOUNDARY
#define STRUCTURE_SIZE_BOUNDARY arm_structure_size_boundary

extern int arm_structure_size_boundary;

/* This is COFF, but prefer stabs.  */
#define SDB_DEBUGGING_INFO

#define PREFERRED_DEBUGGING_TYPE DBX_DEBUG

#include "dbxcoff.h"

/* Note - it is important that these definitions match those in semi.h for the ARM port.  */
#undef LOCAL_LABEL_PREFIX
#define LOCAL_LABEL_PREFIX "."

#undef USER_LABEL_PREFIX
#define USER_LABEL_PREFIX "_"

/* A C statement to output assembler commands which will identify the
   object file as having been compiled with GNU CC (or another GNU
   compiler).  */
#define ASM_IDENTIFY_GCC(STREAM)				\
     fprintf (STREAM, "%sgcc2_compiled.:\n%s", LOCAL_LABEL_PREFIX, ASM_APP_OFF )

#undef ASM_FILE_START
#define ASM_FILE_START(STREAM) \
do {								\
  extern char *version_string;					\
  fprintf ((STREAM), "%s Generated by gcc %s for Thumb/coff\n", \
	   ASM_COMMENT_START, version_string);	                \
  fprintf ((STREAM), ASM_APP_OFF);                              \
} while (0)

/* A C statement to output something to the assembler file to switch to section
   NAME for object DECL which is either a FUNCTION_DECL, a VAR_DECL or
   NULL_TREE.  Some target formats do not support arbitrary sections.  Do not
   define this macro in such cases.  */
#define ASM_OUTPUT_SECTION_NAME(STREAM, DECL, NAME, RELOC) \
do {								\
  if ((DECL) && TREE_CODE (DECL) == FUNCTION_DECL)		\
    fprintf (STREAM, "\t.section %s,\"x\"\n", (NAME));		\
  else if ((DECL) && DECL_READONLY_SECTION (DECL, RELOC))	\
    fprintf (STREAM, "\t.section %s,\"\"\n", (NAME));		\
  else								\
    fprintf (STREAM, "\t.section %s,\"w\"\n", (NAME));		\
} while (0)

/* Support the ctors/dtors and other sections.  */

#undef INIT_SECTION_ASM_OP

/* Define this macro if jump tables (for `tablejump' insns) should be
   output in the text section, along with the assembler instructions.
   Otherwise, the readonly data section is used.  */
#define JUMP_TABLES_IN_TEXT_SECTION 1

#undef READONLY_DATA_SECTION
#define READONLY_DATA_SECTION	rdata_section
#undef RDATA_SECTION_ASM_OP
#define RDATA_SECTION_ASM_OP	"\t.section .rdata"

#undef CTORS_SECTION_ASM_OP
#define CTORS_SECTION_ASM_OP	"\t.section .ctors,\"x\""
#undef DTORS_SECTION_ASM_OP
#define DTORS_SECTION_ASM_OP	"\t.section .dtors,\"x\""

/* A list of other sections which the compiler might be "in" at any
   given time.  */

#undef EXTRA_SECTIONS
#define EXTRA_SECTIONS SUBTARGET_EXTRA_SECTIONS in_rdata, in_ctors, in_dtors

#define SUBTARGET_EXTRA_SECTIONS

/* A list of extra section function definitions.  */

#undef EXTRA_SECTION_FUNCTIONS
#define EXTRA_SECTION_FUNCTIONS \
  RDATA_SECTION_FUNCTION	\
  CTORS_SECTION_FUNCTION	\
  DTORS_SECTION_FUNCTION	\
  SUBTARGET_EXTRA_SECTION_FUNCTIONS

#define SUBTARGET_EXTRA_SECTION_FUNCTIONS

#define RDATA_SECTION_FUNCTION \
void									\
rdata_section ()							\
{									\
  if (in_section != in_rdata)						\
    {									\
      fprintf (asm_out_file, "%s\n", RDATA_SECTION_ASM_OP);		\
      in_section = in_rdata;						\
    }									\
}

#define CTORS_SECTION_FUNCTION \
void									\
ctors_section ()							\
{									\
  if (in_section != in_ctors)						\
    {									\
      fprintf (asm_out_file, "%s\n", CTORS_SECTION_ASM_OP);		\
      in_section = in_ctors;						\
    }									\
}

#define DTORS_SECTION_FUNCTION \
void									\
dtors_section ()							\
{									\
  if (in_section != in_dtors)						\
    {									\
      fprintf (asm_out_file, "%s\n", DTORS_SECTION_ASM_OP);		\
      in_section = in_dtors;						\
    }									\
}

/* Support the ctors/dtors sections for g++.  */

#define INT_ASM_OP ".word"

/* A C statement (sans semicolon) to output an element in the table of
   global constructors.  */
#undef ASM_OUTPUT_CONSTRUCTOR
#define ASM_OUTPUT_CONSTRUCTOR(STREAM,NAME) \
do {						\
  ctors_section ();				\
  fprintf (STREAM, "\t%s\t ", INT_ASM_OP);	\
  assemble_name (STREAM, NAME);			\
  fprintf (STREAM, "\n");			\
} while (0)

/* A C statement (sans semicolon) to output an element in the table of
   global destructors.  */
#undef ASM_OUTPUT_DESTRUCTOR
#define ASM_OUTPUT_DESTRUCTOR(STREAM,NAME) \
do {						\
  dtors_section ();                   		\
  fprintf (STREAM, "\t%s\t ", INT_ASM_OP);	\
  assemble_name (STREAM, NAME);              	\
  fprintf (STREAM, "\n");			\
} while (0)

/* __CTOR_LIST__ and __DTOR_LIST__ must be defined by the linker script.  */
#define CTOR_LISTS_DEFINED_EXTERNALLY

#undef DO_GLOBAL_CTORS_BODY
#undef DO_GLOBAL_DTORS_BODY

/* The ARM development system has atexit and doesn't have _exit,
   so define this for now.  */
#define HAVE_ATEXIT

/* The ARM development system defines __main.  */
#define NAME__MAIN "__gccmain"
#define SYMBOL__MAIN __gccmain

/* This is to better conform to the ARM PCS.
   Richard Earnshaw hasn't put this into FSF sources yet so it's here.  */
#undef RETURN_IN_MEMORY
#define RETURN_IN_MEMORY(TYPE) 						\
  ((TYPE_MODE ((TYPE)) == BLKmode && ! TYPE_NO_FORCE_BLK (TYPE))	\
   || (AGGREGATE_TYPE_P ((TYPE)) && arm_pe_return_in_memory ((TYPE))))

/* A C expression whose value is nonzero if IDENTIFIER with arguments ARGS
   is a valid machine specific attribute for DECL.
   The attributes in ATTRIBUTES have previously been assigned to DECL.  */
extern int arm_pe_valid_machine_decl_attribute ();
extern int arm_valid_machine_decl_attribute ();
#undef VALID_MACHINE_DECL_ATTRIBUTE
#define VALID_MACHINE_DECL_ATTRIBUTE(DECL, ATTRIBUTES, IDENTIFIER, ARGS) \
  arm_pe_valid_machine_decl_attribute (DECL, ATTRIBUTES, IDENTIFIER, ARGS)

extern union tree_node * arm_pe_merge_machine_decl_attributes ();
#define MERGE_MACHINE_DECL_ATTRIBUTES(OLD, NEW) \
  arm_pe_merge_machine_decl_attributes ((OLD), (NEW))

/* In addition to the stuff done in arm.h, we must mark dll symbols specially.
   Definitions of dllexport'd objects install some info in the .drectve
   section.  References to dllimport'd objects are fetched indirectly via
   __imp_.  If both are declared, dllexport overrides.
   This is also needed to implement one-only vtables: they go into their own
   section and we need to set DECL_SECTION_NAME so we do that here.
   Note that we can be called twice on the same decl.  */
extern void arm_pe_encode_section_info ();
#undef ENCODE_SECTION_INFO
#define ENCODE_SECTION_INFO(DECL) \
  arm_pe_encode_section_info (DECL)

#define REDO_SECTION_INFO_P(DECL) 1
     
     /* Utility used only in this file.  */
#define ARM_STRIP_NAME_ENCODING(SYM_NAME) \
((SYM_NAME) + ((SYM_NAME)[0] == '@' ? 3 : 0))

/* Strip any text from SYM_NAME added by ENCODE_SECTION_INFO and store
   the result in VAR.  */
#undef STRIP_NAME_ENCODING
#define STRIP_NAME_ENCODING(VAR, SYM_NAME) \
(VAR) = ARM_STRIP_NAME_ENCODING (SYM_NAME)

/* Define this macro if in some cases global symbols from one translation
   unit may not be bound to undefined symbols in another translation unit
   without user intervention.  For instance, under Microsoft Windows
   symbols must be explicitly imported from shared libraries (DLLs).  */
#define MULTIPLE_SYMBOL_SPACES

#define UNIQUE_SECTION_P(DECL) DECL_ONE_ONLY (DECL)
extern void arm_pe_unique_section ();
#define UNIQUE_SECTION(DECL,RELOC) arm_pe_unique_section (DECL, RELOC)

#define SUPPORTS_ONE_ONLY 1

/* A C statement to output something to the assembler file to switch to section
   NAME for object DECL which is either a FUNCTION_DECL, a VAR_DECL or
   NULL_TREE.  Some target formats do not support arbitrary sections.  Do not
   define this macro in such cases.  */
#undef ASM_OUTPUT_SECTION_NAME
#define ASM_OUTPUT_SECTION_NAME(STREAM, DECL, NAME, RELOC) 	\
do {								\
  if ((DECL) && TREE_CODE (DECL) == FUNCTION_DECL)		\
    fprintf (STREAM, "\t.section %s,\"x\"\n", (NAME));		\
  else if ((DECL) && DECL_READONLY_SECTION (DECL, RELOC))	\
    fprintf (STREAM, "\t.section %s,\"\"\n", (NAME));		\
  else								\
    fprintf (STREAM, "\t.section %s,\"w\"\n", (NAME));		\
  /* Functions may have been compiled at various levels of	\
     optimization so we can't use `same_size' here.  Instead,	\
     have the linker pick one.  */				\
  if ((DECL) && DECL_ONE_ONLY (DECL))				\
    fprintf (STREAM, "\t.linkonce %s\n",			\
	     TREE_CODE (DECL) == FUNCTION_DECL			\
	     ? "discard" : "same_size");			\
} while (0)

/* This outputs a lot of .req's to define alias for various registers.
   Let's try to avoid this.  */
#undef ASM_FILE_START
#define ASM_FILE_START(STREAM) \
do {								\
  extern char *version_string;					\
  fprintf (STREAM, "%s Generated by gcc %s for ARM/pe\n",	\
	   ASM_COMMENT_START, version_string);			\
  output_file_directive ((STREAM), main_input_filename);	\
} while (0)

/* Output a reference to a label.  */
#undef ASM_OUTPUT_LABELREF
#define ASM_OUTPUT_LABELREF(STREAM, NAME)  \
fprintf (STREAM, "%s%s", USER_LABEL_PREFIX, ARM_STRIP_NAME_ENCODING (NAME))

/* Output a function definition label.  */
#undef ASM_DECLARE_FUNCTION_NAME
#define ASM_DECLARE_FUNCTION_NAME(STREAM, NAME, DECL) \
do {							\
  if (arm_dllexport_name_p (NAME))			\
    {							\
      drectve_section ();				\
      fprintf (STREAM, "\t.ascii \" -export:%s\"\n",	\
	       ARM_STRIP_NAME_ENCODING (NAME));		\
      function_section (DECL);				\
    }							\
  if (! is_called_in_ARM_mode (decl))			\
    fprintf (STREAM, "\t.thumb_func\n") ;		\
  else							\
    fprintf (STREAM, "\t.code\t32\n") ;			\
  ASM_OUTPUT_LABEL ((STREAM), (NAME));			\
} while (0)

/* Output a common block.  */
#undef ASM_OUTPUT_COMMON
#define ASM_OUTPUT_COMMON(STREAM, NAME, SIZE, ROUNDED) \
do {							\
  if (arm_dllexport_name_p (NAME))			\
    {							\
      drectve_section ();				\
      fprintf ((STREAM), "\t.ascii \" -export:%s\"\n",	\
	       ARM_STRIP_NAME_ENCODING (NAME));		\
    }							\
  if (! arm_dllimport_name_p (NAME))			\
    {							\
      fprintf ((STREAM), "\t.comm\t"); 			\
      assemble_name ((STREAM), (NAME));			\
      fprintf ((STREAM), ", %d\t%s %d\n",		\
	       (ROUNDED), ASM_COMMENT_START, (SIZE));	\
    }							\
} while (0)

/* Output the label for an initialized variable.  */
#undef ASM_DECLARE_OBJECT_NAME
#define ASM_DECLARE_OBJECT_NAME(STREAM, NAME, DECL) \
do {							\
  if (arm_dllexport_name_p (NAME))			\
    {							\
      enum in_section save_section = in_section;	\
      drectve_section ();				\
      fprintf (STREAM, "\t.ascii \" -export:%s\"\n",	\
	       ARM_STRIP_NAME_ENCODING (NAME));		\
      switch_to_section (save_section, (DECL));		\
    }							\
  ASM_OUTPUT_LABEL ((STREAM), (NAME));			\
} while (0)

/* Support the ctors/dtors and other sections.  */

#define DRECTVE_SECTION_ASM_OP	"\t.section .drectve"

/* A list of other sections which the compiler might be "in" at any
   given time.  */

#undef SUBTARGET_EXTRA_SECTIONS
#define SUBTARGET_EXTRA_SECTIONS in_drectve,

/* A list of extra section function definitions.  */

#undef SUBTARGET_EXTRA_SECTION_FUNCTIONS
#define SUBTARGET_EXTRA_SECTION_FUNCTIONS \
  DRECTVE_SECTION_FUNCTION	\
  SWITCH_TO_SECTION_FUNCTION

#define DRECTVE_SECTION_FUNCTION \
void									\
drectve_section ()							\
{									\
  if (in_section != in_drectve)						\
    {									\
      fprintf (asm_out_file, "%s\n", DRECTVE_SECTION_ASM_OP);		\
      in_section = in_drectve;						\
    }									\
}

/* Switch to SECTION (an `enum in_section').

   ??? This facility should be provided by GCC proper.
   The problem is that we want to temporarily switch sections in
   ASM_DECLARE_OBJECT_NAME and then switch back to the original section
   afterwards.  */
#define SWITCH_TO_SECTION_FUNCTION \
void \
switch_to_section (section, decl) \
     enum in_section section; \
     tree decl; \
{ \
  switch (section) \
    { \
      case in_text: text_section (); break; \
      case in_data: data_section (); break; \
      case in_named: named_section (decl, NULL, 0); break; \
      case in_rdata: rdata_section (); break; \
      case in_ctors: ctors_section (); break; \
      case in_dtors: dtors_section (); break; \
      case in_drectve: drectve_section (); break; \
      default: abort (); break; \
    } \
}



extern int thumb_pe_valid_machine_decl_attribute ();
