.de SH
.sp
.ne 4
.ft B
.ps +2
\\$1
.ps -2
.ft P
.sp
.ns
..
.de DS
.ta .2i \\$1
.sp
.nf
.ft C
..
.de DE
.ft R
.fi
.sp
..
.de C
.ft C
\&\\$1\|
.ft P
..
.de CR
\fC\\$1\fP\\$2
..
.de B
.ft B
\\$1
.ft P
..
.de I
.ft I
\\$1
.ft P
..
.de IR
\fI\\$1\fP\\$2
..
.de QU
``\\$1''
..
.de he
'sp .5i
.ns
.mk
.po .667i
.wh -1i f0
..
.de f0
'sp 2
'tl ''- % -''
.rt
.ns
.ll 3.5i
.po 4.5i
.wh -1i f1
..
.de f1
'bp
..
.wh 0 he
.ll 3.5i
.hy 12
.lt 7.5i

.rs


.ft B
.ps +8
.tl ''VE TUTORIAL''
.ps -8


.ft I
.tl ''Rico Tudor''

.ft R
.tl ''rico@math.nwu.edu''
.tl ''uunet!cbmvax!rico''
.tl ''15 June, 1990''



.sp
.mk
.sp -1

.I ve
is a screen-oriented text editor designed for expert users.
Most commands are one or two key strokes, error messages are terse,
and visual distractions are minimized.
This does not mean that 
.I ve
is difficult to learn;
it is positively spartan
compared to the features and command sets of some editors.
With a little practice,
the commands in this tutorial will
become second nature.

.SH "GETTING IN, GETTING OUT"

To begin your first editing session, type to the shell
.DS
	ve
.DE
and hit the
.C <RETURN>
key.
You should see 
.DS
	~
	~
	~
.DE
on the bottom three lines of the screen.
If you don't, consult your
administrator.
In any case, try the quit command
.DS
	:q
.DE
and type
.CR <RETURN> .
All
.C :
commands require a trailing
.CR <RETURN> .
At this point, you should be back in the shell.
A more forceful way to quit
.I ve
is
.DS
	:Q
.DE
If things seem out of control, type
.C <ESC>
or interrupt a few times.
On most
systems, the interrupt key is
.C <DEL>
or
.CR <ctrl-C> .

.SH "LOOKING AROUND"

Text displayed by
.I ve
is stored in an area called the
.QU "text buffer."
To
look at a file, it must be copied into the text buffer.
Maintained at all
times is the current line and column in the buffer.
While the screen is
often too small to show the entire buffer, this
.QU "current position"
is always
visible on the screen, as indicated by the terminal's cursor.
First start
.IR ve ,
then type
.DS
	:e anyfile
.DE
and then type
.CR <RETURN> .
If
.I anyfile
doesn't exist, the command will fail
with the message
.DS
	ve: can't open file
.DE
When
.I ve
has read a file, you will see the first two lines.
To see more,
type
.C <RETURN>
a few times.
.I ve
doesn't use all lines of the screen at the
outset, but expands the
.QU "text window"
when needed.
Commands to move the
current position include
.DS +1i
	<RETURN>	\fRgo to the next line\fP
	;		\fRgo to the previous line\fP
	G		\fRgo to first line in buffer\fP
	9g		\fRgo to line 9\fP
	g		\fRgo to last line in buffer\fP
	<SPACE>		\fRgo right\fP
	<BACKSPACE>	\fRgo left\fP
	$		\fRgo to the end-of-line\fP
.DE
It is not an error to go past the end-of-line.
Lines which are beyond the end of the buffer appear on the screen as
.DS
	~
.DE
The terminal bell rings after a minor error, like attempting to go past the
end of the buffer.
Major errors are accompanied by a message at the bottom
of the screen.

.SH "CREATING A FILE"

There are two steps to creating a new file or changing an existing one.
First, the text buffer is changed as desired.
Second, the buffer is saved
to the file.
If the second step is not performed, then your work will be
lost when you exit from
.IR ve .

The easiest way to change the buffer is to delete lines or characters:
.DS +.5i
	dd	\fRdelete the current line\fP
	x	\fRdelete the current character\fP
	3dd	\fRdelete three lines\fP
	3x	\fRdelete three characters\fP
.DE
To insert new text, you first type
.DS
	i
.DE
Now everything you type is inserted at the current position, even
.C dd
and
.CR x .
This
.QU "insert mode"
continues until you type
.DS
	<ESC>
.DE
It is always safe to type
.CR <ESC> ,
which is handy if you can't remember the
current mode.
Another way to start inserting text is to type
.DS
	o
.DE
which opens a fresh line, and enters insert mode.
In this mode, your tty
erase and kill characters work in the customary way, as does
.C <RETURN>
and the
.C \\\\
character.

Having completed all desired changes to the buffer, the second step is to
save the changes to a file.
You may forget to do so, but
.I ve
will not;
the command
.C :q
results in the error message
.DS
	ve: text not saved
.DE
You may override
.IR ve 's
objection by quitting forcefully:
.DS
	:Q
.DE
Usually, you will want to save your work.
The command
.DS
	:w anyfile
.DE
writes the buffer to the named file.
If you started the editing session
with a
.C :e
command like
.DS
	:e anyfile
.DE
then you can save the buffer to the remembered file name by simply typing
.DS
	:w
.DE
Did you forget what file you're editing?
Ask
.I ve
with
.DS
	:f
.DE
After saving the buffer, a normal
.C :q
command will return you to the shell.

.SH "RECOVERING FROM MISTAKES"

This tutorial does not cover all the commands and capabilities of
.IR ve ,
but some features are too useful, and fun, to ignore.
Perhaps the most
important is the ability to undo any text change.
If you have made some
sample changes to your buffer, now type
.DS
	u
.DE
By repeating this command, you can undo even more.
Eventually, you would
arrive at the beginning of the current editing session, as indicated by the
message
.DS
	ve: beginning-of-session
.DE
Similarly, you can undo the undo, or re-do, by typing a capital
.DS
	U
.DE
By repeating this command, you eventually arrive at the most recent of your
changes, as indicated by the message
.DS
	ve: end-of-session
.DE
You can think of this activity as a kind of time travel.
What you travel
along is called the
.QU "timeline."
It is important to realize that, when in
your
.QU "past,"
it is possible and reasonable to edit text.
When this happens,
the timeline is cut and the
.QU "future"
is discarded.

.SH "ZONES"

Another feature used widely in
.I ve
is the
.QU "zone."
A zone is established by
identifying one or more adjacent lines in the buffer.
For example,
.DS
	12z
.DE
establishes a 12-line zone starting at the current line, while
.DS
	ka9gza
.DE
places a
.QU "mark"
called
.C a
on the current line, goes to line 9, and then
establishes the zone from the line marked
.C a
to the new current line.
Once
you have a zone, you can go to a faraway line, and type
.DS
	t
.DE
A copy of the zone will be inserted at the current line.
Typing
.DS
	m
.DE
moves, rather than copies, the original zone.
Indenting and, for lack of a
better word, exdenting is achieved by
.DS
	>
	<
.DE
The zone can be written to a file by
.DS
	:wz anyfile
.DE
or deleted entirely by
.DS
	dz
.DE
.SH "REPEATING A COMMAND"

Any command that changes the buffer can be repeated by simply typing
.DS
	.
.DE
Note that
.C u
and
.C U
are never repeated, and can be used to undo/redo the
effects of the
.C .
command.

.SH "LOOKING AT BIG FILES"

Moving the current position one line at a time is tedious for big files.
One way to save time is to give a count:
.DS +1i
	8<RETURN>	\fRgo forward 8 lines\fP
	8;		\fRgo backward 8 lines\fP
.DE
You can also use the
.QU "jump"
commands:
.DS +.5i
	8j	\fRjump forward 8 lines\fP
	8J	\fRjump backward 8 lines\fP
.DE
If a jump command is typed without a line count, it uses the previous.
For example, the sequence of commands
.DS
	8j;;;;j
.DE
advances the current position by 12 lines.
Another way to advance quickly through a file is by "paging".
The current size of the text window defines the page size.
Try typing
.DS +.5i
	p	\fRadvance to next page\fP
	P	\fRback up to previous page\fP
	9p	\fRadvance 9 pages\fP
	9P	\fRback up 9 pages\fP
.DE
As mentioned earlier, the text window expands according to use.
You can prevent this by
.QU "locking"
the window:
.DS
	wl
.DE
This is useful for preserving the top part of the screen,
or when editing over the phone at slow speeds.
To unlock the text window, type
.DS
	wL
.DE
You can also expand the text window to the full size of the screen with
.DS
	w<RETURN>
.DE

.SH "SEARCHING"

The best way to move through large files
is by searching.
This assumes you have some idea of what the file contains,
which is usually the case.
Try the command
.DS
	/cat
.DE
and don't forget the
.CR <RETURN> .
If these three letters do not occur from the
current position to the end of the buffer, you will see the message
.DS
	ve: no match
.DE
Otherwise, the cursor moves to the
.CR c .
You can repeat the search with one
keystroke
.DS
	s
.DE
To search backwards to the beginning of the buffer, type
.DS
	?cat
.DE
or capital
.DS
	S
.DE
In the above commands,
.DS
	cat
.DE
is called the search pattern.
While this pattern will find the word
.CR cat ,
it will also find
.CR ducat ,
.C cater
and
.CR toccata .
Searching can be
constrained in a variety of ways:
.DS +.5i
	cat	\fRmatches\fP cat, cater, ducat, toccata
	~cat	\fRmatches\fP cat, cater
	cat~	\fRmatches\fP cat, ducat
	~cat~	\fRmatches\fP cat
.DE
So, to search forward for the exact word
.CR cat ,
type the command
.DS
	/~cat~
.DE
The
.C ~
is just one of several magical punctuation characters.
Another
is
.CR ^ ,
which constrains the search to the beginnings of lines:
.DS +.5i
	^cat	\fRmatches\fP cat... \fRor\fP cater...
	^cat~	\fRmatches\fP cat ...
.DE
The
.C $
character constrains the search to the endings of lines:
.DS +.5i
	cat$	\fRmatches\fP ...cat \fRor\fP ...ducat
	~cat$	\fRmatches\fP ... cat
.DE
The remaining magical characters should be avoided for now:
.DS
	[   .   *   \\
.DE
Those of you familiar with
.QU "regular expressions,"
as used by UNIX
.I ed
and
.I grep
may wish to experiment further.

.SH "CONCLUSION"

As you become familiar with
.I ve
and the commands described earlier, take
time to peruse the file
.I doc/reference.
This contains an extremely terse, but complete,
description of commands and features.
