/*
 *	SYSGEN -- an imitation of the CONFIG command of VMS SYSGEN.
 *
 *	$Id: devices.h,v 1.4 1997/06/08 08:32:13 tih Exp $
 */

#define NA 0			/* identifies irrelevant alignments */
#define FLOAT 0			/* identifies floating vectors or CSRs */

#define DEVNAMLEN 8		/* maximum length of a device name */
#define MAXDEVS 64		/* max number of configuration devices */

#define VECLEN 4		/* address space footprint of a vector */
#define CSRLEN 2		/* address space footprint of a register */

#define VECBASE 0300		/* floating vectors start with this one */
#define CSRBASE 0760000L	/* floating CSRs start _above_ this point */

struct device {
  char *name;			/* device name */
  int vector;			/* fixed vector number or FLOAT */
  int numvecs;			/* number of vectors used by device */
  int vecalign;			/* alignment requirement for vector number */
  long csr;			/* fixed csr address or FLOAT */
  int csralign;			/* alignment requirement for csr address */
};

/* sorted (prioritized) table of DEC Q22-bus or UNIBUS vectors and CSRs */

struct device devtab[] = {
  { "CR11",    0230,  1, NA, 0777160, NA },
  { "RK611",   0210,  1, NA, 0777440, NA },
  { "LP11",    0200,  1, NA, 0777514, NA },
  { "LP11",    0170,  1, NA, 0764004, NA },
  { "LP11",    0174,  1, NA, 0764014, NA },
  { "LP11",    0270,  1, NA, 0764024, NA },
  { "LP11",    0274,  1, NA, 0764034, NA },
  { "RL11",    0160,  1, NA, 0774400, NA },
  { "TS11",    0224,  1, NA, 0772520, NA },
  { "RX211",   0264,  1, NA, 0777170, NA },
  { "RB730",   0250,  1, NA, 0775606, NA },
  { "UDA",     0154,  1, NA, 0772150, NA },
  { "TU81",    0260,  1, NA, 0774500, NA },
  { "UNA",     0120,  1, NA, 0774510, NA },
  { "QNA",     0120,  1, NA, 0774440, NA },
  { "DC11",   FLOAT,  2,  8, 0774000, NA },
  { "DC11",   FLOAT,  2,  8, 0774010, NA },
  { "DC11",   FLOAT,  2,  8, 0774020, NA },
  { "DC11",   FLOAT,  2,  8, 0774030, NA },
  { "DC11",   FLOAT,  2,  8, 0774040, NA },
  { "DC11",   FLOAT,  2,  8, 0774050, NA },
  { "DC11",   FLOAT,  2,  8, 0774060, NA },
  { "DC11",   FLOAT,  2,  8, 0774070, NA },
  { "DC11",   FLOAT,  2,  8, 0774100, NA },
  { "DC11",   FLOAT,  2,  8, 0774110, NA },
  { "DC11",   FLOAT,  2,  8, 0774120, NA },
  { "DC11",   FLOAT,  2,  8, 0774130, NA },
  { "DC11",   FLOAT,  2,  8, 0774140, NA },
  { "DC11",   FLOAT,  2,  8, 0774150, NA },
  { "DC11",   FLOAT,  2,  8, 0774160, NA },
  { "DC11",   FLOAT,  2,  8, 0774170, NA },
  { "DC11",   FLOAT,  2,  8, 0774200, NA },
  { "DC11",   FLOAT,  2,  8, 0774210, NA },
  { "DC11",   FLOAT,  2,  8, 0774220, NA },
  { "DC11",   FLOAT,  2,  8, 0774230, NA },
  { "DC11",   FLOAT,  2,  8, 0774240, NA },
  { "DC11",   FLOAT,  2,  8, 0774250, NA },
  { "DC11",   FLOAT,  2,  8, 0774260, NA },
  { "DC11",   FLOAT,  2,  8, 0774270, NA },
  { "DC11",   FLOAT,  2,  8, 0774300, NA },
  { "DC11",   FLOAT,  2,  8, 0774310, NA },
  { "DC11",   FLOAT,  2,  8, 0774320, NA },
  { "DC11",   FLOAT,  2,  8, 0774330, NA },
  { "DC11",   FLOAT,  2,  8, 0774340, NA },
  { "DC11",   FLOAT,  2,  8, 0774350, NA },
  { "DC11",   FLOAT,  2,  8, 0774360, NA },
  { "DC11",   FLOAT,  2,  8, 0774370, NA },
  { "TU58",   FLOAT,  2,  8, 0776500, NA },
  { "TU58",   FLOAT,  2,  8, 0776510, NA },
  { "TU58",   FLOAT,  2,  8, 0776520, NA },
  { "TU58",   FLOAT,  2,  8, 0776530, NA },
  { "TU58",   FLOAT,  2,  8, 0776540, NA },
  { "TU58",   FLOAT,  2,  8, 0776550, NA },
  { "TU58",   FLOAT,  2,  8, 0776560, NA },
  { "TU58",   FLOAT,  2,  8, 0776570, NA },
  { "TU58",   FLOAT,  2,  8, 0776600, NA },
  { "TU58",   FLOAT,  2,  8, 0776610, NA },
  { "TU58",   FLOAT,  2,  8, 0776620, NA },
  { "TU58",   FLOAT,  2,  8, 0776630, NA },
  { "TU58",   FLOAT,  2,  8, 0776640, NA },
  { "TU58",   FLOAT,  2,  8, 0776650, NA },
  { "TU58",   FLOAT,  2,  8, 0776660, NA },
  { "TU58",   FLOAT,  2,  8, 0776670, NA },
  { "DN11",   FLOAT,  1,  4, 0775200, NA },
  { "DN11",   FLOAT,  1,  4, 0775210, NA },
  { "DN11",   FLOAT,  1,  4, 0775220, NA },
  { "DN11",   FLOAT,  1,  4, 0775230, NA },
  { "DN11",   FLOAT,  1,  4, 0775240, NA },
  { "DN11",   FLOAT,  1,  4, 0775250, NA },
  { "DN11",   FLOAT,  1,  4, 0775260, NA },
  { "DN11",   FLOAT,  1,  4, 0775270, NA },
  { "DN11",   FLOAT,  1,  4, 0775300, NA },
  { "DN11",   FLOAT,  1,  4, 0775310, NA },
  { "DN11",   FLOAT,  1,  4, 0775320, NA },
  { "DN11",   FLOAT,  1,  4, 0775330, NA },
  { "DN11",   FLOAT,  1,  4, 0775340, NA },
  { "DN11",   FLOAT,  1,  4, 0775350, NA },
  { "DN11",   FLOAT,  1,  4, 0775360, NA },
  { "DN11",   FLOAT,  1,  4, 0775370, NA },
  { "DM11B",  FLOAT,  1,  4, 0770500, NA },
  { "DM11B",  FLOAT,  1,  4, 0770510, NA },
  { "DM11B",  FLOAT,  1,  4, 0770520, NA },
  { "DM11B",  FLOAT,  1,  4, 0770530, NA },
  { "DM11B",  FLOAT,  1,  4, 0770540, NA },
  { "DM11B",  FLOAT,  1,  4, 0770550, NA },
  { "DM11B",  FLOAT,  1,  4, 0770560, NA },
  { "DM11B",  FLOAT,  1,  4, 0770570, NA },
  { "DM11B",  FLOAT,  1,  4, 0770600, NA },
  { "DM11B",  FLOAT,  1,  4, 0770610, NA },
  { "DM11B",  FLOAT,  1,  4, 0770620, NA },
  { "DM11B",  FLOAT,  1,  4, 0770630, NA },
  { "DM11B",  FLOAT,  1,  4, 0770640, NA },
  { "DM11B",  FLOAT,  1,  4, 0770650, NA },
  { "DM11B",  FLOAT,  1,  4, 0770660, NA },
  { "DM11B",  FLOAT,  1,  4, 0770670, NA },
  { "DR11C",  FLOAT,  2,  8, 0767600, NA },
  { "DR11C",  FLOAT,  2,  8, 0767570, NA },
  { "DR11C",  FLOAT,  2,  8, 0767560, NA },
  { "DR11C",  FLOAT,  2,  8, 0767550, NA },
  { "DR11C",  FLOAT,  2,  8, 0767540, NA },
  { "DR11C",  FLOAT,  2,  8, 0767530, NA },
  { "DR11C",  FLOAT,  2,  8, 0767520, NA },
  { "DR11C",  FLOAT,  2,  8, 0767510, NA },
  { "DR11C",  FLOAT,  2,  8, 0767500, NA },
  { "DR11C",  FLOAT,  2,  8, 0767470, NA },
  { "DR11C",  FLOAT,  2,  8, 0767460, NA },
  { "DR11C",  FLOAT,  2,  8, 0767450, NA },
  { "DR11C",  FLOAT,  2,  8, 0767440, NA },
  { "DR11C",  FLOAT,  2,  8, 0767430, NA },
  { "DR11C",  FLOAT,  2,  8, 0767420, NA },
  { "DR11C",  FLOAT,  2,  8, 0767410, NA },
  { "PR611",  FLOAT,  1,  8, 0772600, NA },
  { "PR611",  FLOAT,  1,  8, 0772604, NA },
  { "PR611",  FLOAT,  1,  8, 0772610, NA },
  { "PR611",  FLOAT,  1,  8, 0772614, NA },
  { "PR611",  FLOAT,  1,  8, 0772620, NA },
  { "PR611",  FLOAT,  1,  8, 0772624, NA },
  { "PR611",  FLOAT,  1,  8, 0772630, NA },
  { "PR611",  FLOAT,  1,  8, 0772634, NA },
  { "PP611",  FLOAT,  1,  8, 0772700, NA },
  { "PP611",  FLOAT,  1,  8, 0772704, NA },
  { "PP611",  FLOAT,  1,  8, 0772710, NA },
  { "PP611",  FLOAT,  1,  8, 0772714, NA },
  { "PP611",  FLOAT,  1,  8, 0772720, NA },
  { "PP611",  FLOAT,  1,  8, 0772724, NA },
  { "PP611",  FLOAT,  1,  8, 0772730, NA },
  { "PP611",  FLOAT,  1,  8, 0772734, NA },
  { "DT11",   FLOAT,  2,  8, 0777420, NA },
  { "DT11",   FLOAT,  2,  8, 0777422, NA },
  { "DT11",   FLOAT,  2,  8, 0777424, NA },
  { "DT11",   FLOAT,  2,  8, 0777426, NA },
  { "DT11",   FLOAT,  2,  8, 0777430, NA },
  { "DT11",   FLOAT,  2,  8, 0777432, NA },
  { "DT11",   FLOAT,  2,  8, 0777434, NA },
  { "DT11",   FLOAT,  2,  8, 0777436, NA },
  { "DX11",   FLOAT,  2,  8, 0776200, NA },
  { "DX11",   FLOAT,  2,  8, 0776240, NA },
  { "DL11C",  FLOAT,  2,  8, 0775610, NA },
  { "DL11C",  FLOAT,  2,  8, 0775620, NA },
  { "DL11C",  FLOAT,  2,  8, 0775630, NA },
  { "DL11C",  FLOAT,  2,  8, 0775640, NA },
  { "DL11C",  FLOAT,  2,  8, 0775650, NA },
  { "DL11C",  FLOAT,  2,  8, 0775660, NA },
  { "DL11C",  FLOAT,  2,  8, 0775670, NA },
  { "DL11C",  FLOAT,  2,  8, 0775700, NA },
  { "DL11C",  FLOAT,  2,  8, 0775710, NA },
  { "DL11C",  FLOAT,  2,  8, 0775720, NA },
  { "DL11C",  FLOAT,  2,  8, 0775730, NA },
  { "DL11C",  FLOAT,  2,  8, 0775740, NA },
  { "DL11C",  FLOAT,  2,  8, 0775750, NA },
  { "DL11C",  FLOAT,  2,  8, 0775760, NA },
  { "DL11C",  FLOAT,  2,  8, 0775770, NA },
  { "DL11C",  FLOAT,  2,  8, 0776000, NA },
  { "DL11C",  FLOAT,  2,  8, 0776010, NA },
  { "DL11C",  FLOAT,  2,  8, 0776020, NA },
  { "DL11C",  FLOAT,  2,  8, 0776030, NA },
  { "DL11C",  FLOAT,  2,  8, 0776040, NA },
  { "DL11C",  FLOAT,  2,  8, 0776050, NA },
  { "DL11C",  FLOAT,  2,  8, 0776060, NA },
  { "DL11C",  FLOAT,  2,  8, 0776070, NA },
  { "DL11C",  FLOAT,  2,  8, 0776100, NA },
  { "DL11C",  FLOAT,  2,  8, 0776110, NA },
  { "DL11C",  FLOAT,  2,  8, 0776120, NA },
  { "DL11C",  FLOAT,  2,  8, 0776130, NA },
  { "DL11C",  FLOAT,  2,  8, 0776140, NA },
  { "DL11C",  FLOAT,  2,  8, 0776150, NA },
  { "DL11C",  FLOAT,  2,  8, 0776160, NA },
  { "DL11C",  FLOAT,  2,  8, 0776170, NA },
  { "DJ11",   FLOAT,  2,  8,   FLOAT,  8 },
  { "DH11",   FLOAT,  2,  8,   FLOAT, 16 },
  { "GT40",   FLOAT,  4,  8, 0772000, NA },
  { "GT40",   FLOAT,  4,  8, 0772010, NA },
  { "LPS11",  FLOAT,  6,  8, 0770400, NA },
  { "DQ11",   FLOAT,  2,  8,   FLOAT,  8 },
  { "KW11W",  FLOAT,  2,  8, 0772400, NA },
  { "DU11",   FLOAT,  2,  8,   FLOAT,  8 },
  { "DV11",   FLOAT,  3,  8, 0775000, NA },
  { "DV11",   FLOAT,  3,  8, 0775040, NA },
  { "DV11",   FLOAT,  3,  8, 0775100, NA },
  { "DV11",   FLOAT,  3,  8, 0775140, NA },
  { "LK11",   FLOAT,  2,  8,   FLOAT,  8 },
  { "DMC11",  FLOAT,  2,  8,   FLOAT,  8 },
  { "DZ11",   FLOAT,  2,  8,   FLOAT,  8 },
  { "KMC11",  FLOAT,  2,  8,   FLOAT,  8 },
  { "LPP11",  FLOAT,  2,  8,   FLOAT,  8 },
  { "VMV21",  FLOAT,  2,  8,   FLOAT,  8 },
  { "VMV31",  FLOAT,  2,  8,   FLOAT, 16 },
  { "DWR70",  FLOAT,  2,  8,   FLOAT,  8 },
  { "RL11",   FLOAT,  1,  4,   FLOAT,  8 },
  { "TS11",   FLOAT,  1,  4, 0772524, NA },
  { "TS11",   FLOAT,  1,  4, 0772530, NA },
  { "TS11",   FLOAT,  1,  4, 0772534, NA },
  { "LPA11",  FLOAT,  2,  8, 0770460, NA },
  { "LPA11",  FLOAT,  2,  8,   FLOAT, 16 },
  { "KW11C",  FLOAT,  2,  8,   FLOAT,  8 },
  { "?????",  FLOAT,  0, NA,   FLOAT,  8 }, /* missing in VMS docs */
  { "RX211",  FLOAT,  1,  4,   FLOAT,  8 },
  { "DR11W",  FLOAT,  1,  4,   FLOAT,  8 },
  { "DR11B",   0124,  1, NA, 0772410, NA },
  { "DR11B",  FLOAT,  1,  4, 0772430, NA },
  { "DR11B",  FLOAT,  1,  4,   FLOAT,  8 },
  { "DMP11",  FLOAT,  2,  8,   FLOAT,  8 },
  { "DPV11",  FLOAT,  2,  8,   FLOAT,  8 },
  { "ISB11",  FLOAT,  2,  8,   FLOAT,  8 },
  { "DMV11",  FLOAT,  2,  8,   FLOAT, 16 },
  { "UNA",    FLOAT,  1,  4,   FLOAT,  8 },
  { "QNA",    FLOAT,  1,  4, 0774460, NA },
  { "UDA",    FLOAT,  1,  4,   FLOAT,  4 },
  { "?????",  FLOAT,  0, NA,   FLOAT, 32 }, /* missing in VMS docs */
  { "KMS11",  FLOAT,  3,  8,   FLOAT, 16 },
  { "PCL11",  FLOAT,  2,  8, 0764200, NA },
  { "PCL11",  FLOAT,  2,  8, 0764240, NA },
  { "PCL11",  FLOAT,  2,  8, 0764300, NA },
  { "PCL11",  FLOAT,  2,  8, 0764340, NA },
  { "VS100",  FLOAT,  1,  4,   FLOAT, 16 },
  { "TU81",   FLOAT,  1,  4,   FLOAT,  4 },
  { "KMV11",  FLOAT,  2,  8,   FLOAT, 16 },
  { "KCT32",  FLOAT,  2,  8, 0764400, NA },
  { "KCT32",  FLOAT,  2,  8, 0764440, NA },
  { "KCT32",  FLOAT,  2,  8, 0764500, NA },
  { "KCT32",  FLOAT,  2,  8, 0764540, NA },
  { "IEQ11",  FLOAT,  2,  8, 0764100, NA },
  { "DHV11",  FLOAT,  2,  8,   FLOAT, 16 },
  { "?????",  FLOAT,  0, NA,   FLOAT, 64 }, /* missing in VMS docs */
  { "TC11",    0214,  1, NA, 0777340, NA },
  { "VCB01",  FLOAT,  2,  1, 0777200, NA },
  { "VCB01",  FLOAT,  2,  1,   FLOAT, 64 },
  { "LNV11",  FLOAT,  1,  4, 0776200, NA },
  { "LNV21",  FLOAT,  1,  4,   FLOAT, 16 },
  { "QTA",    FLOAT,  1,  4, 0772570, NA },
  { "QTA",    FLOAT,  1,  4,   FLOAT,  8 },
  { "DSV11",  FLOAT,  1,  4,   FLOAT,  8 },
  { "?????",  FLOAT,  0, NA,   FLOAT,  8 }, /* missing in VMS docs */
  { "ADV11C", FLOAT,  2,  8,   FLOAT,  8 },
  { "AAV11",  FLOAT,  0, NA, 0770440, NA },
  { "AAV11C", FLOAT,  0, NA,   FLOAT,  8 },
  { "AXV11C",  0140,  2, NA, 0776400, NA },
  { "AXV11C", FLOAT,  2,  8,   FLOAT,  8 },
  { "KWV11C", FLOAT,  2,  8, 0770420, NA },
  { "KWV11C", FLOAT,  2,  8,   FLOAT,  4 },
  { "ADV11D", FLOAT,  2,  8, 0776410, NA },
  { "ADV11D", FLOAT,  2,  8,   FLOAT,  8 }, /* VMS docs: CSR align 4 */
  { "AAV11D", FLOAT,  2,  8, 0776420, NA },
  { "AAV11D", FLOAT,  2,  8,   FLOAT,  8 }, /* VMS docs: CSR align 4 */
  { "VCB02",  FLOAT,  3, 16, 0777400, NA },
  { "VCB02",  FLOAT,  3, 16, 0777402, NA },
  { "VCB02",  FLOAT,  3, 16, 0777404, NA },
  { "VCB02",  FLOAT,  3, 16, 0777406, NA },
  { "VCB02",  FLOAT,  3, 16, 0777410, NA },
  { "VCB02",  FLOAT,  3, 16, 0777412, NA },
  { "VCB02",  FLOAT,  3, 16, 0777414, NA },
  { "VCB02",  FLOAT,  3, 16, 0777416, NA },
  { "DRV11J", FLOAT, 16,  4, 0764160, NA },
  { "DRV11J", FLOAT, 16,  4, 0764140, NA },
  { "DRV11J", FLOAT, 16,  4, 0764120, NA },
  { "DRQ3B",  FLOAT,  2,  8,   FLOAT, 16 },
  { "VSV24",  FLOAT,  1,  4,   FLOAT,  8 },
  { "VSV21",  FLOAT,  1,  4,   FLOAT,  8 },
  { "IBQ01",  FLOAT,  1,  4,   FLOAT,  8 },
  { "?????",  FLOAT,  0, NA,   FLOAT,  8 }, /* missing in VMS docs */
  { "?????",  FLOAT,  0, NA,   FLOAT,  8 }, /* missing in VMS docs */
  { "?????",  FLOAT,  0, NA,   FLOAT,  8 }, /* missing in VMS docs */
  { "?????",  FLOAT,  0, NA,   FLOAT,  8 }, /* missing in VMS docs */
  { "?????",  FLOAT,  0, NA,   FLOAT,  8 }, /* missing in VMS docs */
  { "?????",  FLOAT,  0, NA,   FLOAT,  8 }, /* missing in VMS docs */
  { "MIRA",   FLOAT,  2,  8,   FLOAT,  8 },
  { "IEQ11",  FLOAT,  2,  8,   FLOAT, 16 },
  { "ADQ32",  FLOAT,  2,  8,   FLOAT, 32 },
  { "DTC04",  FLOAT,  2,  8,   FLOAT,  2 },
  { "DESNA",  FLOAT,  1,  4,   FLOAT, 32 },
  { "IGQ11",  FLOAT,  2,  8,   FLOAT,  4 },
  { "KMV1F",  FLOAT,  2,  8,   FLOAT, 32 }, 
  { "DIV32",  FLOAT,  1,  8,   FLOAT,  8 }, /* VMS docs: CSR align 4 */
  { "DTCN5",  FLOAT,  2,  8,   FLOAT,  4 },
  { "DTCO5",  FLOAT,  2,  8,   FLOAT,  4 },
  { "KWV32",  FLOAT,  2,  8,   FLOAT,  8 },
  { "QZA",    FLOAT,  1,  4,   FLOAT, 64 }
};

#define DEVTABLEN (sizeof(devtab) / sizeof(struct device))

struct aliastable {
  char *alias;
  char *name;
};

/* table of device names translations to aid lookup in the above table */

struct aliastable aliastab[] = {
  { "DEQNA", "QNA" },
  { "DELQA", "QNA" },
  { "TMSCP", "TU81" },
  { "TK50",  "TU81" },
  { "TK70",  "TU81" },
  { "MSCP",  "UDA"  },
  { "RQDX",  "UDA"  },
  { "RQDX2", "UDA"  },
  { "RQDX3", "UDA"  },
  { "KDA50", "UDA"  },
  { "TSV05", "TS11" }
};

#define ALIASTABLEN (sizeof(aliastab) / sizeof(struct aliastable))

/*
 *	eof
 */
