#include <stdio.h>

#include <malloc.h>

struct _entry {
  struct _entry *link;
  char *data; };

struct _htable {
  int entries;
  int maxentries;
  int tblsize;
  int (*sizefxn)();
  int (*hfxn)();
  int (*cmpfxn)();
  struct _entry **table; };

typedef struct _htable HTABLE;
typedef struct _entry ENTRY;

static int hsizefxn(old)
int old;
{
 if (old <= 0)
  { return(15);
  }
 return(old+old+1);
}

static int gethash(t,e)
register HTABLE *t;
char *e;
{
 register unsigned int i;
 register int s = t->tblsize;

 i = (*t->hfxn)(e,s);
 return((int)(i%s));
}

static grow_table(t)
HTABLE *t;
{
 int newsize;
 int oldsize;
 register ENTRY **newtbl;
 register ENTRY *e;
 register ENTRY *e2;
 register int h;
 register int i;
 register ENTRY **oldtbl;

 oldsize = t->tblsize;
 oldtbl = t->table;
 newsize = (*t->sizefxn)(oldsize);
 if (newsize <= oldsize)
  { newsize = hsizefxn(oldsize);
  }
 newtbl = (ENTRY **) malloc(newsize*sizeof(ENTRY *));
 t->tblsize = newsize;
 t->table = newtbl;
 t->maxentries = 2 * newsize;
 for (i=newsize-1;i>=0;i--)
  { newtbl[i] = 0;
  }
 for (i=oldsize-1;i>=0;i--)
  { for (e=oldtbl[i];e;e=e2)
     { e2 = e->link;
       h = gethash(t,e->data);
       e->link = newtbl[h];
       newtbl[h] = e;
     }
  }
 free((char *)oldtbl);
}

char *new_htable(hfxn,cmpfxn)
int (*hfxn)();
int (*cmpfxn)();
{
 HTABLE *h;

 h = NEW(HTABLE);
 h->entries = 0;
 h->sizefxn = hsizefxn;
 h->tblsize = 0;
 grow_table(h);
 h->hfxn = hfxn;
 h->cmpfxn = cmpfxn;
 h->table = (ENTRY **) malloc(h->tblsize*sizeof(ENTRY *));
 bzero(h->table,h->tblsize*sizeof(char *));
 return((char *)h);
}

static int new_entry(t)
register HTABLE *t;
{
 t->entries ++;
 if (t->entries > t->maxentries)
  { grow_table(t);
    return(1);
  }
 else
  { return(0);
  }
}

#define tbl ((HTABLE *)Tbl)

static int htable_entries(Tbl)
char *Tbl;
{
 return(tbl->entries);
}

static void hset_cmpfxn(Tbl,cmpfxn)
char *Tbl;
int (*cmpfxn)();
{
 tbl->cmpfxn = cmpfxn;
}

char *find_hentry(Tbl,entry)
char *Tbl;
char *entry;
{
 register ENTRY *e;

 for (e=tbl->table[gethash(tbl,entry)];e;e=e->link)
  { if ((*tbl->cmpfxn)(e->data,entry) == 0)
     { return(e->data);
     }
  }
 return(0);
}

void add_new_hentry(Tbl,entry)
char *Tbl;
char *entry;
{
 int h;
 register ENTRY *e;

 new_entry(tbl);
 h = gethash(tbl,entry);
 e = NEW(ENTRY);
 e->link = tbl->table[h];
 tbl->table[h] = e;
 e->data = entry;
}

static char *add_hentry(Tbl,entry)
char *Tbl;
char *entry;
{
 int h;
 register ENTRY *e;

 h = gethash(tbl,entry);
 for (e=tbl->table[h];e;e=e->link)
  { if ((*tbl->cmpfxn)(e->data,entry) == 0)
     { return(e->data);
     }
  }
 if (new_entry(tbl))
  { h = gethash(tbl,entry);
  }
 e = NEW(ENTRY);
 e->link = tbl->table[h];
 tbl->table[h] = e;
 e->data = entry;
 return(0);
}

static char *del_hentry(Tbl,entry)
char *Tbl;
char *entry;
{
 register ENTRY *e;
 register ENTRY **E;
 register char *rv;

 E = &tbl->table[gethash(tbl,entry)];
 while (e = *E)
  { if ((*tbl->cmpfxn)(e->data,entry) == 0)
     { *E = e->link;
       rv = e->data;
       OLD(e);
       tbl->entries --;
       return(rv);
     }
    E = &e->link;
  }
 return(0);
}

static char *del_one_hentry(Tbl)
char *Tbl;
{
 static int lastbucket = 0;
 register int i;
 register ENTRY *e;
 register char *rv;

 if (tbl->entries == 0)
  { return(0);
  }
 lastbucket %= tbl->tblsize;
 i = lastbucket;
 if (!tbl->table[i])
  { for (i++;!tbl->table[i];i=(i+1)%tbl->tblsize)
     { if (i == lastbucket)
	{ fprintf(stderr,"incorrect tbl->entries in hash table\n");
	  abort();
	  exit(1);
	}
     }
  }
 lastbucket = i;
 e = tbl->table[i];
 tbl->table[i] = e->link;
 rv = e->data;
 OLD(e);
 tbl->entries --;
 return(rv);
}

static int del_this_hentry(Tbl,entry)
char *Tbl;
char *entry;
{
 register ENTRY *e;
 register ENTRY **E;

 E = &tbl->table[gethash(tbl,entry)];
 while (e = *E)
  { if (e->data == entry)
     { *E = e->link;
       OLD(e);
       tbl->entries --;
       return(1);
     }
    E = &e->link;
  }
 return(0);
}

void map_htable(Tbl,fxn)
char *Tbl;
int (*fxn)();
{
 register int i;
 register ENTRY *e;

 for (i=tbl->tblsize-1;i>=0;i--)
  { for (e=tbl->table[i];e;e=e->link)
     { (*fxn)(e->data);
     }
  }
}

static void clear_htable(Tbl)
char *Tbl;
{
 register int i;
 register ENTRY *e;
 register ENTRY *e2;

 for (i=tbl->tblsize-1;i>=0;i--)
  { for (e=tbl->table[i];e;e=e2)
     { e2 = e->link;
       OLD(e);
     }
    tbl->table[i] = 0;
  }
 tbl->entries = 0;
}

static void free_htable(Tbl)
char *Tbl;
{
 clear_htable(Tbl);
 free((char *)tbl->table);
 OLD(tbl);
}

/* Now come the "provided" hfxns and cmpfxns */

int string_hfxn(str,siz)
register char *str;
int siz;
{
 register unsigned int i;

 for (i=0;*str;str++)
  { i = (i << 5) + (i >> 28) + *str;
  }
 i &= ((unsigned int)-1) >> 1;
 return(i%siz);
}

int string_cmpfxn(s1,s2)
register char *s1;
register char *s2;
{
 return(strcmp(s1,s2));
}
