/* Copyright (c)1997 Begemot Computer Associates. All rights reserved.
 * See the file COPYRIGHT for details of redistribution and use. */
/*
 * $Id: warn.c,v 1.6 1998/03/17 15:33:09 hbb Exp $
 */
# include <stdio.h>
# include <stdlib.h>
# include "begemot.h"
# include "private.h"

static int warncnt;

/*
 * Display a warning message.
 */
void
warn(const char *fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);
	begemot_common_err("warning", "\n", fmt, ap);
	va_end(ap);

	warncnt++;
}
void
vwarn(const char *fmt, va_list ap)
{
	begemot_common_err("warning", "\n", fmt, ap);

	warncnt++;
}

int
getwarncnt()
{
	return warncnt;
}
