#if 0
int heapsort(ptrs,nels,cmp)
char **ptrs; /* should be `<unknown>**ptrs', but no such type exists */
int nels;
int (*cmp)();
#endif
/*
	Sorts the ptrs vector.  (*cmp)(ptrs[i],ptrs[j]) should return:

		< 0	if *ptrs[i] < *ptrs[j]
		= 0	if *ptrs[i] = *ptrs[j]
		> 0	if *ptrs[i] > *ptrs[j]

	For example, if the ptrs are actually pointers to int, it would
	be perfectly good to write a cmp function as follows (unless the
	integers are so large that overflow can occur in the subtraction):

		int cmp(p1,p2)
		char *p1;
		char *p2;
		{
		 return(*(int *)p1 - *(int *)p2);
		}

	Tip:  If the ptrs are character string pointers, the standard
	strcmp() function is a good cmp function.

	The vector will be in non-decreasing order by this criterion on
	return from heapsort.
*/

static _heapsort_bubble_up(size,ptrs,cmp)
int size;
char **ptrs;
int (*cmp)();
{
 int i;
 int p;
 char *temp;

 i = size;
 while (1)
  { if (i == 0)
     { return;
     }
    p = (i - 1) >> 1;
    if ((*cmp)(ptrs[i],ptrs[p]) > 0)
     { temp = ptrs[i];
       ptrs[i] = ptrs[p];
       ptrs[p] = temp;
       i = p;
     }
    else
     { return;
     }
  }
}

static _heapsort_bubble_down(size,ptrs,cmp)
int size;
char **ptrs;
int (*cmp)();
{
 int i;
 int j;
 int l;
 int r;
 int cl;
 int cr;
 char *temp;

 i = 0;
 while (1)
  { if (i >= size)
     { return;
     }
    l = i + i + 1;
    r = l + 1;
    cl = (l >= size) ? 1 : ((*cmp)(ptrs[i],ptrs[l]) >= 0);
    cr = (r >= size) ? 1 : ((*cmp)(ptrs[i],ptrs[r]) >= 0);
    switch ((cl<<1)|cr)
     { case 0:
	  j = ((*cmp)(ptrs[l],ptrs[r]) > 0) ? l : r;
	  break;
       case 1:
	  j = l;
	  break;
       case 2:
	  j = r;
	  break;
       case 3:
	  return;
     }
    temp = ptrs[j];
    ptrs[j] = ptrs[i];
    ptrs[i] = temp;
    i = j;
  }
}

void heapsort(ptrs,nels,cmp)
char **ptrs;
int nels;
int (*cmp)();
{
 int size;
 char *temp;

 if (nels <= 1)
  { return;
  }
 size = 1;
 while (size < nels)
  { _heapsort_bubble_up(size,ptrs,cmp);
    size ++;
  }
 while (size > 1)
  { size --;
    temp = ptrs[size];
    ptrs[size] = ptrs[0];
    ptrs[0] = temp;
    _heapsort_bubble_down(size,ptrs,cmp);
  }
}
