/* wall-clock board driver */

#define BASE 017771230
#define USEC_L (BASE+0)
#define USEC_H (BASE+2)
#define SEC_L  (BASE+4)
#define SEC_H  (BASE+6)

#include "driver.h"

#include <sys/time.h>

extern DRIVER clk_driver;

static struct timeval now;

static void clk_init(d,iomask)
DRIVER *d;
char *iomask;
{
 int i;

 iomask[IOMASK(USEC_L)] = 1;
 iomask[IOMASK(USEC_H)] = 1;
 iomask[IOMASK(SEC_L)] = 1;
 iomask[IOMASK(SEC_H)] = 1;
}

static int clk_io(d,loc,op,data,fxn)
DRIVER *d;
int loc;
int op;
int data;
void (*fxn)();
{
 switch (op & IO_OP)
  { case IO_W:
       gettimeofday(&now,(struct timezone *)0);
       break;
    case IO_R:
       switch (loc)
	{ case IOMASK(USEC_L): return( now.tv_usec     &0xffff); break;
	  case IOMASK(USEC_H): return((now.tv_usec>>16)&0xffff); break;
	  case IOMASK(SEC_L):  return( now.tv_sec      %0xffff); break;
	  case IOMASK(SEC_H):  return((now.tv_sec >>16)&0xffff); break;
	}
       break;
  }
}

static void clk_busreset(d)
DRIVER *d;
{
}

static void clk_reset(d)
DRIVER *d;
{
}

DRIVER clk_driver = { DVR_NORMW, "wall clock", clk_init, 0, clk_io, clk_busreset, clk_reset, 0, 0 };
