'\"
'\" Copyright (c)1997 Begemot Computer Associates. All rights reserved.
'\" See the file COPYRIGHT for details of redistribution and use.
'\"
'\" $Id: xalloc.man,v 1.3 1998/07/17 20:34:17 hbb Exp $
'\"
.TH xalloc l "31 May 1996" "BEGEMOT" "BEGEMOT Library"
.SH NAME
xalloc, xrealloc - memory allocation with simple error check
.SH SYNOPSIS
.nf
.LP
.B "# include <begemot.h>"
.LP
.BR "void * xalloc(size_t " "size" ");"
.LP
.BR "void * xrealloc(void *" "ptr" ", size_t " "size" ");"
.LP
.BR "void xfree(void *" "ptr" ");"
.fi
.SH DESCRIPTION
These functions are a layer above the
.BR malloc (3C)
and
.BR realloc (3C)
functions.
They call these basic functions and check whether the returned pointer
is
.BR NULL .
In this case
.BR panic (l)
is called with the message 'Out of memory:
.IR " param' ",
where
.I param
are the parameters to the allocation function.
.P
See
.BR malloc (3C)
and
.BR realloc (3C)
for a description of the arguments.
.P
These functions have the following additional features:
.TP
-
.BR xalloc (0)
returns a unique pointer for each call.
.TP
-
.BR xfree (NULL)
is legal.
.TP
-
.BR xrealloc "(NULL, 0)"
behaves like
.BR xalloc (0).
.TP
-
.BR xrealloc "(NULL, s)"
will behave like
.BR xalloc (s).
.TP
-
.BR xrealloc "(p, 0)"
behaves like a sequence of
.BR free (p)
and
.BR xalloc (0).
.SH "RETURN VALUE"
See
.BR malloc (3C)
and
.BR realloc (3C)
for a description of the return values. Note that these functions
never return
.BR NULL .
.SH "SEE ALSO"
.BR malloc (3C),
.BR realloc (3C),
.BR panic (l)

