/* p11 - pdp11 emulator; Copyright (C) 1994 Hartmut Brandt, Joerg Micheel 
 * see the file LICENSE for further information */

/*
 * fast block move, addresses are aligned on 16bit boundaries
 */
# define CopyW(T,F,C)	bcopy((F), (T), (C) << 1)


# define SCHAR(S)	((sshort)(schar)(S))

/************************************************************
 *
 * processor emulation
 */
# define WTEST(R)	(void)((proc.n = ((sshort)(R) < 0)),	\
			       (proc.z = ((ushort)(R) == 0)))
# define BTEST(R)	(void)((proc.n = ((schar)(R) < 0)),	\
			       (proc.z = ((uchar)(R) == 0)))
# define WC(R)		(void)(proc.c = ((R) >> 16) & 1)
# define BC(R)		(void)(proc.c = ((R) >> 8) & 1)
# define WV_SUB(D,S,R)	(void)(proc.v = (((D) ^ (S)) & ((S) ^ (ushort)(R)) & 0x8000) != 0)
# define BV_SUB(D,S,R)	(void)(proc.v = (((D) ^ (S)) & ((S) ^ (ushort)(R)) & 0x80) != 0)
# define WV_ADD(D,S,R)	(void)(proc.v = (~((D) ^ (S)) & ((S) ^ (ushort)(R)) & 0x8000) != 0)
# define BV_ADD(D,S,R)	(void)(proc.v = (~((D) ^ (S)) & ((S) ^ (ushort)(R)) & 0x80) != 0)

/*
 * Test word/byte set NZ
 */
# define TestW(S)	WTEST((S))
# define TestB(S)	BTEST((S))

/*
 * Compare word/byte set NZVC
 */
# define CmpW(D,S) 	(void)({ ulong _r = (ulong)(S) - (ulong)(D);	\
				 WTEST(_r); WC(_r); WV_SUB((D),(S),_r); })
# define CmpB(D,S) 	(void)({ ulong _r = (ulong)(S) - (ulong)(D);	\
				 BTEST(_r); BC(_r); BV_SUB((D),(S),_r); })

/*
 * Subtract/add word/byte and set NZVC
 */
# define SubWC(D,S)	(void)({ ulong _r = (ulong)(D) - (ulong)(S);	\
				 WTEST(_r); WC(_r); WV_SUB((S),(D),_r); (D)=_r; })
# define AddWC(D,S)	(void)({ ulong _r = (ulong)(D) + (ulong)(S);	\
				 WTEST(_r); WC(_r); WV_ADD((D),(S),_r); (D)=_r; })
# define SubBC(D,S)	(void)({ ulong _r = (ulong)(D) - (ulong)(S);	\
				 BTEST(_r); BC(_r); BV_SUB((S),(D),_r); (D)=_r; })
# define AddBC(D,S)	(void)({ ulong _r = (ulong)(D) + (ulong)(S);	\
				 BTEST(_r); BC(_r); BV_ADD((D),(S),_r); (D)=_r; })

/*
 * Subtract/add word/byte and set NZV
 */
# define SubW(D,S)	(void)({ ulong _r = (ulong)(D) - (ulong)(S);	\
				 WTEST(_r); WV_SUB((S),(D),_r); (D)=_r; })
# define AddW(D,S)	(void)({ ulong _r = (ulong)(D) + (ulong)(S);	\
				 WTEST(_r); WV_ADD((D),(S),_r); (D)=_r; })
# define SubB(D,S)	(void)({ ulong _r = (ulong)(D) - (ulong)(S);	\
				 BTEST(_r); BV_SUB((S),(D),_r); (D)=_r; })
# define AddB(D,S)	(void)({ ulong _r = (ulong)(D) + (ulong)(S);	\
				 BTEST(_r); BV_ADD((D),(S),_r); (D)=_r; })

/*
 * swap bytes no flags
 */
# define SwabB(D)	(void)((D) = ((((D)<<8)&0xff00)|(((D)>>8)&0xff)))

/*
 * divide et impera, no flags
 */
# define Div(v1,v2,v,d)	(void)(v1 = v/d, v2 = v%d)
