/* p11 - pdp11 emulator; Copyright (C) 1994 Hartmut Brandt, Joerg Micheel 
 * see the file LICENSE for further information */

/*
 * sparc floating point operations for compilers that don't know extended float
 * implemented in as because gcc doesn't know about extended doubles
 *
 * See the SPARC Architecture Manual, Version 8, page 238, for further
 * information on Quad Precision Floating Point.
 */

/*
 * sparc quad float format, usually emulated
 */
struct Float {
	unsigned	s : 1;		/* sign bit */
	unsigned	e : 15;		/* expo offset 0x3fff */
	unsigned	m0 : 16;	/* mantissa 112 bit */
	unsigned	m1 : 32;
	unsigned	m2 : 32;
	unsigned	m3 : 32;
};
# define EXP_OFF	0x3fff

# define InitFp()
# define EndFp()

/* 
 * add S to A
 * sub S from A
 * mul A by S
 * divide A by S (S is already checked for 0)
 * the limits of the host float should be sufficient not
 * to produce any errors.
 */

# define AddF(A,S)
# define SubF(A,S)
# define MulF(A,S)
# define DivF(A,S)
# define ModF(A,F,I)
# define IsZ(A)
# define IsN(S)
# define CnvL(A,L)
# define CnvF2L(S,L)

/*
 * return K so that 2^K <= A < 2^(K+1)
 * (A may not be 0 here)
 */
# define FrExp(A)


/*
 * return sparc float mantissa as a 64bit fixed point value with
 * point after the 1st bit to the left and 1.0 > m >= 0.5
 */
# define GetMant(P)
# define GetExp(P)
# define GetSign(P)


/*
 * insert mantissa into alpha float
 */
# define SetMant(H,M)
# define SetExp(H,E)
# define SetSign(H,S)


/*
 * covert extended float to double, just for printing and debuging
 */
static double
mkd(Float *f)
{
}


/*
 * dump a float
 */
static void
dmpflt(Float *f)
{
	int e = f->e - EXP_OFF;

	printf("%c ", "+-"[f->s]);
	if(f->e)
		printf(" %04x ", e & 0x7fff);
	else 
		printf("    0 ");	
	printf("%04x %08x %08x %08x", f->m0, f->m1, f->m2, f->m3);
}


/*
 * convert pdp float to double for printing
 * precision may be lost and over/underflow may occure
 */
static double
mkdouble(PDP_Float *f, int d)
{
	Float h;

	unfold(f, &h, d);
	return mkd(&h);
}

