#-h-  tcrypt.r                    1293  ascii   03/22/82  16:14:54
# crypt - encrypt and decrypt
 # include ratdef
define(MAXKEY,MAXLINE)
 #  There are 2 versions of crypt here--the one from the book
 #  and a simpler one which does not encrypt control characters
 #  (since some systems have trouble reading/printing various
 #  control characters).  If you want the simpler, no-control-
 #  character version, do this:
 #           define(NOCONTROL,)
 DRIVER(crypt)
   character xor
   character c, key(MAXKEY), b
   character getc
   integer getarg
   integer i, keylen

   call query ("usage:  crypt key.")
   keylen = getarg(1, key, MAXKEY)
   if (keylen == EOF)
      call error("usage: crypt key.")
   for (i=1; getc(c) != EOF; i=mod(i, keylen) +1)
        {
        ifnotdef(NOCONTROL,   call putc(xor(c, key(i))) )
                                 #leave control characters alone
        ifdef(NOCONTROL,
        if (c < BLANK)
                call putc(c)
        else
                {
                b = xor(c, key(i) & 31)
                call putc(b)
                } )
        }
   DRETURN
   end
###################################################################
# The UNIX implementation uses the C version of xor
# # xor - exclusive-or of a and b
# character function xor(a,b)
# character a, b
#
# xor = (a & !b) | (!a & b)
# return
# end
#-t-  tcrypt.r                    1293  ascii   03/22/82  16:14:54
